/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.handlers.standard;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.handlers.FinanceDocumentHandler;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import java.util.List;

public class BulgariaInvoiceHandler
implements FinanceDocumentHandler {
    public FinanceDocumentType getFinanceDocumentType() {
        return FinanceDocumentType.BULGARIA_INVOICE;
    }

    public boolean accept(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) {
        BillingItemSettings billingItemSettings;
        if (billingItem.getProductUids().isEmpty()) {
            return false;
        }
        if (financeDocumentSettings != null && (billingItemSettings = FinanceDocumentsHelper.getBillingItemSettings((List)financeDocumentSettings.getBillingItemsSettings(), (ServiceType)billingItem.getServiceType())) != null && !billingItemSettings.isUseBillingItem()) {
            return false;
        }
        return billingItem.getServiceType() != ServiceType.FEE || !FinanceDocumentsHelper.isPaymentForRefund((Payment)payment);
    }

    public String getDocumentGroupId(BillingItem billingItem, Payment payment, FinanceDocumentSettings financeDocumentSettings) {
        BaseProduct baseProduct = BookingHelper.findProduct((BookingFile)payment.getBookingFile(), (String)((String)billingItem.getProductUids().iterator().next()));
        ProductHandler productHandler = ((HandlersRegistry)Environment.getPublished(HandlersRegistry.class)).findProductHandler(baseProduct.getClass());
        Class productClass = productHandler.getProductClass();
        TransportationType transportationType = productHandler.getTransportationType(baseProduct);
        return String.format("bulgaria_invoice_%s_%s", productClass != null ? productClass.getName().toLowerCase() : "", transportationType != null ? transportationType.name().toLowerCase() : "");
    }
}

