/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.helpers;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AirProductHelper {
    private static String domestic = "BG";
    private static String regional = "EURO";

    public static String getTransportationTypeString(Product product) {
        Logger log = LoggerFactory.getLogger(AirProductHelper.class);
        if (product == null) {
            return null;
        }
        log.debug("calculateTransportationType START");
        ArrayList<String[]> codes = new ArrayList<String[]>();
        for (SegmentTariff segmentTariff : product.getSegmentTariffs()) {
            for (Segment seg : segmentTariff.getSegments()) {
                DictionaryReference arriveLocationReference = seg.getArriveLocation();
                DictionaryReference departureLocationReference = seg.getDepartureLocation();
                codes.add(DictHelper.getCodeVariants((DictionaryReference)arriveLocationReference, Arrays.asList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
                codes.add(DictHelper.getCodeVariants((DictionaryReference)departureLocationReference, Arrays.asList(CodeSystem.IATA), (boolean)false, (boolean)true, (boolean)true).toArray(new String[0]));
            }
        }
        if (codes.isEmpty()) {
            return "?";
        }
        if (RulesHelper.confinedTo(codes, Arrays.asList(domestic))) {
            return "Domestic";
        }
        if (RulesHelper.confinedTo(codes, Arrays.asList(regional))) {
            return "Regional";
        }
        if (!RulesHelper.confinedTo(codes, Arrays.asList(domestic + "-" + regional))) {
            return "International";
        }
        return "?";
    }

    public static TransportationType getTransportationType(Product product) {
        if (product == null) {
            return null;
        }
        Product checkProduct = product;
        if (product.getProductCategory() == ProductCategory.MCO && product.getMcoCategory() != MCOCategory.PTA) {
            Product relatedProduct = com.gridnine.xtrip.common.model.helpers.AirProductHelper.findRelatedAirProduct((Product)product, null, (boolean)false);
            if (relatedProduct != null) {
                checkProduct = relatedProduct;
            }
        } else if ((product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE) && product.getPreviousProduct() != null && product.getPreviousProduct().getTicketType() != TicketType.FAKE) {
            checkProduct = product.getPreviousProduct();
        }
        boolean hasDomestic = false;
        boolean hasInternational = false;
        block0: for (SegmentTariff segmentTariff : checkProduct.getSegmentTariffs()) {
            for (Segment segment : segmentTariff.getSegments()) {
                DictionaryReference departureLocationReference = segment.getDepartureLocation();
                DictionaryReference arriveLocationReference = segment.getArriveLocation();
                String departureLocation = departureLocationReference != null ? departureLocationReference.getCode() : null;
                String arriveLocation = arriveLocationReference != null ? arriveLocationReference.getCode() : null;
                Country departureCountry = DictHelper.findCountry((String)departureLocation);
                Country arriveCountry = DictHelper.findCountry((String)arriveLocation);
                if (departureCountry != null && departureCountry.isDomestic() || arriveCountry != null && arriveCountry.isDomestic()) {
                    hasDomestic = true;
                }
                if (departureCountry != null && !departureCountry.isDomestic() || arriveCountry != null && !arriveCountry.isDomestic()) {
                    hasInternational = true;
                }
                if (!hasDomestic || !hasInternational) continue;
                break block0;
            }
        }
        if (!hasDomestic && !hasInternational) {
            return TransportationType.NONE;
        }
        if (hasDomestic && !hasInternational) {
            return TransportationType.DOMESTIC;
        }
        if (!hasDomestic && hasInternational) {
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.COMBINED;
    }
}

