/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bg.model.templates.jr;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.jr.ReportParametersProvider;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BillingItemServiceData;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.slf4j.LoggerFactory;

public class InvoiceJRDocumentRender {
    private static final String KEY_DOCUMENT_NUMBER = "DOCUMENT_NUMBER";
    private static final String KEY_DOCUMENT_PRODUCT_TYPE = "DOCUMENT_PRODUCT_TYPE";
    private static final String KEY_DOCUMENT_RELATED_DOCUMENT_NUMBER = "DOCUMENT_RELATED_DOCUMENT_NUMBER";
    private static final String KEY_DOCUMENT_RELATED_DOCUMENT_ISSUE_DATE = "DOCUMENT_RELATED_DOCUMENT_ISSUE_DATE";
    private static final String KEY_DOCUMENT_ISSUE_DATE = "DOCUMENT_ISSUE_DATE";
    private static final String KEY_DOCUMENT_ISSUE_ADDRESS = "DOCUMENT_ISSUE_ADDRESS";
    private static final String KEY_RETAIL_CLIENT = "RETAIL_RECEIVER";
    private static final String KEY_CLIENT_NAME = "RECEIVER_NAME";
    private static final String KEY_CLIENT_LEGAL_ADDRESS = "RECEIVER_LEGAL_ADDRESS";
    private static final String KEY_CLIENT_INN = "RECEIVER_IDENTIFICATION_NUMBER";
    private static final String KEY_CLIENT_KPP = "RECEIVER_VAT_NUMBER";
    private static final String KEY_AGENCY_NAME = "ISSUER_NAME";
    private static final String KEY_AGENCY_LEGAL_ADDRESS = "ISSUER_LEGAL_ADDRESS";
    private static final String KEY_AGENCY_INN = "ISSUER_IDENTIFICATION_NUMBER";
    private static final String KEY_AGENCY_KPP = "ISSUER_VAT_NUMBER";
    private static final String KEY_AGENCY_BANK = "ISSUER_BANK";
    private static final String KEY_AGENCY_BANK_BIK = "ISSUER_BANK_BIC";
    private static final String KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT = "ISSUER_BANK_IBAN";
    private static final String KEY_EXCHANGE_RATE = "EXCHANGE_RATE";
    private static final String KEY_TOTAL_AMOUNT_NET_EUR = "TOTAL_AMOUNT_NET_EUR";
    private static final String KEY_TOTAL_AMOUNT_NET_BGN = "TOTAL_AMOUNT_NET_BGN";
    private static final String KEY_VAT_RATE = "VAT_RATE";
    private static final String KEY_TOTAL_VAT_BGN = "TOTAL_VAT_BGN";
    private static final String KEY_TOTAL_AMOUNT_EUR = "TOTAL_AMOUNT_EUR";
    private static final String KEY_TOTAL_AMOUNT_BGN = "TOTAL_AMOUNT_BGN";
    private static final String KEY_TOTAL_AMOUNT_BGN_BY_WORDS = "TOTAL_AMOUNT_BGN_BY_WORDS";
    private static final String KEY_PAYMENT_TYPE = "FORM_OF_PAYMENT";
    private static final String KEY_ZERO_VAT_RATE_REASON = "ZERO_VAT_RATE_REASON";
    private static final String KEY_AGENCY_AGENT = "ISSUER_AGENT";
    private static final String KEY_SALES_POINT_PHONE = "SALES_POINT_PHONE";
    private static final String KEY_SALES_POINT_EMAIL = "SALES_POINT_EMAIL";
    private static final String FIELD_NAME = "NAME";
    private static final String FIELD_ROUTES = "ROUTES";
    private static final String FIELD_QUANTITY = "QUANTITY";
    private static final String FIELD_AMOUNT_NET_EUR = "AMOUNT_NET_EUR";
    private static final String FIELD_AMOUNT_NET_BGN = "AMOUNT_NET_BGN";
    private static final Map<ProductType, String> productTypes = new HashMap<ProductType, String>();

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument financeDocument, EntityContainer<TemplateDocument> templateContainer, ReportParametersProvider parametersProvider) throws Exception {
        FinanceDocumentSettings fds;
        FinanceDocumentsProperties fdp;
        Map<String, Object> parameters;
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)templateContainer.getEntity()).getContent());
        Locale locale = new Locale("bg", "BG");
        String templateLocaleString = jasperReport.getProperty("xtrip.locale");
        if (!TextUtil.isBlank((String)templateLocaleString)) {
            try {
                locale = new Locale(templateLocaleString);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).error(String.format("unable to parse locale %s", templateLocaleString), (Throwable)e);
            }
        }
        if ((parameters = this.getParameters(bookingFileContainer, payment, financeDocument, fdp = FinanceDocumentsHelper.getFinanceDocumentProperties((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (Payment)payment), fds = FinanceDocumentsHelper.getFinanceDocumentSettings((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (FinanceDocumentType)financeDocument.getType()), jasperReport, locale, messages)) == null) {
            return InvoiceJRDocumentRender.createErrorDocument(messages);
        }
        JRDataSource dataSource = this.getDataSource(payment, financeDocument, fdp, fds, jasperReport, locale, messages);
        if (dataSource == null) {
            return InvoiceJRDocumentRender.createErrorDocument(messages);
        }
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters, (JRDataSource)dataSource, (ReportParametersProvider)parametersProvider);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument filledTemplateDocument = new FilledTemplateDocument();
        filledTemplateDocument.setTitle(this.getReportTitle(payment, financeDocument));
        filledTemplateDocument.setContentType(ContentType.JASPERPRINT);
        filledTemplateDocument.setContent(content);
        filledTemplateDocument.setName(this.getFileName(payment, financeDocument));
        filledTemplateDocument.setType(DocumentType.INVOICE);
        filledTemplateDocument.setCreated(date);
        filledTemplateDocument.setNavigationKey(payment.getUid());
        filledTemplateDocument.setOwner(bookingFileContainer.toReference());
        filledTemplateDocument.setCheckSum(MiscUtil.getCheckSum((byte[])filledTemplateDocument.getContent()));
        filledTemplateDocument.setTemplate(templateContainer.toReference());
        filledTemplateDocument.getMessages().addAll(messages);
        return filledTemplateDocument;
    }

    private Map<String, Object> getParameters(EntityContainer<BookingFile> bookingFileContainer, Payment payment, FinanceDocument document, FinanceDocumentsProperties fdp, FinanceDocumentSettings fds, JasperReport jasperReport, Locale locale, Set<Message> messages) throws Exception {
        CurrencyRate currencyRate;
        FinanceDocument relatedDocument;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (payment == null) {
            this.addMessage(messages, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        if (document == null) {
            this.addMessage(messages, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        EntityContainer clientContainer = EntityStorage.get().resolve(((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile());
        if (clientContainer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043a\u043b\u0438\u0435\u043d\u0442\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        EntityContainer agencyContainer = FinanceDocumentsHelper.getAgency((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (Payment)payment);
        if (agencyContainer == null) {
            this.addMessage(messages, "\u041d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        EntityContainer branchContainer = FinanceDocumentsHelper.getBranch((BookingFile)((BookingFile)bookingFileContainer.getEntity()), (Payment)payment);
        Organization client = (Organization)clientContainer.getEntity();
        Organization agency = (Organization)agencyContainer.getEntity();
        Branch branch = branchContainer != null ? (Branch)branchContainer.getEntity() : null;
        BillingItem billingItem = document.getBillingItems().size() > 0 ? (BillingItem)document.getBillingItems().get(0) : null;
        parameters.put(KEY_DOCUMENT_NUMBER, TextUtil.buildFullNumber((CompositeNumber)document));
        String productType = null;
        if (billingItem != null && billingItem.getServiceData().size() > 0) {
            productType = productTypes.get(((BillingItemServiceData)billingItem.getServiceData().get(0)).getProductType());
        }
        parameters.put(KEY_DOCUMENT_PRODUCT_TYPE, productType);
        if (document.getType() == FinanceDocumentType.BULGARIA_INVOICE_CREDIT_NOTE && (relatedDocument = this.getRelatedDocument(payment.getBookingFile(), document)) != null) {
            parameters.put(KEY_DOCUMENT_RELATED_DOCUMENT_NUMBER, relatedDocument.getNumber());
            parameters.put(KEY_DOCUMENT_RELATED_DOCUMENT_ISSUE_DATE, relatedDocument.getDate());
        }
        parameters.put(KEY_DOCUMENT_ISSUE_DATE, document.getDate());
        parameters.put(KEY_DOCUMENT_ISSUE_ADDRESS, this.buildCityString((EntityReference<Person>)payment.getAgent(), payment.getDate(), locale));
        boolean retail = ProfileHelper.isRetailProfile((EntityContainer)clientContainer);
        parameters.put(KEY_RETAIL_CLIENT, retail);
        parameters.put(KEY_CLIENT_NAME, ProfileHelper.getFullName((String)client.getCode(), (L10nString)client.getShortName(), (L10nString)client.getFullName(), (DictionaryReference)client.getLegalForm(), (Locale)locale, (boolean)false));
        parameters.put(KEY_CLIENT_LEGAL_ADDRESS, this.buildAddressString(ProfileHelper.getOrganizationAddresses((Organization)client, (Date)document.getDate()), AddressType.LEGAL, locale));
        parameters.put(KEY_CLIENT_INN, client.getRegistrationId());
        parameters.put(KEY_CLIENT_KPP, client.getKpp());
        parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName((String)agency.getCode(), (L10nString)agency.getShortName(), (L10nString)agency.getFullName(), (DictionaryReference)agency.getLegalForm(), (Locale)locale, (boolean)false));
        parameters.put(KEY_AGENCY_LEGAL_ADDRESS, this.buildAddressString(ProfileHelper.getOrganizationAddresses((Organization)agency, (Date)document.getDate()), AddressType.LEGAL, locale));
        parameters.put(KEY_AGENCY_INN, agency.getRegistrationId());
        parameters.put(KEY_AGENCY_KPP, agency.getKpp());
        BankAccount bankAccount = payment.getBankAccount();
        if (bankAccount == null) {
            bankAccount = agency.getFinanceDocumentProperties().getBankAccount();
        }
        if (bankAccount == null && branch != null && !branch.getBankAccounts().isEmpty()) {
            bankAccount = (BankAccount)branch.getBankAccounts().get(0);
        }
        if (bankAccount == null && !agency.getBankAccounts().isEmpty()) {
            bankAccount = (BankAccount)agency.getBankAccounts().get(0);
        }
        if (bankAccount != null) {
            parameters.put(KEY_AGENCY_BANK, bankAccount.getBankName());
            parameters.put(KEY_AGENCY_BANK_BIK, bankAccount.getBik());
            parameters.put(KEY_AGENCY_BANK_SETTLEMENT_ACCOUNT, bankAccount.getSettlementAccount());
        }
        if ((currencyRate = BookingHelper.findCurrencyRate((String)"EUR", (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null)) != null) {
            parameters.put(KEY_EXCHANGE_RATE, BigDecimal.valueOf(currencyRate.getRate()));
        }
        BigDecimal totalBaseNetAmount = this.calculateTotalBaseNetAmount(document.getBillingItems());
        BigDecimal totalNetAmount = this.calculateTotalNetAmount(document.getBillingItems());
        parameters.put(KEY_TOTAL_AMOUNT_NET_EUR, totalBaseNetAmount);
        parameters.put(KEY_TOTAL_AMOUNT_NET_BGN, totalNetAmount);
        BigDecimal totalBaseAmount = this.calculateTotalBaseAmount(document.getBillingItems());
        BigDecimal totalAmount = this.calculateTotalAmount(document.getBillingItems());
        parameters.put(KEY_TOTAL_VAT_BGN, this.calculateTotalVatAmount(totalAmount, totalNetAmount));
        parameters.put(KEY_TOTAL_AMOUNT_EUR, totalBaseAmount);
        parameters.put(KEY_TOTAL_AMOUNT_BGN, totalAmount);
        if (billingItem != null) {
            parameters.put(KEY_VAT_RATE, billingItem.getVatRate());
        }
        if (totalAmount != null) {
            parameters.put(KEY_TOTAL_AMOUNT_BGN_BY_WORDS, this.buildAmountByWordsString(document.getType() == FinanceDocumentType.BULGARIA_INVOICE_CREDIT_NOTE ? totalAmount.abs() : totalAmount, locale, Locale.ENGLISH, "BGN"));
        }
        parameters.put(KEY_PAYMENT_TYPE, payment.getFop() != null ? this.buildPaymentTypeString(payment.getFop().getType(), locale, Locale.ENGLISH) : null);
        parameters.put(KEY_ZERO_VAT_RATE_REASON, billingItem != null ? billingItem.getZeroVatRateReason() : null);
        parameters.put(KEY_AGENCY_AGENT, this.buildAgentString((EntityReference<Person>)payment.getAgent(), locale));
        parameters.put(KEY_SALES_POINT_PHONE, this.buildPhoneString((EntityReference<Person>)payment.getAgent(), payment.getDate(), locale));
        parameters.put(KEY_SALES_POINT_EMAIL, this.buildEmailString((EntityReference<Person>)payment.getAgent(), payment.getDate(), locale));
        return parameters;
    }

    private JRDataSource getDataSource(Payment payment, FinanceDocument financeDocument, FinanceDocumentsProperties fdp, FinanceDocumentSettings fds, JasperReport jasperReport, Locale locale, Set<Message> messages) throws Exception {
        ArrayList data = new ArrayList();
        for (BillingItem billingItem : financeDocument.getBillingItems()) {
            VatAmount amount;
            HashMap<String, Object> record = new HashMap<String, Object>();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList travellers = new ArrayList();
            ArrayList<String> routes = new ArrayList<String>();
            for (BillingItemServiceData serviceData : billingItem.getServiceData()) {
                names.add(serviceData.getNameInvoice());
                travellers.addAll(serviceData.getTravellers());
                routes.addAll(serviceData.getRoutes());
            }
            record.put(FIELD_NAME, this.buildString(names));
            record.put(FIELD_ROUTES, this.buildString(routes));
            record.put(FIELD_QUANTITY, billingItem.getProductUids().size());
            Money baseAmount = billingItem.getBaseNetAmount();
            if (baseAmount != null) {
                record.put(FIELD_AMOUNT_NET_EUR, baseAmount.getValue());
            }
            if ((amount = billingItem.getAmount()) != null) {
                record.put(FIELD_AMOUNT_NET_BGN, amount.getValue());
            }
            data.add(record);
        }
        return new JRMapCollectionDataSource(data);
    }

    private Set<String> getProductSystemNumbers(BookingFile bookingFile, FinanceDocument document) {
        HashSet<String> productSystemNumbers = new HashSet<String>();
        for (BillingItem billingItem : document.getBillingItems()) {
            for (String productUid : billingItem.getProductUids()) {
                ProductHandler productHandler;
                BaseProduct baseProduct = BookingHelper.findProductByUid((String)productUid, (BookingFile)bookingFile);
                if (baseProduct == null || (productHandler = ((HandlersRegistry)Environment.getPublished(HandlersRegistry.class)).findProductHandler(baseProduct.getClass())) == null) continue;
                productSystemNumbers.addAll(productHandler.getProductNumbers(baseProduct));
            }
        }
        return productSystemNumbers;
    }

    private List<FinanceDocument> getFinanceDocuments(List<FinanceDocument> documents, FinanceDocumentType financeDocumentType) {
        ArrayList<FinanceDocument> financeDocuments = new ArrayList<FinanceDocument>();
        for (FinanceDocument document : documents) {
            if (document.getType() != financeDocumentType) continue;
            financeDocuments.add(document);
        }
        return financeDocuments;
    }

    private Address getAddress(List<Address> addresses, AddressType addressType) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return address;
        }
        return null;
    }

    private Communication getCommunication(List<Communication> communications, CommunicationType communicationType) {
        for (Communication communication : communications) {
            if (communication.getType() != communicationType) continue;
            return communication;
        }
        return null;
    }

    private BigDecimal calculateTotalBaseNetAmount(List<BillingItem> billingItems) {
        BigDecimal totalBaseNetAmount = null;
        for (BillingItem billingItem : billingItems) {
            if (billingItem.getBaseNetAmount() == null || billingItem.getBaseNetAmount().getValue() == null) continue;
            totalBaseNetAmount = totalBaseNetAmount != null ? totalBaseNetAmount.add(billingItem.getBaseNetAmount().getValue()) : billingItem.getBaseNetAmount().getValue();
        }
        return totalBaseNetAmount;
    }

    private BigDecimal calculateTotalBaseAmount(List<BillingItem> billingItems) {
        BigDecimal totalBaseAmount = null;
        for (BillingItem billingItem : billingItems) {
            if (billingItem.getBaseAmount() == null || billingItem.getBaseAmount().getValue() == null) continue;
            totalBaseAmount = totalBaseAmount != null ? totalBaseAmount.add(billingItem.getBaseAmount().getValue()) : billingItem.getBaseAmount().getValue();
        }
        return totalBaseAmount;
    }

    private BigDecimal calculateTotalNetAmount(List<BillingItem> billingItems) {
        BigDecimal totalNetAmount = null;
        for (BillingItem billingItem : billingItems) {
            if (billingItem.getAmount() == null || billingItem.getAmount().getVatAmount() == null) continue;
            totalNetAmount = totalNetAmount != null ? totalNetAmount.add(billingItem.getAmount().getValue()) : billingItem.getAmount().getValue();
        }
        return totalNetAmount;
    }

    private BigDecimal calculateTotalAmount(List<BillingItem> billingItems) {
        BigDecimal totalAmount = null;
        for (BillingItem billingItem : billingItems) {
            if (billingItem.getAmount() == null || billingItem.getAmount().getTotal() == null) continue;
            totalAmount = totalAmount != null ? totalAmount.add(billingItem.getAmount().getTotal()) : billingItem.getAmount().getTotal();
        }
        return totalAmount;
    }

    private BigDecimal calculateTotalVatAmount(BigDecimal totalAmount, BigDecimal totalNetAmount) {
        BigDecimal totalVatAmount = totalAmount;
        if (totalNetAmount != null) {
            totalVatAmount = totalVatAmount != null ? totalVatAmount.subtract(totalNetAmount) : totalNetAmount.negate();
        }
        return totalVatAmount;
    }

    private FinanceDocument getRelatedDocument(BookingFile bookingFile, FinanceDocument document) throws Exception {
        Set<String> productSystemNumbers = this.getProductSystemNumbers(bookingFile, document);
        for (Payment payment : bookingFile.getPayments()) {
            List<FinanceDocument> otherDocuments = this.getFinanceDocuments(payment.getFinanceDocuments(), FinanceDocumentType.BULGARIA_INVOICE);
            for (FinanceDocument otherDocument : otherDocuments) {
                Set<String> otherProductSystemNumbers = this.getProductSystemNumbers(bookingFile, otherDocument);
                if (Collections.disjoint(otherProductSystemNumbers, productSystemNumbers)) continue;
                return otherDocument;
            }
        }
        return null;
    }

    private String buildCityString(EntityReference<Person> agent, Date date, Locale locale) throws Exception {
        EntityContainer agentContainer = EntityStorage.get().resolve(agent);
        if (agentContainer != null) {
            for (EntityReference salesPointReference : ProfileHelper.getPersonSalesPoints(Collections.singletonList(agentContainer.toReference()), (Date)date)) {
                Address address;
                EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
                if (salesPointContainer == null || (address = this.getAddress(((SalesPoint)salesPointContainer.getEntity()).getAddresses(), AddressType.FACTUAL)) == null || address.getCity() == null) continue;
                return address.getCity().toString(locale);
            }
        }
        return null;
    }

    private String buildAddressString(List<Address> addresses, AddressType addressType, Locale locale) {
        Address address = this.getAddress(addresses, addressType);
        return address != null ? ProfileHelper.buildFullAddress((Address)address, (Locale)locale, (boolean)false) : null;
    }

    private String buildAmountByWordsString(BigDecimal amount, Locale primaryLocale, Locale secondaryLocale, String currency) {
        StringBuilder amountByWordsString = new StringBuilder();
        Number2WordsConverter converter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(primaryLocale, currency);
        if (converter != null) {
            try {
                amountByWordsString.append(converter.toCurrencyWords(amount, currency, true, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((converter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(secondaryLocale, currency)) != null) {
            if (amountByWordsString.length() > 0) {
                amountByWordsString.append("\n");
            }
            try {
                amountByWordsString.append(converter.toCurrencyWords(amount, currency, true, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return amountByWordsString.length() > 0 ? amountByWordsString.toString() : null;
    }

    private String buildPaymentTypeString(PaymentType paymentType, Locale primaryLocale, Locale secondaryLocale) {
        StringBuilder paymentTypeString = new StringBuilder();
        LocaleManager localeManager = (LocaleManager)Environment.getPublished(LocaleManager.class);
        Locale locale = localeManager.getCurrentLocale();
        localeManager.setCurrentLocale(localeManager.isSupportedLocale(primaryLocale) ? primaryLocale : Locale.ENGLISH);
        String paymentTypeStringPrimaryLocale = paymentType.toString();
        localeManager.setCurrentLocale(localeManager.isSupportedLocale(secondaryLocale) ? secondaryLocale : Locale.ENGLISH);
        String paymentTypeStringSecondaryLocale = paymentType == PaymentType.INVOICE ? "Bank transfer" : paymentType.toString();
        paymentTypeString.append(String.format("%s / %s", paymentTypeStringPrimaryLocale, paymentTypeStringSecondaryLocale));
        localeManager.setCurrentLocale(locale);
        return paymentTypeString.length() > 0 ? paymentTypeString.toString() : null;
    }

    private String buildAgentString(EntityReference<Person> agent, Locale locale) {
        StringBuilder agentString = new StringBuilder();
        EntityContainer agentContainer = EntityStorage.get().resolve(agent);
        if (agentContainer != null) {
            String code;
            PersonalLocalizableNameFormatter formatter = new PersonalLocalizableNameFormatter("F L");
            String name = formatter.format((PersonalLocalizableName)agentContainer.getEntity(), locale, false);
            if (!TextUtil.isBlank((String)name)) {
                agentString.append(name.trim());
            }
            if (!TextUtil.isBlank((String)(code = ((Person)agentContainer.getEntity()).getCode()))) {
                if (agentString.length() > 0) {
                    agentString.append(" - ");
                }
                agentString.append(code);
            }
        }
        return agentString.length() > 0 ? agentString.toString() : null;
    }

    private String buildPhoneString(EntityReference<Person> agent, Date date, Locale locale) throws Exception {
        EntityContainer agentContainer = EntityStorage.get().resolve(agent);
        if (agentContainer != null) {
            for (EntityReference salesPointReference : ProfileHelper.getPersonSalesPoints(Collections.singletonList(agentContainer.toReference()), (Date)date)) {
                String phone;
                Communication communication;
                EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
                if (salesPointContainer == null || (communication = this.getCommunication(((SalesPoint)salesPointContainer.getEntity()).getCommunications(), CommunicationType.WORK_PHONE)) == null || TextUtil.isBlank((String)(phone = ProfileHelper.buildFullPhoneNumber((Communication)communication)))) continue;
                return phone;
            }
        }
        return null;
    }

    private String buildEmailString(EntityReference<Person> agent, Date date, Locale locale) throws Exception {
        EntityContainer agentContainer = EntityStorage.get().resolve(agent);
        if (agentContainer != null) {
            for (EntityReference salesPointReference : ProfileHelper.getPersonSalesPoints(Collections.singletonList(agentContainer.toReference()), (Date)date)) {
                Communication communication;
                EntityContainer salesPointContainer = EntityStorage.get().resolve(salesPointReference);
                if (salesPointContainer == null || (communication = this.getCommunication(((SalesPoint)salesPointContainer.getEntity()).getCommunications(), CommunicationType.EMAIL)) == null || TextUtil.isBlank((String)communication.getSense())) continue;
                return communication.getSense().trim();
            }
        }
        return null;
    }

    private String buildString(List<String> values) {
        StringBuilder string = new StringBuilder();
        for (String value : values) {
            if (string.length() > 0) {
                string.append("\n");
            }
            string.append(value);
        }
        return string.length() > 0 ? string.toString() : null;
    }

    private void addMessage(Set<Message> messages, String text, String details, MessageType type, Object ... parameters) {
        Message message = new Message();
        message.setType(type);
        message.setMessage(L10nResourcesManager.createL10nMessage((String)text, (Object[])parameters));
        message.setDetails(details);
        if (!messages.contains(message)) {
            messages.add(message);
        }
    }

    public static FilledTemplateDocument createErrorDocument(Set<Message> messages) {
        FilledTemplateDocument result = new FilledTemplateDocument();
        result.getMessages().addAll(messages);
        return result;
    }

    private String getFileName(Payment payment, FinanceDocument doc) {
        StringBuilder sb = new StringBuilder(doc.getType().name()).append(" ").append(TextUtil.buildFullNumber((CompositeNumber)doc));
        sb.append("(").append(new SimpleDateFormat("yyyyMMdd_hh:mm").format(new Date())).append(')');
        return sb.toString();
    }

    private String getReportTitle(Payment payment, FinanceDocument doc) {
        StringBuilder sb = new StringBuilder().append(doc.getTemplate()).append(' ').append(TextUtil.buildFullNumber((CompositeNumber)doc));
        sb.append("(").append(new SimpleDateFormat("yyyyMMdd_hh:mm").format(new Date())).append(')');
        return sb.toString();
    }

    static {
        productTypes.put(ProductType.AIR_TICKET, "1");
        productTypes.put(ProductType.RAILWAY_PRODUCT, "2");
        productTypes.put(ProductType.INSURANCE_TOURISTIC, "3");
    }
}

