/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.assets;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;

public class UserAccount
extends BaseAsset {
    private static final long serialVersionUID = -3440194633858358888L;
    public static final String SYS_ADMIN = "systemAdministrator";
    private String loginName;
    private boolean active;
    private byte[] passwordDigest;
    private Date passwordLastUpdateDate;
    private byte[] ssoSaltDigest;
    private Date ssoSaltDigestLastUpdateDate;
    private Date activeLastUpdateDate;
    private Date temporarilyBlockDate;
    private String fullName;
    private String notes;
    private String email;
    private final List<byte[]> passwordDigests = new ArrayList<byte[]>();
    private Date createDate;
    private Date lastLoginDate;
    private Date expiryDate;

    public static byte[] digest(char[] str) throws Exception {
        if (str == null || str.length == 0) {
            return new byte[0];
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(Charset.forName("UTF-8").encode(CharBuffer.wrap(str)));
        return md5.digest();
    }

    public UserAccount() {
    }

    public UserAccount(String uid) {
        super(uid);
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String value) {
        this.loginName = value;
        if (TextUtil.isBlank((String)this.fullName)) {
            this.fullName = value;
        }
    }

    public boolean isPasswordValid(char[] password) throws Exception {
        return this.isPasswordValid(UserAccount.digest(password));
    }

    public boolean isPasswordValid(byte[] password) throws Exception {
        if (password == null || password.length == 0) {
            if (!(this.passwordDigest != null && this.passwordDigest.length != 0 || this.ssoSaltDigest != null && this.ssoSaltDigest.length != 0)) {
                String message = "Attempt to validate empty password for account \"" + this.loginName + "\" with both passwordDigest and ssoSaltDigest being empty";
                IncidentsLog.reportException((String)message, (Throwable)new IllegalStateException(message));
                return true;
            }
            return false;
        }
        return Arrays.equals(this.passwordDigest, password);
    }

    public void setPassword(char[] password) throws Exception {
        this.passwordDigest = UserAccount.digest(password);
    }

    public byte[] getPasswordDigest() {
        return this.passwordDigest;
    }

    public void setPasswordDigest(byte[] value) {
        this.passwordDigest = value;
    }

    public Date getPasswordLastUpdateDate() {
        return this.passwordLastUpdateDate;
    }

    public void setPasswordLastUpdateDate(Date passwordLastUpdateDate) {
        this.passwordLastUpdateDate = passwordLastUpdateDate;
    }

    public byte[] getSsoSaltDigest() {
        return this.ssoSaltDigest;
    }

    public void setSsoSalt(char[] ssoSalt) throws Exception {
        this.setSsoSaltDigest(UserAccount.digest(ssoSalt));
    }

    public void setSsoSaltDigest(byte[] ssoSaltDigest) {
        this.ssoSaltDigest = ssoSaltDigest;
    }

    public Date getSsoSaltDigestLastUpdateDate() {
        return this.ssoSaltDigestLastUpdateDate;
    }

    public void setSsoSaltDigestLastUpdateDate(Date ssoSaltDigestLastUpdateDate) {
        this.ssoSaltDigestLastUpdateDate = ssoSaltDigestLastUpdateDate;
    }

    public Date getActiveLastUpdateDate() {
        return this.activeLastUpdateDate;
    }

    public void setActiveLastUpdateDate(Date activeLastUpdateDate) {
        this.activeLastUpdateDate = activeLastUpdateDate;
    }

    public Date getTemporarilyBlockDate() {
        return this.temporarilyBlockDate;
    }

    public void setTemporarilyBlockDate(Date temporarilyBlockDate) {
        this.temporarilyBlockDate = temporarilyBlockDate;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String value) {
        this.fullName = value;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String value) {
        this.notes = value;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String value) {
        this.email = value;
    }

    public List<byte[]> getPasswordDigests() {
        return this.passwordDigests;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public void setLastLoginDate(Date lastLoginDate) {
        this.lastLoginDate = lastLoginDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.active = XHelper.readBoolean((Element)elm, (String)"active", (boolean)false);
        this.loginName = XHelper.readString((Element)elm, (String)"loginName");
        this.passwordDigest = XHelper.readBytes((Element)elm, (String)"password");
        this.passwordLastUpdateDate = XHelper.readDate((Element)elm, (String)"passwordLastUpdateDate");
        this.ssoSaltDigest = XHelper.readBytes((Element)elm, (String)"ssoSaltDigest");
        this.ssoSaltDigestLastUpdateDate = XHelper.readDate((Element)elm, (String)"ssoSaltDigestLastUpdateDate");
        this.activeLastUpdateDate = XHelper.readDate((Element)elm, (String)"activeLastUpdateDate");
        this.temporarilyBlockDate = XHelper.readDate((Element)elm, (String)"temporarilyBlockDate");
        this.fullName = XHelper.readString((Element)elm, (String)"fullName");
        this.notes = XHelper.readString((Element)elm, (String)"notes");
        this.email = XHelper.readString((Element)elm, (String)"email");
        this.passwordDigests.clear();
        for (Element itemElm : XmlUtil.getElements((Element)elm, (String)"passwordDigests/item")) {
            byte[] item = XHelper.readBytes((Element)itemElm, (String)".");
            if (item == null) continue;
            this.passwordDigests.add(item);
        }
        this.createDate = XHelper.readDate((Element)elm, (String)"createDate");
        this.lastLoginDate = XHelper.readDate((Element)elm, (String)"lastLoginDate");
        this.expiryDate = XHelper.readDate((Element)elm, (String)"expiryDate");
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("active".equals(tagName)) {
            this.active = XSHelper.readBoolean((XMLStreamReader)reader, (boolean)false);
            return true;
        }
        if ("loginName".equals(tagName)) {
            this.loginName = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("password".equals(tagName)) {
            this.passwordDigest = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("passwordLastUpdateDate".equals(tagName)) {
            this.passwordLastUpdateDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("ssoSaltDigest".equals(tagName)) {
            this.ssoSaltDigest = XSHelper.readBytes((XMLStreamReader)reader);
            return true;
        }
        if ("ssoSaltDigestLastUpdateDate".equals(tagName)) {
            this.ssoSaltDigestLastUpdateDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("activeLastUpdateDate".equals(tagName)) {
            this.activeLastUpdateDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("temporarilyBlockDate".equals(tagName)) {
            this.temporarilyBlockDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("fullName".equals(tagName)) {
            this.fullName = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("notes".equals(tagName)) {
            this.notes = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("passwordDigests".equals(tagName)) {
            while (reader.nextTag() != 2) {
                if ("item".equals(reader.getName().getLocalPart())) {
                    this.passwordDigests.add(XSHelper.readBytes((XMLStreamReader)reader));
                    continue;
                }
                XSHelper.skipElement((XMLStreamReader)reader);
            }
            return true;
        }
        if ("email".equals(tagName)) {
            this.email = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("createDate".equals(tagName)) {
            this.createDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("lastLoginDate".equals(tagName)) {
            this.lastLoginDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        if ("expiryDate".equals(tagName)) {
            this.expiryDate = XSHelper.readDate((XMLStreamReader)reader);
            return true;
        }
        return false;
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeBoolean((Element)elm, (String)"active", (boolean)this.active);
        XHelper.writeString((Element)elm, (String)"loginName", (String)this.loginName);
        XHelper.writeBytes((Element)elm, (String)"password", (byte[])this.passwordDigest, (String)"base64");
        XHelper.writeDate((Element)elm, (String)"passwordLastUpdateDate", (Date)this.passwordLastUpdateDate);
        XHelper.writeBytes((Element)elm, (String)"ssoSaltDigest", (byte[])this.ssoSaltDigest, (String)"base64");
        XHelper.writeDate((Element)elm, (String)"ssoSaltDigestLastUpdateDate", (Date)this.ssoSaltDigestLastUpdateDate);
        XHelper.writeDate((Element)elm, (String)"activeLastUpdateDate", (Date)this.activeLastUpdateDate);
        XHelper.writeDate((Element)elm, (String)"temporarilyBlockDate", (Date)this.temporarilyBlockDate);
        XHelper.writeString((Element)elm, (String)"fullName", (String)this.fullName);
        XHelper.writeString((Element)elm, (String)"notes", (String)this.notes, (boolean)true);
        XHelper.writeString((Element)elm, (String)"email", (String)this.email, (boolean)true);
        for (byte[] item : this.passwordDigests) {
            XHelper.writeBytes((Element)elm, (String)"passwordDigests/item", (byte[])item);
        }
        XHelper.writeDate((Element)elm, (String)"createDate", (Date)this.createDate);
        XHelper.writeDate((Element)elm, (String)"lastLoginDate", (Date)this.lastLoginDate);
        XHelper.writeDate((Element)elm, (String)"expiryDate", (Date)this.expiryDate);
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeBoolean((XMLStreamWriter)writer, (String)"active", (boolean)this.active);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"loginName", (String)this.loginName);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"password", (byte[])this.passwordDigest, (String)"base64");
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"passwordLastUpdateDate", (Date)this.passwordLastUpdateDate);
        XSHelper.writeBytes((XMLStreamWriter)writer, (String)"ssoSaltDigest", (byte[])this.ssoSaltDigest, (String)"base64");
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"ssoSaltDigestLastUpdateDate", (Date)this.ssoSaltDigestLastUpdateDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"activeLastUpdateDate", (Date)this.activeLastUpdateDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"temporarilyBlockDate", (Date)this.temporarilyBlockDate);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"fullName", (String)this.fullName);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"notes", (String)this.notes, (boolean)true);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"email", (String)this.email, (boolean)true);
        if (!this.passwordDigests.isEmpty() && !CollectionUtil.containsOnlyNulls(this.passwordDigests)) {
            writer.writeStartElement("types");
            for (byte[] item : this.passwordDigests) {
                XSHelper.writeBytes((XMLStreamWriter)writer, (String)"item", (byte[])item);
            }
            writer.writeEndElement();
        }
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"createDate", (Date)this.createDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"lastLoginDate", (Date)this.lastLoginDate);
        XSHelper.writeDate((XMLStreamWriter)writer, (String)"expiryDate", (Date)this.expiryDate);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        UserAccount source = (UserAccount)sourceAsset;
        this.active = source.active;
        this.loginName = source.loginName;
        this.passwordDigest = (byte[])XCloneHelper.cloneArray((Object)source.passwordDigest, (boolean)newUids, uids);
        this.passwordLastUpdateDate = XCloneHelper.cloneDate((Date)source.passwordLastUpdateDate);
        this.ssoSaltDigest = (byte[])XCloneHelper.cloneArray((Object)source.ssoSaltDigest, (boolean)newUids, uids);
        this.ssoSaltDigestLastUpdateDate = XCloneHelper.cloneDate((Date)source.ssoSaltDigestLastUpdateDate);
        this.activeLastUpdateDate = XCloneHelper.cloneDate((Date)source.activeLastUpdateDate);
        this.temporarilyBlockDate = XCloneHelper.cloneDate((Date)source.temporarilyBlockDate);
        this.fullName = source.fullName;
        this.notes = source.notes;
        this.email = source.email;
        this.passwordDigests.clear();
        this.passwordDigests.addAll(XCloneHelper.cloneCollection(source.passwordDigests, (boolean)newUids, uids));
        this.createDate = XCloneHelper.cloneDate((Date)source.createDate);
        this.lastLoginDate = XCloneHelper.cloneDate((Date)source.lastLoginDate);
        this.expiryDate = XCloneHelper.cloneDate((Date)source.expiryDate);
    }

    public String toString() {
        return String.format("%s (%s)", this.loginName, this.fullName);
    }

    public static enum Property {
        loginName,
        active,
        passwordDigest,
        passwordLastUpdateDate,
        activeLastUpdateDate,
        fullName,
        notes,
        email,
        createDate,
        lastLoginDate,
        expiryDate;

    }
}

