/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;

public class HttpHelper {
    public static ContentType getContentType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (mimeType.toLowerCase().contains("application/vnd.ms-excel")) {
            return ContentType.EXCEL;
        }
        if (mimeType.toLowerCase().contains("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            return ContentType.EXCEL_2007;
        }
        if (mimeType.toLowerCase().contains("application/msword")) {
            return ContentType.WORD;
        }
        if (mimeType.toLowerCase().contains("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
            return ContentType.WORD_2007;
        }
        if (mimeType.toLowerCase().contains("text/html; charset=utf-8")) {
            return ContentType.HTML;
        }
        if (mimeType.toLowerCase().contains("application/pdf")) {
            return ContentType.PDF;
        }
        if (mimeType.toLowerCase().contains("application/dbase")) {
            return ContentType.DBF;
        }
        if (mimeType.toLowerCase().contains("application/x-dbase")) {
            return ContentType.DBF;
        }
        if (mimeType.toLowerCase().contains("application/dbf")) {
            return ContentType.DBF;
        }
        if (mimeType.toLowerCase().contains("application/x-dbf")) {
            return ContentType.DBF;
        }
        if (mimeType.toLowerCase().contains("application/xml")) {
            return ContentType.XML;
        }
        if (mimeType.toLowerCase().contains("text/plain; charset=utf-8")) {
            return ContentType.TEXT;
        }
        if (mimeType.toLowerCase().contains("text/css; charset=utf-8")) {
            return ContentType.CSS;
        }
        if (mimeType.toLowerCase().contains("image/gif")) {
            return ContentType.GIF;
        }
        if (mimeType.toLowerCase().contains("image/jpeg")) {
            return ContentType.JPEG;
        }
        if (mimeType.toLowerCase().contains("image/png")) {
            return ContentType.PNG;
        }
        if (mimeType.toLowerCase().contains("image/svg+xml")) {
            return ContentType.SVG;
        }
        if (mimeType.toLowerCase().contains("image/x-icon")) {
            return ContentType.ICO;
        }
        if (mimeType.toLowerCase().contains("text/calendar; charset=utf-8")) {
            return ContentType.CALENDAR;
        }
        if (mimeType.toLowerCase().contains("application/octet-stream")) {
            return ContentType.BINARY;
        }
        return null;
    }

    public static String getMimeType(ContentType contentType) {
        if (contentType == null) {
            return null;
        }
        switch (contentType) {
            case EXCEL: {
                return "application/vnd.ms-excel";
            }
            case EXCEL_2007: {
                return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
            }
            case WORD: {
                return "application/msword";
            }
            case HTML: {
                return "text/html; charset=utf-8";
            }
            case PDF: {
                return "application/pdf";
            }
            case DBF: {
                return "application/vnd.ms-excel";
            }
            case XML: {
                return "application/xml";
            }
            case TEXT: {
                return "text/plain; charset=utf-8";
            }
            case CSS: {
                return "text/css; charset=utf-8";
            }
            case GIF: {
                return "image/gif";
            }
            case JPEG: {
                return "image/jpeg";
            }
            case PNG: {
                return "image/png";
            }
            case SVG: {
                return "image/svg+xml";
            }
            case ICO: {
                return "image/x-icon";
            }
            case CALENDAR: {
                return "text/calendar; charset=utf-8";
            }
            case WORD_2007: {
                return "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
            }
        }
        return "application/octet-stream";
    }

    public static ContentType detectContentType(String fileName) {
        if (TextUtil.isBlank((String)fileName)) {
            return null;
        }
        int p = fileName.lastIndexOf(46);
        if (p == -1 || p == fileName.length() - 1) {
            return ContentType.BINARY;
        }
        String ext = fileName.substring(p + 1).toLowerCase(Locale.ROOT);
        if ("xls".equals(ext) || "xlsm".equals(ext)) {
            return ContentType.EXCEL;
        }
        if ("xlsx".equals(ext)) {
            return ContentType.EXCEL_2007;
        }
        if ("doc".equals(ext) || "docx".equals(ext) || "docm".equals(ext)) {
            return ContentType.WORD;
        }
        if ("htm".equals(ext) || "html".equals(ext)) {
            return ContentType.HTML;
        }
        if ("pdf".equals(ext)) {
            return ContentType.PDF;
        }
        if ("xml".equals(ext)) {
            return ContentType.XML;
        }
        if ("txt".equals(ext)) {
            return ContentType.TEXT;
        }
        if ("gif".equals(ext)) {
            return ContentType.GIF;
        }
        if ("dbf".equals(ext)) {
            return ContentType.DBF;
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return ContentType.JPEG;
        }
        if ("png".equals(ext)) {
            return ContentType.PNG;
        }
        if ("css".equals(ext)) {
            return ContentType.CSS;
        }
        if ("ico".equals(ext)) {
            return ContentType.ICO;
        }
        if ("svg".equals(ext)) {
            return ContentType.SVG;
        }
        return ContentType.BINARY;
    }
}

