/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class MessagesHelper {
    public static Message createMessage(MessageType messageType, String key, Object ... parameters) {
        return MessagesHelper.createMessage(messageType, key, null, parameters);
    }

    public static Message createMessage(MessageType messageType, String key, Throwable error, Object ... parameters) {
        Message result = new Message();
        result.setType(messageType);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        if (error != null) {
            StringWriter writer = new StringWriter();
            error.printStackTrace(new PrintWriter(writer));
            result.setDetails(writer.toString());
            Xeption xeption = (Xeption)IncidentsHelper.findCause((Throwable)error, Xeption.class);
            if (xeption != null) {
                result.setXeptionMessage((L10nMessage)MiscUtil.guarded((Object)xeption.getEndUserMessage(), (Object)xeption.getAdminMessage()));
            }
        }
        return result;
    }

    public static Message createMessage(MessageType messageType, L10nMessage message, Throwable error) {
        Message result = new Message();
        result.setType(messageType);
        result.setMessage(message);
        if (error != null) {
            StringWriter writer = new StringWriter();
            error.printStackTrace(new PrintWriter(writer));
            result.setDetails(writer.toString());
        }
        return result;
    }

    public static List<Message> createMessages(MessageType messageType, Collection<L10nMessage> messages, Throwable error) {
        if (messageType == null) {
            return Collections.emptyList();
        }
        return messages.stream().filter(Objects::nonNull).map(m -> MessagesHelper.createMessage(messageType, m, error)).collect(Collectors.toList());
    }

    public static Message createMessageWithDetails(MessageType messageType, String key, String details, Object ... parameters) {
        Message result = new Message();
        result.setType(messageType);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)key, (Object[])parameters));
        result.setDetails(details);
        return result;
    }

    public static boolean hasErrorMessage(Iterable<Message> messages) {
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    public static boolean hasErrorMessage(Message ... messages) {
        if (messages == null || messages.length == 0) {
            return false;
        }
        for (Message message : messages) {
            if (message.getType() != MessageType.ERROR) continue;
            return true;
        }
        return false;
    }

    private MessagesHelper() {
    }

    public static class MessageBuilder {
        private final MessageType type;
        private String key;
        private String details;
        private Throwable error;
        private final Collection<Object> parameters = new ArrayList<Object>();

        public static MessageBuilder of(MessageType type) {
            return new MessageBuilder(type);
        }

        private MessageBuilder(MessageType type) {
            this.type = type;
        }

        public MessageBuilder key(String key) {
            this.key = key;
            return this;
        }

        public MessageBuilder details(String details) {
            this.details = details;
            return this;
        }

        public MessageBuilder error(Throwable error) {
            this.error = error;
            return this;
        }

        public MessageBuilder parameters(Object ... parameters) {
            this.parameters.clear();
            this.parameters.addAll(Arrays.asList(parameters));
            return this;
        }

        public Message build() {
            Message message = new Message();
            message.setType(this.type);
            message.setMessage(L10nResourcesManager.createL10nMessage((String)this.key, (Object[])new Object[]{this.parameters}));
            message.setDetails(this.details);
            if (this.error != null) {
                StringWriter writer = new StringWriter();
                this.error.printStackTrace(new PrintWriter(writer));
                message.setDetails(writer.toString());
            }
            return message;
        }
    }
}

