/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.standard.helpers;

import com.gridnine.xtrip.common.model.system.NamedValue;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class NamedValueHelper {
    public static String getValueForName(String name, Collection<NamedValue> namedValues) {
        return Optional.ofNullable(NamedValueHelper.getNamedValueForName(name, namedValues)).map(NamedValue::getValue).orElse(null);
    }

    public static void setValueForName(String name, String value, Collection<NamedValue> namedValues) {
        Optional<NamedValue> namedValue = Optional.ofNullable(NamedValueHelper.getNamedValueForName(name, namedValues));
        if (namedValue.isPresent()) {
            namedValue.get().setValue(value);
        } else {
            namedValues.add(NamedValueHelper.namedValue(name, value));
        }
    }

    public static NamedValue getNamedValueForName(String name, Collection<NamedValue> namedValues) {
        return namedValues.stream().filter(Objects::nonNull).filter(namedValue -> TextUtil.equals((String)name, (String)namedValue.getName(), (boolean)true)).findFirst().orElse(null);
    }

    public static boolean containsValueForName(String name, Collection<NamedValue> namedValues) {
        return NamedValueHelper.getNamedValueForName(name, namedValues) != null;
    }

    public static boolean containsValueForName(String name, String value, Collection<NamedValue> namedValues) {
        return namedValues.stream().filter(Objects::nonNull).filter(namedValue -> TextUtil.equals((String)namedValue.getName(), (String)name, (boolean)true)).filter(namedValue -> TextUtil.equals((String)namedValue.getValue(), (String)value, (boolean)true)).findFirst().isPresent();
    }

    public static boolean containsValuesWithNameStartingWith(String nameStartsWith, Collection<NamedValue> namedValues) {
        return namedValues.stream().filter(Objects::nonNull).filter(namedValue -> StringUtils.startsWith((String)namedValue.getName(), (String)nameStartsWith)).findFirst().isPresent();
    }

    public static Iterator<NamedValue> itrValuesWithNameStartingWith(final String nameStartsWith, final Collection<NamedValue> namedValues) {
        return new Iterator<NamedValue>(){
            final Iterator<NamedValue> itr;
            boolean needsToFindNext;
            boolean hasFoundNext;
            NamedValue nextNamedValue;
            {
                this.itr = namedValues.iterator();
                this.needsToFindNext = true;
                this.hasFoundNext = false;
            }

            @Override
            public boolean hasNext() {
                if (this.needsToFindNext) {
                    this.hasFoundNext = false;
                    while (this.itr.hasNext()) {
                        this.nextNamedValue = this.itr.next();
                        if (!this.nextNamedValue.getName().startsWith(nameStartsWith)) continue;
                        this.hasFoundNext = true;
                        break;
                    }
                    this.needsToFindNext = false;
                }
                return this.hasFoundNext;
            }

            @Override
            public NamedValue next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.needsToFindNext = true;
                return this.nextNamedValue;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported");
            }
        };
    }

    public static boolean containsTrueForName(String name, Collection<NamedValue> namedValues) {
        return Optional.ofNullable(NamedValueHelper.getNamedValueForName(name, namedValues)).map(NamedValue::getValue).map(Boolean::valueOf).orElse(false);
    }

    public static NamedValue namedValue(String name, String value) {
        NamedValue result = new NamedValue();
        result.setName(name);
        result.setValue(value);
        return result;
    }

    public static Map<String, String> toMap(Collection<NamedValue> namedValues) {
        return namedValues.stream().filter(Objects::nonNull).collect(Collectors.toMap(NamedValue::getName, NamedValue::getValue));
    }
}

