/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescription;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeDescriptionItem;
import com.gridnine.xtrip.common.gds.model.AncillaryFeeType;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class GdsDictHelper {
    public static final String AIRLINE_POBEDA = "DP";
    public static final String AIRLINE_S7 = "S7";
    public static final String AIRLINE_AZIMUT = "A4";
    public static final String AIRLINE_AEROFLOT = "SU";
    public static final String AIRLINE_BELAVIA = "B2";
    public static final String AIRLINE_AURORA = "HZ";
    public static final String AIRLINE_TRAFFIC = "YK";
    private static final Map<AncillaryFeeType, MCOCategory> ancillaryFeeType2McoCategoryMap = new HashMap<AncillaryFeeType, MCOCategory>();

    public static boolean isWithoutSeat(DictionaryReference<PassengerType> ptRef) {
        return ((PassengerType)DictionaryCache.get().resolveReference(ptRef)).isWithoutSeat();
    }

    public static DictionaryReference<Aircraft> findAircraftBySpellVariant(String spellVariant) {
        for (Aircraft aircraft : DictionaryCache.get().getAll(Aircraft.class).values()) {
            for (String sv : aircraft.getSpellVariants()) {
                if (!sv.equalsIgnoreCase(spellVariant)) continue;
                return aircraft.toReference();
            }
        }
        return null;
    }

    public static boolean isSuCarrier(Flight flight) {
        return GdsDictHelper.isSuCarrier((DictionaryReference<Airline>)flight.getCarrier());
    }

    public static boolean isSuCarrier(DictionaryReference<Airline> carrier) {
        Airline carrierRes = (Airline)DictionaryCache.get().resolveReference(carrier);
        return Objects.nonNull(carrierRes) && MiscUtil.equals(carrierRes.getCodeVariants().get(CodeSystem.IATA.name()), (Object)AIRLINE_AEROFLOT);
    }

    public static boolean containsSuAirline(Flight flight) {
        return FlightHelper.getSegments(flight).stream().anyMatch(s -> GdsDictHelper.isSuCarrier((DictionaryReference<Airline>)s.getAirline()));
    }

    public static DictionaryReference<Airline> findAirlineBySpellVariant(String spellVariant) {
        for (Airline airline : DictionaryCache.get().getAll(Airline.class).values()) {
            for (String sv : airline.getSpellVariants()) {
                if (!sv.equalsIgnoreCase(spellVariant)) continue;
                return airline.toReference();
            }
        }
        return null;
    }

    public static AncillaryFeeDescription findAncillaryFeeDescription(AncillaryFeeType type, DictionaryReference<Airline> airline, String serviceCode, String serviceName, GdsName gdsName) {
        for (AncillaryFeeDescription description : DictionaryCache.get().getAll(AncillaryFeeDescription.class).values()) {
            if (type != null && !type.equals((Object)description.getType())) continue;
            for (AncillaryFeeDescriptionItem descriptionItem : description.getDescriptionItems()) {
                if (descriptionItem.getGds() != null && !descriptionItem.getGds().equals((Object)gdsName) || descriptionItem.getAirline() != null && airline != null && !MiscUtil.equals((Object)descriptionItem.getAirline(), airline) || !TextUtil.isSame((String)descriptionItem.getServiceCode(), (String)serviceCode) || !TextUtil.isSame((String)descriptionItem.getServiceName(), (String)serviceName)) continue;
                return description;
            }
        }
        return null;
    }

    public static AncillaryFeeDescription findAncillaryFeeDescriptionByServiceCode(AncillaryFeeType type, String serviceCode, GdsName gdsName) {
        return GdsDictHelper.findAncillaryFeeDescription(type, null, serviceCode, null, gdsName);
    }

    public static AncillaryFeeDescription findAncillaryFeeDescriptionByServiceName(AncillaryFeeType type, String serviceName, GdsName gdsName) {
        return GdsDictHelper.findAncillaryFeeDescription(type, null, null, serviceName, gdsName);
    }

    public static Integer getTravelDuration(DictionaryReference<GeoLocation> locationBegin, DictionaryReference<GeoLocation> locationEnd, Date dateBegin, Date dateEnd) {
        ZonedDateTime zonedBegin = DictHelper.getZonedDateTime((Date)dateBegin, locationBegin, (boolean)true);
        if (zonedBegin == null) {
            return null;
        }
        ZonedDateTime zonedEnd = DictHelper.getZonedDateTime((Date)dateEnd, locationEnd, (boolean)true);
        if (zonedEnd == null) {
            return null;
        }
        return (int)Duration.between(zonedBegin, zonedEnd).toMinutes();
    }

    public static Integer getTravelDuration(DictionaryReference<GeoLocation> locationBegin, DictionaryReference<GeoLocation> locationEnd, LocalDateTime dateBegin, LocalDateTime dateEnd) {
        ZonedDateTime zonedBegin = DictHelper.getZonedDateTime((LocalDateTime)dateBegin, locationBegin);
        if (zonedBegin == null) {
            return null;
        }
        ZonedDateTime zonedEnd = DictHelper.getZonedDateTime((LocalDateTime)dateEnd, locationEnd);
        if (zonedEnd == null) {
            return null;
        }
        return (int)Duration.between(zonedBegin, zonedEnd).toMinutes();
    }

    public static AncillaryFeeType parseAncillaryFeeType(String code) {
        return GdsDictHelper.parseAncillaryFeeType(code, false);
    }

    public static AncillaryFeeType parseAncillaryFeeType(String code, boolean ignoreUnknown) {
        if (code == null) {
            return null;
        }
        switch (code) {
            case "BG": {
                return AncillaryFeeType.BAGGAGE;
            }
            case "ML": {
                return AncillaryFeeType.MEALS;
            }
            case "SA": {
                return AncillaryFeeType.PREFERRED_SEATING;
            }
            case "IE": {
                return AncillaryFeeType.IN_FLIGHT_ENTERTAINMENT;
            }
            case "PT": {
                return AncillaryFeeType.PETS;
            }
            case "LG": {
                return AncillaryFeeType.LOUNGE;
            }
            case "MD": {
                return AncillaryFeeType.MEDICAL;
            }
            case "GT": {
                return AncillaryFeeType.GROUND_TRANSPORTATION;
            }
            case "TS": {
                return AncillaryFeeType.TRAVEL_SERVICES;
            }
            case "UN": {
                return AncillaryFeeType.UNACCOMPANIED_PASSENGERS;
            }
            case "SB": {
                return AncillaryFeeType.STANDBY;
            }
            case "UP": {
                return AncillaryFeeType.UPGRADES;
            }
            case "BD": {
                return AncillaryFeeType.BUNDLED_SERVICE;
            }
            case "PS": {
                return AncillaryFeeType.EXPRESS_MAIL;
            }
            case "BF": {
                return AncillaryFeeType.BRANDED_FARES;
            }
            case "ST": {
                return AncillaryFeeType.STORE;
            }
        }
        if (ignoreUnknown) {
            return null;
        }
        throw Xeption.forDeveloper((String)"unexpected ancillary fee type code {0}", (Object[])new Object[]{code});
    }

    public static MCOCategory convertToMcoCategory(AncillaryFeeType type) {
        return ancillaryFeeType2McoCategoryMap.get(type);
    }

    static {
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.BAGGAGE, MCOCategory.EXCESS_LUGGAGE);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.MEALS, MCOCategory.SPECIAL_FOOD);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.PREFERRED_SEATING, MCOCategory.SEAT_RESERVATION);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.IN_FLIGHT_ENTERTAINMENT, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.UNACCOMPANIED_PASSENGERS, MCOCategory.UNESCORTED_MINOR);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.PETS, MCOCategory.ANIMALS);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.STANDARD_PLUS, MCOCategory.STANDARD_PLUS);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.COMFORT, MCOCategory.COMFORT);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.COMFORT_PLUS, MCOCategory.COMFORT_PLUS);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.LOUNGE, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.MEDICAL, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.GROUND_TRANSPORTATION, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.TRAVEL_SERVICES, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.STANDBY, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.BUNDLED_SERVICE, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.UPGRADES, MCOCategory.ADDITIONAL_TARIFF);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.EXPRESS_MAIL, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.BRANDED_FARES, MCOCategory.ADDITIONAL_SERVICES);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.FLIGHT_INSURANCE, MCOCategory.FLIGHT_INSURANCE);
        ancillaryFeeType2McoCategoryMap.put(AncillaryFeeType.SMS_NOTIFICATIONS, MCOCategory.SMS_NOTIFICATIONS);
    }
}

