/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.model.GDSParameters;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Introspectable;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageContext;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Pcc;
import com.gridnine.xtrip.common.model.profile.PccParameter;
import com.gridnine.xtrip.common.model.profile.PccParameterName;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.SalesPointIndex;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.List;
import java.util.stream.Collectors;

public final class PccHelper {
    private static final String BOOKING = "booking";
    private static final String TICKETING = "ticketing";
    private static final String SEARCH = "search";
    private static final String PCC = "PCC";
    private static final String PCCRef = "PCCRef";

    public static void setBookingPcc(GDSParameters params, String code, NestedEntityReference<SalesPoint, Pcc> ref) {
        PccHelper.setPcc((Introspectable)params, BOOKING, code, ref);
    }

    public static void setTicketingPcc(GDSParameters params, String code, NestedEntityReference<SalesPoint, Pcc> ref) {
        PccHelper.setPcc((Introspectable)params, TICKETING, code, ref);
    }

    public static void setSearchPcc(GDSParameters params, String code, NestedEntityReference<SalesPoint, Pcc> ref) {
        PccHelper.setPcc((Introspectable)params, SEARCH, code, ref);
    }

    private static void setPcc(Introspectable obj, String memberIdPrefix, String code, NestedEntityReference<SalesPoint, Pcc> ref) {
        obj.setValue(memberIdPrefix + PCC, (Object)code);
        obj.setValue(memberIdPrefix + PCCRef, ref);
    }

    public static String getBookingPccCode(GDSParameters params) {
        return PccHelper.getPccCode((Introspectable)params, BOOKING);
    }

    public static String getTicketingPccCode(GDSParameters params) {
        return PccHelper.getPccCode((Introspectable)params, TICKETING);
    }

    public static String getSearchPccCode(GDSParameters params) {
        return PccHelper.getPccCode((Introspectable)params, SEARCH);
    }

    private static String getPccCode(Introspectable obj, String memberIdPrefix) {
        String code = (String)obj.getValue(memberIdPrefix + PCC);
        if (!TextUtil.isBlank((String)code)) {
            return code;
        }
        NestedEntityReference ref = (NestedEntityReference)obj.getValue(memberIdPrefix + PCCRef);
        if (ref == null) {
            return null;
        }
        Pcc pcc = (Pcc)EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)EntityStorageHelper.createContext());
        return pcc == null ? null : pcc.getCode();
    }

    public static Pcc getBookingPcc(GDSParameters params, EntityReference<SalesPoint> spRef, GdsName gdsName) {
        return PccHelper.getPcc((Introspectable)params, BOOKING, spRef, gdsName);
    }

    public static Pcc getTicketingPcc(GDSParameters params, EntityReference<SalesPoint> spRef, GdsName gdsName) {
        return PccHelper.getPcc((Introspectable)params, TICKETING, spRef, gdsName);
    }

    public static NestedEntityReference<SalesPoint, Pcc> getTicketingPccRef(GDSParameters params) {
        return PccHelper.getPccRef(params, TICKETING);
    }

    private static NestedEntityReference<SalesPoint, Pcc> getPccRef(GDSParameters params, String memberIdPrefix) {
        NestedEntityReference ref = (NestedEntityReference)params.getValue(memberIdPrefix + PCCRef);
        if (ref != null) {
            return ref;
        }
        String code = (String)params.getValue(memberIdPrefix + PCC);
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        SearchResult searchResult = EntityStorage.get().search(SalesPointIndex.class, new SearchQuery());
        SalesPointIndex idxWithThePcc = null;
        for (SalesPointIndex idx : searchResult.getData()) {
            if (!idx.getPccs().contains(code)) continue;
            idxWithThePcc = idx;
            break;
        }
        EntityContainer spCtr = EntityStorage.get().resolve(idxWithThePcc.getSource());
        for (Pcc pcc : ((SalesPoint)spCtr.getEntity()).getPccs()) {
            if (!code.equalsIgnoreCase(pcc.getCode())) continue;
            return new NestedEntityReference(spCtr, (BaseEntity)pcc);
        }
        return null;
    }

    public static Pcc getSearchPcc(GDSParameters params, EntityReference<SalesPoint> spRef, GdsName gdsName) {
        return PccHelper.getPcc((Introspectable)params, SEARCH, spRef, gdsName);
    }

    private static Pcc getPcc(Introspectable obj, String memberIdPrefix, EntityReference<SalesPoint> spRef, GdsName gdsName) {
        try {
            Pcc result;
            NestedEntityReference ref = (NestedEntityReference)obj.getValue(memberIdPrefix + PCCRef);
            if (ref != null && (result = (Pcc)EntityStorageHelper.resolve((NestedEntityReference)ref, (EntityStorageContext)EntityStorageHelper.createContext())) != null) {
                return result;
            }
        }
        catch (IllegalArgumentException ref) {
            // empty catch block
        }
        String code = (String)obj.getValue(memberIdPrefix + PCC);
        return PccHelper.findPccGds(code, gdsName, spRef);
    }

    public static Pcc findPccGds(String code, GdsName gdsName, EntityReference<SalesPoint> spRef) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        return spRef == null ? PccHelper.findPcc(code, gdsName) : PccHelper.findPcc(spRef, code, gdsName);
    }

    public static Pcc findPcc(EntityReference<SalesPoint> spRef, String code, GdsName gdsName) {
        EntityContainer resolve = EntityStorage.get().resolve(spRef);
        if (resolve != null && resolve.getEntity() != null) {
            for (Pcc pcc : ((SalesPoint)resolve.getEntity()).getPccs()) {
                if (pcc == null || !TextUtil.isSame((String)pcc.getCode(), (String)code, (boolean)true) || !gdsName.equals((Object)pcc.getGdsName())) continue;
                return pcc;
            }
        }
        throw Xeption.forAdmin((String)"PCC \u0441 \u043a\u043e\u0434\u043e\u043c {0} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0432 \u0442\u043e\u0447\u043a\u0435 \u043f\u0440\u043e\u0434\u0430\u0436 {1}", (Object[])new Object[]{code, spRef});
    }

    public static Pcc findPcc(String code, GdsName gdsName) {
        SearchResult searchResult = EntityStorage.get().search(SalesPointIndex.class, new SearchQuery());
        SalesPointIndex idxWithThePcc = null;
        for (SalesPointIndex idx : searchResult.getData()) {
            if (!idx.getPccs().contains(code)) continue;
            idxWithThePcc = idx;
            break;
        }
        if (idxWithThePcc == null) {
            throw Xeption.forAdmin((String)"sales point with the pcc {0} not found", (Object[])new Object[]{code});
        }
        EntityContainer spCtr = EntityStorage.get().resolve(idxWithThePcc.getSource());
        List pccs = ((SalesPoint)spCtr.getEntity()).getPccs().stream().filter(pcc -> gdsName.equals((Object)pcc.getGdsName())).collect(Collectors.toList());
        for (Pcc pcc2 : pccs) {
            if (!code.equalsIgnoreCase(pcc2.getCode())) continue;
            return pcc2;
        }
        return null;
    }

    public static String getPccParameter(Pcc pcc, PccParameterName name) {
        for (PccParameter param : pcc.getParameters()) {
            if (param.getName() != name) continue;
            return param.getValue();
        }
        return null;
    }

    public static void setPccParameter(Pcc pcc, PccParameterName name, String value) {
        for (PccParameter param : pcc.getParameters()) {
            if (param.getName() != name) continue;
            param.setValue(value);
            return;
        }
        PccParameter param = new PccParameter();
        param.setName(name);
        param.setValue(value);
        pcc.getParameters().add(param);
    }

    private PccHelper() {
    }
}

