/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.helper;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.FareInfo;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.gds.model.FlightFare;
import com.gridnine.xtrip.common.gds.model.FlightSegment;
import com.gridnine.xtrip.common.gds.model.FlightSegmentTariff;
import com.gridnine.xtrip.common.gds.model.GdsContractRelationData;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.air.AirProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.gds.PenaltiesInfo;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.function.Predicate;

public final class PenaltiesInfoHelper {
    private static PenaltiesInfoValuesProvider refundAfterDepartureProvider = new PenaltiesInfoValuesProvider(){

        @Override
        public Integer getPercentPenalty(PenaltiesInfo info) {
            return info.getRefundAfterDepartureFarePercent();
        }

        @Override
        public Money getFixedPenalty(PenaltiesInfo info) {
            return info.getRefundAfterDeparture();
        }
    };
    private static PenaltiesInfoValuesProvider refundBeforeDepartureProvider = new PenaltiesInfoValuesProvider(){

        @Override
        public Integer getPercentPenalty(PenaltiesInfo info) {
            return info.getRefundBeforeDepartureFarePercent();
        }

        @Override
        public Money getFixedPenalty(PenaltiesInfo info) {
            return info.getRefundBeforeDeparture();
        }
    };
    private static PenaltiesInfoValuesProvider exchangeAfterDepartureProvider = new PenaltiesInfoValuesProvider(){

        @Override
        public Integer getPercentPenalty(PenaltiesInfo info) {
            return info.getExchangeAfterDepartureFarePercent();
        }

        @Override
        public Money getFixedPenalty(PenaltiesInfo info) {
            return info.getExchangeAfterDeparture();
        }
    };
    private static PenaltiesInfoValuesProvider exchangeBeforeDepartureProvider = new PenaltiesInfoValuesProvider(){

        @Override
        public Integer getPercentPenalty(PenaltiesInfo info) {
            return info.getExchangeBeforeDepartureFarePercent();
        }

        @Override
        public Money getFixedPenalty(PenaltiesInfo info) {
            return info.getExchangeBeforeDeparture();
        }
    };

    public static BigDecimal getRefundAfterDepartureEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt) {
        return PenaltiesInfoHelper.getFlightEquivalentSum(flight, pt, refundAfterDepartureProvider);
    }

    public static BigDecimal getRefundBeforeDepartureEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt) {
        return PenaltiesInfoHelper.getFlightEquivalentSum(flight, pt, refundBeforeDepartureProvider);
    }

    public static BigDecimal getExchangeAfterDepartureEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt) {
        return PenaltiesInfoHelper.getFlightEquivalentSum(flight, pt, exchangeAfterDepartureProvider);
    }

    public static BigDecimal getExchangeBeforeDepartureEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt) {
        return PenaltiesInfoHelper.getFlightEquivalentSum(flight, pt, exchangeBeforeDepartureProvider);
    }

    private static BigDecimal getFlightEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt, PenaltiesInfoValuesProvider provider) {
        PenaltiesInfo penaltyInfo = (PenaltiesInfo)flight.getPenaltiesInfos().get(pt);
        if (penaltyInfo == null) {
            return null;
        }
        return PenaltiesInfoHelper.getFlightEquivalentSum(flight, pt, provider.getPercentPenalty(penaltyInfo), provider.getFixedPenalty(penaltyInfo));
    }

    public static BigDecimal getFlightEquivalentSum(Flight flight, DictionaryReference<PassengerType> pt, Integer percent, Money fixed) {
        BigDecimal flightFare;
        double rateValue;
        BigDecimal result = BigDecimal.ZERO;
        String resultCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        GdsContractRelationData cr = FlightHelper.getContractRelation(flight, ContractType.CLIENT, pt);
        if (cr != null && cr.getGeneralData().getCurrency() != null) {
            resultCurrencyCode = cr.getGeneralData().getCurrency().getCode();
        }
        if (fixed != null && fixed.getValue() != null && fixed.getCurrency() != null) {
            if (!fixed.getCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)fixed.getCurrency(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
                result = MiscUtil.mul((BigDecimal)fixed.getValue(), (BigDecimal)BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.UP);
            } else {
                result = MiscUtil.guarded((BigDecimal)fixed.getValue());
            }
        }
        if (percent != null && percent != 0 && (flightFare = FlightHelper.getEquivalentFare(flight, pt)) != null) {
            rateValue = 1.0;
            if (flight.getGdsCurrencyCode() != null && !flight.getGdsCurrencyCode().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)flight.getGdsCurrencyCode(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
            }
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, MiscUtil.guarded((BigDecimal)flightFare).multiply(BigDecimal.valueOf(percent.intValue())).multiply(BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.HALF_UP)});
        }
        return result;
    }

    private static BigDecimal getFlightSegmentEquivalentSum(FlightSegmentTariff st, DictionaryReference<PassengerType> pt, Flight flight, PenaltiesInfoValuesProvider provider) {
        FlightFare flightFare;
        Integer percent;
        Money fixed;
        if (st.getSegments().size() == 0) {
            return null;
        }
        FlightSegment segment = (FlightSegment)st.getSegments().get(0);
        Predicate<FareInfo> flightFareInfoPredicate = fi -> pt.equals((Object)fi.getPassengerType());
        FareInfo fareInfo = segment.getFareInfos().stream().filter(flightFareInfoPredicate).findFirst().orElse(null);
        if (fareInfo == null) {
            return null;
        }
        if (fareInfo.getPenaltiesInfo() == null) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        String resultCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        GdsContractRelationData cr = FlightHelper.getContractRelation(flight, ContractType.CLIENT, pt);
        if (cr != null && cr.getGeneralData().getCurrency() != null) {
            resultCurrencyCode = cr.getGeneralData().getCurrency().getCode();
        }
        if ((fixed = provider.getFixedPenalty(fareInfo.getPenaltiesInfo())) != null && fixed.getValue() != null && fixed.getCurrency() != null) {
            if (!fixed.getCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)fixed.getCurrency(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                double rateValue = rate == null ? 1.0 : rate.getRate();
                result = MiscUtil.mul((BigDecimal)fixed.getValue(), (BigDecimal)BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.UP);
            } else {
                result = MiscUtil.guarded((BigDecimal)fixed.getValue());
            }
        }
        if ((percent = provider.getPercentPenalty(fareInfo.getPenaltiesInfo())) != null && percent != 0 && (flightFare = (FlightFare)flight.getFares().stream().filter(ff -> pt.equals((Object)ff.getPassengerType()) && ff.getSegmentTariff() == st).findFirst().orElse(null)) != null) {
            double rateValue = 1.0;
            if (flight.getGdsCurrencyCode() != null && !flight.getGdsCurrencyCode().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)flight.getGdsCurrencyCode(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
            }
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, MiscUtil.guarded((BigDecimal)flightFare.getEquivalentAmount()).multiply(BigDecimal.valueOf(percent.intValue())).multiply(BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.HALF_UP)});
        }
        return result;
    }

    public static BigDecimal getRefundAfterDepartureEquivalentSum(FlightSegmentTariff st, DictionaryReference<PassengerType> pt, Flight flight) {
        return PenaltiesInfoHelper.getFlightSegmentEquivalentSum(st, pt, flight, refundAfterDepartureProvider);
    }

    public static BigDecimal getRefundBeforeDepartureEquivalentSum(FlightSegmentTariff st, DictionaryReference<PassengerType> pt, Flight flight) {
        return PenaltiesInfoHelper.getFlightSegmentEquivalentSum(st, pt, flight, refundBeforeDepartureProvider);
    }

    public static BigDecimal getExchangeAfterDepartureEquivalentSum(FlightSegmentTariff st, DictionaryReference<PassengerType> pt, Flight flight) {
        return PenaltiesInfoHelper.getFlightSegmentEquivalentSum(st, pt, flight, exchangeAfterDepartureProvider);
    }

    public static BigDecimal getExchangeBeforeDepartureEquivalentSum(FlightSegmentTariff st, DictionaryReference<PassengerType> pt, Flight flight) {
        return PenaltiesInfoHelper.getFlightSegmentEquivalentSum(st, pt, flight, exchangeBeforeDepartureProvider);
    }

    private static BigDecimal getProductEquivalentSum(Product prod, PenaltiesInfoValuesProvider provider) {
        if (prod.getPenaltiesInfo() == null) {
            return null;
        }
        return PenaltiesInfoHelper.getProductEquivalentSum(prod, provider.getPercentPenalty(prod.getPenaltiesInfo()), provider.getFixedPenalty(prod.getPenaltiesInfo()));
    }

    public static BigDecimal getProductEquivalentSum(Product prod, Integer percent, Money fixed) {
        BigDecimal flightFare;
        double rateValue;
        BigDecimal result = BigDecimal.ZERO;
        String resultCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        AirProductContractRelationData cr = AirProductHelper.getClientContractRelation((Product)prod);
        if (cr != null && cr.getGeneralData().getCurrency() != null) {
            resultCurrencyCode = cr.getGeneralData().getCurrency().getCode();
        }
        if (fixed != null && fixed.getValue() != null && fixed.getCurrency() != null) {
            if (!fixed.getCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)fixed.getCurrency(), (Date)(prod.getIssueDate() != null ? prod.getIssueDate() : new Date()), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
                result = MiscUtil.mul((BigDecimal)fixed.getValue(), (BigDecimal)BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.UP);
            } else {
                result = MiscUtil.guarded((BigDecimal)fixed.getValue());
            }
        }
        if (percent != null && percent != 0 && (flightFare = AirProductHelper.getEquivalentFare((Product)prod)) != null) {
            rateValue = 1.0;
            if (prod.getGdsCurrency() != null && !prod.getGdsCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)prod.getGdsCurrency(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
            }
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, MiscUtil.guarded((BigDecimal)flightFare).multiply(BigDecimal.valueOf(percent.intValue())).multiply(BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.HALF_UP)});
        }
        return result;
    }

    public static BigDecimal getRefundAfterDepartureEquivalentSum(Product prod) {
        return PenaltiesInfoHelper.getProductEquivalentSum(prod, refundAfterDepartureProvider);
    }

    public static BigDecimal getRefundBeforeDepartureEquivalentSum(Product prod) {
        return PenaltiesInfoHelper.getProductEquivalentSum(prod, refundBeforeDepartureProvider);
    }

    public static BigDecimal getExchangeAfterDepartureEquivalentSum(Product prod) {
        return PenaltiesInfoHelper.getProductEquivalentSum(prod, exchangeAfterDepartureProvider);
    }

    public static BigDecimal getExchangeBeforeDepartureEquivalentSum(Product prod) {
        return PenaltiesInfoHelper.getProductEquivalentSum(prod, exchangeBeforeDepartureProvider);
    }

    private static BigDecimal getSegmentTariffEquivalentSum(SegmentTariff st, Product prod, PenaltiesInfoValuesProvider provider) {
        BigDecimal equivalentFare;
        Integer percent;
        Money fixed;
        if (st.getSegments().size() == 0) {
            return null;
        }
        Segment segment = (Segment)st.getSegments().get(0);
        if (segment.getPenaltiesInfo() == null) {
            return null;
        }
        BigDecimal result = BigDecimal.ZERO;
        String resultCurrencyCode = DictHelper.getPreferenceValue((PreferenceKey)PreferenceKey.EQUIVE_CURRENCY, (String)"RUB");
        AirProductContractRelationData cr = AirProductHelper.getClientContractRelation((Product)prod);
        if (cr != null && cr.getGeneralData().getCurrency() != null) {
            resultCurrencyCode = cr.getGeneralData().getCurrency().getCode();
        }
        if ((fixed = provider.getFixedPenalty(segment.getPenaltiesInfo())) != null && fixed.getValue() != null && fixed.getCurrency() != null) {
            if (!fixed.getCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)fixed.getCurrency(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                double rateValue = rate == null ? 1.0 : rate.getRate();
                result = MiscUtil.mul((BigDecimal)fixed.getValue(), (BigDecimal)BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.UP);
            } else {
                result = MiscUtil.guarded((BigDecimal)fixed.getValue());
            }
        }
        if ((percent = provider.getPercentPenalty(segment.getPenaltiesInfo())) != null && percent != 0 && (equivalentFare = AirProductHelper.getSegmentEquivalentFare((Product)prod, (SegmentTariff)st)) != null) {
            double rateValue = 1.0;
            if (prod.getGdsCurrency() != null && !prod.getGdsCurrency().equals(resultCurrencyCode)) {
                CurrencyRate rate = BookingHelper.findCurrencyRate((String)resultCurrencyCode, (String)prod.getGdsCurrency(), (Date)new Date(), (CurrencyRateType)CurrencyRateType.IATA, null, null, null);
                rateValue = rate == null ? 1.0 : rate.getRate();
            }
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, MiscUtil.guarded((BigDecimal)equivalentFare).multiply(BigDecimal.valueOf(percent.intValue())).multiply(BigDecimal.valueOf(rateValue)).setScale(0, RoundingMode.HALF_UP)});
        }
        return result;
    }

    public static BigDecimal getRefundAfterDepartureEquivalentSum(SegmentTariff st, Product prod) {
        return PenaltiesInfoHelper.getSegmentTariffEquivalentSum(st, prod, refundAfterDepartureProvider);
    }

    public static BigDecimal getRefundBeforeDepartureEquivalentSum(SegmentTariff st, Product prod) {
        return PenaltiesInfoHelper.getSegmentTariffEquivalentSum(st, prod, refundBeforeDepartureProvider);
    }

    public static BigDecimal getExchangeAfterDepartureEquivalentSum(SegmentTariff st, Product prod) {
        return PenaltiesInfoHelper.getSegmentTariffEquivalentSum(st, prod, exchangeAfterDepartureProvider);
    }

    public static BigDecimal getExchangeBeforeDepartureEquivalentSum(SegmentTariff st, Product prod) {
        return PenaltiesInfoHelper.getSegmentTariffEquivalentSum(st, prod, exchangeBeforeDepartureProvider);
    }

    private PenaltiesInfoHelper() {
    }

    static interface PenaltiesInfoValuesProvider {
        public Integer getPercentPenalty(PenaltiesInfo var1);

        public Money getFixedPenalty(PenaltiesInfo var1);
    }
}

