/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.mtd;

import com.gridnine.xtrip.common.gds.helper.FlightHelper;
import com.gridnine.xtrip.common.gds.model.BaseMtdFareSettingsIndex;
import com.gridnine.xtrip.common.gds.model.MtdSearchParameters;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.PassengerTypeValue;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictPredifinedValueProvider;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.misc.IrrelevanceTolerantEntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public final class CommonMtdHelper {
    private static final String MO_RETIREE = "01606";
    private static final Pattern PATTERN_MO = Pattern.compile("^(?!01606)[0-9]{13}+$");
    private static final Pattern PATTERN_MVD = Pattern.compile("^[AB\u0410\u0411][0-9]{13}+$");

    public static boolean isMtdEnabled(SalesContext salesContext) {
        if (!((Organization)EntityStorage.get().resolve(salesContext.getSubagency()).getEntity()).isMtdFaresEnabled()) {
            return false;
        }
        return ProfileHelper.isRetailProfile((EntityReference)salesContext.getClient()) || ((Organization)EntityStorage.get().resolve(salesContext.getClient()).getEntity()).isMtdFaresEnabled();
    }

    public static boolean isMtdNumberValid(String mtd, PassengerStatus passengerStatus) {
        if (passengerStatus == null || StringUtils.isBlank((String)mtd)) {
            return false;
        }
        switch (passengerStatus) {
            case VS_MO: {
                return PATTERN_MO.matcher(mtd).matches();
            }
            case VS_MVD: 
            case VS_OVD: 
            case VS_OVD_KSK: 
            case VS_VV: {
                return PATTERN_MVD.matcher(mtd).matches();
            }
        }
        return false;
    }

    public static boolean isMoRetiree(String mtd) {
        return mtd.startsWith(MO_RETIREE);
    }

    public static List<BaseMtdFareSettingsIndex> search(List<EntityReference<Organization>> agenciesRankedList, EntityReference<Organization> subagencyRef) {
        return CommonMtdHelper.search(agenciesRankedList, null, subagencyRef);
    }

    public static List<BaseMtdFareSettingsIndex> search(List<EntityReference<Organization>> agenciesRankedList, MtdSearchParameters parameters, EntityReference<Organization> subagencyRef) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.active.name(), (Object)Boolean.TRUE));
        query.getCriteria().getCriterions().add(SearchCriterion.in((String)BaseMtdFareSettingsIndex.Property.agency.name(), (Object[])agenciesRankedList.toArray(new EntityReference[agenciesRankedList.size()])));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)BaseMtdFareSettingsIndex.Property.subagencies.name()), SearchCriterion.contains((String)BaseMtdFareSettingsIndex.Property.subagencies.name(), subagencyRef)}));
        query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.isEmpty((String)BaseMtdFareSettingsIndex.Property.excludeSubagencies.name()), SearchCriterion.not((SearchCriterion)SearchCriterion.contains((String)BaseMtdFareSettingsIndex.Property.excludeSubagencies.name(), subagencyRef))}));
        if (parameters != null) {
            if (parameters.getPassengerStatus() != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)BaseMtdFareSettingsIndex.Property.passengerStatuses.name(), (Object)parameters.getPassengerStatus()), SearchCriterion.isEmpty((String)BaseMtdFareSettingsIndex.Property.passengerStatuses.name())}));
            }
            if (!parameters.getAirlines().isEmpty()) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.in((String)BaseMtdFareSettingsIndex.Property.airline.name(), (Object[])parameters.getAirlines().toArray()), SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.airline.name(), null)}));
            }
            Integer validDays = (int)ChronoUnit.DAYS.between(parameters.getValidFrom(), LocalDate.now());
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)BaseMtdFareSettingsIndex.Property.validDays.name(), (Object)validDays), SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.validDays.name(), null)}));
            Integer advanceDays = FlightHelper.getDaysBeforeDeparture(parameters.getRouteSegment());
            if (advanceDays != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.ge((String)BaseMtdFareSettingsIndex.Property.maxAdvanceDays.name(), (Object)advanceDays), SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.maxAdvanceDays.name(), null)}));
            }
            if (parameters.getServiceClass() == ClassOfService.BUSINESS) {
                if (parameters.getChildrenCount() > 0) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.businessChildrenAllowed.name(), (Object)Boolean.TRUE));
                }
                if (parameters.getInfantsCount() > 0) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.businessInfantsAllowed.name(), (Object)Boolean.TRUE));
                }
                if (parameters.getInfantsWithSiteCount() > 0) {
                    query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BaseMtdFareSettingsIndex.Property.businessInfantsWithSiteAllowed.name(), (Object)Boolean.TRUE));
                }
            }
        }
        ArrayList<BaseMtdFareSettingsIndex> data = EntityStorage.get().search(BaseMtdFareSettingsIndex.class, query, IrrelevanceTolerantEntityStorage.IRRELEVANCE_TOLERANT_PARAMS).getData();
        Map<DictionaryReference, List<BaseMtdFareSettingsIndex>> settingsByAirline = data.stream().collect(Collectors.groupingBy(BaseMtdFareSettingsIndex::getAirline));
        data = new ArrayList<BaseMtdFareSettingsIndex>(settingsByAirline.size());
        for (List<BaseMtdFareSettingsIndex> settingsGroup : settingsByAirline.values()) {
            if (settingsGroup.size() > 1) {
                settingsGroup = new ArrayList<BaseMtdFareSettingsIndex>(settingsGroup);
                settingsGroup.sort((idx1, idx2) -> MiscUtil.compare((int)agenciesRankedList.indexOf(idx1.getAgency()), (int)agenciesRankedList.indexOf(idx2.getAgency())));
            }
            EntityReference agency = settingsGroup.get(0).getAgency();
            data.addAll(settingsGroup.stream().filter(idx -> agency.equals((Object)idx.getAgency())).collect(Collectors.toList()));
        }
        return data;
    }

    @Deprecated
    public static Set<PassengerStatus> getMinistries(List<EntityReference<Organization>> agenciesRankedList, EntityReference<Organization> subagencyRef) {
        return CommonMtdHelper.search(agenciesRankedList, subagencyRef).stream().map(i -> i.getPassengerStatuses()).flatMap(l -> l.stream()).collect(Collectors.toSet());
    }

    @Deprecated
    public static Set<DictionaryReference<Airline>> getAirlines(List<EntityReference<Organization>> agenciesRankedList, EntityReference<Organization> subagencyRef) {
        return CommonMtdHelper.search(agenciesRankedList, subagencyRef).stream().map(i -> i.getAirline()).collect(Collectors.toSet());
    }

    public static List<SeatPreferences> buildSeats(MtdSearchParameters parameters) {
        SeatPreferences sp;
        ArrayList<SeatPreferences> result = new ArrayList<SeatPreferences>();
        if (parameters.getAdultsCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(DictHelper.getAdultPassengerType());
            sp.setCount(parameters.getAdultsCount());
            result.add(sp);
        }
        if (parameters.getChildrenCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(DictHelper.getChildPassengerType());
            sp.setCount(parameters.getChildrenCount());
            result.add(sp);
        }
        if (parameters.getInfantsCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType(DictHelper.getInfantPassengerType());
            sp.setCount(parameters.getInfantsCount());
            result.add(sp);
        }
        if (parameters.getInfantsWithSiteCount() > 0) {
            sp = new SeatPreferences();
            sp.setPassengerType((DictionaryReference)((PassengerType)DictHelper.getPredifinedValue((DictPredifinedValueProvider)PassengerTypeValue.INFANT_WITH_SITE)).toReference());
            sp.setCount(parameters.getInfantsWithSiteCount());
            result.add(sp);
        }
        return result;
    }
}

