/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules;

import com.gridnine.xtrip.common.gds.rules.Conditions;
import com.gridnine.xtrip.common.gds.rules.ConnectionData;
import com.gridnine.xtrip.common.gds.rules.ConnectionRestrictionValue;
import com.gridnine.xtrip.common.gds.rules.GDSParametersPropertiesProvider;
import com.gridnine.xtrip.common.gds.rules.GdsAccountPropertyMatcher;
import com.gridnine.xtrip.common.gds.rules.Targets;
import com.gridnine.xtrip.common.gds.rules.ValueTypes;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ClassOfService;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.TariffType;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.model.rules.standard.AirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.SalesContextPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.TimeLimitPropertyProvider;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;

public enum Properties implements RuleProperty
{
    ROUTE_TYPE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_ROUTE_TYPE);
        }

        public String getRendererId() {
            return ValueTypes.ROUTE_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_ROUTE_TYPE_info), cond.getDisplayName(), value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            return ((List)value).contains(((GDSParametersPropertiesProvider)propertySet).getRouteType());
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.name()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.name(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.name()};
        }
    }
    ,
    AGENCY_CODE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_AGENCY_CODE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_AGENCY_CODE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesContextPropertiesProvider ps = (SalesContextPropertiesProvider)propertySet;
            String agencyCode = ps.getAgencyCode();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                return agencyCode != null && RulesHelper.matchesStringRestriction((String)agencyCode, (Object)value, (boolean)true);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                return agencyCode != null && RulesHelper.matchesStringRestriction((String)agencyCode, (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    SUBAGENCY_CODE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_SUBAGENCY_CODE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.TECHNICAL_FEE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_SUBAGENCY_CODE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesContextPropertiesProvider ps = (SalesContextPropertiesProvider)propertySet;
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getSubagencyCodes(), (Object)value, (boolean)true);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getSubagencyCodes(), (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    CLIENT_CODE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CLIENT_CODE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.TECHNICAL_FEE.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_CLIENT_CODE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesContextPropertiesProvider ps = (SalesContextPropertiesProvider)propertySet;
            EntityContainer clientCtr = EntityStorage.get().resolve(ps.getClient());
            if (clientCtr == null) {
                return false;
            }
            String code = ((Organization)clientCtr.getEntity()).getCode();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)code, (Object)value, (boolean)true);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)code, (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    HOLDING_CODE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HOLDING_CODE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HOLDING_CODE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            SalesContextPropertiesProvider ps = (SalesContextPropertiesProvider)propertySet;
            EntityContainer holdingCtr = Optional.ofNullable(ps.getClient()).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).map(EntityContainer::getEntity).map(Organization::getHolding).map(arg_0 -> ((EntityStorage)EntityStorage.get()).resolve(arg_0)).orElse(null);
            if (holdingCtr == null) {
                return false;
            }
            String code = ((Holding)holdingCtr.getEntity()).getCode();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)code, (Object)value, (boolean)true);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((String)code, (Object)value, (boolean)false);
            }
            return true;
        }
    }
    ,
    HAS_AIRLINE_BONUS_CARDS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HAS_AIRLINE_BONUS_CARDS);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.RuleProperty_HAS_AIRLINE_BONUS_CARDS_info) : L10n.get((String)Messages.RuleProperty_HAS_NO_AIRLINE_BONUS_CARDS_info));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider ps = (BasicAirTicketPropertiesProvider)propertySet;
            return ps.isHasAirlineBonusCards() == (value != null && (Boolean)value != false);
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId()};
        }
    }
    ,
    HOURS_BEFORE_DEPARTURE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HOURS_BEFORE_DEPARTURE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HOURS_BEFORE_DEPARTURE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (Double)value;
            double hrs = ps.getHoursBeforeDeparture();
            if (hrs == -1.0) {
                return false;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }
    }
    ,
    HOURS_AFTER_DEPARTURE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HOURS_AFTER_DEPARTURE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HOURS_AFTER_DEPARTURE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (double)((Double)value).intValue();
            double hrs = -ps.getHoursBeforeDeparture();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }
    }
    ,
    HOURS_BETWEEN_SELL_AND_DEPARTURE{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_HOURS_BETWEEN_SELL_AND_DEPARTURE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.NUMBER.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_HOURS_BETWEEN_SELL_AND_DEPARTURE_info, (Object[])new Object[]{cond.getDisplayName(), value}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            double dv = value == null ? 0.0 : (double)((Double)value).intValue();
            double hrs = ps.getHoursBetweenSellAndDeparture();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                return hrs == dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                return hrs != dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN.equals((Object)condition)) {
                return hrs > dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.GREATER_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs >= dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN.equals((Object)condition)) {
                return hrs < dv;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.LESS_THAN_OR_EQUALS.equals((Object)condition)) {
                return hrs <= dv;
            }
            return true;
        }
    }
    ,
    DEPARTURE_RESTRICTION{

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.PERIOD_WITHIN.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.PERIOD_BEYOND.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_DEPARTURE_RESTRICTION);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.REFUND_PARAMETERS.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_DEPARTURE_RESTRICTION_info), cond.getDisplayName(), value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            Date date2;
            Date date1;
            String interval;
            String[] dates;
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            List intervals = RulesHelper.toStringCollection((Object)value);
            Date date = MiscUtil.clearTime((Date)ps.getDepartureDate());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            boolean isContains = false;
            Iterator iterator = intervals.iterator();
            while (iterator.hasNext() && ((dates = (interval = (String)iterator.next()).split("-")).length != 2 || !(isContains = MiscUtil.isBetween((Date)(date1 = this.calcDate(dates[0], year)), (Date)(date2 = this.calcDate(dates[1], year)), (Date)date)))) {
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.PERIOD_WITHIN.equals((Object)condition)) {
                return isContains;
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.PERIOD_BEYOND.equals((Object)condition)) {
                return !isContains;
            }
            return true;
        }

        private Date calcDate(String str, int defaultYear) {
            int maxDay;
            if (str == null) {
                return null;
            }
            String[] arr = str.split("\\.");
            if (arr.length != 2 && arr.length != 3) {
                return null;
            }
            Calendar cal = Calendar.getInstance();
            cal.clear();
            int day = Integer.valueOf(arr[0]);
            int month = Integer.valueOf(arr[1]) - 1;
            int year = defaultYear;
            if (arr.length == 3) {
                year = Integer.valueOf(arr[2]);
            }
            if ((maxDay = this.getDaysInMonth(year, month)) < day) {
                day = maxDay;
            }
            cal.set(year, month, day);
            return cal.getTime();
        }

        private int getDaysInMonth(int year, int month) {
            GregorianCalendar cal = new GregorianCalendar(year, month, 1);
            return ((Calendar)cal).getActualMaximum(5);
        }
    }
    ,
    GDS_CURRENCY{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_CURRENCY);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(cond == com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET ? L10n.get((String)Messages.RuleProperty_GDS_NO_CURRENCY_info) : String.format(L10n.get((String)Messages.RuleProperty_GDS_CURRENCY_info), cond.getDisplayName(), value));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            String currency = ps.getGdsCurrency();
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET.equals((Object)condition)) {
                return currency == null;
            }
            List vs = RulesHelper.toStringCollection((Object)value);
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                return currency == null ? false : vs.contains(currency);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                return currency == null ? true : !vs.contains(currency);
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_SET.getId()};
        }
    }
    ,
    CONNECTION_TIME{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_CONNECTION_TIME);
        }

        public String getRendererId() {
            return ValueTypes.CONNECTION_TIME_RESTRICTION.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (cond == Conditions.CONNECTION_WITH_DIFFERENT_AIRPORTS) {
                buf.append(L10n.get((String)Messages.RuleProperty_CONNECTION_DIFFERENT_AIRPORTS_info));
                return;
            }
            ConnectionRestrictionValue data = (ConnectionRestrictionValue)value;
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_CONNECTION_TIME_info), this.toString(data.getAirportCodes()), Integer.toString(data.getMinConnectionTimeInMinutes())));
        }

        private String toString(Set<String> airportCodes) {
            ArrayList<String> lst = new ArrayList<String>(airportCodes);
            Collections.sort(lst);
            StringBuilder sb = new StringBuilder();
            for (String item : lst) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(item);
            }
            return sb.toString();
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            List connections = (List)ps.getCustomParameter(CONNECTION_TIME.name());
            if (connections == null) {
                return false;
            }
            ConnectionRestrictionValue restriction = (ConnectionRestrictionValue)value;
            if (condition == Conditions.CONNECTION_WITH_DIFFERENT_AIRPORTS) {
                for (ConnectionData item : connections) {
                    if (item.getDepartureAirport() == null || item.getArrivalAirport() == null || item.getDepartureAirport().equals(item.getArrivalAirport())) continue;
                    return true;
                }
                return false;
            }
            if (restriction == null) {
                return false;
            }
            for (ConnectionData item : connections) {
                if (item.getDepartureAirport() == null || !item.getDepartureAirport().equals(item.getArrivalAirport())) continue;
                if (!restriction.getAirportCodes().contains("*")) {
                    GeoLocation loc = (GeoLocation)DictionaryCache.get().resolveReference(item.getDepartureAirport());
                    if (loc == null) continue;
                    boolean found = false;
                    for (String codeVariant : loc.getCodeVariants().values()) {
                        if (!restriction.getAirportCodes().contains(codeVariant)) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                }
                if (restriction.getMinConnectionTimeInMinutes() <= 0) {
                    return true;
                }
                if (item.getConnectionTimeInMinutes() <= 0 || restriction.getMinConnectionTimeInMinutes() <= item.getConnectionTimeInMinutes()) continue;
                return true;
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.CONNECTION_WITH_DIFFERENT_AIRPORTS.getId(), Conditions.CONNECTION_TIME_RESTRICTED.getId()};
        }
    }
    ,
    GDS_ACCOUNT{
        private final GdsAccountPropertyMatcher matcher = new GdsAccountPropertyMatcher();

        public double getRank() {
            return 0.01;
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_ACCOUNT);
        }

        public String getRendererId() {
            return ValueTypes.GDS_ACCOUNTS.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.HOTELS_COMMISSION.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.TECHNICAL_FEE.getId(), com.gridnine.xtrip.common.model.rules.standard.Targets.TECHNICAL_FEE_SYSTEM.getId()};
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GDS_ACCOUNT_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.toString((Object)value)}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            return this.matcher.match(propertySet, condition, value);
        }
    }
    ,
    AIRLINE{

        public double getRank() {
            return 0.1;
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_AIRLINE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING_LIST.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_GDS_AIRLINE_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getAirlines(), (Object)value, (boolean)true);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                return RulesHelper.matchesStringRestriction((Collection)ps.getAirlines(), (Object)value, (boolean)false);
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.CONFINED_TO.equals((Object)condition)) {
                return RulesHelper.confinedTo((List)ps.getSegmentAirlines(), (List)RulesHelper.toStringCollection((Object)value));
            }
            if (com.gridnine.xtrip.common.model.rules.standard.Conditions.CONTAINS_ONLY.equals((Object)condition)) {
                return RulesHelper.containsOnly((List)ps.getSegmentAirlines(), (List)RulesHelper.toStringCollection((Object)value));
            }
            return true;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.CONFINED_TO.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.CONTAINS_ONLY.getId()};
        }
    }
    ,
    FLIGHT_NUMBER{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_FLIGHT_NUMBER);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.STRING.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_GDS_FLIGHT_NUMBER_info), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof AirTicketPropertiesProvider) {
                AirTicketPropertiesProvider fps = (AirTicketPropertiesProvider)propertySet;
                List flightNumbers = fps.getFlightNumbers();
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                    return flightNumbers.contains(value);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                    return !flightNumbers.contains(value);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.equals((Object)condition)) {
                    return RulesHelper.matchesStringRestriction((Collection)flightNumbers, (Object)value, (boolean)true);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.equals((Object)condition)) {
                    return RulesHelper.matchesStringRestriction((Collection)flightNumbers, (Object)value, (boolean)false);
                }
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.INCLUDE.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.EXCLUDE.getId()};
        }
    }
    ,
    CLASS_OF_SERVICE{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_CLASS_OF_SERVICE);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.CLASS_OF_SERVICE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleProperty_GDS_CLASS_OF_SERVICE_info, (Object[])new Object[]{cond.getDisplayName(), RulesHelper.values2text((List)((List)value))}));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof AirTicketPropertiesProvider) {
                AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
                ArrayList<ClassOfService> classesOfService = new ArrayList<ClassOfService>(ps.getServiceClasses().size());
                for (String classOfServiceCode : ps.getServiceClasses()) {
                    if (TextUtil.isBlank((String)classOfServiceCode)) continue;
                    classesOfService.add(ClassOfService.valueOf((String)classOfServiceCode));
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.equals((Object)condition)) {
                    return !Collections.disjoint(classesOfService, (List)value);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.equals((Object)condition)) {
                    return Collections.disjoint(classesOfService, (List)value);
                }
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.NOT_EQUALS.getId()};
        }
    }
    ,
    TARIFF{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleProperty_GDS_TARIFF);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.TARIFF_TYPE.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            buf.append(String.format(L10n.get((String)Messages.RuleProperty_GDS_TARIFF), cond.getDisplayName(), RulesHelper.toString((Object)value)));
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (propertySet instanceof AirTicketPropertiesProvider) {
                AirTicketPropertiesProvider ps = (AirTicketPropertiesProvider)propertySet;
                TariffType flightTariffType = TariffType.valueOf((String)ps.getTariffType());
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_REGULAR.equals((Object)condition)) {
                    return flightTariffType.equals((Object)TariffType.REGULAR);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_BLOCKCHARTER.equals((Object)condition)) {
                    return flightTariffType.equals((Object)TariffType.BLOCKCHARTER);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_GROUP.equals((Object)condition)) {
                    return flightTariffType.equals((Object)TariffType.GROUP);
                }
                if (com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_CHARTER.equals((Object)condition)) {
                    return flightTariffType.equals((Object)TariffType.CHARTER);
                }
            }
            return false;
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS.getId(), Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_REGULAR.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_BLOCKCHARTER.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_GROUP.getId(), com.gridnine.xtrip.common.model.rules.standard.Conditions.TARIFF_TYPE_CHARTER.getId()};
        }
    }
    ,
    TIME_LIMIT_FROM_SUPPLIER{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.ruleProperty_timeLimitFromSupplier);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (value != null) {
                buf.append(L10n.get((String)Messages.ruleProperty_timeLimitFromSupplier_info)).append(" ").append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.ruleProperty_received) : L10n.get((String)Messages.ruleProperty_notReceived));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TimeLimitPropertyProvider ps = (TimeLimitPropertyProvider)propertySet;
            return ps.isTimeLimitFromSupplierReceived() == (value != null && (Boolean)value != false);
        }
    }
    ,
    TIME_LIMIT_FROM_SUPPLIER_AFTER_DEPARTURE{

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.GDS_PARAMETERS_EX.getId()};
        }

        @Override
        String[] getConditionIds() {
            return new String[]{com.gridnine.xtrip.common.model.rules.standard.Conditions.EQUALS.getId()};
        }

        public String getDisplayName() {
            return L10n.get((String)Messages.Properties_TIME_LIMIT_FROM_SUPPLIER_AFTER_DEPARTURE_displayName);
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public void buildInfo(StringBuilder buf, RuleCondition cond, Object value) {
            if (value != null) {
                buf.append(L10n.get((String)Messages.Properties_TIME_LIMIT_FROM_SUPPLIER_AFTER_DEPARTURE_infoBeginning)).append(" ").append(Boolean.TRUE.equals(value) ? L10n.get((String)Messages.Properties_TIME_LIMIT_FROM_SUPPLIER_AFTER_DEPARTURE_infoAfterDeparture) : L10n.get((String)Messages.Properties_TIME_LIMIT_FROM_SUPPLIER_AFTER_DEPARTURE_infoBeforeDeparture));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            TimeLimitPropertyProvider ps = (TimeLimitPropertyProvider)propertySet;
            return ps.isTimeLimitFromSupplierAfterDeparture() == (value != null && (Boolean)value != false);
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();

    protected String[] getValues(String str) {
        if (TextUtil.isBlank((String)str)) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(str, ",;", false);
        ArrayList<String> lst = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (TextUtil.isBlank((String)token)) continue;
            lst.add(token.trim());
        }
        return lst.toArray(new String[lst.size()]);
    }

    protected void buildAndMultiRestriction(StringBuilder buf, String field, String op, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        buf.append("\t\t\t").append(field).append(' ');
        boolean first = true;
        for (String val : values) {
            if (TextUtil.isBlank((String)val)) continue;
            if (!first) {
                buf.append(" && ");
            } else {
                first = false;
            }
            buf.append(op).append(" \"").append(val.trim()).append('\"');
        }
    }

    protected void buildMultiRestriction(StringBuilder buf, String field, String op, List<? extends Enum<?>> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        buf.append("\t\t\t").append(field).append(' ');
        boolean first = true;
        for (Enum<?> val : values) {
            if (val == null) continue;
            if (!first) {
                buf.append(" || ");
            } else {
                first = false;
            }
            buf.append(op).append(" \"").append(val.name()).append('\"');
        }
    }

    protected void buildMultiRestriction(StringBuilder buf, String field, String op, String[] values) {
        if (values == null || values.length == 0) {
            return;
        }
        buf.append("\t\t\t").append(field).append(' ');
        boolean first = true;
        for (String val : values) {
            if (TextUtil.isBlank((String)val)) continue;
            if (!first) {
                buf.append(" || ");
            } else {
                first = false;
            }
            buf.append(op).append(" \"").append(val.trim()).append('\"');
        }
    }

    protected void buildAndMultiRestriction(StringBuilder buf, String field, String op, List<? extends Enum<?>> values) {
        if (values == null || values.isEmpty()) {
            return;
        }
        buf.append("\t\t\t").append(field).append(' ');
        boolean first = true;
        for (Enum<?> val : values) {
            if (val == null) continue;
            if (!first) {
                buf.append(" && ");
            } else {
                first = false;
            }
            buf.append(op).append(" \"").append(val.name()).append('\"');
        }
    }
}

