/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.gds.rules.airline;

import com.gridnine.xtrip.common.gds.model.FarePricingParameters;
import com.gridnine.xtrip.common.gds.rules.ValueTypes;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineActionSet;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.dict.MealServiceIndicatorGroup;
import com.gridnine.xtrip.common.model.gds.ExtendedLuggageInfo;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.LocaleUtil;
import java.util.Locale;

public enum BrandedFaresActions implements RuleAction
{
    BRAND_NAME{

        public void buildInfo(StringBuilder buf, Object value) {
            Locale locale = LocaleUtil.createNormalizedLocale((Locale)LocaleManager.get().getCurrentLocale());
            String localizedBrandName = (String)((L10nString)value).getValues().get(locale);
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u0430: ");
            buf.append(localizedBrandName != null ? localizedBrandName : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0435\u043c\u043e\u0435 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u0440\u0435\u043d\u0434\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.MULTILINGUAL_STRING.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-brand-name";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setDisplayName((L10nString)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    LUGGAGE_INFO{

        public void buildInfo(StringBuilder buf, Object value) {
            ExtendedLuggageInfo info = (ExtendedLuggageInfo)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430: ");
            BrandedFaresActions.buildExtendedLuggageInfo(info, buf);
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430";
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_LUGGAGE_INFO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-luggage-info";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setLuggageInfo((ExtendedLuggageInfo)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PAID_LUGGAGE_INFO{

        public void buildInfo(StringBuilder buf, Object value) {
            ExtendedLuggageInfo info = (ExtendedLuggageInfo)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430: ");
            BrandedFaresActions.buildExtendedLuggageInfo(info, buf);
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430";
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_LUGGAGE_INFO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-paid-luggage-info";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPaidLuggageInfo((ExtendedLuggageInfo)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PAID_LUGGAGE_PRICE{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0431\u0430\u0433\u0430\u0436\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-paid-luggage-price";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPaidLuggagePrice((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    CABIN_LUGGAGE_INFO{

        public void buildInfo(StringBuilder buf, Object value) {
            ExtendedLuggageInfo info = (ExtendedLuggageInfo)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438: ");
            BrandedFaresActions.buildExtendedLuggageInfo(info, buf);
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438";
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_LUGGAGE_INFO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-cabin-luggage-info";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setCabinLuggageInfo((ExtendedLuggageInfo)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PAID_CABIN_LUGGAGE_INFO{

        public void buildInfo(StringBuilder buf, Object value) {
            ExtendedLuggageInfo info = (ExtendedLuggageInfo)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438: ");
            BrandedFaresActions.buildExtendedLuggageInfo(info, buf);
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u043e\u0440\u043c\u0443 \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438";
        }

        public String getRendererId() {
            return ValueTypes.EXTENDED_LUGGAGE_INFO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-paid-cabin-luggage-info";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPaidCabinLuggageInfo((ExtendedLuggageInfo)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PAID_CABIN_LUGGAGE_PRICE{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c \u043f\u043b\u0430\u0442\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0432\u043e\u0437\u0430 \u0440\u0443\u0447\u043d\u043e\u0439 \u043a\u043b\u0430\u0434\u0438";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-paid-cabin-luggage-price";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPaidCabinLuggagePrice((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUNDABLE_BEFORE_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refundable-before-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundableBeforeDepartureSegment((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUNDABLE_AFTER_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refundable-after-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundableAfterDepartureSegment((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGABLE_BEFORE_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u043c\u0435\u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchangable-before-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangableBeforeDepartureSegment((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGABLE_AFTER_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u043c\u0435\u043d\u0430 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchangable-after-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangableAfterDepartureSegment((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_BEFORE_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-before-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundBeforeDepartureSegment((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_AFTER_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-after-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundAfterDepartureSegment((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_BEFORE_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-before-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeBeforeDepartureSegment((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_AFTER_DEPARTURE_SEGMENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0441\u0435\u0433\u043c\u0435\u043d\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-after-departure-segment";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeAfterDepartureSegment((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUNDABLE_BEFORE_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refundable-before-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundableBeforeDepartureTicket((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUNDABLE_AFTER_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refundable-after-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundableAfterDepartureTicket((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGABLE_BEFORE_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u043c\u0435\u043d\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchangable-before-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangableBeforeDepartureTicket((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGABLE_AFTER_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043e\u0431\u043c\u0435\u043d\u0430 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchangable-after-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangableAfterDepartureTicket((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_BEFORE_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-before-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundBeforeDepartureTicket((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_AFTER_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-after-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundAfterDepartureTicket((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_BEFORE_DEPARTURE_TICKET_FARE_PERCENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Integer price = (Integer)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430: ");
            buf.append(price != null && price != null ? price.toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.INTEGER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-before-departure-ticket-fare-percent";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundBeforeDepartureTicketFarePercent((Integer)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    REFUND_AFTER_DEPARTURE_TICKET_FARE_PERCENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Integer price = (Integer)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430: ");
            buf.append(price != null && price != null ? price.toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.INTEGER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-refund-after-departure-ticket-fare-percent";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setRefundAfterDepartureTicketFarePercent((Integer)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_BEFORE_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-before-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeBeforeDepartureTicket((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_AFTER_DEPARTURE_TICKET{

        public void buildInfo(StringBuilder buf, Object value) {
            Money price = (Money)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430: ");
            buf.append(price != null && price.getValue() != null ? price.getValue().toString() : "?");
            buf.append(" ");
            buf.append(price != null && price.getCurrency() != null ? price.getCurrency().toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.PRICE_WITH_CURRENCY.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-after-departure-ticket";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeAfterDepartureTicket((Money)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_BEFORE_DEPARTURE_TICKET_FARE_PERCENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Integer price = (Integer)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430: ");
            buf.append(price != null && price != null ? price.toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u0434\u043e \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.INTEGER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-before-departure-ticket-fare-percent";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeBeforeDepartureTicketFarePercent((Integer)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXCHANGE_AFTER_DEPARTURE_TICKET_FARE_PERCENT{

        public void buildInfo(StringBuilder buf, Object value) {
            Integer price = (Integer)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430: ");
            buf.append(price != null && price != null ? price.toString() : "?");
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0448\u0442\u0440\u0430\u0444 \u0437\u0430 \u043e\u0431\u043c\u0435\u043d \u0431\u0438\u043b\u0435\u0442\u0430 \u043f\u043e\u0441\u043b\u0435 \u0432\u044b\u043b\u0435\u0442\u0430 \u0432 % \u043e\u0442 \u0442\u0430\u0440\u0438\u0444\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.INTEGER.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-exchange-after-departure-ticket-fare-percent";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExchangeAfterDepartureTicketFarePercent((Integer)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    MEAL_SERVICE{

        public void buildInfo(StringBuilder buf, Object value) {
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0438\u0442\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u0440\u0442\u0443 ");
            if (value != null) {
                buf.append(value);
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0438\u0442\u0430\u043d\u0438\u0435 \u043d\u0430 \u0431\u043e\u0440\u0442\u0443";
        }

        public String getRendererId() {
            return ValueTypes.MEAL_SERVICE_INDICATOR_GROUP.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-meal-service";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setMealService((MealServiceIndicatorGroup)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    BUSINESS_LOUNGE_ACCESS{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0434\u043e\u0441\u0442\u0443\u043f \u0432 \u0431\u0438\u0437\u043d\u0435\u0441-\u0437\u0430\u043b ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u0432 \u0431\u0438\u0437\u043d\u0435\u0441-\u0437\u0430\u043b";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-business-lounge-access";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setBusinessLoungeAccess((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    CLASS_UPGRADE_AVAILABLE{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043a\u043b\u0430\u0441\u0441\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u043e\u0432\u044b\u0448\u0435\u043d\u0438\u044f \u043a\u043b\u0430\u0441\u0441\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-class-upgrade-available";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setClassUpgradeAvailable((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    EXTRA_MILEAGE_BONUS{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043c\u0438\u043b\u0438 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u043d\u0430\u0447\u0438\u0441\u043b\u044f\u044e\u0442\u0441\u044f");
                } else {
                    buf.append("\u041d\u0415 \u043d\u0430\u0447\u0438\u0441\u043b\u044f\u044e\u0442\u0441\u044f");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043c\u0438\u043b\u044c";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-extra-mileage-bonus";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setExtraMileageBonus((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PRIORITY_BOARDING{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u0430\u044f \u043f\u043e\u0441\u0430\u0434\u043a\u0430 ");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u0441\u0430\u0434\u043a\u0438";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-priority-boarding";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPriorityBoarding((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    SEAT_CHOICE{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0432\u044b\u0431\u043e\u0440 \u043c\u0435\u0441\u0442\u0430");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u044c \u0432\u044b\u0431\u043e\u0440\u0430 \u043c\u0435\u0441\u0442\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-seat-choice";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setSeatChoice((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    TRANSFER_INCLUDED{

        public void buildInfo(StringBuilder buf, Object value) {
            Boolean result = (Boolean)value;
            buf.append("\u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440");
            if (result != null) {
                if (result.booleanValue()) {
                    buf.append("\u0432\u043a\u043b\u044e\u0447\u0435\u043d");
                } else {
                    buf.append("\u041d\u0415 \u0432\u043a\u043b\u044e\u0447\u0435\u043d");
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0442\u0440\u0430\u043d\u0441\u0444\u0435\u0440\u0430";
        }

        public String getRendererId() {
            return com.gridnine.xtrip.common.model.rules.standard.ValueTypes.YES_NO.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-transfer-included";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setTransferIncluded((Boolean)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    }
    ,
    PRICING_PARAMETERS{

        public void buildInfo(StringBuilder buf, Object value) {
            FarePricingParameters result = (FarePricingParameters)value;
            buf.append("\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438: ");
            if (result != null) {
                if (result.isDefaultPricing()) {
                    buf.append("\u0440\u0430\u0441\u0447\u0435\u0442 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
                } else {
                    boolean first = true;
                    if (result.getBrandId() != null) {
                        buf.append("Brand ID = ");
                        buf.append(result.getBrandId());
                        first = false;
                    }
                    if (result.getPublicFare() != null) {
                        if (!first) {
                            buf.append(", ");
                        }
                        buf.append("Public Fare = ");
                        buf.append(result.getPublicFare());
                        first = false;
                    }
                    if (result.getRefundableAny() != null) {
                        if (!first) {
                            buf.append(", ");
                        }
                        buf.append("Refundable Any = ");
                        buf.append(result.getRefundableAny());
                        first = false;
                    }
                }
            } else {
                buf.append("?");
            }
        }

        public String getDisplayName() {
            return "\u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438";
        }

        public String getRendererId() {
            return ValueTypes.FARE_PRICING_PARAMETERS.name();
        }

        public boolean hasValue() {
            return true;
        }

        public String getRuleCategoryValue(Object actionSet, Object value) throws Exception {
            return "branded-fares-pricing-parameters";
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            CommonAirlineActionSet as = (CommonAirlineActionSet)proxy.getActionSet();
            as.setPricingParameters((FarePricingParameters)value);
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    private static void buildExtendedLuggageInfo(ExtendedLuggageInfo info, StringBuilder buf) {
        buf.append(info != null && info.getPieces() != null ? info.getPieces().toString() : "?");
        buf.append(" \u0448\u0442. (");
        buf.append(info != null && info.getWeight() != null ? info.getWeight().toString() : "?");
        buf.append(" ");
        buf.append(info != null && info.getWeightUnit() != null ? info.getWeightUnit() : "?");
        buf.append("., ");
        if (info != null && (info.getLength() != null || info.getWidth() != null || info.getHeight() != null)) {
            buf.append(info.getLength() != null ? info.getLength() : "?");
            buf.append(" x ");
            buf.append(info.getWidth() != null ? info.getWidth() : "?");
            buf.append(" x ");
            buf.append(info.getHeight() != null ? info.getHeight() : "?");
        } else {
            buf.append(info != null && info.getDimensionsSum() != null ? info.getDimensionsSum() : "?");
        }
        buf.append(" ");
        buf.append(info != null && info.getDimensionUnit() != null ? info.getDimensionUnit() : "?");
        buf.append(".)");
    }

    public String getId() {
        return this.name();
    }
}

