/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.http.ssl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.remoting.util.socket.HandshakeRepeater;

public class HTTPSSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory targetFactory = null;
    private HandshakeCompletedListener targetListener = null;

    public HTTPSSocketFactory(SSLSocketFactory socketFactory, HandshakeCompletedListener listener) {
        this.targetFactory = socketFactory;
        this.targetListener = listener;
        if (this.targetFactory == null) {
            throw new RuntimeException("Can not create HTTPSSocketFactory with target SSLSocketFactory being null.");
        }
        if (this.targetListener == null) {
            throw new RuntimeException("Can not create HTTPSSocketFactory with target HandshakeCompletedListener being null.");
        }
    }

    public String[] getDefaultCipherSuites() {
        return this.targetFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.targetFactory.getSupportedCipherSuites();
    }

    public Socket createSocket(Socket socket, String string, int i, boolean b) throws IOException {
        Socket retSocket = this.targetFactory.createSocket(socket, string, i, b);
        if (retSocket instanceof SSLSocket) {
            this.establishHandshake((SSLSocket)retSocket, this.targetListener);
        }
        return retSocket;
    }

    public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
        Socket retSocket = this.targetFactory.createSocket(string, i);
        if (retSocket instanceof SSLSocket) {
            this.establishHandshake((SSLSocket)retSocket, this.targetListener);
        }
        return retSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
        Socket retSocket = this.targetFactory.createSocket(inetAddress, i);
        if (retSocket instanceof SSLSocket) {
            this.establishHandshake((SSLSocket)retSocket, this.targetListener);
        }
        return retSocket;
    }

    public Socket createSocket(String string, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
        Socket retSocket = this.targetFactory.createSocket(string, i, inetAddress, i1);
        if (retSocket instanceof SSLSocket) {
            this.establishHandshake((SSLSocket)retSocket, this.targetListener);
        }
        return retSocket;
    }

    public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
        Socket retSocket = this.targetFactory.createSocket(inetAddress, i, inetAddress1, i1);
        if (retSocket instanceof SSLSocket) {
            this.establishHandshake((SSLSocket)retSocket, this.targetListener);
        }
        return retSocket;
    }

    private void establishHandshake(SSLSocket sslSocket, HandshakeCompletedListener listener) throws IOException {
        HandshakeRepeater repeater = new HandshakeRepeater(listener);
        sslSocket.addHandshakeCompletedListener((HandshakeCompletedListener)repeater);
        sslSocket.getSession();
        repeater.waitForHandshake();
    }
}

