/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeTranslator {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final String[] varTypes;

    public CodeTranslator(String ... variationTypes) {
        this.varTypes = variationTypes;
    }

    public <D extends BaseDictionary> boolean hasNativeCode(DictionaryReference<D> ref) {
        if (ref == null) {
            return false;
        }
        BaseDictionary loc = DictionaryCache.get().resolveReference(ref);
        if (loc == null) {
            return false;
        }
        for (String varType : this.varTypes) {
            if (!loc.getCodeVariants().containsKey(varType)) continue;
            return true;
        }
        return false;
    }

    public <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref) {
        return this.getNativeCode(ref, true);
    }

    public <D extends BaseDictionary> String getNativeCode(DictionaryReference<D> ref, boolean failSafe) {
        if (ref == null) {
            return null;
        }
        BaseDictionary loc = DictionaryCache.get().resolveReference(ref);
        if (loc == null) {
            if (failSafe) {
                this.log.debug("can't resolve dictionary reference " + ref);
                return ref.getCode();
            }
            throw Xeption.forDeveloper((String)("can't resolve dictionary reference " + ref), (Object[])new Object[0]);
        }
        for (String varType : this.varTypes) {
            String result = (String)loc.getCodeVariants().get(varType);
            if (result == null) continue;
            return result;
        }
        if (failSafe) {
            this.log.debug("can't find native code for " + ref);
            return loc.getCode();
        }
        throw Xeption.forAdmin((String)"\u0414\u043b\u044f \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '{0}' \u0441 \u043a\u043e\u0434\u043e\u043c '{1}' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b \u043a\u043e\u0434\u044b \u0434\u043b\u044f \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u0441\u0442\u0435\u043c: '{2}'", (Object[])new Object[]{MetaRegistryHelper.getDictionaryType((String)loc.getClass().getName()).getDisplayName(), loc.getCode(), Arrays.toString(this.varTypes)});
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code) {
        return this.resolveNativeCode(cls, code, LocationType.AIRPORT, true);
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing, boolean reportMissing) {
        return this.resolveNativeCode(cls, code, LocationType.AIRPORT, createIfMissing, reportMissing);
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, boolean createIfMissing) {
        return this.resolveNativeCode(cls, code, LocationType.AIRPORT, createIfMissing);
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, LocationType preferedType) {
        return this.resolveNativeCode(cls, code, preferedType, true);
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, LocationType preferedType, boolean createIfMissing) {
        return this.resolveNativeCode(cls, code, preferedType, createIfMissing, true);
    }

    public <D extends BaseDictionary> DictionaryReference<D> resolveNativeCode(Class<D> cls, String code, LocationType preferedType, boolean createIfMissing, boolean reportMissing) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        DictionaryCache dictionaryCache = DictionaryCache.get();
        Set set = dictionaryCache.lookup(cls, code, this.varTypes);
        String systemCode = null;
        String caption = null;
        if (set.isEmpty()) {
            Object item = (BaseDictionary)dictionaryCache.getAll(cls).get(code);
            if (item == null) {
                item = (BaseDictionary)dictionaryCache.getAll(cls).get(code.toUpperCase());
            }
            if (item == null) {
                this.log.debug(String.format("can't find dictionary item of type %s for code %s", cls.getName(), code));
                if (reportMissing) {
                    IncidentsLog.reportAdminStackTrace((String)("\u043d\u0435\u0442 \u0437\u0430\u043f\u0438\u0441\u0438 \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0435 " + cls.getSimpleName() + " \u0434\u043b\u044f \u043a\u043e\u0434\u0430 " + code));
                }
                if (!createIfMissing) {
                    return null;
                }
                systemCode = code;
            } else {
                systemCode = item.getCode();
                caption = item.toString();
            }
        } else {
            if (set.size() > 1) {
                if (GeoLocation.class.getName().equals(cls.getName())) {
                    for (BaseDictionary item : set) {
                        GeoLocation loc = (GeoLocation)item;
                        if (loc.getType() == preferedType) {
                            systemCode = item.getCode();
                            caption = item.toString();
                            continue;
                        }
                        if (systemCode != null) continue;
                        systemCode = item.getCode();
                        caption = item.toString();
                    }
                } else {
                    this.log.debug(String.format("more than one dictionary item of type %s found for code %s", cls.getName(), code));
                }
            }
            if (systemCode == null) {
                BaseDictionary dict = (BaseDictionary)set.iterator().next();
                systemCode = dict.getCode();
                caption = dict.toString();
            }
        }
        try {
            Class<?> refCls = Class.forName(cls.getName() + "Reference");
            DictionaryReference result = (DictionaryReference)refCls.newInstance();
            result.setCode(systemCode);
            result.setCaption(caption);
            return result;
        }
        catch (Exception e) {
            this.log.error("failed creating dictionary reference for " + cls.getName(), (Throwable)e);
            return null;
        }
    }
}

