/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.midoffice.helper;

import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonHelper {
    private static final Logger log = LoggerFactory.getLogger(CommonHelper.class);
    private static String GDSTRACINGSETTINGS_KEY = "GDSTRACINGSETTINGS_KEY";

    public static String getCompoundKey(String loginName) {
        return String.format("%s.%s", GDSTRACINGSETTINGS_KEY, loginName);
    }

    public static boolean isSubagent(EntityContainer<Person> agentCtr) {
        return CommonHelper.isSubagentOrg(CommonHelper.getOrganization(agentCtr));
    }

    public static boolean isSubagentOrg(EntityContainer<Organization> organizationContainer) {
        return organizationContainer != null && ((Organization)organizationContainer.getEntity()).getTypes().contains(OrganizationType.AGENCY);
    }

    public static EntityContainer<Organization> getParent(EntityReference<Organization> orgRef) {
        EntityContainer orgCtr = EntityStorageHelper.resolve(orgRef);
        EntityContainer result = orgCtr != null ? EntityStorageHelper.resolve((EntityReference)((Organization)orgCtr.getEntity()).getParent()) : null;
        return result;
    }

    public static EntityContainer<Organization> getOrganization(EntityContainer<Person> personCtr) {
        EntityReference<Organization> ref = CommonHelper.getOrganizationRef(personCtr);
        return ref != null ? EntityStorage.get().resolve(ref) : null;
    }

    public static EntityReference<Organization> getOrganizationRef(EntityReference<Person> agentRef) {
        return CommonHelper.getOrganizationRef((EntityContainer<Person>)EntityStorageHelper.resolve(agentRef));
    }

    public static EntityReference<Organization> getOrganizationRef(EntityContainer<Person> agentCtr) {
        if (agentCtr == null) {
            return null;
        }
        for (PersonEmployment item : ((Person)agentCtr.getEntity()).getEmployments()) {
            if (!item.isMainEmployment()) continue;
            return item.getOrganization();
        }
        log.warn(String.format("unable to define main employment for agent %s", ((Person)agentCtr.getEntity()).toString()));
        return null;
    }

    public static SalesContext clone(SalesContext salesContext, EntityReference<SalesPoint> salesPoint) {
        if (salesContext == null) {
            throw Xeption.forDeveloper((String)"empty original sales context", (Object[])new Object[0]);
        }
        if (salesPoint == null) {
            throw Xeption.forDeveloper((String)"empty sales point for clone sales context", (Object[])new Object[0]);
        }
        SalesContext res = new SalesContext();
        try {
            XCloneModelHelper.copy((BaseEntity)salesContext, (BaseEntity)res, (boolean)true);
        }
        catch (Exception e) {
            throw Xeption.forDeveloper((String)"some problem while clone sales context, problem={0}", (Object[])new Object[]{e.getMessage()});
        }
        res.setSalesPoint(salesPoint);
        res.setAgency(CommonHelper.findAgencyBySalesPoint(salesPoint));
        return res;
    }

    public static EntityReference<Organization> findAgencyBySalesPoint(EntityReference<SalesPoint> spRef) {
        EntityContainer salesPoint;
        if (spRef != null && (salesPoint = EntityStorage.get().resolve(spRef)) != null) {
            return SalesContextHandler.get().getOnlineAgency((SalesPoint)salesPoint.getEntity());
        }
        return null;
    }

    public static String getAgencyCode(SalesContext sc) {
        EntityContainer agencyCtr = EntityStorage.get().resolve(sc.getAgency());
        return agencyCtr == null ? null : ((Organization)agencyCtr.getEntity()).getCode();
    }

    public static String getClientCode(SalesContext sc) {
        EntityContainer agencyCtr = EntityStorage.get().resolve(sc.getClient());
        return agencyCtr == null ? null : ((Organization)agencyCtr.getEntity()).getCode();
    }
}

