/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.rules.standard;

import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.rules.standard.CommissionActionsProvider;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Arrays;

public enum MidofficeActions implements RuleAction
{
    ALLOWED_PAYMENT_TYPES{

        @Override
        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            PaymentType[] pts = (PaymentType[])value;
            if (pts.length == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)"RULES_STANDARD_SET_THE_ALLOWED_FORMS_OF_PAYMENT_TO_X", (Object[])new Object[]{CollectionUtil.collectionToString(Arrays.asList(pts), (String)", ", (boolean)false)}));
        }

        @Override
        public String getDisplayName() {
            return L10nResourcesManager.getStr((String)"RULES_STANDARD_SET_THE_ALLOWED_FORMS_OF_PAYMENT", (Object[])new Object[0]);
        }

        @Override
        public String getRendererId() {
            return ValueTypes.PAYMENT_TYPES_LIST.name();
        }

        @Override
        public boolean hasValue() {
            return true;
        }

        @Override
        public String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId(), Targets.HOTELS_COMMISSION.getId(), "RAILWAY_PRODUCT_COMMISSION", Targets.TRANSFER.getId()};
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) {
            for (PaymentType pt : (PaymentType[])value) {
                ((CommissionActionsProvider)proxy.getActionSet()).addAllowedPaymentType(pt.name());
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(proxy.getActionSet(), value));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return "\"allowed-payment-types\"";
        }

        @Override
        public String getId() {
            return this.name();
        }
    };


    public String getId() {
        return this.name();
    }

    public abstract String getRendererId();

    public abstract String[] getTargetIds();

    public abstract String getDisplayName();

    public abstract boolean hasValue();

    public abstract void buildInfo(StringBuilder var1, Object var2);
}

