/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.fx.rpc;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class AclQuery
implements Serializable {
    private static final long serialVersionUID = 2236837744812391575L;
    private final Collection<AclQueryEntry> entries = new ArrayList<AclQueryEntry>();

    private AclQuery() {
    }

    @Deprecated
    public AclQuery(String operationId, String resourceId) {
        this(operationId, resourceId, resourceId, null);
    }

    @Deprecated
    public AclQuery(String operationId, String resourceId, EntityReference<?> reference) {
        this(operationId, resourceId, resourceId, new NestedEntityReference(reference, null, null, null));
    }

    @Deprecated
    public AclQuery(String operationId, String rootResourceId, String resourceId, NestedEntityReference<?, ?> reference) {
        AclQueryEntry entry = new AclQueryEntry(operationId, rootResourceId, resourceId, reference);
        this.entries.add(entry);
    }

    public Collection<AclQueryEntry> getEntries() {
        return this.entries;
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AclQuery)) {
            return false;
        }
        AclQuery other = (AclQuery)object;
        return MiscUtil.equals(this.entries, other.entries);
    }

    public String toString() {
        return Arrays.toString(this.entries.toArray());
    }

    public static class AclQueryEntry
    implements Serializable {
        private static final long serialVersionUID = -5779193077910257683L;
        private final String rootResourceId;
        private final String resourceId;
        private final String operationId;
        private final NestedEntityReference<?, ?> reference;
        private transient int hashCode;

        private AclQueryEntry(String operationId, String rootResourceId, String resourceId, NestedEntityReference<?, ?> reference) {
            this.operationId = Objects.requireNonNull(operationId);
            this.rootResourceId = Objects.requireNonNull(rootResourceId);
            this.resourceId = Objects.requireNonNull(resourceId);
            this.reference = reference;
        }

        public String getRootResourceId() {
            return this.rootResourceId;
        }

        public String getResourceId() {
            return this.resourceId;
        }

        public String getOperationId() {
            return this.operationId;
        }

        public NestedEntityReference<?, ?> getReference() {
            return this.reference;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = Arrays.hashCode(new Object[]{this.rootResourceId, this.resourceId, this.operationId, this.reference});
            return this.hashCode;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AclQueryEntry)) {
                return false;
            }
            AclQueryEntry other = (AclQueryEntry)object;
            if (!TextUtil.isSame((String)this.rootResourceId, (String)other.rootResourceId, (boolean)false, (boolean)false)) {
                return false;
            }
            if (!TextUtil.isSame((String)this.resourceId, (String)other.resourceId, (boolean)false, (boolean)false)) {
                return false;
            }
            if (!TextUtil.isSame((String)this.operationId, (String)other.operationId, (boolean)false, (boolean)false)) {
                return false;
            }
            return MiscUtil.equals(this.reference, other.reference);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[').append(this.rootResourceId).append(", ").append(this.resourceId).append(", ").append(this.operationId);
            if (this.reference != null) {
                stringBuilder.append(", ").append(this.reference);
            }
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }

    public static class AclQueryBuilder {
        private final AclQuery query = new AclQuery();

        public static AclQueryBuilder get() {
            return new AclQueryBuilder();
        }

        private AclQueryBuilder() {
        }

        public AclQueryBuilder entry(String operationId, String resourceId) {
            AclQueryEntry entry = new AclQueryEntry(operationId, resourceId, resourceId, null);
            this.query.getEntries().add(entry);
            return this;
        }

        public AclQueryBuilder entry(String operationId, String resourceId, EntityReference<?> reference) {
            AclQueryEntry entry = new AclQueryEntry(operationId, resourceId, resourceId, new NestedEntityReference(reference, null, null, null));
            this.query.getEntries().add(entry);
            return this;
        }

        public AclQueryBuilder entry(String operationId, String rootResourceId, String resourceId, NestedEntityReference<?, ?> reference) {
            AclQueryEntry entry = new AclQueryEntry(operationId, rootResourceId, resourceId, reference);
            this.query.getEntries().add(entry);
            return this;
        }

        public AclQuery build() {
            return this.query;
        }
    }
}

