/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.railway.tasks.dialog.RailwayProductRefundDialog;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class RailwayProductRefundListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(RailwayProductIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.REFUND;
    }

    public double getWeight() {
        return 9.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return context.getSelectedItems().size() == 1;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        Notifications.get().submitTask(() -> {
            EntityIndex bfInd = (EntityIndex)selectedItems.get(0);
            EntityReference bfRef = bfInd.getSource();
            EntityContainer bfCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), bfRef);
            if (bfCtr == null) {
                Dialog.info((Node)context, (String)Messages.Order_not_found);
                return;
            }
            BaseProduct selectedProduct = BookingHelper.findProductByUid((String)bfInd.getNavigationKey(), (BookingFile)((BookingFile)bfCtr.getEntity()));
            if (!(selectedProduct instanceof RailwayProduct)) {
                Dialog.info((Node)context, (String)Messages.Service_isnt_railroad_ticket);
                return;
            }
            ProductStatus productStatus = BookingHelper.getProductStatus((BaseProduct)selectedProduct);
            if (productStatus != ProductStatus.SELL) {
                Dialog.info((Node)context, (String)Messages.Service_isnt_saling);
                return;
            }
            if (((RailwayProduct)selectedProduct).getNextProduct() != null) {
                Dialog.info((Node)context, (String)Messages.Service_already_got_payback);
                return;
            }
            FxUtil.submitToFxThread(() -> {
                RailwayProductRefundDialog dialog = new RailwayProductRefundDialog((Node)source, (EntityReference<BookingFile>)bfRef, (RailwayProduct)selectedProduct);
                dialog.showDialog();
            });
        }, context.getMutex());
    }

    public String getId() {
        return "railway-product-list-refund";
    }
}

