/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.parsers.processors;

import com.gridnine.xtrip.client.fx.standard.processing.BaseStubForFileProcessor;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentMetaData;
import com.gridnine.xtrip.common.railway.parsers.ExpressExchangeDocumentsMetaData;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ExpressFilesProcessor
extends BaseStubForFileProcessor {
    protected final transient Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String CONTENT_FILE_EXTENSION = "txt";
    public static final String EXCHANGE_FILE_ENCODING = "cp1251";
    public static final String EXCHANGE_FILE_SEPARATOR = "\n\r";
    public static final String STORE_ENCODING = "utf8";
    public static final String TOKEN_SEPARATOR = "\n";
    public static final int REMOVE_DAYS_TRESHOLD = 2;
    public static final int W1_AGENT_RECORD_STRING_AMOUNT = 6;
    public static final int AGENT_RECORD_STRING_AMOUNT = 1;
    public static final int REFUSE_RECORD_STRING_AMOUNT = 4;
    public static final int COUPON_RECORD_STRING_AMOUNT = 8;
    private final File folder;
    private final FileFilter fileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (!file.isFile()) {
                return false;
            }
            return file.getName().endsWith("rzd");
        }
    };

    public ExpressFilesProcessor() {
        this.folder = this.getDataFolder("import.express.folder", new File(Environment.getDataFolder(), "import/express-files"));
    }

    public Class<ExpressFilesProcessor> getProcessorClass() {
        return ExpressFilesProcessor.class;
    }

    protected File[] getFiles() {
        return this.folder.listFiles(this.fileFilter);
    }

    public String getFileType() {
        return "EXPRESS";
    }

    public void process() {
        File[] files = this.getFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (!file.canWrite()) continue;
            if (this.isGeneralProblemExists()) {
                this.log.info("general problem exists, skipping processing");
                return;
            }
            this.process(file);
        }
    }

    protected void process(File file) {
        String fileName = file.getName();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String currentDateString = dateFormat.format(new Date());
        File partFile = new File(this.folder, IoUtil.removeExtension((String)fileName) + "_" + currentDateString + "." + IoUtil.getExtension((String)fileName));
        if (!file.canWrite()) {
            return;
        }
        try {
            IoUtil.moveFile((File)file, (File)partFile, (boolean)false);
            File cropFile = new File(this.folder, IoUtil.removeExtension((String)fileName) + ".crp");
            String cropContent = this.readContent(cropFile, EXCHANGE_FILE_ENCODING);
            String partContent = this.readContent(partFile, EXCHANGE_FILE_ENCODING);
            String content = cropContent + partContent;
            this.writeContent(content, partFile, EXCHANGE_FILE_ENCODING);
            IoUtil.deleteFile((File)cropFile);
            File matafile = this.getMetaFile();
            ExpressExchangeDocumentsMetaData metaDatas = this.readMetaData(matafile);
            this.clearMetaData(metaDatas);
            ExpressExchangeDocumentMetaData currentMetaData = null;
            for (ExpressExchangeDocumentMetaData metaData : metaDatas.getExpressExchangeDocuments()) {
                if (!fileName.equals(metaData.getFileName())) continue;
                currentMetaData = metaData;
                break;
            }
            if (currentMetaData == null) {
                currentMetaData = new ExpressExchangeDocumentMetaData();
                currentMetaData.setFileName(fileName);
                metaDatas.getExpressExchangeDocuments().add(currentMetaData);
            }
            ContentInfo contentInfo = this.createContentInfo(content, currentMetaData);
            partContent = contentInfo.getPartContent();
            cropContent = contentInfo.getCropContent();
            content = contentInfo.getContent();
            currentMetaData.setLastModified(new Date());
            this.writeMetaData(metaDatas, matafile);
            this.writeContent(partContent, partFile, EXCHANGE_FILE_ENCODING);
            this.writeContent(cropContent, cropFile, EXCHANGE_FILE_ENCODING);
            for (int i = 0; i < contentInfo.getEntries().size(); ++i) {
                File entryFile = new File(this.folder, IoUtil.removeExtension((String)fileName) + "_" + currentDateString + "_" + i + "." + CONTENT_FILE_EXTENSION);
                this.writeContent(contentInfo.getEntries().get(i), entryFile, EXCHANGE_FILE_ENCODING);
            }
            this.moveTo(partFile, "processed");
            this.log.debug("file processed " + partFile);
        }
        catch (Exception e) {
            this.moveTo(partFile, "error");
            this.log.error("failed processing file " + partFile, (Throwable)e);
        }
    }

    private ContentInfo createContentInfo(String fileContent, ExpressExchangeDocumentMetaData currentMetaData) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(fileContent, EXCHANGE_FILE_SEPARATOR, true);
        ArrayList<String> tokens = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            tokens.add(stringTokenizer.nextToken());
        }
        ArrayList<TokenInfo> tokenInfos = new ArrayList<TokenInfo>();
        for (int i = 0; i < tokens.size(); ++i) {
            String originalToken = (String)tokens.get(i);
            String token = originalToken.trim();
            if (token.length() <= 0 || Pattern.compile("^P$").matcher(token).find()) continue;
            TokenInfo tokenInfo = new TokenInfo();
            tokenInfo.setIndex(i);
            tokenInfo.setToken(originalToken);
            tokenInfos.add(tokenInfo);
        }
        StringBuilder content = new StringBuilder();
        String agentCode = currentMetaData.getLastAgentCode();
        if (!TextUtil.isBlank((String)agentCode)) {
            content.append(String.format("###ENTRY:%s", new Object[]{RecordType.AGENT}));
            content.append(TOKEN_SEPARATOR);
            content.append(agentCode);
        }
        int startLine = 0;
        int endLine = 0;
        int cropIndex = 0;
        RecordType recordType = null;
        boolean searchingRecordEnd = false;
        ArrayList<String> entries = new ArrayList<String>();
        for (int i = 0; i < tokenInfos.size(); ++i) {
            String token = ((TokenInfo)tokenInfos.get(i)).getToken().trim();
            try {
                if (Pattern.compile("^\\d{6}\\s+\\d{4}\\s+\\d{7}\\s+\\d{2}\u041d\\s+").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of agent record found before previous record ends!");
                    }
                    recordType = RecordType.AGENT;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 1;
                } else if (Pattern.compile("(^|\\s+)\u0418\u041d\u041d\\s+\\d{10}$").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = Math.max(i - 1, 0);
                        if (i + 1 < tokenInfos.size()) {
                            String nextToken = ((TokenInfo)tokenInfos.get(i + 1)).getToken().trim();
                            if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                                endLine = i;
                            } else if (Pattern.compile("^\u041f\u041e\u0413\u0410\u0428\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                                endLine = i;
                            } else if (i + 2 < tokenInfos.size()) {
                                nextToken = ((TokenInfo)tokenInfos.get(i + 2)).getToken().trim();
                                if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                                    endLine = i;
                                }
                            }
                        }
                        throw new UnexpectedRecoredEndException("Start of sell or refund or void record found before previous record ends!");
                    }
                    recordType = RecordType.SELL;
                    searchingRecordEnd = true;
                    startLine = Math.max(i - 1, 0);
                    if (i + 1 < tokenInfos.size()) {
                        String nextToken = ((TokenInfo)tokenInfos.get(i + 1)).getToken().trim();
                        if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                            recordType = RecordType.REFUND;
                            searchingRecordEnd = true;
                            startLine = i;
                        } else if (Pattern.compile("^\u041f\u041e\u0413\u0410\u0428\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                            recordType = RecordType.VOID;
                            searchingRecordEnd = true;
                            startLine = i;
                        } else if (i + 2 < tokenInfos.size()) {
                            nextToken = ((TokenInfo)tokenInfos.get(i + 2)).getToken().trim();
                            if (Pattern.compile("^\u0412\u041e\u0417\u0412\u0420\u0410\u0429\u0415\u041d\u041e\\s+").matcher(nextToken).find()) {
                                recordType = RecordType.REFUND;
                                searchingRecordEnd = true;
                                startLine = i;
                            }
                        }
                    }
                } else if (Pattern.compile("^\u041e\u0422\u041a\u0410\u0417\\s+\u041e\u0422\\s+\u0417\u0410\u041a\u0410\u0417\u0410$").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of refuse record found before previous record ends!");
                    }
                    recordType = RecordType.REFUSE;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 4;
                } else if (Pattern.compile("\\s+\\d{4}-\u0422\u0410\u041b\u041e\u041d\\s+").matcher(token).find()) {
                    if (searchingRecordEnd) {
                        endLine = i;
                        throw new UnexpectedRecoredEndException("Start of coupon record found before previous record ends!");
                    }
                    recordType = RecordType.COUPON;
                    searchingRecordEnd = true;
                    startLine = i;
                    endLine = i + 8;
                } else if (searchingRecordEnd && recordType == RecordType.SELL && Pattern.compile("^\\*(\\s+\\d{1}){14}\\s+\\*$").matcher(token).find()) {
                    endLine = i + 1;
                } else if (searchingRecordEnd && recordType == RecordType.REFUND && Pattern.compile("^.*\\(\u041f\\.\u0414\\.\\D{1,2}(\\*)*\\d{6}\\).*$").matcher(token).find()) {
                    endLine = i + 1;
                } else if (searchingRecordEnd && recordType == RecordType.VOID && Pattern.compile("^\\D{1,2}\\d{6}\\s+.{3}\\s+(\\D{1}\\s+)*.{2}\\s+\\d{7}\\s+\\d{6}\\s+\\d{4}\\s+.+$").matcher(token).find()) {
                    endLine = i + 1;
                }
            }
            catch (UnexpectedRecoredEndException e) {
                this.log.error("", (Throwable)e);
                i = endLine - 1;
            }
            if (!searchingRecordEnd || i != endLine - 1) continue;
            searchingRecordEnd = false;
            if (recordType == RecordType.AGENT) {
                agentCode = this.getAgentCode(((TokenInfo)tokenInfos.get(startLine)).getToken());
                currentMetaData.setLastAgentCode(agentCode);
                if (!TextUtil.isBlank((String)agentCode)) {
                    if (content.length() > 0) {
                        content.append(TOKEN_SEPARATOR);
                    }
                    content.append(String.format("###ENTRY:%s", new Object[]{RecordType.AGENT}));
                    content.append(TOKEN_SEPARATOR);
                    content.append(agentCode);
                }
            }
            if (!this.skip(recordType)) {
                if (content.length() > 0) {
                    content.append(TOKEN_SEPARATOR);
                }
                content.append(String.format("###ENTRY:%s", new Object[]{recordType}));
                for (int j = startLine; j < endLine; ++j) {
                    if (content.length() > 0) {
                        content.append(TOKEN_SEPARATOR);
                    }
                    content.append(((TokenInfo)tokenInfos.get(j)).getToken());
                }
            }
            if (recordType == RecordType.SELL || recordType == RecordType.REFUND || recordType == RecordType.VOID) {
                StringBuilder entry = new StringBuilder();
                entry.append(String.format("AGENT:%s", agentCode != null ? agentCode : ""));
                entry.append(TOKEN_SEPARATOR);
                for (int j = startLine; j < endLine; ++j) {
                    entry.append(((TokenInfo)tokenInfos.get(j)).getToken());
                    entry.append(TOKEN_SEPARATOR);
                }
                entries.add(entry.toString());
            }
            cropIndex = ((TokenInfo)tokenInfos.get(endLine - 1)).getIndex() + 1;
        }
        StringBuilder partContent = new StringBuilder();
        for (int i = 0; i < cropIndex; ++i) {
            partContent.append((String)tokens.get(i));
        }
        StringBuilder cropContent = new StringBuilder();
        for (int i = cropIndex; i < tokens.size(); ++i) {
            cropContent.append((String)tokens.get(i));
        }
        ContentInfo contentInfo = new ContentInfo();
        contentInfo.setContent(content.toString());
        contentInfo.setPartContent(partContent.toString());
        contentInfo.setCropContent(cropContent.toString());
        contentInfo.getEntries().clear();
        contentInfo.getEntries().addAll(entries);
        return contentInfo;
    }

    private String getAgentCode(String token) {
        if (token == null) {
            return null;
        }
        String[] values = token.trim().split("\\s+");
        return values.length > 6 ? values[5].trim() + " " + values[6].trim() : null;
    }

    private boolean skip(RecordType recordType) {
        if (recordType == null) {
            return true;
        }
        return recordType != RecordType.SELL && recordType != RecordType.REFUND && recordType != RecordType.AGENT && recordType != RecordType.REFUSE && recordType != RecordType.COUPON && recordType != RecordType.VOID;
    }

    private ExpressExchangeDocumentsMetaData readMetaData(File metaFile) throws Exception {
        Document document = DocumentBuilderHelper.parse((File)metaFile);
        ExpressExchangeDocumentsMetaData metaData = new ExpressExchangeDocumentsMetaData();
        metaData.fromXML(document.getDocumentElement());
        return metaData;
    }

    private void writeMetaData(ExpressExchangeDocumentsMetaData metaDatas, File metaFile) throws Exception {
        FileOutputStream outputStream = new FileOutputStream(metaFile);
        XUtil.serialize((XSerializable)metaDatas, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    private void clearMetaData(ExpressExchangeDocumentsMetaData metaDatas) throws Exception {
        Calendar currentCalendar = Calendar.getInstance();
        Iterator iterator = metaDatas.getExpressExchangeDocuments().iterator();
        while (iterator.hasNext()) {
            ExpressExchangeDocumentMetaData metaData = (ExpressExchangeDocumentMetaData)iterator.next();
            Date lastModified = metaData.getLastModified();
            if (lastModified != null) {
                Calendar lastModifiedCalendar = Calendar.getInstance();
                lastModifiedCalendar.setTime(lastModified);
                long differenceInDays = (currentCalendar.getTimeInMillis() - lastModifiedCalendar.getTimeInMillis()) / 86400000L;
                if (differenceInDays <= 2L) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private File getMetaFile() throws Exception {
        File metaFile = new File(this.folder, "meta.xml");
        if (!metaFile.exists()) {
            this.createMetaFile(metaFile);
            this.log.info("meta file was not found. Creating a new one");
        }
        return metaFile;
    }

    private void createMetaFile(File metaFile) throws Exception {
        ExpressExchangeDocumentsMetaData metaDatas = new ExpressExchangeDocumentsMetaData();
        FileOutputStream outputStream = new FileOutputStream(metaFile);
        XUtil.serialize((XSerializable)metaDatas, (OutputStream)outputStream);
        ((OutputStream)outputStream).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readContent(File file, String encoding) throws Exception {
        ByteArrayOutputStream out;
        block15: {
            out = new ByteArrayOutputStream();
            try {
                if (file == null || !file.exists()) break block15;
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
                }
            }
            finally {
                out.close();
            }
        }
        return new String(out.toByteArray(), encoding);
    }

    private void writeContent(String content, File file, String encoding) throws Exception {
        try (ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(encoding));
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));){
            IoUtil.copyStream((InputStream)in, (OutputStream)out, (int)256);
        }
    }

    private static class UnexpectedRecoredEndException
    extends Exception {
        private static final long serialVersionUID = 8470113693955499218L;

        public UnexpectedRecoredEndException(String message) {
            super(message);
        }
    }

    private static final class ContentInfo {
        private String content;
        private String partContent;
        private String cropContent;
        private final List<String> entries = new ArrayList<String>();

        private ContentInfo() {
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getPartContent() {
            return this.partContent;
        }

        public void setPartContent(String partContent) {
            this.partContent = partContent;
        }

        public String getCropContent() {
            return this.cropContent;
        }

        public void setCropContent(String cropContent) {
            this.cropContent = cropContent;
        }

        public List<String> getEntries() {
            return this.entries;
        }
    }

    private static final class TokenInfo {
        private int index;
        private String token;

        private TokenInfo() {
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }

    private static enum RecordType {
        AGENT,
        SELL,
        REFUND,
        VOID,
        REFUSE,
        COUPON;

    }
}

