/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product;

import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.railway.entity.actions.RailwayProductVatRecalculateAction;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.railway.tasks.dialog.RailwayProductRefundDialog;
import com.gridnine.xtrip.client.fx.standard.entity.actions.productcopy.CopyTask;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.BaseProductCreatePassiveSegmentsActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ChangePayerProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.CopyProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MoveNextProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.MovePrevProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.PayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionContext;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.ProductActionsProvider;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RecalculateFOPProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefundProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.RefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnpayProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnrefusePaymentProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.UnvoidProductAction;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.actions.VoidProductAction;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import java.util.Arrays;
import java.util.List;
import javafx.scene.Node;

public class RailwayProductActionsProvider
implements ProductActionsProvider {
    private List<TileAction<Node, BookingFileProductsFullPanel>> actions;

    public String getId() {
        return "standard-railway-product-actions-provider";
    }

    public boolean isApplicableTo(Node productView) {
        return productView instanceof BookingFileProductRailwayPanel;
    }

    public List<TileAction<Node, BookingFileProductsFullPanel>> getAvailableActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = Arrays.asList(new TileAction[]{new MovePrevProductAction<RailwayProduct>(){

            protected BaseProduct getPreviousProduct(RailwayProduct product) {
                return product.getPreviousProduct();
            }
        }, new MoveNextProductAction<RailwayProduct>(){

            protected BaseProduct getNextProduct(RailwayProduct product) {
                return product.getNextProduct();
            }
        }, new RefundProductAction<RailwayProduct>(){

            protected boolean isEnabled(RailwayProduct product) {
                return product != null && product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null && product.getReservation().getBookingFile().getNumber() != null;
            }

            protected void execute(ProductActionContext<RailwayProduct> ctx) {
                Notifications.get().submitTask(() -> {
                    RailwayProductRefundDialog dialog = new RailwayProductRefundDialog(ctx.getRootPane(), (RailwayProduct)ctx.getSelectedProduct());
                    FxUtil.submitToFxThread(dialog::showDialog);
                }, Messages.Railroad_ticket_payback);
            }
        }, new RecalculateFOPProductAction(), new CopyProductAction<RailwayProduct>(){

            protected boolean isEnabled(RailwayProduct product) {
                return product != null && (product.getStatus() == ProductStatus.SELL || product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.VOID_BOOKING || product.getStatus() == ProductStatus.VOID);
            }

            protected void execute(ProductActionContext<RailwayProduct> ctx) {
                CopyTask.showCopyDialog((EntityReference)ctx.getRootPane().getData().getContainer().toReference(), (String)((RailwayProduct)ctx.getSelectedProduct()).getUid(), (Node)ctx.getRootPane(), (ObservableMutex)ctx.getRootPane().getMutex());
            }
        }, new VoidProductAction<RailwayProduct>(){

            protected boolean isEnabled(RailwayProduct product) {
                return product != null && (product.getStatus() == ProductStatus.BOOKING || product.getStatus() == ProductStatus.SELL) && product.getNextProduct() == null;
            }
        }, new UnvoidProductAction<RailwayProduct>(){

            protected boolean isEnabled(RailwayProduct product) {
                return product != null && (product.getStatus() == ProductStatus.VOID || product.getStatus() == ProductStatus.VOID_BOOKING);
            }
        }, new PayProductAction<RailwayProduct>(){

            protected ProductStatus getStatus(RailwayProduct product) {
                return product.getStatus();
            }
        }, new UnpayProductAction<RailwayProduct>(){

            protected ProductStatus getStatus(RailwayProduct product) {
                return product.getStatus();
            }
        }, new RefusePaymentProductAction<RailwayProduct>(){

            protected ProductStatus getStatus(RailwayProduct product) {
                return product.getStatus();
            }
        }, new UnrefusePaymentProductAction<RailwayProduct>(){

            protected ProductStatus getStatus(RailwayProduct product) {
                return product.getStatus();
            }
        }, new ChangePayerProductAction(), new RailwayProductVatRecalculateAction(), new BaseProductCreatePassiveSegmentsActionsProvider()});
        return this.actions;
    }
}

