/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product;

import com.gridnine.xtrip.client.fx.core.lib.widgets.extendedtable.ExtendedTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileContractPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductCommissionsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductFopVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwaySalesChainPane;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductValidationMessagesVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpace;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileVendorFinanceDocumentsDataPanelVM;
import com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper.RailwayProductFXHelper;
import com.gridnine.xtrip.client.fx.railway.l10n.Messages;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanelController;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanelVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayProductUIData;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.ReasonCodeType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javafx.scene.Node;

public class RailwayProductFXHandler
implements ProductFXHandler<RailwayProduct, RailwayProductIndex, RailwayProductUIData, Void> {
    public boolean isDeletable(RailwayProduct product) {
        return Objects.isNull(product.getNextProduct());
    }

    public void remove(RailwayProduct product) {
        RailwayProduct nextProduct;
        product.getReservation().getProducts().remove(product);
        RailwayProduct previousProduct = product.getPreviousProduct();
        if (previousProduct != null) {
            previousProduct.setNextProduct(null);
        }
        if ((nextProduct = product.getNextProduct()) != null) {
            nextProduct.setPreviousProduct(null);
        }
    }

    public ProductStatus getProductStatus(RailwayProduct product) {
        return product.getStatus();
    }

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public Class<RailwayProductIndex> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public StatisticalData getStatisticalData(RailwayProduct product) {
        return product.getStatisticalData();
    }

    public void newStatisticalData(RailwayProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public Collection<Traveller> getTravellers(RailwayProduct product) {
        return product.getPassengers();
    }

    public boolean isMultiTraveller() {
        return true;
    }

    public void setAgent(RailwayProduct product, EntityReference<Person> agent) {
        product.setCashier(agent);
    }

    public String getDisplayName() {
        return ProductType.RAILWAY_PRODUCT.toString();
    }

    public void fromVM(BaseProductVM vm, RailwayProduct product, RailwayProductUIData productData) {
        BookingFile bookingFile;
        BookingFile bookingFile2 = bookingFile = product.getReservation() != null && product.getReservation().getBookingFile() != null ? product.getReservation().getBookingFile() : vm.getBookingFile();
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        BookingFileProductRailwayPanelVM productVM = (BookingFileProductRailwayPanelVM)vm;
        RailwayProductFXHelper.fromVMParameters(productVM, product, productData, bookingFile);
        RailwayProductFXHelper.fromVMSegmentsVM(productVM, product);
        RailwayProductFXHelper.fromVMCost(productVM.getCost(), product);
        RailwayProductFXHelper.fromVMRailwayAdditionalParameters(productVM.getOtherParameters(), product);
        GeneralProductFXHelper.fromVMCommissions((BaseProduct)product, (BookingFileProductCommissionsVM)productVM.getCommissions(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMFop((BaseProduct)product, (BookingFileProductFopVM)productVM.getFops(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMProductContract((BookingFileContractPanelVM)productVM.getFops().getContract(), (BaseProductUIData)productData);
        GeneralProductFXHelper.fromVMVendorFinanceDocumentsData((BookingFileVendorFinanceDocumentsDataPanelVM)productVM.getFops().getVendorFinanceDocumentsData(), (BaseProductUIData)productData);
        StatisticalData data = product.getStatisticalData();
        if (data == null) {
            data = new StatisticalData();
            product.setStatisticalData(data);
        }
        GeneralProductFXHelper.fromVMProductStatistic((BookingFile)product.getReservation().getBookingFile(), (BookingFileProductStatisticVM)productVM.getOtherParameters().getStatistic(), (StatisticalData)data, (BaseProductUIData)productData);
        product.setStatisticalData(data);
    }

    public RailwayProduct getPreviousProduct(RailwayProduct product) {
        return product.getPreviousProduct();
    }

    public RailwayProduct getNextProduct(RailwayProduct product) {
        return product.getNextProduct();
    }

    public RailwayProduct createProduct() {
        return new RailwayProduct();
    }

    public RailwayProductUIData createUiData() {
        return new RailwayProductUIData();
    }

    public BaseProductVM createVM(RailwayProduct product) {
        return new BookingFileProductRailwayPanelVM();
    }

    public String getRecordLocator(BaseProductVM vm) {
        return ((BookingFileProductRailwayPanelVM)vm).getGeneral().getOtherParameters().getInfo().getReservationValue();
    }

    public void toVM(RailwayProduct product, RailwayProductUIData productData, BaseProductVM vm, EntityReference<Organization> customerProfile) {
        List<ReasonCodeType> reasonCodeRailTypes = Arrays.asList(ReasonCodeType.REASON_CODE_RAIL, ReasonCodeType.REASON_CODE_NO_HOTEL, ReasonCodeType.REASON_CODE_DECLINED);
        BookingFileProductRailwayPanelVM productVM = (BookingFileProductRailwayPanelVM)vm;
        productVM.setStatus(product.getStatus());
        GeneralProductFXHelper.toVMProductFop((BaseProduct)product, (BaseProductUIData)productData, (BookingFileProductFopVM)productVM.getFops());
        GeneralProductFXHelper.toVMProductCommissions((BaseProduct)product, (BaseProductUIData)productData, (BookingFileProductCommissionsVM)productVM.getCommissions());
        GeneralProductFXHelper.toVMProductStatistic((StatisticalData)product.getStatisticalData(), (BaseProductUIData)productData, reasonCodeRailTypes, RailwayProduct.class, (BookingFileProductStatisticVM)productVM.getOtherParameters().getStatistic(), customerProfile);
        GeneralProductFXHelper.toVMValidationMessages((List)product.getValidationMessages(), (String)product.getUid(), (BookingFileProductValidationMessagesVM)productVM.getOtherParameters().getValidation());
        GeneralProductFXHelper.toVMProductContract((BaseProductUIData)productData, (BookingFileContractPanelVM)productVM.getFops().getContract());
        GeneralProductFXHelper.toVMPrepaymentDocuments((BaseProductUIData)productData, (List)productVM.getFops().getPrepaymentDocuments());
        GeneralProductFXHelper.toVMVendorFinanceDocumentsData((BaseProductUIData)productData, (BookingFileVendorFinanceDocumentsDataPanelVM)productVM.getFops().getVendorFinanceDocumentsData());
        RailwayProductFXHelper.toVMAllPanels(product, productData, productVM);
    }

    public boolean isAwareOf(Node node) {
        return node instanceof BookingFileProductRailwayPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node createNodeForNewProduct(BookingFileSpaceVM bookingFileVM, Void configuration, Map<String, Object> parameters) {
        BookingFile bookingFile = (BookingFile)parameters.get("bookingFile");
        Reservation reservation = (Reservation)parameters.get("reservation");
        BookingFileProductRailwayPanelVM productVM = new BookingFileProductRailwayPanelVM();
        productVM.setBookingFile(bookingFile);
        productVM.setProductFullNameWithSpaces(ProductType.RAILWAY_PRODUCT.toString());
        MiscUtil.Pair<RailwayProduct, RailwayProductUIData> prototypeData = RailwayProductFXHelper.getPrototypeData();
        RailwayProduct product = (RailwayProduct)prototypeData.getFirst();
        RailwayProductUIData productSupplementData = (RailwayProductUIData)prototypeData.getSecond();
        productVM.setProductUiData((BaseProductUIData)productSupplementData);
        String reservationUid = UUIDUtil.toString((UUID)UUID.randomUUID());
        if (reservation == null) {
            reservation = new Reservation(reservationUid);
        }
        if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
            bookingFile.getReservations().add(reservation);
            reservation.setBookingFile(bookingFile);
        }
        reservation.getProducts().add(product);
        product.setReservation(reservation);
        GeneralProductHelper.fillCommonCostCodes((BookingFile)bookingFile, (BaseProduct)product);
        try {
            this.toVM(product, productSupplementData, (BaseProductVM)productVM, null);
            BookingFileProductRailwayPanel node = new BookingFileProductRailwayPanel(false);
            node.getProperties().put((Object)"model-uid", (Object)product.getUid());
            RailwayProductFXHelper.updateNode(node, bookingFileVM);
            BookingFileProductRailwayPanelController controller = new BookingFileProductRailwayPanelController(node, false);
            controller.readData(productVM);
            BookingFileProductRailwayPanel bookingFileProductRailwayPanel = node;
            return bookingFileProductRailwayPanel;
        }
        finally {
            reservation.getProducts().remove(product);
            product.setReservation(null);
            if (MiscUtil.equals((Object)reservation.getUid(), (Object)reservationUid)) {
                bookingFile.getReservations().remove(reservation);
                reservation.setBookingFile(null);
            }
        }
    }

    public Node createNodeForExistingProduct(BookingFileSpaceVM bookingFileVM, Map<String, Object> parameters) {
        BookingFileProductRailwayPanel node = new BookingFileProductRailwayPanel(false);
        RailwayProductFXHelper.updateNode(node, bookingFileVM);
        return node;
    }

    public ProductType getProductType(RailwayProduct product) {
        return ProductType.RAILWAY_PRODUCT;
    }

    public Set<ContractType> getHiddenContractTypes(Node node) {
        BookingFileProductRailwaySalesChainPane paramsPane = ((BookingFileProductRailwayPanel)node).getGeneralNode().getSalesChainNode().getInfoNode();
        return GeneralProductFXHelper.getHiddenContractTypes((EntityReference)paramsPane.getAgencyValueNode().getValue(), (EntityReference)paramsPane.getSubagencyValueNode().getValue());
    }

    public void validate(String uid, Node node, List<Message> errors) {
        BookingFileProductRailwayPanel panel = (BookingFileProductRailwayPanel)node;
        String systemNumber = panel.getGeneralNode().getTicketInfoNode().getInfoNode().getTicketNumberValueNode().getValue();
        boolean emptyPaymentType = ((ExtendedTableWidget)panel.getFopsNode().getFopTableCell().getPayload()).getTable().getRows().stream().anyMatch(item -> ((ComboBoxWidget)item.getWidget("paymentType")).getValue() == null);
        if (emptyPaymentType) {
            errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.ProductPaymentTypeIsEmpty, (Object[])new Object[]{systemNumber}));
        }
    }

    public void validateStatisticalData(BookingFileSpace space, String uid, Node node, List<Message> errors) throws Exception {
        if (node instanceof BookingFileProductRailwayPanel) {
            BookingFileProductRailwayPanel panel = (BookingFileProductRailwayPanel)node;
            Collection statisticUdidsVMS = ((TableWidget)((BookingFileProductStatistic)panel.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getUdidsCard().getContent()).getRowsData();
            GeneralProductFXHelper.validateStatisticalData((BookingFileSpace)space, (String)uid, (Collection)statisticUdidsVMS, errors);
        }
    }
}

