/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.system.ValidatorValuePair;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaAdditionalsTariffVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaCostSumVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaCostVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaGeneralPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCrimeaSegmentsTableVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayStatusesPaneVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayCrimeaMCOUIData;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayProductPrototypeService;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayCrimeaMco;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class RailwayCrimeaMcoFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    public static void toVMGeneralAdditionalParametersTariff(RailwayCrimeaMco product, BookingFileProductRailwayCrimeaAdditionalsTariffVM model) {
        model.setEndorsement(product.getEndorsement());
        model.setFareCalculationData(product.getFareCalculationData());
    }

    public static void toVMAllPanels(RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData, BookingFileProductRailwayCrimeaPanelVM productVM) {
        productVM.setUid(product.getUid());
        productVM.setProductShortName(BookingHelper.generateShortProductName((BaseProduct)product));
        RailwayCrimeaMcoFXHelper.toVMGeneral(productVM.getGeneral(), product, productData);
        RailwayCrimeaMcoFXHelper.toVMControlStatuses(productVM.getStatuses(), product, productData);
        RailwayCrimeaMcoFXHelper.toVMRailwaySegments(product, productVM);
        RailwayCrimeaMcoFXHelper.toVMRailwayCostLeftTable(product, productVM.getCost());
        productVM.getOtherParameters().getPopups().getComments().setComments(product.getComments());
        RailwayCrimeaMcoFXHelper.toVMGeneralAdditionalParametersTariff(product, productVM.getOtherParameters().getTariff());
    }

    private static void toVMRailwayCostLeftTable(RailwayCrimeaMco product, BookingFileProductRailwayCrimeaCostVM vm) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductRailwayCrimeaCostSumVM sumCell = vm.getSum();
        sumCell.setTariffSumValue(RailwayCrimeaMcoFXHelper.getValue(product.getEquivalentFare(), negate));
        sumCell.setTariffTAXValue(RailwayCrimeaMcoFXHelper.getValue(product.getEquivalentVat(), negate));
        sumCell.setTariffCurrencyValue("RUB");
        sumCell.setFineSumValue(product.getPenalty());
        sumCell.setFineTAXValue(product.getPenaltyVat());
        sumCell.setFineTaxCurrencyValue("RUB");
        sumCell.setTotalSumValue(RailwayCrimeaMcoFXHelper.getValue(product.getTotalEquivalentFare(), negate));
        sumCell.setTotalTAXValue(RailwayCrimeaMcoFXHelper.getValue(product.getTotalEquivalentVat(), negate));
        sumCell.setTotalTaxCurrencyValue("RUB");
    }

    private static void toVMRailwaySegments(RailwayCrimeaMco product, BookingFileProductRailwayCrimeaPanelVM productVM) {
        VMHelper.transfer((Collection)product.getSegments(), (Collection)productVM.getSegments(), railwaySegment -> {
            BookingFileProductRailwayCrimeaSegmentsTableVM result = new BookingFileProductRailwayCrimeaSegmentsTableVM();
            result.setDeparturePoint(railwaySegment.getDepartureStation());
            result.setSegment(railwaySegment.getNumber());
            result.setArrivalPoint(railwaySegment.getArriveStation());
            result.setTrainNumber(railwaySegment.getTrainNumber());
            result.setSlot(railwaySegment.getSlot());
            result.setDepartureDate(DateUtils.asLocalDateTime((Date)railwaySegment.getDepartureDate()));
            result.setArrivalDate(DateUtils.asLocalDateTime((Date)railwaySegment.getArriveDate()));
            result.setFare(railwaySegment.getFare());
            result.setEqFare(railwaySegment.getEquivalentFare());
            result.setVat(railwaySegment.getEquivalentVAT());
            return result;
        });
    }

    private static void toVMControlStatuses(BookingFileProductRailwayStatusesPaneVM vm, RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData) {
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
    }

    private static void toVMGeneral(BookingFileProductRailwayCrimeaGeneralPanelVM generalVM, RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData) {
        String providerSystemNumber = product.getProviderSystemNumber();
        if (!TextUtil.isBlank((String)providerSystemNumber)) {
            generalVM.getTicketInfo().setProviderTicketNumberValue(providerSystemNumber);
        }
        generalVM.getTicketInfo().setProductValue(ProductType.RAILWAY_CRIMEA_MCO.toString());
        generalVM.getTicketInfo().setTicketNumberValue(product.getSystemNumber());
        generalVM.getTicketInfo().setScnValue(product.getScn());
        generalVM.getTicketInfo().setStatusValue(product.getStatus().toString());
        generalVM.getTicketInfo().setBlankValue(product.getBlankType());
        generalVM.getTicketInfo().setProviderValue(product.getProvider());
        generalVM.getTicketInfo().setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        generalVM.getTicketInfo().setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        generalVM.getTravelerInfo().setTransportationTypeValue(productData.getTransportationType());
        generalVM.getTravelerInfo().setStationValue(product.getPcc());
        generalVM.getTravelerInfo().setReservationValue(product.getReservation().getUid());
        generalVM.getTravelerInfo().setTicketTypeValue(product.getTicketType());
        generalVM.getTravelerInfo().getTravellersValue().clear();
        generalVM.getTravelerInfo().getTravellersValue().addAll(product.getPassengers());
        generalVM.getTravelerInfo().setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        generalVM.getTravelerInfo().setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        generalVM.getSalesChain().getValidatorValue().setReference(product.getValidator());
        if (product.getValidator() != null) {
            generalVM.getSalesChain().getValidatorValue().setCode(product.getValidator().getCaption());
        }
        generalVM.getSalesChain().setBlankOwnerValue(product.getBlankOwner());
        generalVM.getSalesChain().setSupplierValue(productData.getSupplier());
        generalVM.getSalesChain().setAgencyValue(productData.getAgency());
        generalVM.getSalesChain().setSubagencyValue(productData.getSubagency());
        generalVM.getSalesChain().setBranchValue(product.getBranch());
        generalVM.getSalesChain().setSalesPointValue(product.getSalesPoint());
        generalVM.getSalesChain().setPrescribeAgentValue(product.getAgent());
    }

    public static void fromVMRailwayAdditionalParameters(BookingFileProductRailwayCrimeaPanelVM productVM, RailwayCrimeaMco product) {
        product.setEndorsement(productVM.getOtherParameters().getTariff().getEndorsement());
        product.setFareCalculationData(productVM.getOtherParameters().getTariff().getFareCalculationData());
        product.setComments(productVM.getOtherParameters().getPopups().getComments().getComments());
    }

    public static void fromVMCostVM(BookingFileProductRailwayCrimeaCostVM vm, RailwayCrimeaMco product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductRailwayCrimeaCostSumVM sumCell = vm.getSum();
        product.setEquivalentFare(RailwayCrimeaMcoFXHelper.getValue(sumCell.getTariffSumValue(), negate));
        product.setEquivalentVat(RailwayCrimeaMcoFXHelper.getValue(sumCell.getTariffTAXValue(), negate));
        product.setPenalty(sumCell.getFineSumValue());
        product.setPenaltyVat(sumCell.getFineTAXValue());
        product.setTotalEquivalentFare(RailwayCrimeaMcoFXHelper.getValue(sumCell.getTotalSumValue(), negate));
        product.setTotalEquivalentVat(RailwayCrimeaMcoFXHelper.getValue(sumCell.getTotalTAXValue(), negate));
    }

    public static void fromVMSegmentsVM(BookingFileProductRailwayCrimeaPanelVM productVM, RailwayCrimeaMco product) {
        VMHelper.transfer((Collection)productVM.getSegments(), (Collection)product.getSegments(), segmentVM -> {
            RailwaySegment railwaySegment = new RailwaySegment();
            railwaySegment.setNumber(segmentVM.getSegment());
            railwaySegment.setDepartureStation(segmentVM.getDeparturePoint());
            railwaySegment.setArriveStation(segmentVM.getArrivalPoint());
            railwaySegment.setTrainNumber(segmentVM.getTrainNumber());
            railwaySegment.setSlot(segmentVM.getSlot());
            railwaySegment.setDepartureDate(DateUtils.asDate((LocalDateTime)segmentVM.getDepartureDate()));
            railwaySegment.setArriveDate(DateUtils.asDate((LocalDateTime)segmentVM.getArrivalDate()));
            railwaySegment.setFare(segmentVM.getFare());
            railwaySegment.setEquivalentFare(segmentVM.getEqFare());
            railwaySegment.setEquivalentVAT(segmentVM.getVat());
            return railwaySegment;
        });
    }

    public static void fromVMParameters(BookingFileProductRailwayCrimeaPanelVM productVM, RailwayCrimeaMco product, RailwayCrimeaMCOUIData productData, BookingFile bookingFile) {
        product.setSystemNumber(productVM.getGeneral().getTicketInfo().getTicketNumberValue());
        product.setScn(productVM.getGeneral().getTicketInfo().getScnValue());
        product.setBlankType(productVM.getGeneral().getTicketInfo().getBlankValue());
        product.setProvider(productVM.getGeneral().getTicketInfo().getProviderValue());
        product.setProviderSystemNumber(productVM.getGeneral().getTicketInfo().getProviderTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTicketInfo().getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTicketInfo().getCorrectionDateValue()));
        product.setPcc(productVM.getGeneral().getTravelerInfo().getStationValue());
        product.setTicketType(productVM.getGeneral().getTravelerInfo().getTicketTypeValue());
        productData.setTransportationType(productVM.getGeneral().getTravelerInfo().getTransportationTypeValue());
        List passengers = product.getPassengers();
        passengers.clear();
        productVM.getGeneral().getTravelerInfo().getTravellersValue().forEach(tr -> {
            Traveller foundTraveller;
            if (tr != null && (foundTraveller = GeneralProductFXHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)tr.getUid())) != null) {
                passengers.add(foundTraveller);
            }
        });
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTravelerInfo().getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)productVM.getGeneral().getTravelerInfo().getShipmentsDateSubagentValue()));
        ValidatorValuePair validatorValuePair = productVM.getGeneral().getSalesChain().getValidatorValue();
        if (validatorValuePair != null) {
            NestedEntityReference reference = validatorValuePair.getReference();
            product.setValidator(reference);
        }
        product.setBlankOwner(productVM.getGeneral().getSalesChain().getBlankOwnerValue());
        product.setBranch(productVM.getGeneral().getSalesChain().getBranchValue());
        product.setSalesPoint(productVM.getGeneral().getSalesChain().getSalesPointValue());
        product.setAgent(productVM.getGeneral().getSalesChain().getPrescribeAgentValue());
        productData.setSupplier(productVM.getGeneral().getSalesChain().getSupplierValue());
        productData.setAgency(productVM.getGeneral().getSalesChain().getAgencyValue());
        productData.setSubagency(productVM.getGeneral().getSalesChain().getSubagencyValue());
        product.setChecked(productVM.getStatuses().isChecked());
        product.setCompleted(productVM.getStatuses().isFinished());
        product.setContractRulesApplied(productVM.getStatuses().isRulesApplied());
    }

    public static MiscUtil.Pair<RailwayCrimeaMco, RailwayCrimeaMCOUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        RailwayCrimeaMco product = new RailwayCrimeaMco();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((RailwayProductPrototypeService)RpcServiceManager.get().getService(RailwayProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new RailwayCrimeaMco(), (Object)new RailwayCrimeaMCOUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductRailwayCrimeaPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(RailwayCrimeaMco.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

