/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.entity.handlers.product.helper;

import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayOtherParametersPanelVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayPassengerParametersPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwayPassengerVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductRailwaySalesChainPaneVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatistic;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.model.booking.SabrePassiveSegmentsPaneVM;
import com.gridnine.xtrip.client.fx.model.system.ValidatorValuePair;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCostPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayCostSumPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayGeneralPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayOtherParametersPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanelVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwaySegmentDetailsPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwaySegmentsTableVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayStatusesPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayTariffPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayTicketInfoPaneVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayVatDetailsItemVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayChildReservedSeatVM;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileRailwayChildTaxesVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.GeneralProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.AgentData;
import com.gridnine.xtrip.common.fx.railway.model.uidata.RailwayProductUIData;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayProductPrototypeService;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RailwayProductFXHelper {
    private static BigDecimal getValue(BigDecimal value, boolean negate) {
        if (value == null) {
            return null;
        }
        return negate ? value.negate() : value;
    }

    private static void toVMGeneralAdditionalParametersTariff(RailwayProduct product, BookingFileProductRailwayTariffPaneVM model) {
        model.setEndorsement(product.getEndorsement());
        model.setFareCalculationData(product.getFareCalculationData());
    }

    public static void toVMAllPanels(RailwayProduct product, RailwayProductUIData productData, BookingFileProductRailwayPanelVM productVM) {
        if (product.getStatus() == null) {
            product.setStatus(ProductStatus.SELL);
        }
        if (product.getTicketType() == null) {
            product.setTicketType(TicketType.OWN);
        }
        RailwayProductFXHelper.toVMGeneral(productVM.getGeneral(), product, productData);
        RailwayProductFXHelper.toVMStatuses(productVM.getStatuses(), product, productData);
        RailwayProductFXHelper.toVMRailwaySegments(product, productVM);
        RailwayProductFXHelper.toVMRailwayCost(product, productVM.getCost());
        RailwayProductFXHelper.toVMAdditionalParametersVM(product, productVM.getOtherParameters());
    }

    private static void toVMGeneral(BookingFileProductRailwayGeneralPanelVM generalVM, RailwayProduct product, RailwayProductUIData productData) {
        String providerSystemNumber = product.getProviderSystemNumber();
        BookingFileProductRailwayTicketInfoPaneVM ticketInfoVM = generalVM.getTicketInfo().getInfo();
        if (!TextUtil.isBlank((String)providerSystemNumber)) {
            ticketInfoVM.setProviderTicketNumberValue(providerSystemNumber);
        }
        ticketInfoVM.setProductValue(ProductType.RAILWAY_PRODUCT.toString());
        ticketInfoVM.setCarrierValue(product.getCarrier());
        ticketInfoVM.setTicketNumberValue(product.getSystemNumber());
        ticketInfoVM.setScnValue(product.getScn());
        ticketInfoVM.setStatusValue(product.getStatus().toString());
        ticketInfoVM.setBlankValue(product.getBlankType());
        ticketInfoVM.setProviderValue(product.getProvider());
        ticketInfoVM.setOperationDateValue(DateUtils.asLocalDateTime((Date)product.getIssueDate()));
        ticketInfoVM.setCorrectionDateValue(DateUtils.asLocalDateTime((Date)product.getCorrectionDate()));
        ticketInfoVM.setBookingFile(product.getReservation().getBookingFile());
        BookingFileProductRailwayOtherParametersPaneVM otherParametersVM = generalVM.getOtherParameters().getInfo();
        otherParametersVM.setRefundDateValue(DateUtils.asLocalDateTime((Date)product.getRefundExpireDate()));
        otherParametersVM.setTransportationTypeValue(productData.getTransportationType());
        otherParametersVM.setStationValue(product.getPcc());
        otherParametersVM.setReservationValue(product.getReservation().getUid());
        otherParametersVM.setShipmentsDateValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDate()));
        otherParametersVM.setShipmentsDateSubagentValue(DateUtils.asLocalDateTime((Date)product.getShipmentsDateSubagent()));
        BookingFileProductRailwayPassengerParametersPaneVM passengersVM = generalVM.getOtherParameters().getPassengers();
        passengersVM.getPassengers().clear();
        product.getPassengers().forEach(traveller -> {
            BookingFileProductRailwayPassengerVM passengerVM = new BookingFileProductRailwayPassengerVM();
            passengerVM.setPassenger(traveller);
            DictionaryReference passengerType = RailwayProductHelper.getPassengerType((RailwayProduct)product, (Traveller)traveller);
            passengerVM.setPassengerType(passengerType);
            passengersVM.getPassengers().add(passengerVM);
        });
        String validatorCode = product.getValidatorCode();
        NestedEntityReference validatorRef = product.getValidatorRef();
        if (validatorRef != null && validatorCode != null && validatorRef.getCaption().contains("com.gridnine")) {
            validatorRef.setCaption(validatorCode);
        }
        BookingFileProductRailwaySalesChainPaneVM salesChainVM = generalVM.getSalesChain().getInfo();
        salesChainVM.getValidatorValue().setCode(validatorCode);
        salesChainVM.getValidatorValue().setReference(validatorRef);
        salesChainVM.setBlankOwnerValue(product.getBlankOwnerRef());
        salesChainVM.setSupplierValue(productData.getSupplier());
        salesChainVM.setAgencyValue(productData.getAgency());
        salesChainVM.setSubagencyValue(productData.getSubagency());
        salesChainVM.setBranchValue(product.getBranch());
        salesChainVM.setSalesPointValue(product.getSalesPoint());
        salesChainVM.setPrescribeAgentValue(product.getCashier());
        salesChainVM.setTicketTypeValue(product.getTicketType());
    }

    private static void toVMStatuses(BookingFileProductRailwayStatusesPaneVM vm, RailwayProduct product, RailwayProductUIData productData) {
        VatDetalization vendorVatDetalization = product.getVendorVatDetalization();
        if (vendorVatDetalization != null) {
            vm.setVatSpecified(vendorVatDetalization.isDetalized());
        }
        vm.setChecked(product.isChecked());
        vm.setFinished(product.isCompleted());
        vm.setHasErrors(productData.isHasErrors());
        vm.setHasWarnings(productData.isHasWarnings());
        vm.setRulesApplied(product.isContractRulesApplied());
        vm.setForcedRefund(product.isForcedRefund());
    }

    private static void toVMRailwayCost(RailwayProduct product, BookingFileProductRailwayCostPaneVM view) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        RailwayProductFXHelper.toVMSum(negate, product, view);
        RailwayProductFXHelper.toVMVat(negate, product, view);
    }

    private static void toVMVat(boolean negate, RailwayProduct product, BookingFileProductRailwayCostPaneVM view) {
        VatDetalization vatDetalization = product.getVendorVatDetalization();
        if (vatDetalization != null) {
            vatDetalization.getComponents().stream().map(vatComponent -> {
                BookingFileProductRailwayVatDetailsItemVM result = new BookingFileProductRailwayVatDetailsItemVM();
                List taxList = vatComponent.getTaxesUids().stream().map(uid -> product.getTaxes().stream().filter(railwayTax -> railwayTax.getUid().equals(uid)).findFirst().orElse(null)).collect(Collectors.toList());
                result.setRate((BigDecimal)Optional.ofNullable(vatComponent.getRate()).map(BigDecimal::valueOf).orElse(null));
                result.setBase(RailwayProductFXHelper.getValue(vatComponent.getBasis(), negate));
                result.setSum(RailwayProductFXHelper.getValue(vatComponent.getSum(), negate));
                result.getTax().addAll(taxList);
                result.getBaseType().addAll(vatComponent.getBasisTypes());
                return result;
            }).collect(Collectors.toCollection(() -> view.getVatDetails().getContent()));
        }
    }

    private static void toVMSum(boolean negate, RailwayProduct product, BookingFileProductRailwayCostPaneVM view) {
        BookingFileProductRailwayCostSumPaneVM costCell = view.getSum();
        costCell.setTariffSumValue(RailwayProductFXHelper.getValue(product.getEquivalentFare(), negate));
        costCell.setTariffTAXValue(RailwayProductFXHelper.getValue(product.getEquivalentVAT(), negate));
        String gdsCurrency = (String)MiscUtil.guarded((Object)product.getGdsCurrency(), (Object)Prefetched.getData().getEquivalentCurrency(), (Object[])new String[]{"RUB"});
        costCell.setTariffCurrencyValue(gdsCurrency);
        costCell.setServiceSumValue(RailwayProductFXHelper.getValue(product.getServiceFare(), negate));
        costCell.setServiceTAXValue(RailwayProductFXHelper.getValue(product.getServiceVAT(), negate));
        costCell.setServiceCurrencyValue(gdsCurrency);
        costCell.setFineSumValue(product.getPenalty());
        costCell.setFineTAXValue(product.getPenaltyVAT());
        costCell.setFineTaxCurrencyValue(gdsCurrency);
        costCell.setTotalSumValue(RailwayProductFXHelper.getValue(product.getTotalEquivalentFare(), negate));
        costCell.setTotalTAXValue(RailwayProductFXHelper.getValue(product.getTotalEquivalentVAT(), negate));
        costCell.setTotalTaxCurrencyValue(gdsCurrency);
    }

    private static void toVMAdditionalParametersVM(RailwayProduct product, BookingFileProductRailwayOtherParametersPanelVM vm) {
        vm.getPopups().getComments().setComments(product.getComments());
        RailwayProductFXHelper.toVMGeneralAdditionalParametersTariff(product, vm.getTariff());
        GeneralProductFXHelper.toVMPassiveSegments((BaseProduct)product, (SabrePassiveSegmentsPaneVM)vm.getPopups().getPassiveSegments());
    }

    private static void toVMRailwaySegments(RailwayProduct product, BookingFileProductRailwayPanelVM productVM) {
        VMHelper.transfer((Collection)product.getSegments(), (Collection)productVM.getSegments(), res -> new BookingFileProductRailwaySegmentsTableVM(), (railwaySegment, result) -> {
            result.setSegmentModel(railwaySegment);
            result.setDeparturePoint(railwaySegment.getDepartureStation());
            result.setSegment(railwaySegment.getNumber());
            result.setArrivalPoint(railwaySegment.getArriveStation());
            result.setTrainNumber(railwaySegment.getTrainNumber());
            result.setCarriageNumber(railwaySegment.getCarriageNumber());
            result.setCarriageType(railwaySegment.getCarriageType());
            result.setPlaces(railwaySegment.getPlaces().stream().collect(Collectors.joining(", ")));
            result.setDepartureDate(DateUtils.asLocalDateTime((Date)railwaySegment.getDepartureDate()));
            result.setFare(railwaySegment.getFare());
            result.setEqFare(railwaySegment.getEquivalentFare());
            result.setVat(railwaySegment.getEquivalentVAT());
            BookingFileProductRailwaySegmentDetailsPaneVM additionalVM = result.getSuperColumn();
            additionalVM.setArrivalDate(DateUtils.asLocalDateTime((Date)railwaySegment.getArriveDate()));
            additionalVM.setCarrier(railwaySegment.getCarrier());
            additionalVM.setRailway(railwaySegment.getRoute());
            additionalVM.setDepartureSign(railwaySegment.getTimeInfo());
            additionalVM.setERegistrationPossible(railwaySegment.isERegEnabled());
            additionalVM.setERegistration(railwaySegment.isHasEReg());
            additionalVM.setSlot(railwaySegment.getSlot());
            additionalVM.setCompartmentType(railwaySegment.getCompartmentType());
            additionalVM.setServiceClass(railwaySegment.getServiceClass());
            additionalVM.setRequirements(railwaySegment.getAddInfo());
        });
        product.getReservedSeats().stream().map(reservedSeat -> {
            BookingFileRailwayChildReservedSeatVM reservedSeatVM = new BookingFileRailwayChildReservedSeatVM();
            reservedSeatVM.setNumber(reservedSeat.getSegment());
            reservedSeatVM.setFare(reservedSeat.getFare());
            reservedSeatVM.setEqFare(reservedSeat.getEquivalentFare());
            reservedSeatVM.setVat(reservedSeat.getEquivalentVAT());
            reservedSeatVM.setDeduction(reservedSeat.getEquivalentDeduction());
            reservedSeatVM.setDeductionVat(reservedSeat.getEquivalentDeductionVAT());
            return reservedSeatVM;
        }).collect(Collectors.toCollection(() -> ((BookingFileProductRailwayPanelVM)productVM).getReservedSeats()));
        product.getTaxes().stream().map(tax -> {
            BookingFileRailwayChildTaxesVM taxesVM = new BookingFileRailwayChildTaxesVM();
            taxesVM.setUid(tax.getUid());
            taxesVM.setNumber(tax.getSegment());
            taxesVM.setCode(tax.getCode());
            taxesVM.setFare(tax.getFare());
            taxesVM.setEqFare(tax.getEquivalentFare());
            taxesVM.setVat(tax.getEquivalentVAT());
            return taxesVM;
        }).collect(Collectors.toCollection(() -> ((BookingFileProductRailwayPanelVM)productVM).getTaxes()));
    }

    public static void fromVMParameters(BookingFileProductRailwayPanelVM productVM, RailwayProduct product, RailwayProductUIData productData, BookingFile bookingFile) {
        productVM.getGeneral().getTicketInfo().getInfo().setBookingFile(bookingFile);
        RailwayProductFXHelper.fromVMGeneral(productVM.getGeneral(), product, productData);
        BookingFileProductRailwayStatusesPaneVM statusesVM = productVM.getStatuses();
        product.setChecked(statusesVM.isChecked());
        product.setCompleted(statusesVM.isFinished());
        product.setContractRulesApplied(statusesVM.isRulesApplied());
        product.setForcedRefund(statusesVM.isForcedRefund());
        VatDetalization vendorVatDetalization = product.getVendorVatDetalization();
        if (vendorVatDetalization != null) {
            vendorVatDetalization.setDetalized(statusesVM.isVatSpecified());
        }
    }

    private static void fromVMGeneral(BookingFileProductRailwayGeneralPanelVM generalVM, RailwayProduct product, RailwayProductUIData productData) {
        BookingFileProductRailwayTicketInfoPaneVM ticketInfoVM = generalVM.getTicketInfo().getInfo();
        product.setSystemNumber(ticketInfoVM.getTicketNumberValue());
        product.setCarrier(ticketInfoVM.getCarrierValue());
        product.setScn(ticketInfoVM.getScnValue());
        product.setBlankType(ticketInfoVM.getBlankValue());
        product.setProvider(ticketInfoVM.getProviderValue());
        product.setProviderSystemNumber(ticketInfoVM.getProviderTicketNumberValue());
        product.setIssueDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getOperationDateValue()));
        product.setCorrectionDate(DateUtils.asDate((LocalDateTime)ticketInfoVM.getCorrectionDateValue()));
        BookingFileProductRailwayOtherParametersPaneVM otherParametersVM = generalVM.getOtherParameters().getInfo();
        product.setPcc(otherParametersVM.getStationValue());
        productData.setTransportationType(otherParametersVM.getTransportationTypeValue());
        BookingFileProductRailwayPassengerParametersPaneVM passengersVM = generalVM.getOtherParameters().getPassengers();
        List passengers = product.getPassengers();
        passengers.clear();
        product.getPassengerTypes().clear();
        passengersVM.getPassengers().forEach(passengerVM -> {
            if (passengerVM.getPassenger() != null) {
                Traveller traveller = GeneralProductFXHelper.findTraveller((BookingFile)product.getReservation().getBookingFile(), (String)passengerVM.getPassenger().getUid());
                if (traveller != null) {
                    passengers.add(traveller);
                }
                RailwayProductHelper.setPassengerType((RailwayProduct)product, (Traveller)traveller, (DictionaryReference)passengerVM.getPassengerType());
            }
        });
        product.setRefundExpireDate(DateUtils.asDate((LocalDateTime)otherParametersVM.getRefundDateValue()));
        product.setShipmentsDate(DateUtils.asDate((LocalDateTime)otherParametersVM.getShipmentsDateValue()));
        product.setShipmentsDateSubagent(DateUtils.asDate((LocalDateTime)otherParametersVM.getShipmentsDateSubagentValue()));
        BookingFileProductRailwaySalesChainPaneVM salesChainVM = generalVM.getSalesChain().getInfo();
        ValidatorValuePair validatorValuePair = salesChainVM.getValidatorValue();
        if (validatorValuePair != null) {
            product.setValidatorCode(validatorValuePair.getCode());
            product.setValidatorRef(validatorValuePair.getReference());
        }
        product.setBlankOwnerRef(salesChainVM.getBlankOwnerValue());
        product.setBranch(salesChainVM.getBranchValue());
        product.setSalesPoint(salesChainVM.getSalesPointValue());
        product.setCashier(salesChainVM.getPrescribeAgentValue());
        productData.setSupplier(salesChainVM.getSupplierValue());
        productData.setAgency(salesChainVM.getAgencyValue());
        productData.setSubagency(salesChainVM.getSubagencyValue());
        product.setTicketType(salesChainVM.getTicketTypeValue());
    }

    public static void fromVMRailwayAdditionalParameters(BookingFileProductRailwayOtherParametersPanelVM vm, RailwayProduct product) {
        product.setEndorsement(vm.getTariff().getEndorsement());
        product.setFareCalculationData(vm.getTariff().getFareCalculationData());
        product.setComments(vm.getPopups().getComments().getComments());
        GeneralProductFXHelper.fromVMPassiveSegments((SabrePassiveSegmentsPaneVM)vm.getPopups().getPassiveSegments(), (BaseProduct)product);
    }

    private static Function<BookingFileProductRailwayVatDetailsItemVM, VatComponent> fromVMVatComponent(boolean negate) {
        return vatDetailVM -> {
            VatComponent result = new VatComponent();
            BigDecimal rate = vatDetailVM.getRate();
            result.setRate(rate == null ? null : Double.valueOf(rate.doubleValue()));
            result.setBasis(RailwayProductFXHelper.getValue(vatDetailVM.getBase(), negate));
            result.setSum(RailwayProductFXHelper.getValue(vatDetailVM.getSum(), negate));
            result.getBasisTypes().clear();
            result.getBasisTypes().addAll(vatDetailVM.getBaseType());
            result.getTaxesUids().clear();
            vatDetailVM.getTax().stream().map(BaseIdentity::getUid).collect(Collectors.toCollection(() -> ((VatComponent)result).getTaxesUids()));
            return result;
        };
    }

    public static void fromVMCost(BookingFileProductRailwayCostPaneVM view, RailwayProduct product) {
        boolean negate = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE;
        BookingFileProductRailwayCostSumPaneVM costCell = view.getSum();
        product.setEquivalentFare(RailwayProductFXHelper.getValue(costCell.getTariffSumValue(), negate));
        product.setEquivalentVAT(RailwayProductFXHelper.getValue(costCell.getTariffTAXValue(), negate));
        product.setServiceFare(RailwayProductFXHelper.getValue(costCell.getServiceSumValue(), negate));
        product.setServiceVAT(RailwayProductFXHelper.getValue(costCell.getServiceTAXValue(), negate));
        product.setPenalty(costCell.getFineSumValue());
        product.setPenaltyVAT(costCell.getFineTAXValue());
        product.setTotalEquivalentFare(RailwayProductFXHelper.getValue(costCell.getTotalSumValue(), negate));
        product.setTotalEquivalentVAT(RailwayProductFXHelper.getValue(costCell.getTotalTAXValue(), negate));
        VatDetalization vendorVatDetalization = product.getVendorVatDetalization();
        vendorVatDetalization = vendorVatDetalization != null ? vendorVatDetalization : new VatDetalization();
        List vatComponentList = vendorVatDetalization.getComponents();
        vatComponentList.clear();
        List vatDetailsVM = view.getVatDetails().getContent();
        vatDetailsVM.stream().map(RailwayProductFXHelper.fromVMVatComponent(negate)).collect(Collectors.toCollection(() -> vatComponentList));
    }

    public static void fromVMSegmentsVM(BookingFileProductRailwayPanelVM vm, RailwayProduct product) {
        RailwayProductFXHelper.fromVMSegmentsCard(vm.getSegments(), product);
        RailwayProductFXHelper.fromVMReservedSeatsCard(product.getSegments(), vm.getReservedSeats(), product.getReservedSeats());
        RailwayProductFXHelper.fromVMTaxesCard(vm.getTaxes(), product.getTaxes());
    }

    private static void fromVMTaxesCard(List<BookingFileRailwayChildTaxesVM> taxesVM, List<RailwayTax> productTaxes) {
        productTaxes.clear();
        taxesVM.stream().map(taxVM -> {
            RailwayTax railwayTax = new RailwayTax();
            railwayTax.setUid(taxVM.getUid());
            railwayTax.setSegment(taxVM.getNumber());
            railwayTax.setFare(taxVM.getFare());
            railwayTax.setEquivalentFare(taxVM.getEqFare());
            railwayTax.setEquivalentVAT(taxVM.getVat());
            railwayTax.setCode(taxVM.getCode());
            return railwayTax;
        }).collect(Collectors.toCollection(() -> productTaxes));
    }

    private static void fromVMReservedSeatsCard(Collection<RailwaySegment> segments, List<BookingFileRailwayChildReservedSeatVM> reservedSeatsVM, List<ReservedSeat> productReservedSeats) {
        productReservedSeats.clear();
        Map<String, RailwaySegment> segmentsMap = segments.stream().collect(Collectors.toMap(BaseIdentity::getUid, el -> el, (o1, o2) -> o2));
        reservedSeatsVM.stream().map(reservedSeatVM -> {
            ReservedSeat reservedSeat = new ReservedSeat();
            RailwaySegment segment = reservedSeatVM.getNumber();
            if (segment != null) {
                reservedSeat.setSegment(segmentsMap.getOrDefault(segment.getUid(), segment));
            }
            reservedSeat.setFare(reservedSeatVM.getFare());
            reservedSeat.setEquivalentFare(reservedSeatVM.getEqFare());
            reservedSeat.setEquivalentVAT(reservedSeatVM.getVat());
            reservedSeat.setEquivalentDeduction(reservedSeatVM.getDeduction());
            reservedSeat.setEquivalentDeductionVAT(reservedSeatVM.getDeductionVat());
            return reservedSeat;
        }).collect(Collectors.toCollection(() -> productReservedSeats));
    }

    private static void fromVMSegmentsCard(List<BookingFileProductRailwaySegmentsTableVM> segments, RailwayProduct product) {
        VMHelper.transfer(segments, (Collection)product.getSegments(), res -> new RailwaySegment(), (segmentVM, railwaySegment) -> {
            railwaySegment.setNumber(segmentVM.getSegment());
            railwaySegment.setDepartureStation(segmentVM.getDeparturePoint());
            railwaySegment.setArriveStation(segmentVM.getArrivalPoint());
            railwaySegment.setTrainNumber(segmentVM.getTrainNumber());
            railwaySegment.setCarriageNumber(segmentVM.getCarriageNumber());
            railwaySegment.setCarriageType(segmentVM.getCarriageType());
            String places = segmentVM.getPlaces();
            if (places != null) {
                railwaySegment.getPlaces().clear();
                railwaySegment.getPlaces().addAll(Arrays.asList(places.split(", ")));
            }
            railwaySegment.setDepartureDate(DateUtils.asDate((LocalDateTime)segmentVM.getDepartureDate()));
            railwaySegment.setFare(segmentVM.getFare());
            railwaySegment.setEquivalentFare(segmentVM.getEqFare());
            railwaySegment.setEquivalentVAT(segmentVM.getVat());
            BookingFileProductRailwaySegmentDetailsPaneVM additionalDataVM = segmentVM.getSuperColumn();
            railwaySegment.setArriveDate(DateUtils.asDate((LocalDateTime)additionalDataVM.getArrivalDate()));
            railwaySegment.setERegEnabled(additionalDataVM.isERegistrationPossible());
            railwaySegment.setHasEReg(additionalDataVM.isERegistration());
            railwaySegment.setCarrier(additionalDataVM.getCarrier());
            railwaySegment.setRoute(additionalDataVM.getRailway());
            railwaySegment.setTimeInfo(additionalDataVM.getDepartureSign());
            railwaySegment.setSlot(additionalDataVM.getSlot());
            railwaySegment.setCompartmentType(additionalDataVM.getCompartmentType());
            railwaySegment.setServiceClass(additionalDataVM.getServiceClass());
            railwaySegment.setAddInfo(additionalDataVM.getRequirements());
        });
    }

    public static MiscUtil.Pair<RailwayProduct, RailwayProductUIData> getPrototypeData() {
        AgentData agentData = Prefetched.getData().getCurrentAgentData();
        RailwayProduct product = new RailwayProduct();
        GeneralProductFXHelper.loadPrototypeData((BaseProduct)product);
        MiscUtil.Pair prototypeData = null;
        try {
            prototypeData = ((RailwayProductPrototypeService)RpcServiceManager.get().getService(RailwayProductPrototypeService.class)).getPrototypeData(ServiceInvocationContext.get(), agentData, product);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        if (prototypeData == null) {
            prototypeData = new MiscUtil.Pair((Object)new RailwayProduct(), (Object)new RailwayProductUIData());
        }
        return prototypeData;
    }

    public static void updateNode(BookingFileProductRailwayPanel node, BookingFileSpaceVM bookingFileVM) {
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().setValue(RailwayProduct.class);
        ((BookingFileProductStatisticAfs)((BookingFileProductStatistic)node.getOtherParametersNode().getStatisticCard().getContent()).getStatisticNode().getAfsCard().getContent()).clientProperty().setValue((Object)bookingFileVM.getMainFull().getGeneralParameters().getClient());
    }
}

