/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.tasks.RailwayItineraryReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseItineraryReceiptDialog;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayService;
import com.gridnine.xtrip.common.fx.rpc.RailwayItineraryReceiptProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.Pane;

public class RailwayItineraryReceiptDialog
extends BaseItineraryReceiptDialog<RailwayItineraryReceiptProperties> {
    public List<GridCell<?>> createAdditionalPropertiesCells() {
        return Collections.emptyList();
    }

    public RailwayItineraryReceiptProperties createProperties(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        Map<String, Collection<EntityReference<TemplateDocument>>> productUids2TemplateRefs = this.getProducts2Templates(products2Bookings);
        if (productUids2TemplateRefs != null) {
            return new RailwayItineraryReceiptProperties(this.getProducts2Bookings(), this.getProducts2Templates(), Collections.emptyList());
        }
        return null;
    }

    public RailwayItineraryReceiptProperties createEmptyProperties() {
        return new RailwayItineraryReceiptProperties();
    }

    public RailwayItineraryReceiptProperties createAndFillProperties() {
        return new RailwayItineraryReceiptProperties(this.getProducts2Bookings(), this.getProducts2Templates(), this.getInformationNotes());
    }

    public void createAdditionalWidgets() {
    }

    public void updateFromProperties(RailwayItineraryReceiptProperties properties) {
    }

    public IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters() {
        return ControllerInterceptorsHelper.getRailwayItineraryTemplates();
    }

    public RailwayItineraryReceiptTask createTask(RailwayItineraryReceiptProperties properties) {
        return new RailwayItineraryReceiptTask(properties);
    }

    public String getPropertiesFileName() {
        return "railway-itinerary-receipt.xml";
    }

    public List<Class<? extends Pane>> getPaneClassList() {
        return Collections.singletonList(BookingFileProductRailwayPanel.class);
    }

    public Class<RailwayProductIndex> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    protected Map<String, Collection<EntityReference<TemplateDocument>>> getProducts2Templates(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        HashMap<String, Collection<EntityReference<TemplateDocument>>> productUids2TemplateRefs = new HashMap<String, Collection<EntityReference<TemplateDocument>>>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entry : products2Bookings.entrySet()) {
            if (!(entry.getKey() instanceof RailwayProduct)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entry.getValue(), (BaseEntity)((RailwayProduct)entry.getKey()));
            try {
                Collection templateDocuments = ((RailwayService)RpcServiceManager.get().getService(RailwayService.class)).getTemplateDocuments(ServiceInvocationContext.get(), productReference);
                productUids2TemplateRefs.put(entry.getKey().getUid(), templateDocuments);
            }
            catch (Exception e) {
                this.log.warn("unable to get TemplateDocument", (Throwable)e);
                productUids2TemplateRefs.put(entry.getKey().getUid(), null);
            }
        }
        return productUids2TemplateRefs;
    }
}

