/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.railway.tasks.dialog;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.railway.model.booking.BookingFileProductRailwayPanel;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.tasks.BaseRefundReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.RailwayRefundReceiptTask;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BaseRefundReceiptDialog;
import com.gridnine.xtrip.common.fx.railway.rpc.RailwayService;
import com.gridnine.xtrip.common.fx.rpc.RailwayRefundReceiptProperties;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.scene.layout.Pane;

public class RailwayRefundReceiptDialog
extends BaseRefundReceiptDialog<RailwayRefundReceiptProperties> {
    public RailwayRefundReceiptProperties createProperties(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        Collection<EntityReference<TemplateDocument>> templateDocuments = this.getTemplateDocuments(products2Bookings);
        if (!templateDocuments.isEmpty()) {
            return new RailwayRefundReceiptProperties(templateDocuments, this.getProducts2Bookings(), Collections.emptyList());
        }
        return null;
    }

    public RailwayRefundReceiptProperties createEmptyProperties() {
        return new RailwayRefundReceiptProperties();
    }

    public RailwayRefundReceiptProperties createAndFillProperties() {
        return new RailwayRefundReceiptProperties(this.getTemplates(), this.getProducts2Bookings(), this.getInformationNotes());
    }

    public void createAdditionalWidgets() {
    }

    public void updateFromDefaultProperties(RailwayRefundReceiptProperties properties) {
    }

    public List<GridCell<?>> createAdditionalPropertiesCells() {
        return Collections.emptyList();
    }

    public IndexListParameters<TemplateDocument, TemplateDocumentIndex> getTemplateParameters() {
        return ControllerInterceptorsHelper.getRailwayRefundTemplates();
    }

    public BaseRefundReceiptTask createTask(RailwayRefundReceiptProperties properties) {
        return new RailwayRefundReceiptTask(properties);
    }

    public String getPropertiesFileName() {
        return "railway-refund-receipt.xml";
    }

    public List<Class<? extends Pane>> getPaneClassList() {
        return Collections.singletonList(BookingFileProductRailwayPanel.class);
    }

    public Class<?> getProductIndexClass() {
        return RailwayProductIndex.class;
    }

    public Class<RailwayProduct> getProductClass() {
        return RailwayProduct.class;
    }

    public Collection<EntityReference<TemplateDocument>> getTemplateDocuments(Map<BaseProduct, EntityReference<BookingFile>> products2Bookings) {
        ArrayList<EntityReference<TemplateDocument>> templateDocuments = new ArrayList<EntityReference<TemplateDocument>>();
        for (Map.Entry<BaseProduct, EntityReference<BookingFile>> entrySet : products2Bookings.entrySet()) {
            if (!(entrySet.getKey() instanceof RailwayProduct)) continue;
            NestedEntityReference productReference = new NestedEntityReference(entrySet.getValue(), (BaseEntity)((RailwayProduct)entrySet.getKey()));
            try {
                Collection docs = ((RailwayService)RpcServiceManager.get().getService(RailwayService.class)).getTemplateDocuments(ServiceInvocationContext.get(), productReference);
                templateDocuments.addAll(docs);
            }
            catch (Exception e) {
                this.log.error("unable to get TemplateDocument", (Throwable)e);
                return null;
            }
        }
        if (!templateDocuments.isEmpty()) {
            return templateDocuments;
        }
        return Collections.emptyList();
    }
}

