/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.registry.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.registry.xml.ManifestHandler;
import org.java.plugin.registry.xml.ManifestInfoHandler;
import org.java.plugin.registry.xml.ModelManifestInfo;
import org.java.plugin.registry.xml.ModelPluginManifest;
import org.java.plugin.registry.xml.PluginRegistryImpl;
import org.java.plugin.util.IoUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class ManifestParser {
    static Log log = LogFactory.getLog(ManifestParser.class);
    static final String PLUGIN_DTD_1_0 = ManifestParser.loadPluginDtd("1_0");
    private final SAXParser parser;
    private final EntityResolver entityResolver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadPluginDtd(String version) {
        String string;
        InputStreamReader in = new InputStreamReader(PluginRegistryImpl.class.getResourceAsStream("plugin_" + version + ".dtd"), "UTF-8");
        try {
            int read;
            StringBuilder sBuf = new StringBuilder();
            char[] cBuf = new char[64];
            while ((read = in.read(cBuf)) != -1) {
                sBuf.append(cBuf, 0, read);
            }
            string = sBuf.toString();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)in).close();
                throw throwable;
            }
            catch (IOException ioe) {
                log.error("can't read plug-in DTD file of version " + version, ioe);
                return null;
            }
        }
        ((Reader)in).close();
        return string;
    }

    private static EntityResolver getDtdEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if (publicId == null) {
                    log.debug("can't resolve entity, public ID is NULL, systemId=" + systemId);
                    return null;
                }
                if (PLUGIN_DTD_1_0 == null) {
                    return null;
                }
                if (publicId.equals("-//JPF//Java Plug-in Manifest 1.0") || publicId.equals("-//JPF//Java Plug-in Manifest 0.7") || publicId.equals("-//JPF//Java Plug-in Manifest 0.6") || publicId.equals("-//JPF//Java Plug-in Manifest 0.5") || publicId.equals("-//JPF//Java Plug-in Manifest 0.4") || publicId.equals("-//JPF//Java Plug-in Manifest 0.3") || publicId.equals("-//JPF//Java Plug-in Manifest 0.2")) {
                    if (log.isDebugEnabled()) {
                        log.debug("entity resolved to plug-in manifest DTD, publicId=" + publicId + ", systemId=" + systemId);
                    }
                    return new InputSource(new StringReader(PLUGIN_DTD_1_0));
                }
                if (log.isDebugEnabled()) {
                    log.debug("entity not resolved, publicId=" + publicId + ", systemId=" + systemId);
                }
                return null;
            }
        };
    }

    ManifestParser(boolean isValidating) {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            parserFactory.setValidating(isValidating);
            parserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.parser = parserFactory.newSAXParser();
            log.info("got SAX parser instance - " + this.parser);
        }
        catch (Exception e) {
            log.error("failed instanciating SAX parser", e);
            throw new Error("failed instanciating SAX parser", e);
        }
        this.entityResolver = isValidating ? ManifestParser.getDtdEntityResolver() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelPluginManifest parseManifest(URL url) throws SAXException, IOException {
        ManifestHandler handler = new ManifestHandler(this.entityResolver);
        InputStream strm = IoUtil.getResourceInputStream(url);
        try {
            this.parser.parse(strm, (DefaultHandler)handler);
        }
        finally {
            strm.close();
        }
        ModelPluginManifest result = handler.getResult();
        result.setLocation(url);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ModelManifestInfo parseManifestInfo(URL url) throws SAXException, IOException {
        ManifestInfoHandler handler = new ManifestInfoHandler(this.entityResolver);
        InputStream strm = IoUtil.getResourceInputStream(url);
        try {
            this.parser.parse(strm, (DefaultHandler)handler);
        }
        finally {
            strm.close();
        }
        return handler.getResult();
    }
}

