/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.transfers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfers.AdditionalService;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.system.Money;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class CommonTransfersHelper {
    public static boolean isValidForRefund(Reservation reservation, Collection<Transfer> products) {
        List productsToRefund = reservation.getProducts().stream().filter(products::contains).collect(Collectors.toList());
        for (BaseProduct baseProduct : productsToRefund) {
            if (((Transfer)baseProduct).getStatus() == ProductStatus.SELL) continue;
            return false;
        }
        return true;
    }

    public static BigDecimal getTotalPrice(Transfer product) {
        Money fare;
        Money money = fare = product.getEquivalentFare() != null ? product.getEquivalentFare() : product.getFare();
        if (fare == null || fare.getValue() == null) {
            return null;
        }
        fare.setValue(fare.getValue().add(CommonTransfersHelper.getAdditionalServiceSum(product)));
        if (product.getStatus() == ProductStatus.REFUND) {
            if (product.getPenalty() == null) {
                product.setPenalty(BigDecimal.ZERO);
            }
            return fare.getValue() != null ? fare.getValue().subtract(product.getPenalty()).negate() : null;
        }
        return fare.getValue();
    }

    public static BigDecimal getAdditionalServiceSum(Transfer product) {
        return product.getAdditionalServices().stream().map(AdditionalService::getPrice).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal getAdditionalServiceIncludedVatSum(Transfer product) {
        return product.getAdditionalServices().stream().map(AdditionalService::getEquivalentVatAmount).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }
}

