/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.transfers.rules;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.gds.rules.ValueTypes;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.rules.l10n.Messages;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersActionsProvider;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collection;

public enum TransferActions implements RuleAction
{
    APPLICABLE_TRANSFER_ACCOUNTS{

        public String getDisplayName() {
            return L10n.get((String)Messages.RuleAction_ApplicableGDSAccounts);
        }

        public String getRendererId() {
            return ValueTypes.GDS_ACCOUNT_LIST.name();
        }

        public boolean hasValue() {
            return true;
        }

        public void buildInfo(StringBuilder buf, Object value) {
            if (value == null) {
                return;
            }
            Collection accounts = (Collection)value;
            if (accounts.size() == 0) {
                return;
            }
            buf.append(L10nResourcesManager.getStr((String)Messages.RuleAction_ApplicableGDSAccounts_info, (Object[])new Object[]{CollectionUtil.collectionToString((Iterable)accounts, (String)", ", (boolean)false)}));
        }

        public String getRuleCategoryValue(Object actionSet, Object value) {
            return this.getId();
        }

        public void apply(RuleProxy<?, ?> proxy, Object value) throws Exception {
            TransferParametersActionsProvider as = (TransferParametersActionsProvider)proxy.getActionSet();
            for (EntityReference gdsAcc : (Collection)value) {
                as.addApplicableGDSAccount((EntityReference<BaseGdsAccount>)gdsAcc);
            }
            proxy.getAppliedRuleCategories().add(this.getRuleCategoryValue(as, value));
        }
    };


    public String getId() {
        return this.name();
    }
}

