/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.restriction.converter.RestrictionsConverter;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

public class AclEditorEntriesPane
extends StackPane
implements DevTool {
    private TableWidgetController<TableWidget<AclEntryDataWrapper>, AclEntryDataWrapper> entriesTable;

    public AclEditorEntriesPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane entriesPane = this.createEntriesPane();
        entriesPane.getStyleClass().add((Object)"acl-entries-pane");
        this.getChildren().setAll((Object[])new Node[]{entriesPane});
    }

    private Pane createEntriesPane() {
        this.entriesTable = new TableWidgetController<TableWidget<AclEntryDataWrapper>, AclEntryDataWrapper>(){
            private final TableWidget<AclEntryDataWrapper> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data_to_view);
            }

            public TableWidget<AclEntryDataWrapper> getView() {
                return this.view;
            }
        };
        this.entriesTable.setReadonly(true);
        ArrayList<RendererWidgetColumn> columns = new ArrayList<RendererWidgetColumn>();
        RendererWidgetColumn resourceColumn = new RendererWidgetColumn(entry -> entry.resource, (entry, value) -> {
            entry.resource = (RestrictionResource)value;
        });
        resourceColumn.setRenderer((NodeRenderer)new ResourceRenderer());
        resourceColumn.setCaption(Messages.Resource);
        resourceColumn.setId("resource");
        columns.add(resourceColumn);
        RendererWidgetColumn rulesColumn = new RendererWidgetColumn(entry -> entry.rules, (entry, value) -> {
            entry.rules = (List)value;
        });
        rulesColumn.setRenderer((NodeRenderer)new RulesRenderer());
        rulesColumn.setCaption(Messages.Rules);
        rulesColumn.setId("rules");
        columns.add(rulesColumn);
        ((TableWidget)this.entriesTable.getView()).setColumns(columns);
        return (Pane)this.entriesTable.getView();
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    protected Collection<AclEntryDataWrapper> toTableColumnSettingsWrappers(Collection<AclChangeRegistry.AclEntryData> entryDatas) {
        ArrayList<AclEntryDataWrapper> entryDataWrappers = new ArrayList<AclEntryDataWrapper>();
        Map<String, RestrictionResource> resources = RestrictionResourcesRegistry.get().getResources().stream().collect(Collectors.toMap(value -> value.getId(), value -> value));
        for (AclChangeRegistry.AclEntryData entryData : entryDatas) {
            if (!resources.containsKey(entryData.getEntry().getResourceId())) continue;
            AclEntryDataWrapper entryDataWrapper = new AclEntryDataWrapper();
            entryDataWrapper.resource = resources.get(entryData.getEntry().getResourceId());
            entryDataWrapper.rules = entryData.getEntry().getRules();
            entryDataWrappers.add(entryDataWrapper);
        }
        return entryDataWrappers;
    }

    public boolean isDataChanged() {
        return false;
    }

    public void readData(List<AclChangeRegistry.AclEntryData> model) {
        this.entriesTable.readData(this.toTableColumnSettingsWrappers(model));
    }

    public void writeData(List<AclChangeRegistry.AclEntryData> model) {
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.unmodifiableList(AclEditorEntriesPane.this.getChildren());
            }

            public String getInfo() {
                return ((Object)((Object)AclEditorEntriesPane.this)).getClass().getSimpleName();
            }
        };
    }

    private static class RulesRenderer
    implements NodeRenderer {
        private RulesRenderer() {
        }

        public Node createNode(boolean readonly) {
            ColumnConstraints actionsColumnConstraints = new ColumnConstraints();
            actionsColumnConstraints.setPercentWidth(25.0);
            ColumnConstraints conditionsColumnConstraints = new ColumnConstraints();
            conditionsColumnConstraints.setPercentWidth(40.0);
            ColumnConstraints fieldsRestrictionsColumnConstraints = new ColumnConstraints();
            fieldsRestrictionsColumnConstraints.setPercentWidth(35.0);
            GridPane pane = new GridPane();
            pane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{actionsColumnConstraints, conditionsColumnConstraints, fieldsRestrictionsColumnConstraints});
            return pane;
        }

        public Object getValue(Node node) {
            return node.getUserData();
        }

        public void setValue(Node node, Object value) {
            node.setUserData(value);
            GridPane pane = (GridPane)node;
            List rules = (List)value;
            pane.getChildren().clear();
            if (rules != null) {
                int i = 0;
                for (AclRule rule : rules) {
                    RichTextFlow actionsTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML);
                    actionsTextFlow.getStyleClass().add((Object)"sub-cell");
                    if (i == 0) {
                        actionsTextFlow.getStyleClass().add((Object)"first-sub-cell");
                    } else {
                        actionsTextFlow.getStyleClass().add((Object)"first-sub-column-cell");
                    }
                    actionsTextFlow.setPrefWidth(100.0);
                    actionsTextFlow.setText("<html>" + RestrictionsHelper.getActionInfo((Collection)rule.getActions(), (boolean)true));
                    UiUtil.gridPosition((GridPane)pane, (Node)actionsTextFlow).col(0).row(i).colSpan(1).rowSpan(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
                    RichTextFlow conditionsTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML);
                    conditionsTextFlow.getStyleClass().add((Object)"sub-cell");
                    if (i == 0) {
                        conditionsTextFlow.getStyleClass().add((Object)"first-sub-row-cell");
                    }
                    conditionsTextFlow.setPrefWidth(100.0);
                    conditionsTextFlow.setText("<html>" + RestrictionsHelper.getRestrictionInfo((Collection)(Prefetched.getData().isRestrictedAclResources() ? RestrictionsConverter.toRestrictionGroups((Collection)rule.getPropertyRestrictionGroups()) : rule.getRestrictionGroups()), Collections.emptyList(), (boolean)true));
                    UiUtil.gridPosition((GridPane)pane, (Node)conditionsTextFlow).col(1).row(i).colSpan(1).rowSpan(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
                    RichTextFlow fieldRestrictionsTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML);
                    fieldRestrictionsTextFlow.getStyleClass().add((Object)"sub-cell");
                    if (i == 0) {
                        fieldRestrictionsTextFlow.getStyleClass().add((Object)"first-sub-row-cell");
                    }
                    fieldRestrictionsTextFlow.setPrefWidth(100.0);
                    fieldRestrictionsTextFlow.setText("<html>" + RestrictionsHelper.getFieldInfo((Collection)rule.getFieldRestrictions(), (boolean)true));
                    UiUtil.gridPosition((GridPane)pane, (Node)fieldRestrictionsTextFlow).col(2).row(i).colSpan(1).rowSpan(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
                    ++i;
                }
            }
        }

        public void setReadonly(boolean readonly, Node node) {
        }
    }

    private static class ResourceRenderer
    implements NodeRenderer {
        private ResourceRenderer() {
        }

        public Node createNode(boolean readonly) {
            return new GridPane();
        }

        public Object getValue(Node node) {
            return node.getUserData();
        }

        public void setValue(Node node, Object value) {
            node.setUserData(value);
            GridPane pane = (GridPane)node;
            RestrictionResource resource = (RestrictionResource)value;
            pane.getChildren().clear();
            RichTextFlow resourceTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML);
            resourceTextFlow.getStyleClass().add((Object)"sub-cell");
            resourceTextFlow.getStyleClass().add((Object)"first-sub-cell");
            resourceTextFlow.setText("<html>" + (resource != null ? RestrictionsHelper.getResourceInfo((RestrictionResource)resource, (boolean)true) : UiUtil.NULL_TEXT));
            UiUtil.gridPosition((GridPane)pane, (Node)resourceTextFlow).col(0).row(0).colSpan(1).rowSpan(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        }

        public void setReadonly(boolean readonly, Node node) {
        }
    }

    private static class AclEntryDataWrapper {
        RestrictionResource resource;
        List<AclRule> rules;

        private AclEntryDataWrapper() {
        }
    }
}

