/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.kb.ShortcutHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TileAction;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorPane;
import com.gridnine.xtrip.client.fx.standard.acl.Tools;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.KeyEvent;

public class AclEditorManagerPane
extends BaseContentPane
implements ShortcutHandler {
    private final ObservableMutex mutex;
    private final ActionsPane<AclEditorManagerAction> actionsPane = new ActionsPane<AclEditorManagerAction>(){

        protected boolean isDefault(AclEditorManagerAction action) {
            return false;
        }

        protected boolean isEnabled(AclEditorManagerAction action) {
            if (AclEditorManagerPane.this.getMutex().isAcquired()) {
                return false;
            }
            return action.isEnabled((Object)AclEditorManagerPane.this);
        }

        protected void execute(Control source, AclEditorManagerAction action, boolean alt) {
            action.execute(source, (Object)AclEditorManagerPane.this, alt);
        }

        protected String getName(AclEditorManagerAction action) {
            return action.getName(AclEditorManagerPane.this);
        }

        protected String getDescription(AclEditorManagerAction action) {
            return action.getDescription(AclEditorManagerPane.this);
        }

        protected ActionIcon getIcon(AclEditorManagerAction action) {
            return action.getIcon((Object)AclEditorManagerPane.this);
        }
    };
    private final Tile<Node, AclEditorPane> tile;
    private InvalidationListener acquiredListener;

    AclEditorManagerPane(ObservableMutex mtx) {
        this.mutex = mtx;
        this.getStyleClass().add((Object)"xtrip-acl-editor-pane");
        TilesSpace space = new TilesSpace(1);
        this.tile = new Tile("main", Messages.Permissions, null, (Node)new AclEditorPane(this));
        for (final Tools tool : Tools.values()) {
            this.tile.getActions().add((Object)new TileAction<Node, AclEditorPane>(){

                public boolean isEnabled(Tile<Node, AclEditorPane> tl) {
                    return tool.isEnabled((AclEditorPane)tl.getFullNode());
                }

                public double getWeight() {
                    return tool.getWeight();
                }

                public String getName(Tile<Node, AclEditorPane> tl) {
                    return tool.getName((AclEditorPane)tl.getFullNode());
                }

                public String getDescription(Tile<Node, AclEditorPane> tl) {
                    return tool.getDescription((AclEditorPane)tl.getFullNode());
                }

                public void execute(Control source, Tile<Node, AclEditorPane> tl, boolean alt) {
                    tool.execute((AclEditorPane)tl.getFullNode(), alt);
                }
            });
        }
        space.addTiles(new Tile[]{this.tile});
        this.actionsPane.populate((Collection)ClientRegistry.get().allOf(AclEditorManagerAction.TYPE).values().stream().filter(action -> action.isAvailable((Object)this)).collect(Collectors.toList()));
        this.acquiredListener = obj -> this.actionsPane.revalidate();
        this.mutex.acquiredProperty().addListener(this.acquiredListener);
        this.composePane((Node)space, null, this.actionsPane, null);
    }

    public ObservableMutex getMutex() {
        return this.mutex;
    }

    public AclEditorPane getEditor() {
        return (AclEditorPane)this.tile.getFullNode();
    }

    public void dispose() {
        ((AclEditorPane)this.tile.getFullNode()).dispose();
        this.mutex.acquiredProperty().removeListener(this.acquiredListener);
        super.dispose();
    }

    public void handleShortcut(KeyEvent event) {
        if (this.mutex.isAcquired()) {
            return;
        }
        this.actionsPane.handleShortcut(event);
    }

    void reloadData() throws Exception {
        FxUtil.waitForFxThread(() -> this.revalidate());
    }

    void revalidate() {
        this.actionsPane.revalidate();
        this.tile.revalidateActions();
    }

    boolean isDataChanged() {
        return this.getEditor().isDataChanged();
    }
}

