/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.SearchTextField;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomDndTreeView;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.CustomTreeView;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardAction;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.DelayedChangeListener;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorEmptyParametersPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorEntriesEditorPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorEntriesPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorGroupConverter;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorGroupDataPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorGroupParametersPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorHelper;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorManagerPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorUserConverter;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorUserDataPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorUserParametersPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclGroupsPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclPrincipalChangedEvent;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.AclDataService;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResource;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ChangeListener;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.TextField;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclEditorPane
extends StackPane
implements DevTool {
    private static final Logger log = LoggerFactory.getLogger(AclEditorPane.class);
    public static final Comparator<AclChangeRegistry.AclEntryData> entryDataComparator = new Comparator<AclChangeRegistry.AclEntryData>(){

        @Override
        public int compare(AclChangeRegistry.AclEntryData o1, AclChangeRegistry.AclEntryData o2) {
            RestrictionResource parentResource2;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            ArrayList<RestrictionResource> resources1 = new ArrayList<RestrictionResource>();
            ArrayList<RestrictionResource> resources2 = new ArrayList<RestrictionResource>();
            RestrictionResource parentResource1 = o1.getEntry().getResourceId() != null ? RestrictionResourcesRegistry.get().getResource(o1.getEntry().getResourceId()) : null;
            RestrictionResource restrictionResource = parentResource2 = o2.getEntry().getResourceId() != null ? RestrictionResourcesRegistry.get().getResource(o2.getEntry().getResourceId()) : null;
            while (parentResource1 != null) {
                resources1.add(parentResource1);
                parentResource1 = parentResource1.getParentId() != null ? RestrictionResourcesRegistry.get().getResource(parentResource1.getParentId()) : null;
            }
            while (parentResource2 != null) {
                resources2.add(parentResource2);
                parentResource2 = parentResource2.getParentId() != null ? RestrictionResourcesRegistry.get().getResource(parentResource2.getParentId()) : null;
            }
            Collections.reverse(resources1);
            Collections.reverse(resources2);
            int count = 0;
            while (true) {
                String resourceName2;
                String resourceName1 = count < resources1.size() ? ((RestrictionResource)resources1.get(count)).getName() : null;
                String string = resourceName2 = count < resources2.size() ? ((RestrictionResource)resources2.get(count)).getName() : null;
                if (resourceName1 == null && resourceName2 == null) {
                    return 0;
                }
                if (resourceName1 == null) {
                    return -1;
                }
                if (resourceName2 == null) {
                    return 1;
                }
                int result = MiscUtil.compare((Comparable)((Object)resourceName1), (Comparable)((Object)resourceName2));
                if (result != 0) {
                    return result;
                }
                ++count;
            }
        }
    };
    private TextField filterTextField;
    private CustomDndTreeView<AclPrincipal> tree;
    private CardsContainer principalsCardsPane;
    private CardsContainer parametersCardsPane;
    private final Card<AclEditorEmptyParametersPane> emptyParametersCard;
    private final Card<AclEditorEntriesPane> entriesCard;
    private SortableTreeItem<AclPrincipal> selectedItem;
    private AclChangeRegistry.AclPrincipalData<? extends AclPrincipal> selectedPrincipalData;
    private List<AclChangeRegistry.AclEntryData> selectedEntryDatas;
    private final List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>> selectedEditors = new ArrayList<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>>();
    private final Map<AclPrincipal, AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>> principalDataCache = new HashMap<AclPrincipal, AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>();
    private final Map<AclPrincipal, List<AclChangeRegistry.AclEntryData>> entryDatasCache = new HashMap<AclPrincipal, List<AclChangeRegistry.AclEntryData>>();
    private final Map<Class<? extends AclPrincipal>, AclPrincipalConverter<? extends AclPrincipal>> convertersCache = new HashMap<Class<? extends AclPrincipal>, AclPrincipalConverter<? extends AclPrincipal>>();
    private final Map<Class<? extends AclPrincipal>, List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>>> editorsCache = new HashMap<Class<? extends AclPrincipal>, List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>>>();
    private final AclChangeRegistry changeRegistry = new AclChangeRegistry();
    private final AclEditorManagerPane managerPane;
    private AclRegistry registry;
    private Consumer<AclPrincipalChangedEvent> consumer;
    private ChangeListener<? super Boolean> acquiredListener;
    private boolean restricted;

    AclEditorPane(final AclEditorManagerPane managerPane) {
        this.managerPane = managerPane;
        this.restricted = Boolean.valueOf(System.getProperty("client.fx.acl.editor.restricted"));
        this.emptyParametersCard = new Card("stub", UiCardsContainer.Style.STATIC, null, (Node)new AclEditorEmptyParametersPane());
        this.entriesCard = new Card("rules", UiCardsContainer.Style.STATIC, Messages.Rules, (Node)new AclEditorEntriesPane());
        this.entriesCard.getActions().add((Object)new CardAction<AclEditorEntriesPane>(){

            public String getName(Card<AclEditorEntriesPane> card) {
                return Messages.Change;
            }

            public String getDescription(Card<AclEditorEntriesPane> card) {
                return null;
            }

            public double getWeight() {
                return 0.0;
            }

            public boolean isEnabled(Card<AclEditorEntriesPane> card) {
                return AclEditorPane.this.selectedItem != null;
            }

            public void execute(Card<AclEditorEntriesPane> card, boolean alt) {
                try {
                    if (AclEditorPane.this.selectedItem != null) {
                        AclRegistry cloneRegistry = new AclRegistry();
                        AclChangeRegistry cloneChangeRegistry = new AclChangeRegistry();
                        AclEditorHelper.clone((AclPrincipal)AclEditorPane.this.selectedItem.getValue(), AclEditorPane.this.registry, cloneRegistry, AclEditorPane.this.changeRegistry, cloneChangeRegistry);
                        AclEditorPane.this.debugEditEntry("== EDIT ENTRIES START ===================", cloneRegistry, cloneChangeRegistry);
                        AclEditorEntriesEditorPane pane = new AclEditorEntriesEditorPane((AclChangeRegistry.AclPrincipalData<AclPrincipal>)AclEditorPane.this.selectedPrincipalData, cloneRegistry, cloneChangeRegistry, managerPane.getMutex());
                        new Dialog().setTitle(Messages.getSettings_rules_for(((AclPrincipal)AclEditorPane.this.selectedItem.getValue()).getName())).setMessage(Prefetched.getData().isRestrictedAclResources() ? "\u0412\u043d\u0438\u043c\u0430\u043d\u0438\u0435! \u0414\u043e \u043f\u043e\u043b\u043d\u043e\u0433\u043e \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u0441\u0442\u0430\u0440\u043e\u0433\u043e \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u041e\u0431\u044a\u0435\u043a\u0442\u044b \u0438 \u0421\u043f\u0438\u0441\u043a\u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430!" : null).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> {
                            pane.flush();
                            AclEditorHelper.merge((AclPrincipal)AclEditorPane.this.selectedItem.getValue(), cloneRegistry, AclEditorPane.this.registry, cloneChangeRegistry, AclEditorPane.this.changeRegistry);
                            AclEditorPane.this.debugEditEntry("== EDIT ENTRIES END =====================", cloneRegistry, cloneChangeRegistry);
                            AclEditorPane.this.entryDatasCache.remove(AclEditorPane.this.selectedItem.getValue());
                            AclEditorPane.this.selectedItem = null;
                            AclEditorPane.this.select();
                        }).setExpandToParent().show((Node)managerPane.getEditor());
                    }
                }
                catch (Exception e) {
                    ErrorHandler.handle((Throwable)e);
                }
            }
        });
        this.createGUI();
        this.createBindings();
        this.createListeners();
        Notifications.get().submitTask(() -> this.populate(), managerPane.getMutex());
    }

    private void createGUI() {
        Pane aclPane = this.createAclPane();
        this.getChildren().setAll((Object[])new Node[]{aclPane});
    }

    private Pane createAclPane() {
        Pane principalsPane = this.createPrincipalsPane();
        Pane parametersPane = this.createParametersPane();
        GridPane aclPane = new GridPane();
        UiUtil.gridPosition((GridPane)aclPane, (Node)principalsPane).col(0).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition((GridPane)aclPane, (Node)parametersPane).col(1).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return aclPane;
    }

    private Pane createPrincipalsPane() {
        this.filterTextField = new SearchTextField();
        this.tree = new CustomDndTreeView();
        this.tree.setShowRoot(false);
        this.tree.setConverter((StringConverter)new StringConverter<AclPrincipal>(){

            public String toString(AclPrincipal object) {
                return object.getName();
            }

            public AclPrincipal fromString(String string) {
                return null;
            }
        });
        this.tree.setIconSupplier(item -> {
            AclPrincipal value = (AclPrincipal)item.getValue();
            if (value instanceof AclGroup) {
                return StandardIconShapes.GROUP_14X14;
            }
            if (value instanceof AclUser) {
                return StandardIconShapes.USER_14X14;
            }
            return StandardIconShapes.UNDEFINED;
        });
        this.tree.setStyleSupplier(item -> {
            AclPrincipal value = (AclPrincipal)item.getValue();
            return this.registry.getPrincipalEntries(value.getId()).size() > 0 ? Collections.singletonList("bold") : Collections.emptyList();
        });
        this.tree.setMenuItemsSupplier(item -> {
            CustomMenuItem menuItem;
            AclPrincipal value = (AclPrincipal)item.getValue();
            ArrayList<CustomMenuItem> menuItems = new ArrayList<CustomMenuItem>();
            Collection entries = this.registry.getPrincipalEntries(value.getId());
            if (entries.size() > 0) {
                menuItem = new CustomMenuItem(Messages.Copy_entries);
                menuItem.setOnAction(event -> this.copyEntries((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item)));
                menuItems.add(menuItem);
            }
            if (Clipboard.getSystemClipboard().hasContent(DataFormat.PLAIN_TEXT)) {
                menuItem = new CustomMenuItem(Messages.Paste_entries);
                menuItem.setOnAction(event -> this.pasteEntries((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item)));
                menuItems.add(menuItem);
            }
            return menuItems;
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<AclPrincipal>(){

            public IconShape getIconShape() {
                return StandardIconShapes.DELETE_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Delete_group;
            }

            public boolean isAvailable(TreeItem<AclPrincipal> item) {
                return item.isLeaf() && item.getValue() instanceof AclGroup && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)item.getValue()));
            }

            public boolean isEnabled(TreeItem<AclPrincipal> item) {
                return true;
            }

            public void onAction(TreeItem<AclPrincipal> item) {
                AclEditorPane.this.remove((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item), false);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<AclPrincipal>(){

            public IconShape getIconShape() {
                return StandardIconShapes.GROUP_ADD_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Create_group;
            }

            public boolean isAvailable(TreeItem<AclPrincipal> item) {
                return item.getValue() instanceof AclGroup;
            }

            public boolean isEnabled(TreeItem<AclPrincipal> item) {
                return true;
            }

            public void onAction(TreeItem<AclPrincipal> item) {
                AclEditorPane.this.add((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item), AclEditorPane.this.createGroup());
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<AclPrincipal>(){

            public IconShape getIconShape() {
                return StandardIconShapes.DELETE_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Delete_user;
            }

            public boolean isAvailable(TreeItem<AclPrincipal> item) {
                return item.isLeaf() && item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue()));
            }

            public boolean isEnabled(TreeItem<AclPrincipal> item) {
                return true;
            }

            public void onAction(TreeItem<AclPrincipal> item) {
                AclEditorPane.this.remove((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item), true);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<AclPrincipal>(){

            public IconShape getIconShape() {
                return StandardIconShapes.REMOVE_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Expell_user_from_current_group;
            }

            public boolean isAvailable(TreeItem<AclPrincipal> item) {
                return item.isLeaf() && item.getValue() instanceof AclUser && !AclHelper.isSpecialUser((AclUser)((AclUser)item.getValue())) && ((AclUser)item.getValue()).getGroupIds().size() > 1;
            }

            public boolean isEnabled(TreeItem<AclPrincipal> item) {
                return true;
            }

            public void onAction(TreeItem<AclPrincipal> item) {
                AclEditorPane.this.remove((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item), false);
            }
        });
        this.tree.getControlButtons().add(new CustomTreeView.ControlButton<AclPrincipal>(){

            public IconShape getIconShape() {
                return StandardIconShapes.USER_ADD_14X14;
            }

            public IconIntention getIconIntention() {
                return StandardIconIntentions.TREE_CELL_BUTTON_ACTION;
            }

            public String getDescription() {
                return Messages.Create_user;
            }

            public boolean isAvailable(TreeItem<AclPrincipal> item) {
                return item.getValue() instanceof AclGroup;
            }

            public boolean isEnabled(TreeItem<AclPrincipal> item) {
                return true;
            }

            public void onAction(TreeItem<AclPrincipal> item) {
                AclEditorPane.this.add((SortableTreeItem<AclPrincipal>)((SortableTreeItem)item), AclEditorPane.this.createUser());
            }
        });
        this.tree.setDropPolicy(CustomDndTreeView.DropPolicy.GROUP);
        this.tree.setTransferModes(TransferMode.COPY_OR_MOVE);
        this.tree.setRenderer(item -> item.getValue() != null ? ((AclPrincipal)item.getValue()).getName() : null);
        this.tree.setDragLeafChecker((source, mode) -> source.getValue() instanceof AclUser);
        this.tree.setDragDetectChecker((source, mode) -> {
            if (source != null) {
                if (source.getValue() instanceof AclGroup) {
                    return mode == TransferMode.MOVE && !AclHelper.isSpecialGroup((AclGroup)((AclGroup)source.getValue()));
                }
                if (source.getValue() instanceof AclUser) {
                    return !AclHelper.isSpecialUser((AclUser)((AclUser)source.getValue()));
                }
            }
            return false;
        });
        this.tree.setDragOverChecker((source, target, value, mode, type, location) -> true);
        this.tree.setDragDropHandler((source, target, value, mode, type, location) -> {
            if (target != null) {
                SortableTreeItem parent;
                if (source == null) {
                    // empty if block
                }
                if (source != null && (parent = (SortableTreeItem)(type == CustomDndTreeView.DropType.SIBLING ? target.getParent() : target)) != null) {
                    SortableTreeItem item = (SortableTreeItem)source;
                    this.relocate((SortableTreeItem<AclPrincipal>)parent, (SortableTreeItem<AclPrincipal>)item, mode == TransferMode.COPY);
                }
            }
        });
        GridPane pane = new GridPane();
        UiUtil.gridPosition((GridPane)pane, (Node)this.filterTextField).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
        UiUtil.gridPosition((GridPane)pane, this.tree).col(0).row(1).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        Card card = new Card("principals", UiCardsContainer.Style.STATIC, Messages.Groups_and_users, (Node)pane);
        card.setAdaptiveHeight(true);
        this.principalsCardsPane = new CardsContainer();
        this.principalsCardsPane.getStyleClass().add((Object)"principals-pane");
        this.principalsCardsPane.getCards().add((Object)card);
        return this.principalsCardsPane;
    }

    private Pane createParametersPane() {
        this.parametersCardsPane = new CardsContainer();
        this.parametersCardsPane.getStyleClass().add((Object)"parameters-pane");
        this.parametersCardsPane.getCards().add(this.emptyParametersCard);
        return this.parametersCardsPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        this.consumer = value -> {
            if (this.selectedItem != null && value.getChangeType() == AclPrincipalChangedEvent.ChangeType.NAME) {
                this.update();
            }
        };
        EventBus.get().subscribe(AclPrincipalChangedEvent.TYPE, this.consumer);
        this.acquiredListener = (observable, oldValue, newValue) -> this.tree.setDisable(newValue.booleanValue());
        this.managerPane.getMutex().acquiredProperty().addListener(this.acquiredListener);
        if (this.restricted) {
            this.filterTextField.setOnAction(event -> {
                this.tree.getSelectionModel().select(null);
                Notifications.get().submitTask(() -> {
                    this.populate();
                    FxUtil.submitToFxThread(() -> this.filter());
                }, this.managerPane.getMutex());
            });
        } else {
            this.filterTextField.textProperty().addListener((ChangeListener)new DelayedChangeListener<String>(Duration.millis((double)700.0)){

                protected void handle(String text) {
                    AclEditorPane.this.filter();
                }
            });
        }
        this.tree.getSelectionModel().selectedItemProperty().addListener(observable -> this.select());
    }

    private void filter() {
        SortableTreeItem root = (SortableTreeItem)this.tree.getRoot();
        if (root != null) {
            this.tree.getSelectionModel().select(null);
            String pattern = this.filterTextField.getText();
            root.setPredicate(pattern != null && !pattern.isEmpty() && (!this.restricted || !pattern.equals("*")) ? value -> TextUtil.isLike((String)value.getId(), (String)pattern, (boolean)true, (boolean)false) || TextUtil.isLike((String)value.getName(), (String)pattern, (boolean)true, (boolean)false) || TextUtil.isLike((String)value.getDescription(), (String)pattern, (boolean)true, (boolean)false) : null);
            UiUtil.expand(this.tree);
        }
    }

    void dispose() {
        if (this.acquiredListener != null) {
            this.managerPane.getMutex().acquiredProperty().removeListener(this.acquiredListener);
        }
    }

    private void populate() throws Exception {
        if (this.restricted) {
            this.registry = ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).getRestrictedAclRegistry(ServiceInvocationContext.get(), this.changeRegistry, this.filterTextField.getText());
            for (AclPrincipal principal : Stream.concat(this.registry.getGroups().stream(), this.registry.getUsers().stream()).collect(Collectors.toList())) {
                AclChangeRegistry.AclPrincipalData<? extends AclPrincipal> principalData = this.principalDataCache.get(principal);
                if (principalData != null) {
                    principalData.setPrincipal(principal);
                }
                for (AclChangeRegistry.AclEntryData entryData : Optional.ofNullable(this.entryDatasCache.get(principal)).orElse(Collections.emptyList())) {
                    AclEntry entry = this.registry.getEntry(entryData.getEntry().getPrincipalId(), entryData.getEntry().getResourceId());
                    if (entry == null) continue;
                    entryData.setEntry(entry);
                }
            }
        } else {
            this.registry = ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).getFullAclRegistry(ServiceInvocationContext.get());
        }
        this.debugState("== POPULATE ================================");
        AclGroup group = new AclGroup();
        group.setId("root");
        SortableTreeItem root = new SortableTreeItem();
        root.setValue((Object)group);
        root.setComparator(MiscUtil.comparator(item -> (AclPrincipal)item.getValue(), (Comparator)AclHelper.principalComparator));
        List<AclGroup> rootGroups = this.registry.getGroups().stream().filter(value -> value.getParentId() == null).collect(Collectors.toList());
        List<AclUser> rootUsers = this.registry.getUsers().stream().filter(value -> value.getGroupIds().isEmpty()).collect(Collectors.toList());
        this.populate(this.registry, (SortableTreeItem<AclPrincipal>)root, rootGroups, rootUsers);
        FxUtil.submitToFxThread(() -> {
            this.tree.setRoot((TreeItem)root);
            UiUtil.expand(this.tree);
            this.tree.getSelectionModel().clearSelection();
            this.tree.getSelectionModel().select(this.tree.getRoot() != null && this.tree.getRoot().getChildren().size() > 0 ? (TreeItem)this.tree.getRoot().getChildren().get(0) : null);
        });
    }

    private void populate(AclRegistry registry, SortableTreeItem<AclPrincipal> item, Collection<AclGroup> groups, Collection<AclUser> users) {
        for (AclGroup group : groups) {
            SortableTreeItem groupItem = new SortableTreeItem();
            groupItem.setValue((Object)group);
            item.add((TreeItem)groupItem);
            ArrayList<AclGroup> groupChildren = new ArrayList<AclGroup>();
            for (String groupChildId : registry.getGroupChildren(group.getId())) {
                AclGroup groupChild = registry.getGroup(groupChildId);
                if (groupChild == null) continue;
                groupChildren.add(groupChild);
            }
            ArrayList<AclUser> groupUsers = new ArrayList<AclUser>();
            for (String groupUserId : registry.getGroupUsers(group.getId())) {
                AclUser groupUser = registry.getUser(groupUserId);
                if (groupUser == null) continue;
                groupUsers.add(groupUser);
            }
            this.populate(registry, (SortableTreeItem<AclPrincipal>)groupItem, groupChildren, groupUsers);
        }
        for (AclUser user : users) {
            SortableTreeItem userItem = new SortableTreeItem();
            userItem.setValue((Object)user);
            item.add((TreeItem)userItem);
        }
    }

    private AclChangeRegistry.AclPrincipalData<? extends AclPrincipal> getPrincipalData(AclPrincipal principal) throws Exception {
        AclPrincipalConverter<? extends AclPrincipal> converter;
        AclChangeRegistry.AclPrincipalData<? extends AclPrincipal> principalData = this.principalDataCache.get(principal);
        if (principalData == null && (converter = this.getConverter(principal)) != null) {
            principalData = converter.convert((AclPrincipal)principal);
            this.principalDataCache.put(principal, principalData);
        }
        return principalData;
    }

    private AclPrincipalConverter<? extends AclPrincipal> getConverter(AclPrincipal principal) {
        AclPrincipalConverter<AclGroup> converter = this.convertersCache.get(principal.getClass());
        if (converter == null) {
            if (principal instanceof AclGroup) {
                converter = new AclEditorGroupConverter();
                this.convertersCache.put(principal.getClass(), converter);
            } else if (principal instanceof AclUser) {
                converter = new AclEditorUserConverter();
                this.convertersCache.put(principal.getClass(), converter);
            }
        }
        return converter;
    }

    private List<AclChangeRegistry.AclEntryData> getEntryDatas(AclPrincipal principal) throws Exception {
        List<Object> entryDatas = this.entryDatasCache.get(principal);
        if (entryDatas == null) {
            entryDatas = this.registry.getPrincipalEntries(principal.getId()).stream().map(value -> {
                AclChangeRegistry.AclEntryData data = new AclChangeRegistry.AclEntryData();
                data.setEntry(value);
                return data;
            }).sorted(entryDataComparator).collect(Collectors.toList());
            this.entryDatasCache.put(principal, entryDatas);
        }
        return entryDatas;
    }

    private List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>> getEditors(AclPrincipal principal) {
        List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>> editors = this.editorsCache.get(principal.getClass());
        if (editors == null) {
            editors = new ArrayList<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>>();
            if (principal instanceof AclGroup) {
                AclEditorGroupParametersPane pane = new AclEditorGroupParametersPane();
                editors.add((MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>)new MiscUtil.Pair((Object)pane, pane.getContent()));
            } else if (principal instanceof AclUser) {
                AclEditorUserParametersPane pane = new AclEditorUserParametersPane();
                editors.add((MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>)new MiscUtil.Pair((Object)pane, pane.getContent()));
            }
            this.editorsCache.put(principal.getClass(), editors);
        }
        return editors;
    }

    public boolean isDataChanged() {
        if (!this.changeRegistry.isEmpty()) {
            return true;
        }
        return this.check();
    }

    private boolean check() {
        return this.selectedItem != null && this.selectedEditors.stream().map(value -> (AclPrincipalEditor)value.getFirst()).anyMatch(value -> value.isDataChanged());
    }

    private void read() {
        if (this.selectedItem != null) {
            this.selectedEditors.stream().map(value -> (AclPrincipalEditor)value.getFirst()).forEach(value -> value.readData(this.selectedPrincipalData));
            ((AclEditorEntriesPane)this.entriesCard.getContent()).readData(this.selectedEntryDatas);
            this.update();
        }
    }

    private void write() {
        boolean check;
        if (this.selectedItem != null && (check = this.check())) {
            this.selectedEditors.stream().map(value -> (AclPrincipalEditor)value.getFirst()).forEach(value -> value.writeData(this.selectedPrincipalData));
            if (this.selectedItem.getValue() instanceof AclGroup) {
                AclChangeRegistry.AclGroupData groupData = (AclChangeRegistry.AclGroupData)this.selectedPrincipalData;
                this.changeRegistry.edit(groupData);
            } else if (this.selectedItem.getValue() instanceof AclUser) {
                AclChangeRegistry.AclUserData userData = (AclChangeRegistry.AclUserData)this.selectedPrincipalData;
                this.changeRegistry.edit(userData);
            }
            if (((AclEditorEntriesPane)this.entriesCard.getContent()).isDataChanged()) {
                ((AclEditorEntriesPane)this.entriesCard.getContent()).writeData(this.selectedEntryDatas);
            }
            this.update();
        }
    }

    private void select() {
        Notifications.get().submitTask(() -> {
            if (this.selectedItem != null) {
                FxUtil.waitForFxThread(() -> {
                    this.write();
                    this.debugState("== DESELECT ================================");
                });
            }
            this.selectedItem = (SortableTreeItem)this.tree.getSelectionModel().getSelectedItem();
            this.selectedPrincipalData = null;
            this.selectedEntryDatas = null;
            this.selectedEditors.clear();
            if (this.selectedItem != null) {
                this.selectedPrincipalData = this.getPrincipalData((AclPrincipal)this.selectedItem.getValue());
                this.selectedEntryDatas = this.getEntryDatas((AclPrincipal)this.selectedItem.getValue());
                List<MiscUtil.Pair<AclPrincipalEditor<? extends AclPrincipal, ? extends AclChangeRegistry.AclPrincipalData<? extends AclPrincipal>>, Card<Node>>> editors = this.getEditors((AclPrincipal)this.selectedItem.getValue());
                this.selectedEditors.addAll(editors);
                FxUtil.waitForFxThread(() -> {
                    this.parametersCardsPane.getCards().setAll((Collection)this.selectedEditors.stream().map(value -> (Card)value.getSecond()).collect(Collectors.toList()));
                    this.parametersCardsPane.getCards().add(this.entriesCard);
                    this.read();
                    this.debugState("== SELECT ===============================");
                });
            } else {
                FxUtil.waitForFxThread(() -> this.parametersCardsPane.getCards().setAll((Object[])new Card[]{this.emptyParametersCard}));
            }
            FxUtil.submitToFxThread(() -> this.managerPane.revalidate());
        }, this.managerPane.getMutex());
    }

    private void flush() {
        this.write();
        this.debugState("== FLUSH ================================");
    }

    private void update() {
        Event.fireEvent(this.selectedItem, (Event)new TreeItem.TreeModificationEvent(TreeItem.valueChangedEvent(), this.selectedItem, this.selectedItem.getValue()));
    }

    SortableTreeItem<AclPrincipal> createGroup() {
        AclGroup group = new AclGroup();
        SortableTreeItem item = new SortableTreeItem();
        item.setValue((Object)group);
        return item;
    }

    SortableTreeItem<AclPrincipal> createUser() {
        AclUser user = new AclUser();
        SortableTreeItem item = new SortableTreeItem();
        item.setValue((Object)user);
        return item;
    }

    void remove(SortableTreeItem<AclPrincipal> item, boolean all) {
        Notifications.get().submitTask(() -> {
            if (item.getValue() instanceof AclGroup) {
                AclGroup group = (AclGroup)item.getValue();
                FxUtil.waitForFxThread(() -> Dialog.confirm((Node)this, (String)Messages.getDelete_group_N(group.getName()), null, (String)Messages.Delete, () -> Notifications.get().submitTask(() -> {
                    AclChangeRegistry.AclGroupData groupData = (AclChangeRegistry.AclGroupData)this.getPrincipalData((AclPrincipal)group);
                    SortableTreeItem parentItem = (SortableTreeItem)item.getParent();
                    if (parentItem != null) {
                        group.setParentId(null);
                        if (item.equals(this.selectedItem)) {
                            this.selectedItem = null;
                        }
                        FxUtil.waitForFxThread(() -> parentItem.remove((TreeItem)item));
                        this.registry.removeGroup(group);
                        this.changeRegistry.delete(groupData);
                        this.debugState("== GROUP REMOVE =========================");
                    }
                }, this.managerPane.getMutex()), null));
            } else if (item.getValue() instanceof AclUser) {
                AclUser user = (AclUser)item.getValue();
                FxUtil.waitForFxThread(() -> Dialog.confirm((Node)this, (String)(all ? Messages.getDelete_user_N(user.getName()) : Messages.getExpell_user_N_from_current_group(user.getName())), null, (String)(all ? Messages.Delete : Messages.Expell), () -> Notifications.get().submitTask(() -> {
                    AclChangeRegistry.AclUserData userData = (AclChangeRegistry.AclUserData)this.getPrincipalData((AclPrincipal)user);
                    ArrayList<SortableTreeItem> items = new ArrayList<SortableTreeItem>();
                    if (all) {
                        items.addAll(UiUtil.search((TreeItem)this.tree.getRoot(), (Object)user, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().map(value -> (SortableTreeItem)value).collect(Collectors.toList()));
                    } else {
                        items.add(item);
                    }
                    if (items.size() > 0) {
                        for (SortableTreeItem i : items) {
                            SortableTreeItem parentItem = (SortableTreeItem)i.getParent();
                            if (parentItem == null) continue;
                            AclGroup parentGroup = (AclGroup)parentItem.getValue();
                            user.getGroupIds().remove(parentGroup.getId());
                            if (item.equals(this.selectedItem)) {
                                this.selectedItem = null;
                            }
                            FxUtil.waitForFxThread(() -> parentItem.remove((TreeItem)i));
                            this.registry.unregisterUserGroup(user.getId(), parentGroup.getId());
                        }
                        userData.setUserChanged(true);
                        if (user.getGroupIds().isEmpty()) {
                            this.registry.removeUser(user);
                            this.changeRegistry.delete(userData);
                        } else {
                            this.changeRegistry.edit(userData);
                        }
                        this.debugState("== USER REMOVE ==========================");
                    }
                }, this.managerPane.getMutex()), null));
            }
        }, this.managerPane.getMutex());
    }

    void add(SortableTreeItem<AclPrincipal> parent, SortableTreeItem<AclPrincipal> item) {
        Notifications.get().submitTask(() -> {
            if (item.getValue() instanceof AclGroup) {
                AclGroup parentGroup = (AclGroup)parent.getValue();
                AclGroup group = (AclGroup)item.getValue();
                group.setParentId(parentGroup.getId());
                AclChangeRegistry.AclGroupData groupData = (AclChangeRegistry.AclGroupData)this.getPrincipalData((AclPrincipal)group);
                FxUtil.waitForFxThread(() -> {
                    AclEditorGroupDataPane pane = new AclEditorGroupDataPane(this.registry, this.managerPane.getMutex());
                    pane.readData(groupData);
                    VBox body = new VBox(new Node[]{pane});
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Creating_new_group).setBody((Node)body).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).addButton(DialogButtonStyle.DECLINE, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> Notifications.get().submitTask(() -> {
                        AclGroup selectedParentGroup;
                        ValueHolder valid = new ValueHolder();
                        FxUtil.waitForFxThread(() -> {
                            pane.writeData(groupData);
                            if (this.registry.getGroup(((AclGroup)groupData.getPrincipal()).getId()) != null || this.registry.getUser(((AclGroup)groupData.getPrincipal()).getId()) != null) {
                                MessagePane messagePane = MessagePane.error((String)Messages.group_id_invalid);
                                body.getChildren().setAll((Object[])new Node[]{messagePane, pane});
                                Notifications.get().getScheduler().schedule(() -> AclEditorPane.lambda$null$50(body, (Node)messagePane), 5L, TimeUnit.SECONDS);
                                valid.set((Object)Boolean.FALSE);
                            } else {
                                valid.set((Object)Boolean.TRUE);
                                dialog.close();
                            }
                        });
                        if (!((Boolean)valid.get()).booleanValue()) {
                            return;
                        }
                        AclGroup aclGroup = selectedParentGroup = ((AclGroup)groupData.getPrincipal()).getParentId() != null ? this.registry.getGroup(((AclGroup)groupData.getPrincipal()).getParentId()) : null;
                        if (selectedParentGroup != null) {
                            SortableTreeItem selectedParentItem = UiUtil.search((TreeItem)this.tree.getRoot(), (Object)selectedParentGroup, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().map(value -> (SortableTreeItem)value).findFirst().get();
                            if (selectedParentItem != null) {
                                FxUtil.waitForFxThread(() -> {
                                    SortableTreeItem groupItem = new SortableTreeItem();
                                    groupItem.setValue((Object)group);
                                    groupItem.setIgnoreFilterOnce(true);
                                    selectedParentItem.add((TreeItem)groupItem);
                                    selectedParentItem.setExpanded(true);
                                    this.tree.getSelectionModel().select((Object)groupItem);
                                });
                            }
                            this.registry.addGroup(group);
                            this.changeRegistry.add(groupData);
                            this.debugState("== GROUP ADD ============================");
                        }
                    }, this.managerPane.getMutex()), (BooleanExpression)pane.validProperty()).setExpandToParent().show((Node)this.managerPane.getEditor());
                });
            } else if (item.getValue() instanceof AclUser) {
                AclGroup parentGroup = (AclGroup)parent.getValue();
                AclUser user = (AclUser)item.getValue();
                if (!user.getGroupIds().contains(parentGroup.getId())) {
                    user.getGroupIds().add(parentGroup.getId());
                }
                AclChangeRegistry.AclUserData userData = (AclChangeRegistry.AclUserData)this.getPrincipalData((AclPrincipal)user);
                FxUtil.waitForFxThread(() -> {
                    AclEditorUserDataPane pane = new AclEditorUserDataPane(this.registry, this.managerPane.getMutex());
                    pane.readData(userData);
                    VBox body = new VBox(new Node[]{pane});
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Creating_new_group).setBody((Node)body).setAutoClose(false).setOnCloseRequest(() -> dialog.close()).addButton(DialogButtonStyle.DECLINE, () -> dialog.close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Create, () -> Notifications.get().submitTask(() -> {
                        ValueHolder valid = new ValueHolder();
                        FxUtil.waitForFxThread(() -> {
                            pane.writeData(userData);
                            if (this.registry.getGroup(((AclUser)userData.getPrincipal()).getId()) != null || this.registry.getUser(((AclUser)userData.getPrincipal()).getId()) != null) {
                                MessagePane messagePane = MessagePane.error((String)Messages.user_id_invalid);
                                body.getChildren().setAll((Object[])new Node[]{messagePane, pane});
                                Notifications.get().getScheduler().schedule(() -> AclEditorPane.lambda$null$62(body, (Node)messagePane), 5L, TimeUnit.SECONDS);
                                valid.set((Object)Boolean.FALSE);
                            } else {
                                valid.set((Object)Boolean.TRUE);
                                dialog.close();
                            }
                        });
                        if (!((Boolean)valid.get()).booleanValue()) {
                            return;
                        }
                        List selectedParentGroups = ((AclUser)userData.getPrincipal()).getGroupIds().stream().map(value -> this.registry.getGroup(value)).collect(Collectors.toList());
                        if (selectedParentGroups.size() > 0) {
                            for (AclGroup actualParentGroup : selectedParentGroups) {
                                SortableTreeItem selectedParentItem = UiUtil.search((TreeItem)this.tree.getRoot(), (Object)actualParentGroup, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().map(value -> (SortableTreeItem)value).findFirst().get();
                                if (selectedParentItem == null) continue;
                                FxUtil.waitForFxThread(() -> {
                                    SortableTreeItem userItem = new SortableTreeItem();
                                    userItem.setValue((Object)user);
                                    userItem.setIgnoreFilterOnce(true);
                                    selectedParentItem.add((TreeItem)userItem);
                                    selectedParentItem.setExpanded(true);
                                    this.tree.getSelectionModel().select((Object)userItem);
                                });
                            }
                            this.registry.addUser(user);
                            this.changeRegistry.add(userData);
                            this.debugState("== USER ADD =============================");
                        }
                    }, this.managerPane.getMutex()), (BooleanExpression)pane.validProperty()).setExpandToParent().show((Node)this.managerPane.getEditor());
                });
            }
        }, this.managerPane.getMutex());
    }

    void relocate(SortableTreeItem<AclPrincipal> item) {
        Notifications.get().submitTask(() -> {
            if (item.getValue() instanceof AclGroup) {
                AclGroup group = (AclGroup)item.getValue();
                AclChangeRegistry.AclGroupData groupData = (AclChangeRegistry.AclGroupData)this.getPrincipalData((AclPrincipal)group);
                FxUtil.waitForFxThread(() -> {
                    AclGroupsPane pane = new AclGroupsPane(this.registry, (AclPrincipal)group, this.managerPane.getMutex());
                    new Dialog().setTitle(Messages.Choose_group).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Choose, () -> Notifications.get().submitTask(() -> {
                        String selectedParentGroupId;
                        String oldParentGroupId = group.getParentId();
                        String string = selectedParentGroupId = pane.getSelectedGroupIds().size() > 0 ? pane.getSelectedGroupIds().get(0) : null;
                        if (oldParentGroupId != selectedParentGroupId) {
                            SortableTreeItem parentItem;
                            AclGroup parentGroup;
                            SortableTreeItem parentItem2;
                            if (oldParentGroupId != null && (parentItem2 = (SortableTreeItem)item.getParent()) != null) {
                                group.setParentId(null);
                                if (item.equals(this.selectedItem)) {
                                    this.selectedItem = null;
                                }
                                FxUtil.waitForFxThread(() -> parentItem2.remove((TreeItem)item));
                                this.registry.unregisterGroupParent(group.getId(), oldParentGroupId);
                            }
                            if (selectedParentGroupId != null && (parentGroup = this.registry.getGroup(selectedParentGroupId)) != null && (parentItem = UiUtil.search((TreeItem)this.tree.getRoot(), (Object)parentGroup, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().map(value -> (SortableTreeItem)value).findFirst().get()) != null) {
                                group.setParentId(selectedParentGroupId);
                                FxUtil.waitForFxThread(() -> {
                                    item.setIgnoreFilterOnce(true);
                                    parentItem.add((TreeItem)item);
                                    parentItem.setExpanded(true);
                                });
                                this.registry.registerGroupParent(group.getId(), selectedParentGroupId);
                            }
                            this.changeRegistry.edit(groupData);
                            this.debugState("== GROUP RELOCATE =======================");
                        }
                    }, this.managerPane.getMutex()), (BooleanExpression)pane.validProperty()).show((Node)this.managerPane.getEditor());
                });
            } else if (item.getValue() instanceof AclUser) {
                AclUser user = (AclUser)item.getValue();
                AclChangeRegistry.AclUserData userData = (AclChangeRegistry.AclUserData)this.getPrincipalData((AclPrincipal)user);
                FxUtil.waitForFxThread(() -> {
                    AclGroupsPane pane = new AclGroupsPane(this.registry, (AclPrincipal)user, this.managerPane.getMutex());
                    new Dialog().setTitle(Messages.Choose_groups).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_CONTINUE, () -> Notifications.get().submitTask(() -> {
                        List oldParentGroupIds = user.getGroupIds();
                        List<String> selectedParentGroupIds = pane.getSelectedGroupIds();
                        ArrayList deleteParentGroupIds = new ArrayList(oldParentGroupIds);
                        deleteParentGroupIds.removeAll(selectedParentGroupIds);
                        ArrayList<String> addParentGroupIds = new ArrayList<String>(selectedParentGroupIds);
                        addParentGroupIds.removeAll(oldParentGroupIds);
                        if (deleteParentGroupIds.size() > 0 || addParentGroupIds.size() > 0) {
                            SortableTreeItem parentItem;
                            if (deleteParentGroupIds.size() > 0) {
                                List items = UiUtil.search((TreeItem)this.tree.getRoot(), (Object)user, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().filter(value -> value.getParent() != null && deleteParentGroupIds.contains(((AclPrincipal)value.getParent().getValue()).getId())).map(value -> (SortableTreeItem)value).collect(Collectors.toList());
                                for (SortableTreeItem i : items) {
                                    parentItem = (SortableTreeItem)i.getParent();
                                    if (parentItem == null) continue;
                                    AclGroup parentGroup = (AclGroup)parentItem.getValue();
                                    user.getGroupIds().remove(parentGroup.getId());
                                    if (item.equals(this.selectedItem)) {
                                        this.selectedItem = null;
                                    }
                                    FxUtil.waitForFxThread(() -> parentItem.remove((TreeItem)i));
                                    this.registry.unregisterUserGroup(user.getId(), parentGroup.getId());
                                }
                            }
                            if (addParentGroupIds.size() > 0) {
                                List parentGroups = addParentGroupIds.stream().map(value -> this.registry.getGroup(value)).collect(Collectors.toList());
                                for (AclGroup parentGroup : parentGroups) {
                                    parentItem = UiUtil.search((TreeItem)this.tree.getRoot(), (Object)parentGroup, (o1, o2) -> MiscUtil.equals((Object)o1, (Object)o2), value -> ((SortableTreeItem)value).getInternalChildren()).stream().map(value -> (SortableTreeItem)value).findFirst().get();
                                    if (parentItem == null) continue;
                                    user.getGroupIds().add(parentGroup.getId());
                                    FxUtil.waitForFxThread(() -> {
                                        SortableTreeItem userItem = new SortableTreeItem();
                                        userItem.setValue((Object)user);
                                        userItem.setIgnoreFilterOnce(true);
                                        parentItem.add((TreeItem)userItem);
                                        parentItem.setExpanded(true);
                                    });
                                    this.registry.registerUserGroup(user.getId(), parentGroup.getId());
                                }
                            }
                            userData.setUserChanged(true);
                            this.changeRegistry.edit(userData);
                            this.debugState("== USER RELOCATE ========================");
                        }
                    }, this.managerPane.getMutex()), (BooleanExpression)pane.validProperty()).show((Node)this.managerPane.getEditor());
                });
            }
        }, this.managerPane.getMutex());
    }

    private void relocate(SortableTreeItem<AclPrincipal> parent, SortableTreeItem<AclPrincipal> item, boolean copy) {
        Notifications.get().submitTask(() -> {
            if (item.getValue() instanceof AclGroup) {
                AclGroup parentGroup = (AclGroup)parent.getValue();
                AclGroup group = (AclGroup)item.getValue();
                AclChangeRegistry.AclGroupData groupData = (AclChangeRegistry.AclGroupData)this.getPrincipalData((AclPrincipal)group);
                if (group.getParentId() != parentGroup.getId()) {
                    SortableTreeItem oldParent = (SortableTreeItem)item.getParent();
                    if (oldParent != null) {
                        AclPrincipal oldParentGroup = (AclPrincipal)oldParent.getValue();
                        group.setParentId(null);
                        if (item.equals(this.selectedItem)) {
                            this.selectedItem = null;
                        }
                        FxUtil.waitForFxThread(() -> oldParent.remove((TreeItem)item));
                        this.registry.unregisterGroupParent(group.getId(), oldParentGroup.getId());
                    }
                    group.setParentId(parentGroup.getId());
                    FxUtil.waitForFxThread(() -> {
                        item.setIgnoreFilterOnce(true);
                        parent.add((TreeItem)item);
                        parent.setExpanded(true);
                    });
                    this.registry.registerGroupParent(group.getId(), parentGroup.getId());
                    this.changeRegistry.edit(groupData);
                    this.debugState("== GROUP RELOCATE =======================");
                }
            } else if (item.getValue() instanceof AclUser) {
                AclGroup parentGroup = (AclGroup)parent.getValue();
                AclUser user = (AclUser)item.getValue();
                AclChangeRegistry.AclUserData userData = (AclChangeRegistry.AclUserData)this.getPrincipalData((AclPrincipal)user);
                if (!user.getGroupIds().contains(parentGroup.getId())) {
                    SortableTreeItem oldParent;
                    if (!copy && (oldParent = (SortableTreeItem)item.getParent()) != null) {
                        AclPrincipal oldParentGroup = (AclPrincipal)oldParent.getValue();
                        user.getGroupIds().remove(oldParentGroup.getId());
                        if (item.equals(this.selectedItem)) {
                            this.selectedItem = null;
                        }
                        FxUtil.waitForFxThread(() -> oldParent.remove((TreeItem)item));
                        this.registry.unregisterUserGroup(user.getId(), oldParentGroup.getId());
                    }
                    user.getGroupIds().add(parentGroup.getId());
                    FxUtil.waitForFxThread(() -> {
                        SortableTreeItem userItem = copy ? new SortableTreeItem((Object)user) : item;
                        userItem.setIgnoreFilterOnce(true);
                        parent.add((TreeItem)userItem);
                        parent.setExpanded(true);
                    });
                    this.registry.registerUserGroup(user.getId(), parentGroup.getId());
                    userData.setUserChanged(true);
                    this.changeRegistry.edit(userData);
                    this.debugState("== USER RELOCATE ========================");
                }
            }
        }, this.managerPane.getMutex());
    }

    void copyEntries(SortableTreeItem<AclPrincipal> item) {
        Collection entries = this.registry.getPrincipalEntries(((AclPrincipal)item.getValue()).getId());
        if (entries.size() > 0) {
            try {
                String content = XSUtil.toString((Collection)entries);
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent clipboardContent = new ClipboardContent();
                clipboardContent.put((Object)DataFormat.PLAIN_TEXT, (Object)content);
                clipboard.setContent((Map)clipboardContent);
                Notifications.get().showFlashNotification(Messages.Copy_success, Messages.Copy_success);
            }
            catch (Throwable e) {
                Notifications.get().showFlashNotification(Messages.Copy_failed, Messages.Copy_failed);
            }
        }
    }

    void pasteEntries(SortableTreeItem<AclPrincipal> item) {
        if (this.registry.getPrincipalEntries(((AclPrincipal)item.getValue()).getId()).size() > 0) {
            Dialog.confirm((Node)this, (String)Messages.Overwrite_entries, null, (String)Messages.Overwrite, () -> this.pasteEntriesInternal(item), null);
        } else {
            this.pasteEntriesInternal(item);
        }
    }

    private void pasteEntriesInternal(SortableTreeItem<AclPrincipal> item) {
        try {
            AclChangeRegistry.AclEntryData entryData;
            ArrayList entries = new ArrayList();
            Clipboard clipboard = Clipboard.getSystemClipboard();
            XUtil.deserialize((String)((String)clipboard.getContent(DataFormat.PLAIN_TEXT)), entries);
            this.debugState("== PASTE ENTRIES START ==================");
            for (AclEntry entry : this.registry.getPrincipalEntries(((AclPrincipal)item.getValue()).getId())) {
                entryData = new AclChangeRegistry.AclEntryData();
                entryData.setEntry(entry);
                this.registry.removeEntry(entryData.getEntry());
                this.changeRegistry.delete(entryData);
            }
            for (AclEntry entry : entries) {
                entryData = new AclChangeRegistry.AclEntryData();
                entryData.setEntry((AclEntry)XCloneHelper.clone((XCloneable)entry, (boolean)true));
                entryData.getEntry().setPrincipalId(((AclPrincipal)item.getValue()).getId());
                this.registry.addEntry(entryData.getEntry());
                this.changeRegistry.add(entryData);
            }
            this.debugState("== PASTE ENTRIES END ====================");
            this.entryDatasCache.remove(this.selectedItem.getValue());
            this.selectedItem = null;
            this.select();
            Notifications.get().showFlashNotification(Messages.Paste_success, Messages.Paste_success);
        }
        catch (Throwable e) {
            Notifications.get().showFlashNotification(Messages.Paste_failed, Messages.Paste_failed);
        }
    }

    public void save() throws Exception {
        Serializable authToken;
        if (this.selectedItem != null) {
            FxUtil.waitForFxThread(() -> this.flush());
        }
        if ((authToken = ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).save(ServiceInvocationContext.get(), this.changeRegistry)) != null) {
            ((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class)).setAuthToken(authToken);
        }
        this.changeRegistry.clear();
        FxUtil.waitForFxThread(() -> StandardNotifications.SAVED.show(Messages.Permissions_settings));
    }

    SortableTreeItem<AclPrincipal> getSelectedItem() {
        return this.selectedItem;
    }

    AclRegistry getRegistry() {
        return this.registry;
    }

    private void debugEditEntry(String title, AclRegistry cloneRegistry, AclChangeRegistry cloneChangeRegistry) {
        if (log.isDebugEnabled()) {
            StringBuilder debug = new StringBuilder();
            debug.append("\n");
            if (title != null) {
                debug.append(title);
                debug.append("\n");
            }
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(this.registry), null, (String)"registry", (boolean)true));
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(cloneRegistry), null, (String)"cloneRegistry", (boolean)true));
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(this.changeRegistry), null, (String)"changeRegistry", (boolean)true));
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(cloneChangeRegistry), null, (String)"cloneChangeRegistry", (boolean)true));
            debug.append(DebugUtil.decorate((Iterable)this.entryDatasCache.entrySet().stream().map(entry -> {
                StringBuilder stringBuilder = new StringBuilder(0);
                stringBuilder.append("key -> " + ((AclPrincipal)entry.getKey()).getId());
                stringBuilder.append("\n");
                stringBuilder.append(DebugUtil.decorate((Iterable)((List)entry.getValue()).stream().map(value -> AclEditorHelper.toString(value.getEntry())).collect(Collectors.toList()), null, (String)"value", (boolean)true));
                return stringBuilder.toString();
            }).collect(Collectors.toList()), null, (String)"entryDataCache", (boolean)true));
            log.debug(debug.toString());
        }
    }

    private void debugState(String title) {
        if (log.isDebugEnabled()) {
            StringBuilder debug = new StringBuilder();
            debug.append("\n");
            if (title != null) {
                debug.append(title);
                debug.append("\n");
            }
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(this.registry), null, (String)"registry", (boolean)true));
            debug.append(DebugUtil.decorate((String)AclEditorHelper.toString(this.changeRegistry), null, (String)"changeRegistry", (boolean)true));
            debug.append(DebugUtil.decorate((Iterable)this.principalDataCache.entrySet().stream().map(item -> {
                StringBuilder stringBuilder = new StringBuilder(0);
                stringBuilder.append("key -> " + ((AclPrincipal)item.getKey()).getId());
                stringBuilder.append("\n");
                stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString(((AclChangeRegistry.AclPrincipalData)item.getValue()).getPrincipal()), null, (String)"value", (boolean)true));
                return stringBuilder.toString();
            }).collect(Collectors.toList()), null, (String)"principalDataCache", (boolean)true));
            debug.append(DebugUtil.decorate((Iterable)this.entryDatasCache.entrySet().stream().map(item -> {
                StringBuilder stringBuilder = new StringBuilder(0);
                stringBuilder.append("key -> " + ((AclPrincipal)item.getKey()).getId());
                stringBuilder.append("\n");
                stringBuilder.append(DebugUtil.decorate((Iterable)((List)item.getValue()).stream().map(value -> AclEditorHelper.toString(value.getEntry())).collect(Collectors.toList()), null, (String)"value", (boolean)true));
                return stringBuilder.toString();
            }).collect(Collectors.toList()), null, (String)"entryDataCache", (boolean)true));
            log.debug(debug.toString());
        }
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(AclEditorPane.this.principalsCardsPane, AclEditorPane.this.parametersCardsPane);
            }

            public String getInfo() {
                return ((Object)((Object)AclEditorPane.this)).getClass().getSimpleName();
            }
        };
    }

    private static /* synthetic */ void lambda$null$62(VBox body, Node messagePane) {
        FxUtil.submitToFxThread(() -> body.getChildren().remove((Object)messagePane));
    }

    private static /* synthetic */ void lambda$null$50(VBox body, Node messagePane) {
        FxUtil.submitToFxThread(() -> body.getChildren().remove((Object)messagePane));
    }

    public static interface AclPrincipalConverter<P extends AclPrincipal> {
        public AclChangeRegistry.AclPrincipalData<P> convert(P var1) throws Exception;
    }

    public static interface AclPrincipalEditor<P extends AclPrincipal, D extends AclChangeRegistry.AclPrincipalData<P>> {
        public Card<Node> getContent();

        public boolean isDataChanged();

        public void readData(D var1);

        public void writeData(D var1);
    }
}

