/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class AclGroupsPane
extends StackPane {
    private TreeView<AclGroup> groupsTree;
    private final AclRegistry registry;
    private final AclPrincipal principal;
    private final ObservableList<String> selectedGroupIds = FXCollections.observableArrayList();
    private SortableCheckBoxTreeItem<AclGroup> selectedItem;
    private final ReadOnlyBooleanWrapper valid = new ReadOnlyBooleanWrapper(false);
    private boolean single;

    public AclGroupsPane(AclRegistry registry, AclPrincipal principal, ObservableMutex mutex) {
        this.registry = registry;
        this.principal = principal;
        this.selectedGroupIds.clear();
        if (principal instanceof AclGroup) {
            this.selectedGroupIds.addAll((Object[])new String[]{((AclGroup)principal).getParentId()});
            this.single = true;
        } else if (principal instanceof AclUser) {
            this.selectedGroupIds.addAll((Collection)((AclUser)principal).getGroupIds());
            this.single = false;
        }
        this.createGUI();
        this.createBindings();
        this.createListeners();
        Notifications.get().submitTask(() -> this.populate(), mutex);
    }

    private void createGUI() {
        Pane groupsPane = this.createGroupsPane();
        this.getChildren().setAll((Object[])new Node[]{groupsPane});
    }

    private Pane createGroupsPane() {
        this.groupsTree = new TreeView();
        this.groupsTree.getStyleClass().addAll((Object[])new String[]{"xtrip-tree-view"});
        this.groupsTree.getStyleClass().addAll((Object[])new String[]{"xtrip-checkbox-tree-view"});
        this.groupsTree.setShowRoot(false);
        this.groupsTree.setCellFactory((Callback)new Callback<TreeView<AclGroup>, TreeCell<AclGroup>>(){

            public TreeCell<AclGroup> call(TreeView<AclGroup> param) {
                return new GroupTreeCell();
            }
        });
        GridPane groupsPane = new GridPane();
        UiUtil.gridPosition((GridPane)groupsPane, this.groupsTree).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        return groupsPane;
    }

    private void createBindings() {
        this.valid.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.selectedGroupIds.size() > 0, (Observable[])new Observable[]{this.selectedGroupIds}));
    }

    private void createListeners() {
    }

    private void populate() throws Exception {
        AclGroup rootGroup = new AclGroup();
        rootGroup.setId("root");
        SortableCheckBoxTreeItem rootItem = new SortableCheckBoxTreeItem();
        rootItem.setValue((Object)rootGroup);
        rootItem.setSelected(false);
        rootItem.setIndependent(true);
        rootItem.setComparator(MiscUtil.comparator(item -> (AclGroup)item.getValue(), (Comparator)AclHelper.groupComparator));
        List<AclGroup> rootGroups = this.registry.getGroups().stream().filter(value -> value.getParentId() == null).collect(Collectors.toList());
        this.populate((SortableCheckBoxTreeItem<AclGroup>)rootItem, rootGroups);
        FxUtil.waitForFxThread(() -> {
            this.groupsTree.setRoot((TreeItem)rootItem);
            UiUtil.expand(this.groupsTree);
        });
    }

    private void populate(SortableCheckBoxTreeItem<AclGroup> parent, Collection<AclGroup> groups) {
        for (AclGroup group : groups) {
            if (group == null || group.equals((Object)this.principal)) continue;
            SortableCheckBoxTreeItem item = new SortableCheckBoxTreeItem();
            item.setValue((Object)group);
            item.setSelected(this.selectedGroupIds.contains((Object)group.getId()));
            item.setIndependent(true);
            if (item.isSelected()) {
                this.selectedItem = item;
            }
            item.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    if (this.single && this.selectedItem != null) {
                        this.selectedItem.setSelected(false);
                    }
                    this.selectedGroupIds.add((Object)((AclGroup)item.getValue()).getId());
                    this.selectedItem = item;
                } else {
                    this.selectedGroupIds.remove((Object)((AclGroup)item.getValue()).getId());
                    this.selectedItem = null;
                }
            });
            parent.add((TreeItem)item);
            List<AclGroup> childGroups = this.registry.getGroupChildren(group.getId()).stream().map(value -> this.registry.getGroup(value)).collect(Collectors.toList());
            this.populate((SortableCheckBoxTreeItem<AclGroup>)item, childGroups);
        }
    }

    List<String> getSelectedGroupIds() {
        return this.selectedGroupIds;
    }

    final ReadOnlyBooleanProperty validProperty() {
        return this.valid.getReadOnlyProperty();
    }

    private static class GroupTreePane
    extends StackPane {
        private final CheckBox selectedCheckBox = new CheckBox();
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;

        GroupTreePane(TreeCell<?> cell) {
            this.selectedCheckBox.getStyleClass().add((Object)"selected-check-box");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.rulerButtonIcon = new IconNode((IconShape)StandardIconShapes.RULER_14X14, cell, (IconIntention)StandardIconIntentions.TREE_CELL_BUTTON_RULER, cell);
            this.rulerButtonIcon.getStyleClass().add((Object)"button-icon");
            GridPane containerPane = new GridPane();
            containerPane.getStyleClass().add((Object)"container-pane");
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.selectedCheckBox).col(0).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.titleLabel).col(1).row(0).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.rulerButtonIcon).col(2).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            this.getChildren().addAll((Object[])new Node[]{containerPane});
        }

        CheckBox getSelectedCheckBox() {
            return this.selectedCheckBox;
        }

        Label getTitleLabel() {
            return this.titleLabel;
        }

        IconNode getRulerButtonIcon() {
            return this.rulerButtonIcon;
        }
    }

    class GroupTreeCell
    extends CheckBoxTreeCell<AclGroup> {
        private GroupTreePane pane;
        private BooleanProperty selectedProperty;

        GroupTreeCell() {
        }

        public void updateItem(AclGroup value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.setDisclosureNode(null);
            if (!empty) {
                TreeItem item;
                if (this.pane == null) {
                    this.pane = new GroupTreePane((TreeCell<?>)this);
                    this.pane.getRulerButtonIcon().setOnMousePressed(event -> {
                        this.getTreeItem().setExpanded(!this.getTreeItem().isExpanded());
                        event.consume();
                    });
                }
                if ((item = this.getTreeItem()) != null) {
                    if (this.selectedProperty != null) {
                        this.pane.getSelectedCheckBox().selectedProperty().unbindBidirectional((Property)this.selectedProperty);
                    }
                    this.selectedProperty = ((SortableCheckBoxTreeItem)item).selectedProperty();
                    this.pane.getSelectedCheckBox().selectedProperty().bindBidirectional((Property)this.selectedProperty);
                    this.setOnMouseClicked(e -> this.selectedProperty.setValue(Boolean.valueOf(this.pane.getSelectedCheckBox().selectedProperty().getValue() == false)));
                    this.pane.getTitleLabel().setText(item.getValue() != null ? ((AclGroup)item.getValue()).getName() : null);
                    this.pane.getRulerButtonIcon().setVisible(!item.isLeaf());
                }
                this.setGraphic((Node)this.pane);
            } else {
                this.setGraphic(null);
            }
            this.setText(null);
        }
    }
}

