/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets.editor;

import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.editor.AssetEditorPane;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.assets.editor.AclUserPane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.helpers.PasswordPolicyHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rpc.service.AssetService;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AclUserEditorPane
extends AssetEditorPane<AclUser> {
    public AclUserEditorPane(ObservableMutex mutex, AssetHandler<AclUser> handler, String assetUid) {
        super(mutex, handler, assetUid);
    }

    public void saveData() throws Exception {
        if (!this.validateLogin() || !this.validatePassword()) {
            return;
        }
        ValueHolder asset = new ValueHolder();
        if (this.getAssetUid() != null) {
            List assets = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ServiceInvocationContext.get(), this.getAssetHandler().getAssetType(), BaseAsset.Property.uid.name(), (Object)this.getAssetUid()).getData();
            if (assets.size() > 0) {
                asset.set(assets.get(0));
            }
        } else {
            asset.set(this.getAssetHandler().getAssetType().newInstance());
        }
        if (asset.get() == null) {
            throw Xeption.forEndUser((String)Messages.Save_Error, (Object[])new Object[0]);
        }
        FxUtil.waitForFxThread(() -> this.writeData((BaseAsset)asset.get()));
        asset.set((Object)((AssetService)RpcServiceManager.get().getService(AssetService.class)).save(ServiceInvocationContext.get(), (BaseAsset)asset.get()));
        ValueHolder accountDataChanged = new ValueHolder();
        ValueHolder profileDataChanged = new ValueHolder();
        ValueHolder profile = new ValueHolder();
        ValueHolder password = new ValueHolder();
        ValueHolder active = new ValueHolder();
        ValueHolder email = new ValueHolder();
        ValueHolder createDate = new ValueHolder();
        ValueHolder lastLoginDate = new ValueHolder();
        ValueHolder expiryDate = new ValueHolder();
        FxUtil.waitForFxThread(() -> {
            AclUserPane pane = (AclUserPane)this.getEditor();
            accountDataChanged.set((Object)pane.isAccountDataChanged());
            profileDataChanged.set((Object)pane.isProfileDataChanged());
            profile.set(pane.getProfile());
            password.set((Object)pane.getPassword());
            active.set((Object)pane.isActive());
            email.set((Object)pane.getEmail());
            createDate.set((Object)pane.getCreateDate());
            lastLoginDate.set((Object)pane.getLastLoginDate());
            expiryDate.set((Object)pane.getExpiryDate());
        });
        if (accountDataChanged.get() != null && ((Boolean)accountDataChanged.get()).booleanValue()) {
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)((AclUser)asset.get()).getId()));
            query.getPreferredProperties().add(UserAccount.Property.loginName.name());
            List accounts = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), UserAccount.class, query).getData();
            UserAccount account = accounts.size() > 0 ? new UserAccount(((UserAccount)accounts.get(0)).getUid()) : new UserAccount();
            char[] passwordChars = !TextUtil.isBlank((String)((String)password.get()), (boolean)false) ? ((String)password.get()).toCharArray() : null;
            account.setFullName(((AclUser)asset.get()).getName());
            account.setNotes(((AclUser)asset.get()).getDescription());
            account.setLoginName(((AclUser)asset.get()).getId());
            account.setPassword(passwordChars);
            account.setActive(active.get() != null ? (Boolean)active.get() : false);
            account.setEmail((String)email.get());
            Date createDateValue = (Date)createDate.get();
            account.setCreateDate(createDateValue != null ? createDateValue : new Date());
            account.setLastLoginDate((Date)lastLoginDate.get());
            account.setExpiryDate((Date)expiryDate.get());
            Serializable authToken = ((ModelService)RpcServiceManager.get().getService(ModelService.class)).updateUserAccount(ServiceInvocationContext.get(), account, null, passwordChars, accounts.size() == 0);
            if (authToken != null) {
                ((ServiceInvocationContext)Environment.getPublished(ServiceInvocationContext.class)).setAuthToken(authToken);
            }
            EventBus.get().publishAsync((Event)new AssetModificationEvent(new AssetModification[]{new AssetModification((BaseAsset)account, AssetModification.ModificationType.CHANGE)}));
        }
        if (profileDataChanged.get() != null && ((Boolean)profileDataChanged.get()).booleanValue()) {
            EntityReference oldProfile = null;
            EntityReference newProfile = (EntityReference)profile.get();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)((AclUser)asset.get()).getId()));
            List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query);
            if (indexes.size() > 0) {
                oldProfile = ((PersonIndex)indexes.get(0)).getSource();
            }
            if (!MiscUtil.equals(oldProfile, (Object)newProfile)) {
                EntityContainer oldProfileContainer = oldProfile != null ? ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), oldProfile) : null;
                EntityContainer newProfileContainer = newProfile != null ? ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), newProfile) : null;
                ArrayList<EntityModification> modifiedPersons = new ArrayList<EntityModification>();
                if (oldProfileContainer != null) {
                    ((Person)oldProfileContainer.getEntity()).setLoginName(null);
                    oldProfileContainer.getVersionInfo().setDataSource("fx-acl-user-editor");
                    oldProfileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), oldProfileContainer, null, true);
                    modifiedPersons.add(new EntityModification(oldProfileContainer.toReference(), EntityModification.ModificationType.CHANGE));
                }
                if (newProfileContainer != null) {
                    List oldAclUsers;
                    List oldAccounts;
                    if (TextUtil.nonBlank((String)((Person)newProfileContainer.getEntity()).getLoginName()) && ProfileHelper.SABRE_LOGIN_PATTERN.matcher(((Person)newProfileContainer.getEntity()).getLoginName()).matches() && !(oldAccounts = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ServiceInvocationContext.get(), UserAccount.class, UserAccount.Property.loginName.name(), (Object)((Person)newProfileContainer.getEntity()).getLoginName()).getData()).isEmpty() && (oldAclUsers = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).find(ServiceInvocationContext.get(), AclUser.class, AclUser.Property.id.name(), (Object)((Person)newProfileContainer.getEntity()).getLoginName()).getData()).isEmpty()) {
                        ((AssetService)RpcServiceManager.get().getService(AssetService.class)).delete(ServiceInvocationContext.get(), (BaseAsset)oldAccounts.get(0));
                        newProfileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), newProfile);
                    }
                    ((Person)newProfileContainer.getEntity()).setLoginName(((AclUser)asset.get()).getId());
                    newProfileContainer.getVersionInfo().setDataSource("fx-acl-user-editor");
                    newProfileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), newProfileContainer, null, true);
                    modifiedPersons.add(new EntityModification(newProfileContainer.toReference(), EntityModification.ModificationType.CHANGE));
                }
                EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, modifiedPersons));
            }
        }
        FxUtil.waitForFxThread(() -> {
            this.readData((BaseAsset)asset.get());
            StandardNotifications.SAVED.show(((AclUser)asset.get()).toString());
        });
        EventBus.get().publishAsync((Event)new AssetModificationEvent(new AssetModification[]{new AssetModification((BaseAsset)asset.get(), AssetModification.ModificationType.CHANGE)}));
    }

    private boolean validateLogin() throws Exception {
        boolean isNew;
        boolean result = true;
        boolean bl = isNew = this.getData() == null;
        if (isNew) {
            AclUserPane pane = (AclUserPane)this.getEditor();
            String name = ((TextFieldWidget)pane.getNameCell().getPayload()).getValue();
            String id = ((TextFieldWidget)pane.getIdCell().getPayload()).getValue();
            SearchQuery loginQuery = new SearchQuery();
            loginQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)id));
            loginQuery.getPreferredProperties().add(UserAccount.Property.loginName.name());
            List foundAccounts = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), UserAccount.class, loginQuery).getData();
            if (!foundAccounts.isEmpty()) {
                Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.getLoginAlreadyExist(name), (Object[])new Object[0])});
                result = false;
            }
        }
        return result;
    }

    private boolean validatePassword() throws Exception {
        boolean isNew;
        boolean result = true;
        AclUserPane pane = (AclUserPane)this.getEditor();
        String newPassword = ((PasswordFieldWidget)pane.getPasswordCell().getPayload()).getValue();
        String login = ((TextFieldWidget)pane.getIdCell().getPayload()).getValue();
        boolean bl = isNew = this.getData() == null;
        if (!TextUtil.isBlank((String)newPassword)) {
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            if (!PasswordPolicyHelper.checkPassword((String)newPassword)) {
                Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Password_requirements, (Object[])new Object[]{8})});
                result = false;
            }
            if (PasswordPolicyHelper.hasInvalidCharacters((String)newPassword)) {
                Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.General_Password_has_invalid_symbols, (Object[])new Object[0])});
                result = false;
            }
            if (!isNew && ((ModelService)RpcServiceManager.get().getService(ModelService.class)).isPasswordMatchPrevious(sic, login, newPassword.toCharArray())) {
                Notifications.get().showMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.core.l10n.Messages.General_Previously_used_password_warning, (Object[])new Object[0])});
                result = false;
            }
        }
        return result;
    }
}

