/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets.editor;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.helpers.UserAccountHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.UserSettingsHandler;
import com.gridnine.xtrip.common.fx.rpc.AclDataService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.rpc.service.AssetService;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class AclUserPane
extends StackPane
implements ViewController<Node, AclUser>,
DevTool {
    private CardsContainer parametersPane;
    private CardsContainer groupsPane;
    private TreeView<AclGroup> groupsTree;
    private GridCell<TextFieldWidget> nameCell;
    private GridCell<TextFieldWidget> descriptionCell;
    private GridCell<EntityBoxWidget<Person>> profileCell;
    private GridCell<TextFieldWidget> idCell;
    private GridCell<PasswordFieldWidget> passwordCell;
    private GridCell<TextFieldWidget> emailCell;
    private GridCell<DateTimeValueWidget> createDateCell;
    private GridCell<DateTimeValueWidget> lastLoginDateCell;
    private GridCell<DateValueWidget> expiryDateCell;
    private GridCell<CheckBoxWidget> activeCell;
    private AclUser model;
    private EntityReference<Person> profile;
    private String password;
    private String email;
    private Date createDate;
    private Date lastLoginDate;
    private Date expiryDate;
    private boolean active;
    private boolean accountDataChanged;
    private boolean profileDataChanged;
    private boolean readonly;
    private AclRegistry registry;
    private final List<String> selectedGroupIds = new ArrayList<String>();
    private final ObservableMutex mutex;

    public AclUserPane(ObservableMutex mutex) {
        this.mutex = mutex;
        this.createGUI();
        this.createBindings();
        this.createListeners();
        Notifications.get().submitTask(() -> this.populate(), mutex);
    }

    private void createGUI() {
        Pane userPane = this.createUserPane();
        this.getChildren().setAll((Object[])new Node[]{userPane});
    }

    private Pane createUserPane() {
        Pane parametersPane = this.createParametersPane();
        Pane groupsPane = this.createGroupsPane();
        GridPane userPane = new GridPane();
        UiUtil.gridPosition((GridPane)userPane, (Node)parametersPane).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        UiUtil.gridPosition((GridPane)userPane, (Node)groupsPane).col(1).row(0).hGrow(Priority.NEVER).vGrow(Priority.ALWAYS).place();
        return userPane;
    }

    private Pane createParametersPane() {
        this.nameCell = new GridCell(Messages.Name, (Node)new TextFieldWidget(false));
        this.descriptionCell = new GridCell(Messages.Description, (Node)new TextFieldWidget(false));
        this.profileCell = new GridCell(Messages.Profile, (Node)new EntityBoxWidget(Person.class, false));
        this.idCell = new GridCell(Messages.Login, (Node)new TextFieldWidget(false));
        this.passwordCell = new GridCell(Messages.New_Password, (Node)new PasswordFieldWidget(false));
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setShowStrengthIndicator(true);
        this.passwordCell.setHelp(() -> new QuickHelp(UserAccountHelper.passwordPolicyInfo(true)));
        this.emailCell = new GridCell(Messages.aclUserPaneEmailCaption, (Node)new TextFieldWidget(false));
        this.emailCell.setHelp(() -> new QuickHelp(Messages.aclUserPaneEmailHint));
        this.activeCell = new GridCell((Node)new CheckBoxWidget(false));
        ((CheckBoxWidget)this.activeCell.getPayload()).setText(Messages.Active);
        this.createDateCell = new GridCell(Messages.aclUserPaneCreateDateCaption, (Node)new DateTimeValueWidget(true));
        this.lastLoginDateCell = new GridCell(Messages.aclUserPaneLastLoginDateCaption, (Node)new DateTimeValueWidget(true));
        this.expiryDateCell = new GridCell(Messages.aclUserPaneExpiryDateCaption, (Node)new DateValueWidget(false));
        GridContainer pane = new GridContainer(3);
        pane.getCells().addAll((Object[])new GridCell[]{this.nameCell, this.descriptionCell, this.profileCell, this.idCell, this.passwordCell, this.emailCell, this.activeCell, this.createDateCell, this.lastLoginDateCell, this.expiryDateCell});
        Card card = new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)pane);
        card.setAdaptiveHeight(true);
        this.parametersPane = new CardsContainer();
        this.parametersPane.getStyleClass().add((Object)"parameters-pane");
        this.parametersPane.getCards().add((Object)card);
        return this.parametersPane;
    }

    private Pane createGroupsPane() {
        this.groupsTree = new TreeView();
        this.groupsTree.getStyleClass().add((Object)"xtrip-tree-view");
        this.groupsTree.getStyleClass().add((Object)"xtrip-checkbox-tree-view");
        this.groupsTree.setShowRoot(false);
        this.groupsTree.setCellFactory((Callback)new Callback<TreeView<AclGroup>, TreeCell<AclGroup>>(){

            public TreeCell<AclGroup> call(TreeView<AclGroup> param) {
                return new GroupTreeCell();
            }
        });
        GridPane pane = new GridPane();
        UiUtil.gridPosition((GridPane)pane, this.groupsTree).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        Card card = new Card("groups", UiCardsContainer.Style.STATIC, Messages.Groups, (Node)pane);
        card.setAdaptiveHeight(true);
        this.groupsPane = new CardsContainer();
        this.groupsPane.getStyleClass().add((Object)"groups-pane");
        this.groupsPane.getCards().add((Object)card);
        return this.groupsPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    public Node getView() {
        return this;
    }

    public AclUser getData() {
        return this.model;
    }

    private void populate() throws Exception {
        this.registry = ((AclDataService)RpcServiceManager.get().getService(AclDataService.class)).getFullAclRegistry(ServiceInvocationContext.get());
        AclGroup rootGroup = new AclGroup();
        rootGroup.setId("root");
        SortableCheckBoxTreeItem rootItem = new SortableCheckBoxTreeItem();
        rootItem.setValue((Object)rootGroup);
        rootItem.setSelected(false);
        rootItem.setIndependent(true);
        rootItem.setComparator(MiscUtil.comparator(item -> (AclGroup)item.getValue(), (Comparator)AclHelper.groupComparator));
        List<AclGroup> rootGroups = this.registry.getGroups().stream().filter(value -> value.getParentId() == null).collect(Collectors.toList());
        this.populate((SortableCheckBoxTreeItem<AclGroup>)rootItem, rootGroups);
        FxUtil.submitToFxThread(() -> {
            this.groupsTree.setRoot((TreeItem)rootItem);
            UiUtil.expand(this.groupsTree);
        });
    }

    private void populate(SortableCheckBoxTreeItem<AclGroup> parent, Collection<AclGroup> groups) {
        for (AclGroup group : groups) {
            if (group == null) continue;
            SortableCheckBoxTreeItem item = new SortableCheckBoxTreeItem();
            item.setValue((Object)group);
            item.setSelected(false);
            item.setIndependent(true);
            item.selectedProperty().addListener((observable, oldValue, newValue) -> {
                if (newValue.booleanValue()) {
                    this.selectedGroupIds.add(((AclGroup)item.getValue()).getId());
                } else {
                    this.selectedGroupIds.remove(((AclGroup)item.getValue()).getId());
                }
            });
            parent.add((TreeItem)item);
            List<AclGroup> childGroups = this.registry.getGroupChildren(group.getId()).stream().map(value -> this.registry.getGroup(value)).collect(Collectors.toList());
            this.populate((SortableCheckBoxTreeItem<AclGroup>)item, childGroups);
        }
    }

    private boolean selectGroup(String groupId, TreeItem<AclGroup> item) {
        if (((AclGroup)item.getValue()).getId().equals(groupId)) {
            ((SortableCheckBoxTreeItem)item).setSelected(true);
            return true;
        }
        for (TreeItem childItem : item.getChildren()) {
            if (!this.selectGroup(groupId, (TreeItem<AclGroup>)childItem)) continue;
            return true;
        }
        return false;
    }

    private void clear(TreeItem<AclGroup> item) {
        if (item == null) {
            return;
        }
        ((SortableCheckBoxTreeItem)item).setSelected(false);
        for (TreeItem childItem : ((SortableCheckBoxTreeItem)item).getInternalChildren()) {
            this.clear((TreeItem<AclGroup>)childItem);
        }
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean value) {
        this.readonly = value;
    }

    public void setNotEditable(boolean value) {
    }

    public void setAclNotEditable(boolean notEditable) {
    }

    public boolean isDataChanged() {
        if (this.readonly) {
            return false;
        }
        if (!((TextFieldWidget)this.nameCell.getPayload()).getViewState().isImmutable() && !TextUtil.isSame((String)((TextFieldWidget)this.nameCell.getPayload()).getValue(), this.model != null ? this.model.getName() : null)) {
            return true;
        }
        if (!((TextFieldWidget)this.descriptionCell.getPayload()).getViewState().isImmutable() && !TextUtil.isSame((String)((TextFieldWidget)this.descriptionCell.getPayload()).getValue(), this.model != null ? this.model.getDescription() : null)) {
            return true;
        }
        if (!((EntityBoxWidget)this.profileCell.getPayload()).getViewState().isImmutable() && !MiscUtil.equals((Object)((EntityBoxWidget)this.profileCell.getPayload()).getValue(), this.profile)) {
            return true;
        }
        if (!((TextFieldWidget)this.idCell.getPayload()).getViewState().isImmutable() && !TextUtil.isSame((String)((TextFieldWidget)this.idCell.getPayload()).getValue(), this.model != null ? this.model.getId() : null)) {
            return true;
        }
        if (!((PasswordFieldWidget)this.passwordCell.getPayload()).getViewState().isImmutable() && !TextUtil.isBlank((String)((PasswordFieldWidget)this.passwordCell.getPayload()).getValue(), (boolean)false)) {
            return true;
        }
        if (!((TextFieldWidget)this.emailCell.getPayload()).getViewState().isImmutable() && !TextUtil.isSame((String)((TextFieldWidget)this.emailCell.getPayload()).getValue(), (String)this.email)) {
            return true;
        }
        if (!((DateValueWidget)this.expiryDateCell.getPayload()).getViewState().isImmutable() && !Objects.equals(((DateValueWidget)this.expiryDateCell.getPayload()).getValue(), DateUtils.asLocalDate((Date)this.expiryDate))) {
            return true;
        }
        if (!((CheckBoxWidget)this.activeCell.getPayload()).getViewState().isImmutable() && ((CheckBoxWidget)this.activeCell.getPayload()).isSelected() != this.active) {
            return true;
        }
        return !this.groupsTree.isDisabled() && !CollectionUtil.equals(this.selectedGroupIds, (Collection)(this.model != null ? this.model.getGroupIds() : Collections.emptyList()), (boolean)true);
    }

    public void readData(AclUser model) {
        this.model = model;
        ((TextFieldWidget)this.nameCell.getPayload()).setValue(model.getName());
        ((TextFieldWidget)this.descriptionCell.getPayload()).setValue(model.getDescription());
        ((TextFieldWidget)this.idCell.getPayload()).setValue(model.getId());
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setValue(null);
        ((TextFieldWidget)this.emailCell.getPayload()).getViewState().setReadonly(true);
        ((DateTimeValueWidget)this.createDateCell.getPayload()).getViewState().setReadonly(true);
        ((DateTimeValueWidget)this.lastLoginDateCell.getPayload()).getViewState().setReadonly(true);
        ((DateValueWidget)this.expiryDateCell.getPayload()).getViewState().setReadonly(true);
        ((EntityBoxWidget)this.profileCell.getPayload()).getViewState().setReadonly(true);
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(true);
        ((CheckBoxWidget)this.activeCell.getPayload()).getViewState().setReadonly(true);
        this.groupsTree.setDisable(true);
        Notifications.get().submitTask(() -> {
            ValueHolder profileHolder = new ValueHolder();
            ValueHolder activeHolder = new ValueHolder();
            ValueHolder emailHolder = new ValueHolder();
            ValueHolder createDateHolder = new ValueHolder();
            ValueHolder lastLoginDateHolder = new ValueHolder();
            ValueHolder expiryDateHolder = new ValueHolder();
            ValueHolder exists = new ValueHolder();
            SearchQuery query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)model.getId()));
            query.getPreferredProperties().add(PersonIndex.Property.loginName.name());
            List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query);
            if (indexes.size() > 0) {
                profileHolder.set((Object)((PersonIndex)indexes.get(0)).getSource());
            }
            query = new SearchQuery();
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)model.getId()));
            query.getPreferredProperties().add(UserAccount.Property.active.name());
            query.getPreferredProperties().add(UserAccount.Property.email.name());
            query.getPreferredProperties().add(UserAccount.Property.createDate.name());
            query.getPreferredProperties().add(UserAccount.Property.lastLoginDate.name());
            query.getPreferredProperties().add(UserAccount.Property.expiryDate.name());
            List accounts = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), UserAccount.class, query).getData();
            if (accounts.size() > 0) {
                UserAccount firstAccount = (UserAccount)accounts.get(0);
                activeHolder.set((Object)firstAccount.isActive());
                emailHolder.set((Object)firstAccount.getEmail());
                createDateHolder.set((Object)firstAccount.getCreateDate());
                lastLoginDateHolder.set((Object)firstAccount.getLastLoginDate());
                expiryDateHolder.set((Object)firstAccount.getExpiryDate());
            }
            exists.set((Object)(accounts.size() > 0 ? 1 : 0));
            String login = model.getId();
            List handlers = ClientRegistry.get().allOf(UserSettingsHandler.TYPE).values().stream().filter(handler -> handler.getLogin() != null && handler.getLogin().equals(login) && handler.isEnabled()).collect(Collectors.toList());
            boolean readOnly = !handlers.isEmpty();
            FxUtil.waitForFxThread(() -> {
                ((EntityBoxWidget)this.profileCell.getPayload()).setValue((EntityReference)profileHolder.get());
                ((CheckBoxWidget)this.activeCell.getPayload()).setSelected(activeHolder.get() != null ? (Boolean)activeHolder.get() : false);
                this.clear((TreeItem<AclGroup>)this.groupsTree.getRoot());
                for (String groupId : model.getGroupIds()) {
                    this.selectGroup(groupId, (TreeItem<AclGroup>)this.groupsTree.getRoot());
                }
                ((EntityBoxWidget)this.profileCell.getPayload()).getViewState().setReadonly(false);
                ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(exists.get() != null ? (Boolean)exists.get() : false);
                ((CheckBoxWidget)this.activeCell.getPayload()).getViewState().setReadonly(AclHelper.isSpecialUser((AclUser)model) || readOnly);
                this.groupsTree.setDisable(AclHelper.isSpecialUser((AclUser)model));
                ((PasswordFieldWidget)this.passwordCell.getPayload()).setPromptText(exists.get() != null && (Boolean)exists.get() != false ? String.join((CharSequence)"", Collections.nCopies(25, "*")) : UiUtil.NULL_TEXT);
                ((PasswordFieldWidget)this.passwordCell.getPayload()).getViewState().setReadonly(readOnly);
                if (readOnly) {
                    this.passwordCell.setHelp(() -> new QuickHelp(UserAccountHelper.passwordAvailabilityInfo(true, login, handlers.stream().map(UserSettingsHandler::getMessage).collect(Collectors.toList()))));
                } else {
                    this.passwordCell.setHelp(() -> new QuickHelp(UserAccountHelper.passwordPolicyInfo(true)));
                }
                ((TextFieldWidget)this.emailCell.getPayload()).getViewState().setReadonly(false);
                ((TextFieldWidget)this.emailCell.getPayload()).setValue((String)emailHolder.get());
                ((DateTimeValueWidget)this.createDateCell.getPayload()).setValue(DateUtils.asLocalDateTime((Date)((Date)createDateHolder.get())));
                ((DateTimeValueWidget)this.lastLoginDateCell.getPayload()).setValue(DateUtils.asLocalDateTime((Date)((Date)lastLoginDateHolder.get())));
                ((DateValueWidget)this.expiryDateCell.getPayload()).getViewState().setReadonly(false);
                ((DateValueWidget)this.expiryDateCell.getPayload()).setValue(DateUtils.asLocalDate((Date)((Date)expiryDateHolder.get())));
            });
            this.profile = (EntityReference)profileHolder.get();
            this.active = activeHolder.get() != null ? (Boolean)activeHolder.get() : false;
            this.email = (String)emailHolder.get();
            this.createDate = (Date)createDateHolder.get();
            this.lastLoginDate = (Date)lastLoginDateHolder.get();
            this.expiryDate = (Date)expiryDateHolder.get();
        }, this.mutex);
    }

    public void writeData(AclUser model) {
        this.model = model;
        this.accountDataChanged = !MiscUtil.equals((Object)model.getName(), (Object)((TextFieldWidget)this.nameCell.getPayload()).getValue()) || !MiscUtil.equals((Object)model.getDescription(), (Object)((TextFieldWidget)this.descriptionCell.getPayload()).getValue()) || !MiscUtil.equals((Object)model.getId(), (Object)((TextFieldWidget)this.idCell.getPayload()).getValue()) || !TextUtil.isBlank((String)((PasswordFieldWidget)this.passwordCell.getPayload()).getValue(), (boolean)false) || !TextUtil.equals((String)this.email, (String)((TextFieldWidget)this.emailCell.getPayload()).getValue(), (boolean)true) || !Objects.equals(DateUtils.asLocalDateTime((Date)this.createDate), ((DateTimeValueWidget)this.createDateCell.getPayload()).getValue()) || !Objects.equals(DateUtils.asLocalDateTime((Date)this.lastLoginDate), ((DateTimeValueWidget)this.lastLoginDateCell.getPayload()).getValue()) || !Objects.equals(DateUtils.asLocalDate((Date)this.expiryDate), ((DateValueWidget)this.expiryDateCell.getPayload()).getValue()) || this.active != ((CheckBoxWidget)this.activeCell.getPayload()).isSelected();
        this.profileDataChanged = !MiscUtil.equals(this.profile, (Object)((EntityBoxWidget)this.profileCell.getPayload()).getValue());
        model.setName(((TextFieldWidget)this.nameCell.getPayload()).getValue());
        model.setDescription(((TextFieldWidget)this.descriptionCell.getPayload()).getValue());
        model.setId(((TextFieldWidget)this.idCell.getPayload()).getValue());
        model.getGroupIds().clear();
        model.getGroupIds().addAll(this.selectedGroupIds);
        this.profile = ((EntityBoxWidget)this.profileCell.getPayload()).getValue();
        this.password = ((PasswordFieldWidget)this.passwordCell.getPayload()).getValue();
        this.active = ((CheckBoxWidget)this.activeCell.getPayload()).isSelected();
        this.email = ((TextFieldWidget)this.emailCell.getPayload()).getValue();
        this.createDate = DateUtils.asDate((LocalDateTime)((DateTimeValueWidget)this.createDateCell.getPayload()).getValue());
        this.lastLoginDate = DateUtils.asDate((LocalDateTime)((DateTimeValueWidget)this.lastLoginDateCell.getPayload()).getValue());
        this.expiryDate = DateUtils.asDate((LocalDate)((DateValueWidget)this.expiryDateCell.getPayload()).getValue());
    }

    public void validateData(List<Message> messages) {
        if (TextUtil.isBlank((String)((TextFieldWidget)this.nameCell.getPayload()).getValue())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Field_name_shouldnt_be_blank, (Object[])new Object[0]));
        }
        if (TextUtil.isBlank((String)((TextFieldWidget)this.emailCell.getPayload()).getValue())) {
            messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.aclUserPaneEmailShouldNotBeBlankMessage, (Object[])new Object[0]));
        }
    }

    public boolean isAccountDataChanged() {
        return this.accountDataChanged;
    }

    public boolean isProfileDataChanged() {
        return this.profileDataChanged;
    }

    public EntityReference<Person> getProfile() {
        return this.profile;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEmail() {
        return this.email;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public Date getLastLoginDate() {
        return this.lastLoginDate;
    }

    public Date getExpiryDate() {
        return this.expiryDate;
    }

    public boolean isActive() {
        return this.active;
    }

    GridCell<TextFieldWidget> getNameCell() {
        return this.nameCell;
    }

    GridCell<TextFieldWidget> getIdCell() {
        return this.idCell;
    }

    public GridCell<PasswordFieldWidget> getPasswordCell() {
        return this.passwordCell;
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Arrays.asList(AclUserPane.this.parametersPane, AclUserPane.this.groupsPane);
            }

            public String getInfo() {
                return ((Object)((Object)AclUserPane.this)).getClass().getSimpleName();
            }
        };
    }

    private static class GroupTreePane
    extends StackPane {
        private final CheckBox selectedCheckBox = new CheckBoxWidget(false);
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;

        GroupTreePane(TreeCell<?> cell) {
            this.selectedCheckBox.getStyleClass().add((Object)"selected-check-box");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            Tooltip.install((Node)this.titleLabel, (Tooltip)new Tooltip(Messages.Select_Group));
            this.rulerButtonIcon = new IconNode((IconShape)StandardIconShapes.RULER_14X14, cell, (IconIntention)StandardIconIntentions.TREE_CELL_BUTTON_RULER, cell);
            this.rulerButtonIcon.getStyleClass().add((Object)"button-icon");
            GridPane containerPane = new GridPane();
            containerPane.getStyleClass().add((Object)"container-pane");
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.selectedCheckBox).col(0).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.titleLabel).col(1).row(0).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.rulerButtonIcon).col(2).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            this.getChildren().addAll((Object[])new Node[]{containerPane});
        }

        CheckBox getSelectedCheckBox() {
            return this.selectedCheckBox;
        }

        Label getTitleLabel() {
            return this.titleLabel;
        }

        IconNode getRulerButtonIcon() {
            return this.rulerButtonIcon;
        }
    }

    class GroupTreeCell
    extends CheckBoxTreeCell<AclGroup> {
        private GroupTreePane pane;
        private BooleanProperty selectedProperty;

        GroupTreeCell() {
        }

        public void updateItem(AclGroup value, boolean empty) {
            super.updateItem((Object)value, empty);
            this.setDisclosureNode(null);
            if (!empty) {
                TreeItem item;
                if (this.pane == null) {
                    this.pane = new GroupTreePane((TreeCell<?>)this);
                    this.pane.getRulerButtonIcon().setOnMousePressed(event -> {
                        this.getTreeItem().setExpanded(!this.getTreeItem().isExpanded());
                        event.consume();
                    });
                }
                if ((item = this.getTreeItem()) != null) {
                    if (this.selectedProperty != null) {
                        this.pane.getSelectedCheckBox().selectedProperty().unbindBidirectional((Property)this.selectedProperty);
                    }
                    this.selectedProperty = ((SortableCheckBoxTreeItem)item).selectedProperty();
                    this.pane.getSelectedCheckBox().selectedProperty().bindBidirectional((Property)this.selectedProperty);
                    this.setOnMouseClicked(e -> this.selectedProperty.setValue(Boolean.valueOf(this.pane.getSelectedCheckBox().selectedProperty().getValue() == false)));
                    this.pane.getTitleLabel().setText(item.getValue() != null ? ((AclGroup)item.getValue()).getName() : null);
                    this.pane.getRulerButtonIcon().setVisible(!item.isLeaf());
                }
                this.setGraphic((Node)this.pane);
            } else {
                this.setGraphic(null);
            }
            this.setText(null);
        }
    }
}

