/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.AddAccountsAvailableTableVM;
import com.gridnine.xtrip.client.fx.model.profile.AddAccountsExistingTableVM;
import com.gridnine.xtrip.client.fx.model.profile.AddAccountsPanel;
import com.gridnine.xtrip.client.fx.model.profile.AddAccountsPanelController;
import com.gridnine.xtrip.client.fx.model.profile.AddAccountsPanelVM;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerPane;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class AddChartOfAccountsElementBalanceEditor
implements BalanceEditorManagerAction {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_CHART_OF_ACCOUNTS_SETTINGS.getId());

    public ActionIcon getIcon(BalanceEditorManagerPane context) {
        return StandardActionIcons.ADD_CHART_OF_ACCOUNTS;
    }

    public double getWeight() {
        return 40.0;
    }

    public boolean isEnabled(BalanceEditorManagerPane context) {
        return context.getHeader() != null && context.getHeader().getOrganizationWidget().getValue() != null;
    }

    public void execute(Control source, BalanceEditorManagerPane context, boolean alt) {
        EntityReference<Organization> organizationRef = this.getOrganizationRefFromPane(context);
        if (alt) {
            Notifications.get().submitTask(() -> {
                EntityContainer financeInitialzationDataContainer = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadFinanceInitializationData(ServiceInvocationContext.get(), organizationRef);
                if (financeInitialzationDataContainer != null) {
                    FxUtil.submitToFxThread(() -> {
                        RichContentWidget widget = new RichContentWidget(true);
                        widget.setFileNameSupplier(() -> financeInitialzationDataContainer.getUid() + ".xml");
                        RichData richData = new RichData();
                        richData.setContentType(ContentType.XML);
                        try {
                            richData.setContent(XSUtil.toByteArray((XSSerializable)financeInitialzationDataContainer));
                        }
                        catch (Exception e) {
                            ErrorHandler.handle((Throwable)e);
                            return;
                        }
                        widget.setData(richData);
                        widget.getViewState().setNotEditable(true);
                        new Dialog().setTitle("Finance initialization data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)source);
                    });
                }
            }, Messages.Notifications_getting_data);
            return;
        }
        EntityReference<ChartOfAccountsElement> accountsRef = this.getAccountsRefFromPane(context);
        DictBoxWidget<CurrencyInfo> currencyDictBox = this.getCustomizedCurrencyWidget(accountsRef);
        GridContainer gridContainer = new GridContainer();
        gridContainer.setColumnsCount(1);
        gridContainer.getCells().add((Object)new GridCell(currencyDictBox));
        new Dialog().setBody((Node)gridContainer).setExpandToParent(false).setTitle(Messages.Action_transaction_balance_editor_selected_currency_for_new_account).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> Notifications.get().submitTask(() -> {
            DictionaryReference currencyInfoRef = currencyDictBox.getValue();
            List<ChartOfAccountsElementIndex> chartOfAccountsElementIndexes = this.loadListAccountsElementsIndexForOrganization(organizationRef, (DictionaryReference<CurrencyInfo>)currencyInfoRef);
            EntityReference settings = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).getChartOfAccountsSettings(ServiceInvocationContext.get(), organizationRef);
            if (settings == null) {
                Notifications.get().showStaticNotification(Messages.Action_transaction_balance_editor_settings_not_found, "");
                return;
            }
            List chartOfAccountsElementTypeExisting = chartOfAccountsElementIndexes.stream().filter(index -> index.getType() != null).map(ChartOfAccountsElementIndex::getType).collect(Collectors.toList());
            List chartOfAccountsElementTypeAvailable = Arrays.stream(ChartOfAccountsElementType.values()).filter(type -> !chartOfAccountsElementTypeExisting.contains(type)).collect(Collectors.toList());
            FxUtil.waitForFxThread(() -> {
                if (chartOfAccountsElementTypeAvailable.isEmpty()) {
                    Notifications.get().showStaticNotification(Messages.Action_transaction_balance_editor_selected_cant_create_account_for_the_currency, "");
                } else {
                    AddAccountsPanel body = this.getBodyForAddAcountsDialog();
                    AddAccountsPanelController controller = new AddAccountsPanelController(body, true);
                    AddAccountsPanelVM model = new AddAccountsPanelVM();
                    this.writeDataToBody(controller, model, chartOfAccountsElementTypeExisting, chartOfAccountsElementTypeAvailable);
                    new Dialog().setBody((Node)controller.getView()).setExpandToParent(true).setTitle(Messages.Action_transaction_balance_editor_selected_account).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> {
                        controller.writeData(model);
                        List listAccountsElementForSaving = model.getAvailableAccounts().stream().filter(AddAccountsAvailableTableVM::isCheckBoxColumn).map(type -> this.createContainerAccountElements((AddAccountsAvailableTableVM)type, (DictionaryReference<CurrencyInfo>)currencyInfoRef, organizationRef, (EntityReference<ChartOfAccountsSettings>)settings)).collect(Collectors.toList());
                        Notifications.get().submitTask(() -> {
                            listAccountsElementForSaving.forEach(cont -> {
                                try {
                                    ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), cont, null, true);
                                }
                                catch (Exception e) {
                                    ErrorHandler.handle((Throwable)e);
                                }
                            });
                            context.updateAccountWidget();
                        }, Messages.Notifications_saving_data);
                    }).show((Node)source);
                }
            });
        }, Messages.Notifications_getting_settings)).show((Node)source);
    }

    private EntityReference<Organization> getOrganizationRefFromPane(BalanceEditorManagerPane context) {
        return context.getHeader().getOrganizationWidget().getValue();
    }

    private EntityReference<ChartOfAccountsElement> getAccountsRefFromPane(BalanceEditorManagerPane context) {
        return (EntityReference)context.getHeader().getAccountWidget().getValue();
    }

    private DictBoxWidget<CurrencyInfo> getCustomizedCurrencyWidget(EntityReference<ChartOfAccountsElement> accountsRef) {
        DictBoxWidget currencyDictBox = new DictBoxWidget(CurrencyInfo.class, false);
        currencyDictBox.setFieldName(Messages.Currency);
        if (accountsRef != null) {
            Notifications.get().submitTask(() -> {
                EntityContainer containerAccountsElement = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), accountsRef);
                if (containerAccountsElement != null) {
                    currencyDictBox.setValue(((ChartOfAccountsElement)containerAccountsElement.getEntity()).getCurrency());
                }
            }, Messages.Notifications_getting_data);
        }
        return currencyDictBox;
    }

    private EntityContainer<ChartOfAccountsElement> createContainerAccountElements(AddAccountsAvailableTableVM type, DictionaryReference<CurrencyInfo> currencyInfoRef, EntityReference<Organization> organizationRef, EntityReference<ChartOfAccountsSettings> settingsRef) {
        ChartOfAccountsElement account = new ChartOfAccountsElement();
        account.setCurrency(currencyInfoRef);
        account.setOrganization(organizationRef);
        account.setType(type.getAccountsColumn());
        account.setSettings(settingsRef);
        return EntityContainer.create((BaseEntity)account, (String)FinanceHelper.getChartOfAccountsElementCompoundUid(organizationRef, settingsRef, (ChartOfAccountsElementType)type.getAccountsColumn(), currencyInfoRef));
    }

    private List<ChartOfAccountsElementIndex> loadListAccountsElementsIndexForOrganization(EntityReference<Organization> organizationRef, DictionaryReference<CurrencyInfo> currencyInfoRef) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organizationRef));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.currency.name(), currencyInfoRef));
        return ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), ChartOfAccountsElementIndex.class, query);
    }

    private AddAccountsPanel getBodyForAddAcountsDialog() {
        AddAccountsPanel body = new AddAccountsPanel(false);
        body.getExistingAccountsNode().getViewState().setReadonly(true);
        body.getAvailableAccountsNode().setControlButtonsAvailability(ControlsPane.NONE);
        body.getAvailableAccountsNode().getColumn("accountsColumn").setNotEditable(Boolean.TRUE);
        body.getAvailableAccountsNode().getColumn("checkBoxColumn").setNotEditable(Boolean.FALSE);
        return body;
    }

    private void writeDataToBody(AddAccountsPanelController controller, AddAccountsPanelVM model, List<ChartOfAccountsElementType> chartOfAccountsElementTypeExisting, List<ChartOfAccountsElementType> chartOfAccountsElementTypeAvailable) {
        chartOfAccountsElementTypeExisting.forEach(type -> {
            AddAccountsExistingTableVM elementVM = new AddAccountsExistingTableVM();
            elementVM.setCheckBoxColumn(true);
            elementVM.setAccountsColumn(type);
            model.getExistingAccounts().add(elementVM);
        });
        chartOfAccountsElementTypeAvailable.forEach(type -> {
            AddAccountsAvailableTableVM elementVM = new AddAccountsAvailableTableVM();
            elementVM.setAccountsColumn(type);
            model.getAvailableAccounts().add(elementVM);
        });
        controller.readData(model);
    }

    public String getId() {
        return "balance-editor-add-chartOfAccountsElement";
    }

    @Override
    public AclQuery getACLQuery(BalanceEditorManagerPane balanceEditorManagerPane) {
        return ACL_QUERY;
    }
}

