/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.widgets.InfoLabelWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.FilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BalanceDataVM;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorBalanceSummaryPanel;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorFilterContainer;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorFullPanel;
import com.gridnine.xtrip.client.fx.standard.balance.DimensionWrapper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceProperties;
import com.gridnine.xtrip.common.fx.rpc.FinanceServiceResult;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.text.DecimalFormat;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.util.Pair;

public class BalanceEditorFilterableDataViewHandler
extends FilterableDataViewHandler<BalanceDataVM, BalanceEditorFilterContainer> {
    private static final int DEFAULT_LIMIT = 40;
    private int offset;

    protected BalanceEditorFilterableDataViewHandler(EntityReference<ChartOfAccountsElement> ref, BalanceEditorFullPanel balanceEditor, ObservableList<TableColumn<BalanceDataVM, ?>> columns, BasicChartOfAccountsElementSettings settings, EntityReference<Organization> defaultSupplier) {
        super(() -> {
            EntityBoxWidget agencyNode;
            BalanceEditorFilterContainer filterPanel = new BalanceEditorFilterContainer(false);
            filterPanel.getEndDateNode().setInitialTimeSupplier(() -> LocalTime.MAX);
            int countColumns = 0;
            int countFilters = 0;
            if (settings.getDimension1() != null && settings.getDimension1().getType() != null) {
                DimensionWrapper dimensionWrapper1 = new DimensionWrapper(settings.getDimension1());
                dimensionWrapper1.setWidget(dimensionWrapper1.getCategory().createNode(dimensionWrapper1.getClazz()));
                Node dimensionWidget1 = dimensionWrapper1.getWidget();
                if (settings.getDimension1().getType() == DimensionType.ORGANIZATION) {
                    agencyNode = (EntityBoxWidget)dimensionWidget1;
                    agencyNode.setValue(defaultSupplier);
                }
                GridCell cell1 = new GridCell(dimensionWrapper1.getCaption(), dimensionWidget1);
                filterPanel.getCells().add(countFilters++, (Object)cell1);
                ((TableColumn)columns.get(countColumns++)).setText(dimensionWrapper1.getCaption());
                filterPanel.getProperties().put((Object)"dimensionWrapper1", (Object)dimensionWrapper1);
            } else {
                ((TableColumn)columns.get(countColumns++)).setVisible(false);
            }
            if (settings.getDimension2() != null && settings.getDimension2().getType() != null) {
                DimensionWrapper dimensionWrapper2 = new DimensionWrapper(settings.getDimension2());
                dimensionWrapper2.setWidget(dimensionWrapper2.getCategory().createNode(dimensionWrapper2.getClazz()));
                Node dimensionWidget2 = dimensionWrapper2.getWidget();
                if (settings.getDimension2().getType() == DimensionType.ORGANIZATION) {
                    agencyNode = (EntityBoxWidget)dimensionWidget2;
                    agencyNode.setValue(defaultSupplier);
                }
                GridCell cell2 = new GridCell(dimensionWrapper2.getCaption(), dimensionWidget2);
                filterPanel.getCells().add(countFilters++, (Object)cell2);
                ((TableColumn)columns.get(countColumns++)).setText(dimensionWrapper2.getCaption());
                filterPanel.getProperties().put((Object)"dimensionWrapper2", (Object)dimensionWrapper2);
            } else {
                ((TableColumn)columns.get(countColumns++)).setVisible(false);
            }
            if (settings.getDimension3() != null && settings.getDimension3().getType() != null) {
                DimensionWrapper dimensionWrapper3 = new DimensionWrapper(settings.getDimension3());
                dimensionWrapper3.setWidget(dimensionWrapper3.getCategory().createNode(dimensionWrapper3.getClazz()));
                Node dimensionWidget3 = dimensionWrapper3.getWidget();
                if (settings.getDimension3().getType() == DimensionType.ORGANIZATION) {
                    agencyNode = (EntityBoxWidget)dimensionWidget3;
                    agencyNode.setValue(defaultSupplier);
                }
                GridCell cell3 = new GridCell(dimensionWrapper3.getCaption(), dimensionWidget3);
                filterPanel.getCells().add(countFilters++, (Object)cell3);
                ((TableColumn)columns.get(countColumns)).setText(dimensionWrapper3.getCaption());
                filterPanel.getProperties().put((Object)"dimensionWrapper3", (Object)dimensionWrapper3);
            } else {
                ((TableColumn)columns.get(countColumns)).setVisible(false);
            }
            while (countFilters > 0 && countFilters < 3) {
                filterPanel.getCells().add(countFilters++, (Object)new GridCell((Node)new InfoLabelWidget()));
            }
            return filterPanel;
        }, false);
        this.getFilteringPane().getProperties().put((Object)"ref", ref);
        this.getFilteringPane().getProperties().put((Object)"balanceEditorFullPanel", (Object)balanceEditor);
    }

    protected int getLimit() {
        return 40;
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void reloadData(int newOffset, List<Pair<String, SortOrder>> sorting) {
        Notifications.get().submitTask(() -> {
            Object valueDimension3;
            DimensionWrapper dimensionWrapper3;
            Object valueDimension2;
            DimensionWrapper dimensionWrapper2;
            Object valueDimension1;
            HashMap<FinanceHelper.Dimension, String> dimensions = new HashMap<FinanceHelper.Dimension, String>();
            FinanceServiceProperties props = new FinanceServiceProperties();
            DimensionWrapper dimensionWrapper1 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper1");
            if (dimensionWrapper1 != null && (valueDimension1 = dimensionWrapper1.getCategory().getValue(dimensionWrapper1.getWidget())) != null) {
                DimensionType type = dimensionWrapper1.getDimensionSettings().getType();
                String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension1);
                dimensions.put(FinanceHelper.Dimension.DIMENSION_1, value);
                if (type == DimensionType.ORGANIZATION) {
                    props.setCreditorForSearch((EntityReference)valueDimension1);
                }
            }
            if ((dimensionWrapper2 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper2")) != null && (valueDimension2 = dimensionWrapper2.getCategory().getValue(dimensionWrapper2.getWidget())) != null) {
                DimensionType type = dimensionWrapper2.getDimensionSettings().getType();
                String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension2);
                dimensions.put(FinanceHelper.Dimension.DIMENSION_2, value);
                if (type == DimensionType.ORGANIZATION) {
                    props.setCreditorForSearch((EntityReference)valueDimension2);
                }
            }
            if ((dimensionWrapper3 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper3")) != null && (valueDimension3 = dimensionWrapper3.getCategory().getValue(dimensionWrapper3.getWidget())) != null) {
                DimensionType type = dimensionWrapper3.getDimensionSettings().getType();
                String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension3);
                dimensions.put(FinanceHelper.Dimension.DIMENSION_3, value);
                if (type == DimensionType.ORGANIZATION) {
                    props.setCreditorForSearch((EntityReference)valueDimension3);
                }
            }
            props.setAccountsElementEntityReference((EntityReference)this.getFilteringPane().getProperties().get((Object)"ref"));
            props.setOffset(newOffset);
            props.setLimit(this.getLimit());
            LocalDateTime dateTemp = ((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getEndDateNode().getValue();
            LocalDateTime endDate = null;
            if (dateTemp != null) {
                LocalTime localTime = LocalTime.of(dateTemp.toLocalTime().getHour(), dateTemp.toLocalTime().getMinute(), 59, 999999999);
                endDate = LocalDateTime.of(dateTemp.toLocalDate(), localTime);
            }
            props.setEndDate(DateUtils.asDate(endDate));
            props.setStartDate(DateUtils.asDate((LocalDateTime)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getStartDateNode().getValue()));
            props.setCalculationDateStart(DateUtils.asDate((LocalDateTime)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getCalcuationDateStartNode().getValue()));
            props.setCalculationDateEnd(DateUtils.asDate((LocalDateTime)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getCalcuationDateEndNode().getValue()));
            props.setShowHistoricalTransactions(((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getIsHistoricalNode().getValue());
            for (int i = 0; i < sorting.size(); ++i) {
                if (!((String)((Pair)sorting.get(i)).getKey()).equals("debit") && !((String)((Pair)sorting.get(i)).getKey()).equals("credit")) continue;
                sorting.set(i, new Pair((Object)"amount", ((Pair)sorting.get(i)).getValue()));
            }
            props.getSorting().addAll(sorting.stream().map(pair -> MiscUtil.Pair.of((Object)pair.getKey(), (Object)pair.getValue())).collect(Collectors.toList()));
            props.getDimensions().putAll(dimensions);
            FinanceServiceResult result = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadTransactionAndBalanceForEditor(ServiceInvocationContext.get(), props);
            FxUtil.waitForFxThread(() -> {
                this.fillingBalancePanel(result);
                this.offset = result.getOffset();
                this.getData().setAll(this.filingDataView(result));
            });
        }, this.getMutex());
    }

    private void fillingBalancePanel(FinanceServiceResult result) {
        BalanceEditorBalanceSummaryPanel balancePanel = (BalanceEditorBalanceSummaryPanel)((BalanceEditorFullPanel)this.getFilteringPane().getProperties().get((Object)"balanceEditorFullPanel")).getBalanceSummaryCard().getContent();
        balancePanel.getBalanceAmountNode().getBalanceAmountValueNode().setValue((Number)result.getBalanceAmount());
        if (!MiscUtil.equals((Object)result.getBalanceAmount(), (Object)result.getBalanceAmountNoHistorical())) {
            balancePanel.getBalanceAmountNode().getBalanceAmountValueNoHistoricalCell().setHidden(false);
            balancePanel.getBalanceAmountNode().getBalanceAmountValueNoHistoricalNode().setValue((Number)result.getBalanceAmountNoHistorical());
        } else {
            balancePanel.getBalanceAmountNode().getBalanceAmountValueNoHistoricalCell().setHidden(true);
        }
        balancePanel.getCreditAmountNode().getCreditAmountValueNode().setValue((Number)result.getCreditAmount());
        balancePanel.getDebitAmountNode().getDebitAmountValueNode().setValue((Number)result.getDebitAmount());
        balancePanel.getEndDateBalanceAmountNode().getEndDateBalanceAmountValueNode().setValue((Number)result.getEndDateBalanceAmount());
        balancePanel.getStartDateBalanceAmountNode().getStartDateBalanceAmountValueNode().setValue((Number)result.getStartDateBalanceAmount());
        String creditAmountFromSupplier = null;
        String availableAmount = null;
        if (result.isUnlimited()) {
            creditAmountFromSupplier = Character.toString('\u221e');
            availableAmount = Character.toString('\u221e');
        } else if (result.getCreditAmountFromSupplier() != null) {
            DecimalFormat format = LocaleManager.get().getLocaleData(LocaleManager.get().getCurrentLocale()).getPriceFormat();
            format.setParseBigDecimal(true);
            creditAmountFromSupplier = format.format(result.getCreditAmountFromSupplier());
            availableAmount = format.format(result.getAvailableAmount());
        }
        balancePanel.getAddCreditFromSupplierNode().getCreditAmountFromSupplierNode().setValue(creditAmountFromSupplier != null ? creditAmountFromSupplier : "\u2014");
        balancePanel.getAddCreditFromSupplierNode().getAvailableAmountNode().setValue(availableAmount != null ? availableAmount : "\u2014");
    }

    private List<BalanceDataVM> filingDataView(FinanceServiceResult result) {
        ArrayList<BalanceDataVM> resultVM = new ArrayList<BalanceDataVM>();
        result.getTransactionData().forEach(data -> {
            DimensionWrapper dimensionWrapper3;
            DimensionWrapper dimensionWrapper2;
            BalanceDataVM vm = new BalanceDataVM();
            DimensionWrapper dimensionWrapper1 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper1");
            if (dimensionWrapper1 != null) {
                vm.setDimension1(BalanceEditorFilterableDataViewHandler.getStringFromObject(data.getDimensionValue1(), dimensionWrapper1.getDimensionSettings().getType()));
            }
            if ((dimensionWrapper2 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper2")) != null) {
                vm.setDimension2(BalanceEditorFilterableDataViewHandler.getStringFromObject(data.getDimensionValue2(), dimensionWrapper2.getDimensionSettings().getType()));
            }
            if ((dimensionWrapper3 = (DimensionWrapper)((BalanceEditorFilterContainer)this.getFilteringPane().getContent()).getProperties().get((Object)"dimensionWrapper3")) != null) {
                vm.setDimension3(BalanceEditorFilterableDataViewHandler.getStringFromObject(data.getDimensionValue3(), dimensionWrapper3.getDimensionSettings().getType()));
            }
            if (data.isCredit()) {
                vm.setCredit((String)StandardRenderers.PRICE.apply((Object)data.getTransactionSum()));
            } else {
                vm.setDebit((String)StandardRenderers.PRICE.apply((Object)data.getTransactionSum()));
            }
            if (data.getTransactionDate() != null) {
                vm.setOperationDate((String)StandardRenderers.DATE_TIME.apply((Object)data.getTransactionDate()));
            }
            vm.setDescription(data.getDescription());
            if (data.getCalculationDate() != null) {
                vm.setCalculationDate((String)StandardRenderers.DATE_TIME.apply((Object)data.getCalculationDate()));
            }
            vm.setHistorical(data.isHistorical() ? Messages.Yes : "");
            vm.setOperationDateValue(data.getTransactionDate());
            vm.setTransactionReference(data.getTransactionReference());
            vm.setDimensionValue1(data.getDimensionValue1());
            vm.setDimensionValue2(data.getDimensionValue2());
            vm.setDimensionValue3(data.getDimensionValue3());
            resultVM.add(vm);
        });
        return resultVM;
    }

    public static String getStringFromObject(Object value, DimensionType type) {
        switch (type) {
            case PAYMENT_TYPE: 
            case CONTRACT_TYPE: {
                if (value == null) break;
                return value.toString();
            }
            case ORGANIZATION: 
            case SALES_POINT: 
            case AGENT: 
            case CASH: 
            case CASH_REGISTER: 
            case CASH_REGISTER_WORKPLACE: {
                if (value == null) break;
                return ((EntityReference)value).getCaption();
            }
            default: {
                return String.format("for dimension type: %s, not found view", type);
            }
        }
        return "";
    }
}

