/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.client.fx.standard.renderer.StandardValueRenderers;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.finance.DimensionSettings;
import com.gridnine.xtrip.common.model.profile.Cash;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import javafx.scene.Node;

public class DimensionWrapper {
    private DimensionSettings dimensionSettings;
    private Node widget;
    private String caption;
    private StandardValueRenderers category;
    private Class clazz;

    public Node getWidget() {
        return this.widget;
    }

    public void setWidget(Node widget) {
        if (this.clazz == PaymentType.class) {
            ((ComboBoxWidget)widget).setItemsSupplier(() -> Prefetched.getData().getAvailablePaymentTypes());
        }
        if (this.clazz == Person.class) {
            ((EntityBoxWidget)widget).setListParametersSupplier(() -> {
                EntityIndexHandler handler = EntityIndexHandler.forId((String)PersonIndex.class.getName());
                IndexListParameters listParameters = handler.createListParameters();
                listParameters.getSearchCriterions().add(SearchCriterion.not((SearchCriterion)SearchCriterion.containsOnly((String)PersonIndex.Property.types.name(), (String)PersonType.PASSENGER.name())));
                return listParameters;
            });
        }
        this.widget = widget;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public StandardValueRenderers getCategory() {
        return this.category;
    }

    public String getCaption() {
        return this.caption;
    }

    public DimensionSettings getDimensionSettings() {
        return this.dimensionSettings;
    }

    public DimensionWrapper(DimensionSettings dimensionSettings) {
        this.dimensionSettings = dimensionSettings;
        this.fillingStandardValueRenderersAndCaption();
    }

    private void fillingStandardValueRenderersAndCaption() {
        switch (this.dimensionSettings.getType()) {
            case PAYMENT_TYPE: {
                this.caption = Messages.Dimension_payment_type;
                this.category = StandardValueRenderers.ENUM;
                this.clazz = PaymentType.class;
                break;
            }
            case CONTRACT_TYPE: {
                this.caption = Messages.Dimension_contract_type;
                this.category = StandardValueRenderers.ENUM;
                this.clazz = ContractType.class;
                break;
            }
            case ORGANIZATION: {
                this.caption = Messages.Dimension_organization;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = Organization.class;
                break;
            }
            case SALES_POINT: {
                this.caption = Messages.Dimension_sales_point;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = SalesPoint.class;
                break;
            }
            case AGENT: {
                this.caption = Messages.Dimension_agent;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = Person.class;
                break;
            }
            case CASH: {
                this.caption = Messages.Dimension_cash;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = Cash.class;
                break;
            }
            case CASH_REGISTER: {
                this.caption = Messages.Dimension_cash_register;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = CashRegister.class;
                break;
            }
            case CASH_REGISTER_WORKPLACE: {
                this.caption = Messages.Dimension_cash_register_workplace;
                this.category = StandardValueRenderers.ENTITY;
                this.clazz = CashRegisterWorkplace.class;
                break;
            }
            default: {
                throw Xeption.forDeveloper((String)String.format("for dimension type: %s, not found view", this.dimensionSettings.getType()), (Object[])new Object[0]);
            }
        }
    }
}

