/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconIntention;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconNode;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.IconShape;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconIntentions;
import com.gridnine.xtrip.client.fx.core.lib.components.icon.StandardIconShapes;
import com.gridnine.xtrip.client.fx.core.lib.components.tree.SortableCheckBoxTreeItem;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.model.export.TreeDataWrapper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import javafx.css.Styleable;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.control.cell.CheckBoxTreeCell;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.util.Callback;

public class ExportSettingsCheckBoxTreeWidget
extends CustomWidget<TreeDataWrapper> {
    private final ViewState viewState = new ViewState();
    private TreeView<TreeDataWrapper> treeView = new TreeView();
    private SortableCheckBoxTreeItem<TreeDataWrapper> rootItem;
    private GridPane treePane;
    private boolean isChanged;
    private TreeDataWrapper model;
    private TreeDataWrapper savedModel;

    public void setFieldName(String value) {
    }

    public void readData(TreeDataWrapper model) {
        this.model = model;
        try {
            this.savedModel = (TreeDataWrapper)XCloneHelper.clone((XCloneable)model, (boolean)true);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
        }
        this.createWidget(model);
        this.selectSelectedSettings((ObservableList<TreeItem<TreeDataWrapper>>)this.rootItem.getChildren());
        ((TreeDataWrapper)this.rootItem.getValue()).getSettings().setExported(model.getSettings().isExported());
    }

    public void writeData(TreeDataWrapper model) {
        model.getSettings().setName(((TreeDataWrapper)this.rootItem.getValue()).getSettings().getName());
        if (this.selectSelectedSettings((ObservableList<TreeItem<TreeDataWrapper>>)this.rootItem.getChildren())) {
            model.getSettings().setExported(true);
        } else {
            model.getSettings().setExported(false);
        }
        VMHelper.transfer(this.model.getChildren(), model.getChildren());
    }

    public boolean isDataChanged() {
        if (this.model.getSettings().isExported() != this.savedModel.getSettings().isExported()) {
            return true;
        }
        this.isChanged = false;
        if (this.selectSelectedSettings((ObservableList<TreeItem<TreeDataWrapper>>)this.rootItem.getChildren())) {
            this.model.getSettings().setExported(true);
        } else {
            this.model.getSettings().setExported(false);
        }
        this.checkDataChanged(this.model, this.savedModel);
        return this.isChanged;
    }

    private void checkDataChanged(TreeDataWrapper model, TreeDataWrapper savedModel) {
        if (this.isChanged || model.getSettings().isExported() != savedModel.getSettings().isExported()) {
            this.isChanged = true;
            return;
        }
        for (TreeDataWrapper newModel : model.getChildren()) {
            for (TreeDataWrapper saved : savedModel.getChildren()) {
                if (!newModel.getSettings().getName().equals(saved.getSettings().getName())) continue;
                if (newModel.getSettings().isExported() != saved.getSettings().isExported()) {
                    this.isChanged = true;
                    return;
                }
                this.checkDataChanged(newModel, saved);
            }
        }
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public boolean selectSelectedSettings(ObservableList<TreeItem<TreeDataWrapper>> parent) {
        boolean hasSelectedChild = false;
        for (TreeItem child : parent) {
            if (this.selectSelectedSettings((ObservableList<TreeItem<TreeDataWrapper>>)child.getChildren()) || ((SortableCheckBoxTreeItem)child).isSelected()) {
                ((TreeDataWrapper)child.getValue()).getSettings().setExported(true);
                hasSelectedChild = true;
                continue;
            }
            ((TreeDataWrapper)child.getValue()).getSettings().setExported(false);
        }
        return hasSelectedChild;
    }

    public ExportSettingsCheckBoxTreeWidget(boolean ro) {
    }

    public void createWidget(TreeDataWrapper root) {
        this.treeView = new TreeView();
        this.treeView.getStyleClass().add((Object)"xtrip-tree-view");
        this.treeView.setShowRoot(true);
        this.treeView.setCellFactory((Callback)new Callback<TreeView<TreeDataWrapper>, TreeCell<TreeDataWrapper>>(){

            public TreeCell<TreeDataWrapper> call(TreeView<TreeDataWrapper> param) {
                return new ExportCheckBoxTreeCell<TreeDataWrapper>(){

                    @Override
                    protected String getTitle(TreeDataWrapper v) {
                        return ExportSettingsCheckBoxTreeWidget.this.getNodeTitle(v);
                    }
                };
            }
        });
        this.treePane = new GridPane();
        UiUtil.gridPosition((GridPane)this.treePane, this.treeView).col(0).row(0).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        this.rootItem = new SortableCheckBoxTreeItem();
        this.rootItem.setValue((Object)root);
        this.rootItem.setSelected(root.getSettings().isExported());
        this.rootItem.setComparator(this.getComparator());
        this.treeView.setRoot(this.rootItem);
        UiUtil.expand(this.treeView);
        this.populate(this.rootItem, this.getNodeChildren(root));
        this.getChildren().clear();
        this.getChildren().add((Object)this.treePane);
    }

    private void populate(SortableCheckBoxTreeItem<TreeDataWrapper> parent, Collection<TreeDataWrapper> children) {
        for (TreeDataWrapper child : children) {
            if (child == null) continue;
            SortableCheckBoxTreeItem item = new SortableCheckBoxTreeItem();
            item.setValue((Object)child);
            item.setSelected(child.getSettings().isExported());
            parent.add((TreeItem)item);
            this.populate((SortableCheckBoxTreeItem<TreeDataWrapper>)item, this.getNodeChildren(child));
        }
    }

    protected Comparator<TreeItem<TreeDataWrapper>> getComparator() {
        return MiscUtil.comparator(item -> (TreeDataWrapper)item.getValue(), (Comparator)new Comparator<TreeDataWrapper>(){

            @Override
            public int compare(TreeDataWrapper o1, TreeDataWrapper o2) {
                if (o1.equals((Object)o2)) {
                    return 0;
                }
                if (ExportSettingsCheckBoxTreeWidget.this.getNodeId(o1) == null) {
                    return ExportSettingsCheckBoxTreeWidget.this.getNodeId(o2) == null ? 0 : -1;
                }
                if (ExportSettingsCheckBoxTreeWidget.this.getNodeId(o2) == null) {
                    return ExportSettingsCheckBoxTreeWidget.this.getNodeId(o1) == null ? 0 : 1;
                }
                return MiscUtil.compare((Comparable)((Object)ExportSettingsCheckBoxTreeWidget.this.getNodeTitle(o1)), (Comparable)((Object)ExportSettingsCheckBoxTreeWidget.this.getNodeTitle(o2)));
            }
        });
    }

    protected List<TreeDataWrapper> getNodeChildren(TreeDataWrapper v) {
        return v.getChildren();
    }

    protected String getNodeTitle(TreeDataWrapper v) {
        StringBuilder str = new StringBuilder();
        str.append(v.getDoc()).append(" (").append(v.getSettings().getName()).append(")");
        return str.toString();
    }

    protected String getNodeId(TreeDataWrapper v) {
        return v.getSettings().getUid();
    }

    public class ExportCheckBoxTreePane
    extends StackPane {
        private final CheckBox selectedCheckBox = new CheckBox();
        private final Label titleLabel;
        private final IconNode rulerButtonIcon;

        ExportCheckBoxTreePane() {
            this.selectedCheckBox.getStyleClass().add((Object)"selected-check-box");
            this.titleLabel = new Label();
            this.titleLabel.getStyleClass().add((Object)"title-label");
            this.rulerButtonIcon = new IconNode((IconShape)StandardIconShapes.RULER_14X14, (Styleable)this, (IconIntention)StandardIconIntentions.RULER_BUTTON_ACTION, (Styleable)this);
            GridPane containerPane = new GridPane();
            containerPane.getStyleClass().add((Object)"container-pane");
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.selectedCheckBox).col(0).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.titleLabel).col(1).row(0).hAlignment(HPos.LEFT).hGrow(Priority.ALWAYS).vGrow(Priority.NEVER).place();
            UiUtil.gridPosition((GridPane)containerPane, (Node)this.rulerButtonIcon).col(2).row(0).hAlignment(HPos.LEFT).hGrow(Priority.NEVER).vGrow(Priority.NEVER).place();
            this.getChildren().addAll((Object[])new Node[]{containerPane});
        }

        CheckBox getSelectedCheckBox() {
            return this.selectedCheckBox;
        }

        Label getTitleLabel() {
            return this.titleLabel;
        }

        IconNode getRulerButtonIcon() {
            return this.rulerButtonIcon;
        }

        void setExpanded(boolean value) {
            this.pseudoClassStateChanged(Styles.EXPANDED_PSEUDOCLASS, value);
        }
    }

    public abstract class ExportCheckBoxTreeCell<V>
    extends CheckBoxTreeCell<V> {
        private ExportCheckBoxTreePane pane;
        private BooleanProperty selectedProperty;

        public void updateItem(V value, boolean empty) {
            super.updateItem(value, empty);
            this.setDisclosureNode(null);
            CheckBoxTreeItem item = (CheckBoxTreeItem)this.getTreeItem();
            if (!empty) {
                if (this.pane == null) {
                    this.pane = new ExportCheckBoxTreePane();
                    this.pane.getSelectedCheckBox().setDisable(ExportSettingsCheckBoxTreeWidget.this.viewState.isImmutable());
                    this.setOnMousePressed(event -> {
                        this.getTreeItem().setExpanded(!this.getTreeItem().isExpanded());
                        event.consume();
                    });
                }
                if (this.selectedProperty != null) {
                    this.pane.getSelectedCheckBox().selectedProperty().unbindBidirectional((Property)this.selectedProperty);
                }
                if (item != null) {
                    this.selectedProperty = item.selectedProperty();
                    this.pane.getSelectedCheckBox().selectedProperty().bindBidirectional((Property)this.selectedProperty);
                }
                this.pane.getTitleLabel().setText(value != null ? this.getTitle(value) : null);
                UiUtil.setHidden((Node)this.pane.getRulerButtonIcon(), (item == null || item.isLeaf() ? 1 : 0) != 0);
                this.setGraphic((Node)this.pane);
            } else {
                this.setGraphic(null);
            }
            this.setText(null);
        }

        protected abstract String getTitle(V var1);
    }
}

