/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomComboBox;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsSupport;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.BaseNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.NavigatorViewType;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.StandardViewTypeProvider;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.util.StringConverter;

public class ReservationViewTypeProvider
extends StandardViewTypeProvider {
    protected ReservationViewTypeProvider(BaseNavigatorWidget owner) {
        super(owner);
    }

    public void accept(Consumer<NavigatorViewType> resultConsumer) {
        List availableValues = this.getTypes();
        if (availableValues.isEmpty()) {
            return;
        }
        if (availableValues.size() == 1) {
            resultConsumer.accept((NavigatorViewType)availableValues.get(0));
            return;
        }
        availableValues.sort((o1, o2) -> TextUtil.compare((String)o1.getDisplayName(), (String)o2.getDisplayName(), (boolean)true, (boolean)false));
        CustomComboBox comboBox = new CustomComboBox();
        comboBox.setConverter((StringConverter)new StringConverter<NavigatorViewType>(){

            public String toString(NavigatorViewType object) {
                return object == null ? "" : object.getDisplayName();
            }

            public NavigatorViewType fromString(String string) {
                return null;
            }
        });
        comboBox.getItems().setAll((Collection)availableValues);
        comboBox.setValue(availableValues.get(0));
        if (this.widget.isSuggestionsEnabled()) {
            SuggestionsSupport.installSuggestions((ComboBox)comboBox, (SuggestionsHandler)new SimpleSuggestionsHandler((ComboBox)comboBox, false));
        }
        GridCell comboBoxCell = new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Product_Type, (Node)comboBox);
        BooleanValueWidget sameReservationWidget = new BooleanValueWidget(false, false);
        sameReservationWidget.setConverter(Converters.boolConverter((String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Current_booking, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.New_booking));
        GridCell sameReservationCell = new GridCell(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Location_of_the_new_ticket, (Node)sameReservationWidget);
        GridContainer container = new GridContainer(1);
        container.setStyle("-fx-pref-width: 30em;");
        container.getCells().addAll((Object[])new GridCell[]{comboBoxCell, sameReservationCell});
        String selectedProductUid = this.widget.getSelectedView() == null ? null : (String)this.widget.getSelectedView().getProperties().get((Object)"model-uid");
        BaseProduct currentProduct = null;
        if (TextUtil.nonBlank(selectedProductUid)) {
            BookingFile booking = (BookingFile)RootEntityPane.lookup((Node)this.widget).getData().getContainer().getEntity();
            currentProduct = BookingHelper.findProduct((BookingFile)booking, (String)selectedProductUid);
        }
        Reservation currentReservation = currentProduct == null ? null : currentProduct.getReservation();
        new Dialog().setTitle(TextUtil.isBlank((String)this.widget.getFieldName()) ? Messages.General_Choose_object_type : this.widget.getFieldName()).setBody((Node)container).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.General_Choose, () -> {
            NavigatorViewType value = (NavigatorViewType)comboBox.getValue();
            if (sameReservationWidget.getValue()) {
                value.getCustomData().put("reservation", currentReservation);
            }
            if (value != null) {
                resultConsumer.accept(value);
            }
        }).show((Node)this.widget);
        FxUtil.submitToFxThread(() -> ((CustomComboBox)comboBox).requestFocus());
    }
}

