/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.editor.DictEditorPane;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.DictEditingService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ModelCheckUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.demo.EditorTester;
import com.gridnine.xtrip.client.fx.standard.dicts.DictEditorActivityHandler;
import com.gridnine.xtrip.common.fx.rpc.DictQuery;
import com.gridnine.xtrip.common.fx.rpc.DictService;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.Identity;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class DictEditorTester
implements EditorTester {
    private final DictHandler<?> handler;

    static void collectAll(List<EditorTester> result) {
        ClientRegistry.get().allOf(DictHandler.TYPE).values().stream().map(h -> new DictEditorTester((DictHandler<?>)h)).collect(Collectors.toCollection(() -> result));
    }

    private DictEditorTester(DictHandler<?> h) {
        this.handler = h;
    }

    public String toString() {
        return "DICT: " + DictHandler.format(this.handler);
    }

    @Override
    public List<?> loadTestObjects(int limit) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        DictService dictService = (DictService)RpcServiceManager.get().getService(DictService.class);
        List searchResult = dictService.search(sic, this.handler.getDictType(), new DictQuery());
        Collections.shuffle(searchResult);
        return searchResult.stream().limit(limit).map(item -> item.getReference()).collect(Collectors.toList());
    }

    @Override
    public void doTest(Object obj) throws Exception {
        DictionaryReference ref = (DictionaryReference)obj;
        String token = DictEditorActivityHandler.buildToken(this.handler, ref.getCode());
        FxUtil.waitForFxThread(() -> DictEditingService.get().open(ref));
        boolean close = true;
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            ValueHolder editorPane = new ValueHolder();
            FxUtil.waitForFxThread(() -> ActivityManager.get().find(token, true, node -> editorPane.set((Object)((DictEditorPane)node))));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (editorPane.get() == null || ((DictEditorPane)editorPane.get()).getMutex().isAcquired() || ((DictEditorPane)editorPane.get()).getData() == null) {
                Thread.sleep(333L);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            Thread.sleep(1000L);
            BaseDictionary data1 = ((DictEditorPane)editorPane.get()).getData();
            ValueHolder dataChanged = new ValueHolder();
            FxUtil.waitForFxThread(() -> dataChanged.set((Object)((DictEditorPane)editorPane.get()).isDataChanged()));
            if (((Boolean)dataChanged.get()).booleanValue()) {
                throw Xeption.forDeveloper((String)"\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0441\u0440\u0430\u0431\u043e\u0442\u0430\u043b \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435", (Object[])new Object[0]);
            }
            ((DictEditorPane)editorPane.get()).saveData();
            Thread.sleep(1000L);
            BaseDictionary data2 = ((DictEditorPane)editorPane.get()).getData();
            ModelCheckUtil.compare((Identity)data1, (Identity)data2);
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            close = false;
            throw e;
        }
        finally {
            if (close) {
                FxUtil.waitForFxThread(() -> ActivityManager.get().remove(token, true));
            }
        }
    }
}

