/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.ModelCheckUtil;
import com.gridnine.xtrip.client.fx.standard.demo.DictEditorTester;
import com.gridnine.xtrip.client.fx.standard.demo.EditorTester;
import com.gridnine.xtrip.client.fx.standard.demo.RootEntityEditorTester;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;

class EditorsTesterTask
extends ClientTask {
    private final EditorTester tester;
    private final int objectsNumber;

    static void showSettingsDialog() {
        final ComboBoxWidget handlerWidget = new ComboBoxWidget(false);
        handlerWidget.setNoNulls(true);
        handlerWidget.setItemsSupplier(() -> {
            ArrayList<EditorTester> result = new ArrayList<EditorTester>();
            DictEditorTester.collectAll(result);
            RootEntityEditorTester.collectAll(result);
            return result;
        });
        handlerWidget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(handlerWidget.getConverter(), handlerWidget.getItemsSupplier(), handlerWidget.isSortItems()));
        final IntValueWidget objectsNumberWidget = new IntValueWidget(false);
        objectsNumberWidget.setDefaultValue((Number)10);
        GridContainer ctr = new GridContainer(1);
        ctr.getCells().addAll((Object[])new GridCell[]{new GridCell("\u0422\u0438\u043f \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Node)handlerWidget), new GridCell("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Node)objectsNumberWidget)});
        new Dialog().setTitle("\u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430\u0445").setBody((Node)ctr).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, "\u041d\u0430\u0447\u0430\u0442\u044c \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435", () -> Notifications.get().enqueueAsyncTask((ClientTask)new EditorsTesterTask((EditorTester)handlerWidget.getValue(), (Integer)objectsNumberWidget.getValue())), (BooleanExpression)new BooleanBinding(){
            {
                this.bind(new Observable[]{handlerWidget.valueProperty(), objectsNumberWidget.valueProperty()});
            }

            protected boolean computeValue() {
                return handlerWidget.getValue() != null && (Integer)objectsNumberWidget.getValue() > 0;
            }
        }).showGlobal();
    }

    private EditorsTesterTask(EditorTester t, int n) {
        this.tester = t;
        this.objectsNumber = n;
    }

    protected String getTitle() {
        return "\u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0432 \u0440\u0435\u0434\u0430\u043a\u0442\u043e\u0440\u0430\u0445";
    }

    protected void execute() throws Exception {
        this.addMessages(new Message[]{MessageHelper.createMessage((String)"\u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0442\u0438\u043f\u0430 {0}", (Object[])new Object[]{this.tester})});
        this.setProgress((byte)-1, "\u041f\u043e\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430 \u043a \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044e \u0442\u0435\u0441\u0442\u043e\u0432");
        List<?> testObjects = this.tester.loadTestObjects(this.objectsNumber);
        this.setProgress((byte)0, "\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
        this.addMessages(new Message[]{MessageHelper.createMessage((String)"\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e {0} \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432 \u0434\u043b\u044f \u0442\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[]{testObjects.size()})});
        int i = 0;
        for (Object obj : testObjects) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            this.setProgress((byte)Math.round((double)i++ * 100.0 / (double)testObjects.size()), "\u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 " + obj);
            this.addMessages(new Message[]{MessageHelper.createMessage((String)"\u0422\u0435\u0441\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 {0}", (Object[])new Object[]{obj})});
            try {
                this.tester.doTest(obj);
            }
            catch (InterruptedException ie) {
                throw ie;
            }
            catch (ModelCheckUtil.MatchFailedException me) {
                this.addMessages(new Message[]{MessageHelper.createErrorMessage((String)me.getPath(), (String)me.getDetails(), (Object[])new Object[0])});
            }
            catch (Exception e) {
                this.addMessages(new Message[]{MessageHelper.createMessage((MessageType)MessageType.ERROR, (String)"\u041e\u0448\u0438\u0431\u043a\u0430 {0}", (String)ErrorHandler.getDetails((Throwable)e), (Object[])new Object[]{e.getMessage()})});
            }
        }
    }
}

