/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionSession;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.DictionaryCollection;
import com.gridnine.xtrip.common.meta.DictionaryProperty;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityCollection;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.EnumItem;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.IndexCollection;
import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.Property;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.util.StringConverter;

class MetaRegistryBrowserPane
extends GridContainer {
    MetaRegistryBrowserPane() {
        super(1);
        final List<RegistryItem> items = MetaRegistryBrowserPane.getRegistryItems();
        ComboBoxWidget itemsWidget = new ComboBoxWidget(false);
        itemsWidget.setSortItems(false);
        itemsWidget.setItemsSupplier(() -> items);
        itemsWidget.setConverter((StringConverter)new StringConverter<RegistryItem>(){

            public String toString(RegistryItem object) {
                return object == null ? null : object.getDisplayName();
            }

            public RegistryItem fromString(String string) {
                return null;
            }
        });
        itemsWidget.setSuggestionsHandler((SuggestionsHandler)new SuggestionsHandler<RegistryItem>(){

            public void startSession(SuggestionSession<RegistryItem> session) {
                String text = session.getUserText();
                if (TextUtil.isBlank((String)text)) {
                    session.setSuggestions(Collections.emptyList());
                    return;
                }
                String pattern = text.trim().toLowerCase(Locale.ROOT);
                session.setSuggestions(items.stream().filter(item -> item.getSearchContent().contains(pattern)).limit(25L).collect(Collectors.toList()));
            }

            public boolean isAsync() {
                return false;
            }
        });
        TextAreaWidget detailsWidget = new TextAreaWidget(true);
        detailsWidget.getViewState().setNotEditable(true);
        detailsWidget.setMonospace(true);
        itemsWidget.valueProperty().addListener((s, o, n) -> detailsWidget.setValue(n == null ? null : n.getDetails()));
        this.getCells().add((Object)new GridCell("Registry Item", (Node)itemsWidget));
        this.getCells().add((Object)new GridCell("Item Details", (Node)detailsWidget));
    }

    private static List<RegistryItem> getRegistryItems() {
        ArrayList<RegistryItem> result = new ArrayList<RegistryItem>();
        MetaRegistry mr = MetaRegistry.get();
        mr.getEnums().values().stream().sorted(RegistryItem.COMPARATOR).forEach(et -> {
            result.add(new EnumTypeItem((EnumType)et));
            et.getItems().values().stream().sorted(RegistryItem.COMPARATOR).forEach(ei -> result.add(new EnumTypeItem((EnumType)et, (EnumItem)ei)));
        });
        mr.getDictionaries().values().stream().sorted(RegistryItem.COMPARATOR).forEach(dt -> {
            result.add(new DictTypeItem((DictionaryType)dt));
            dt.getProperties().values().stream().sorted(RegistryItem.COMPARATOR).forEach(prop -> result.add(new DictTypeItem((DictionaryType)dt, (DictionaryProperty)prop)));
            dt.getCollections().values().stream().sorted(RegistryItem.COMPARATOR).forEach(coll -> result.add(new DictTypeItem((DictionaryType)dt, (DictionaryCollection)coll)));
        });
        mr.getEntities().values().stream().sorted(RegistryItem.COMPARATOR).forEach(ett -> {
            result.add(new EntityTypeItem((EntityType)ett));
            ett.getProperties().values().stream().sorted(RegistryItem.COMPARATOR).forEach(prop -> result.add(new EntityTypeItem((EntityType)ett, (Property)prop)));
            ett.getCollections().values().stream().sorted(RegistryItem.COMPARATOR).forEach(coll -> result.add(new EntityTypeItem((EntityType)ett, (EntityCollection)coll)));
        });
        mr.getIndexes().values().stream().sorted(RegistryItem.COMPARATOR).forEach(idt -> {
            result.add(new IndexTypeItem((IndexType)idt));
            idt.getProperties().values().stream().sorted(RegistryItem.COMPARATOR).forEach(prop -> result.add(new IndexTypeItem((IndexType)idt, (IndexProperty)prop)));
            idt.getCollections().values().stream().sorted(RegistryItem.COMPARATOR).forEach(coll -> result.add(new IndexTypeItem((IndexType)idt, (IndexCollection)coll)));
        });
        return result;
    }

    private static class IndexTypeItem
    extends RegistryItem {
        private final IndexType indexType;

        IndexTypeItem(IndexType idt) {
            super((BaseMetaElement)idt, "IDX");
            this.indexType = idt;
        }

        IndexTypeItem(IndexType idt, IndexProperty prop) {
            super((BaseMetaElement)prop, "IDX-PROP");
            this.indexType = idt;
        }

        IndexTypeItem(IndexType idt, IndexCollection coll) {
            super((BaseMetaElement)coll, "IDX-COLL");
            this.indexType = idt;
        }

        @Override
        String getDetails() {
            StringBuilder buf = new StringBuilder();
            buf.append("Index ").append(this.indexType.getId());
            this.appendFlag(buf, this.indexType.isDeprecated(), "deprecated");
            this.appendFlag(buf, this.indexType.isHidden(), "hidden");
            buf.append('\n');
            buf.append("Display name: ").append(this.indexType.getDisplayName()).append('\n');
            buf.append("Sources:\n");
            this.indexType.getSources().forEach(src -> buf.append('\t').append(src).append('\n'));
            buf.append("Entity: ").append(this.indexType.getEntityId()).append('\n');
            if (!this.indexType.getParameters().isEmpty()) {
                buf.append("Parameters:\n");
                this.indexType.getParameters().forEach((name, value) -> buf.append('\t').append((String)name).append(" = ").append((String)value).append('\n'));
            }
            buf.append("Properties:\n");
            this.indexType.getProperties().values().stream().sorted(COMPARATOR).forEach(prop -> {
                buf.append('\t').append(prop.getId()).append(' ').append(prop.getDisplayName());
                this.appendFlag(buf, prop.isDeprecated(), "deprecated");
                this.appendFlag(buf, prop.isViewable(), "viewable");
                this.appendFlag(buf, prop.isFinalProperty(), "final");
                this.appendFlag(buf, prop.isLocalizable(), "localizable");
                this.appendFlag(buf, prop.isAggregated(), "aggregated");
                this.appendFlag(buf, prop.isCached(), "cached");
                this.appendFlag(buf, prop.isDbIndexed(), "DB indexed");
                this.appendFlag(buf, prop.isFilterable(), "filterable");
                this.appendFlag(buf, prop.isSearchable(), "searchable");
                this.appendFlag(buf, prop.isSecured(), "secured");
                this.appendFlag(buf, prop.isSystem(), "system");
                this.appendFlag(buf, prop.isUnique(), "unique");
                buf.append('\n');
            });
            buf.append("Collections:\n");
            this.indexType.getCollections().values().stream().sorted(COMPARATOR).forEach(coll -> {
                buf.append('\t').append(coll.getId()).append(' ').append(coll.getDisplayName());
                this.appendFlag(buf, coll.isDeprecated(), "deprecated");
                this.appendFlag(buf, coll.isViewable(), "viewable");
                this.appendFlag(buf, coll.isAggregated(), "aggregated");
                this.appendFlag(buf, coll.isDbIndexed(), "DB indexed");
                this.appendFlag(buf, coll.isFilterable(), "filterable");
                this.appendFlag(buf, coll.isSearchable(), "searchable");
                this.appendFlag(buf, coll.isSystem(), "system");
                buf.append('\n');
            });
            return buf.toString();
        }
    }

    private static class EntityTypeItem
    extends RegistryItem {
        private final EntityType entityType;

        EntityTypeItem(EntityType ett) {
            super((BaseMetaElement)ett, "ETTY");
            this.entityType = ett;
        }

        EntityTypeItem(EntityType ett, Property prop) {
            super((BaseMetaElement)prop, "ETTY-PROP");
            this.entityType = ett;
        }

        EntityTypeItem(EntityType ett, EntityCollection coll) {
            super((BaseMetaElement)coll, "ETTY-COLL");
            this.entityType = ett;
        }

        @Override
        String getDetails() {
            StringBuilder buf = new StringBuilder();
            buf.append("Entity ").append(this.entityType.getId());
            this.appendFlag(buf, this.entityType.isDeprecated(), "deprecated");
            this.appendFlag(buf, this.entityType.isRoot(), "root");
            this.appendFlag(buf, this.entityType.isAbstract(), "abstract");
            this.appendFlag(buf, this.entityType.isCached(), "cached");
            this.appendFlag(buf, this.entityType.isCachedReference(), "cached reference");
            this.appendFlag(buf, this.entityType.isNestedActualize(), "nested actualize");
            this.appendFlag(buf, this.entityType.isValidatable(), "validatable");
            buf.append('\n');
            buf.append("Display name: ").append(this.entityType.getDisplayName()).append('\n');
            buf.append("Sources:\n");
            this.entityType.getSources().forEach(src -> buf.append('\t').append(src).append('\n'));
            buf.append("Extends: ").append(TextUtil.isBlank((String)this.entityType.getExtendsId()) ? BaseEntity.class.getName() : this.entityType.getExtendsId()).append('\n');
            if (!this.entityType.getInterfaces().isEmpty()) {
                buf.append("Implements:\n");
                this.entityType.getInterfaces().forEach(itf -> buf.append('\t').append((String)itf).append('\n'));
            }
            if (!this.entityType.getParameters().isEmpty()) {
                buf.append("Parameters:\n");
                this.entityType.getParameters().forEach((name, value) -> buf.append('\t').append((String)name).append(" = ").append((String)value).append('\n'));
            }
            buf.append("Properties:\n");
            this.entityType.getProperties().values().stream().sorted(COMPARATOR).forEach(prop -> {
                buf.append('\t').append(prop.getId()).append(' ').append(prop.getDisplayName());
                this.appendFlag(buf, prop.isDeprecated(), "deprecated");
                this.appendFlag(buf, prop.isViewable(), "viewable");
                this.appendFlag(buf, prop.isReadonly(), "readonly");
                this.appendFlag(buf, prop.isPrivateField(), "private");
                this.appendFlag(buf, prop.isHistorical(), "historical");
                this.appendFlag(buf, prop.isPeriodical(), "periodical");
                this.appendFlag(buf, prop.isFinalProperty(), "final");
                this.appendFlag(buf, prop.isLocalizable(), "localizable");
                this.appendFlag(buf, prop.isReference(), "reference");
                buf.append('\n');
            });
            buf.append("Collections:\n");
            this.entityType.getCollections().values().stream().sorted(COMPARATOR).forEach(coll -> {
                buf.append('\t').append(coll.getId()).append(' ').append(coll.getDisplayName());
                this.appendFlag(buf, coll.isDeprecated(), "deprecated");
                this.appendFlag(buf, coll.isViewable(), "viewable");
                this.appendFlag(buf, coll.isKeyReference(), "key reference");
                this.appendFlag(buf, coll.isReference(), "reference");
                this.appendFlag(buf, coll.isNullable(), "nullable");
                this.appendFlag(buf, coll.isPrivateCollection(), "private");
                buf.append('\n');
            });
            return buf.toString();
        }
    }

    private static class DictTypeItem
    extends RegistryItem {
        private final DictionaryType dictType;

        DictTypeItem(DictionaryType dt) {
            super((BaseMetaElement)dt, "DICT");
            this.dictType = dt;
        }

        DictTypeItem(DictionaryType dt, DictionaryProperty prop) {
            super((BaseMetaElement)prop, "DICT-PROP");
            this.dictType = dt;
        }

        DictTypeItem(DictionaryType dt, DictionaryCollection coll) {
            super((BaseMetaElement)coll, "DICT-COLL");
            this.dictType = dt;
        }

        @Override
        String getDetails() {
            StringBuilder buf = new StringBuilder();
            buf.append("Dictionary ").append(this.dictType.getId());
            this.appendFlag(buf, this.dictType.isDeprecated(), "deprecated");
            this.appendFlag(buf, this.dictType.isAbstract(), "abstract");
            this.appendFlag(buf, this.dictType.isInternal(), "internal");
            this.appendFlag(buf, this.dictType.isRemote(), "remote");
            buf.append('\n');
            buf.append("Display name: ").append(this.dictType.getDisplayName()).append('\n');
            buf.append("Sources:\n");
            this.dictType.getSources().forEach(src -> buf.append('\t').append(src).append('\n'));
            buf.append("Extends: ").append(TextUtil.isBlank((String)this.dictType.getExtendsId()) ? BaseDictionary.class.getName() : this.dictType.getExtendsId()).append('\n');
            if (!this.dictType.getInterfaces().isEmpty()) {
                buf.append("Implements:\n");
                this.dictType.getInterfaces().forEach(itf -> buf.append('\t').append((String)itf).append('\n'));
            }
            if (!this.dictType.getParameters().isEmpty()) {
                buf.append("Parameters:\n");
                this.dictType.getParameters().forEach((name, value) -> buf.append('\t').append((String)name).append(" = ").append((String)value).append('\n'));
            }
            if (!TextUtil.isBlank((String)this.dictType.getProviderId())) {
                buf.append("Provider: ").append(this.dictType.getProviderId()).append('\n');
            }
            if (!this.dictType.getDisabledInModules().isEmpty()) {
                buf.append("Disabled in:\n");
                this.dictType.getDisabledInModules().forEach(name -> buf.append('\t').append((String)name).append('\n'));
            }
            buf.append("Properties:\n");
            this.dictType.getProperties().values().stream().sorted(COMPARATOR).forEach(prop -> {
                buf.append('\t').append(prop.getId()).append(' ').append(prop.getDisplayName());
                this.appendFlag(buf, prop.isDeprecated(), "deprecated");
                this.appendFlag(buf, prop.isIndexed(), "indexed");
                this.appendFlag(buf, prop.isHistorical(), "historical");
                this.appendFlag(buf, prop.isPeriodical(), "periodical");
                this.appendFlag(buf, prop.isFinalProperty(), "final");
                this.appendFlag(buf, prop.isLocalizable(), "localizable");
                this.appendFlag(buf, prop.isReference(), "reference");
                buf.append('\n');
            });
            buf.append("Collections:\n");
            this.dictType.getCollections().values().stream().sorted(COMPARATOR).forEach(coll -> {
                buf.append('\t').append(coll.getId()).append(' ').append(coll.getDisplayName());
                this.appendFlag(buf, coll.isDeprecated(), "deprecated");
                this.appendFlag(buf, coll.isIndexed(), "indexed");
                this.appendFlag(buf, coll.isViewable(), "viewable");
                this.appendFlag(buf, coll.isKeyReference(), "key reference");
                this.appendFlag(buf, coll.isReference(), "reference");
                this.appendFlag(buf, coll.isNullable(), "nullable");
                this.appendFlag(buf, coll.isPrivateCollection(), "private");
                buf.append('\n');
            });
            return buf.toString();
        }
    }

    private static class EnumTypeItem
    extends RegistryItem {
        private final EnumType enumType;

        EnumTypeItem(EnumType et) {
            super((BaseMetaElement)et, "ENUM");
            this.enumType = et;
        }

        EnumTypeItem(EnumType et, EnumItem itm) {
            super((BaseMetaElement)itm, "ENUM-ITEM");
            this.enumType = et;
        }

        @Override
        String getDetails() {
            StringBuilder buf = new StringBuilder();
            buf.append("Enum ").append(this.enumType.getId());
            this.appendFlag(buf, this.enumType.isDeprecated(), "deprecated");
            this.appendFlag(buf, this.enumType.isSystem(), "system");
            buf.append('\n');
            buf.append("Display name: ").append(this.enumType.getDisplayName()).append('\n');
            buf.append("Items:\n");
            this.enumType.getItems().values().stream().sorted(COMPARATOR).forEach(ei -> {
                buf.append('\t').append(ei.getId()).append(' ').append(ei.getDisplayName());
                this.appendFlag(buf, ei.isDeprecated(), "deprecated");
                buf.append('\n');
            });
            return buf.toString();
        }
    }

    private static abstract class RegistryItem {
        static final Comparator<? super BaseMetaElement> COMPARATOR = Comparator.comparing(RegistryItem::getDisplayName);
        private final String name;
        private String content;

        protected static String getDisplayName(BaseMetaElement elm) {
            String displayName = elm.getDisplayName();
            return TextUtil.isBlank((String)displayName) || displayName.contains(".gridnine.") ? elm.getId() : displayName;
        }

        protected void appendFlag(StringBuilder buf, boolean value, String displayName) {
            if (value) {
                buf.append(" [").append(displayName).append(']');
            }
        }

        RegistryItem(BaseMetaElement elm, String prefix) {
            this.name = '[' + prefix + "] " + RegistryItem.getDisplayName(elm);
            this.content = elm.getId();
            String str = elm.getDisplayName();
            if (!str.contains(".gridnine.")) {
                this.content = this.content + ' ' + str;
            }
            if (!(str = elm.getShortName()).contains(".gridnine.")) {
                this.content = this.content + ' ' + str;
            }
            if ((str = elm.getDescription()) != null && !str.contains(".gridnine.")) {
                this.content = this.content + ' ' + str;
            }
            this.content = this.content.toLowerCase(Locale.ROOT);
        }

        String getDisplayName() {
            return this.name;
        }

        String getSearchContent() {
            return this.content;
        }

        abstract String getDetails();
    }
}

