/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.acl.AppliedAclData;
import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.metadata.MetadataBasedEditor;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.HyperlinkWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.BigTableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.ActionColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.bigtable.column.StringColumn;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionItemVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsEntryVM;
import com.gridnine.xtrip.client.fx.model.sandbox.BaseControlsPanelVM;
import com.gridnine.xtrip.client.fx.model.sandbox.BigTableRowVM;
import com.gridnine.xtrip.client.fx.model.sandbox.SandboxSpaceController;
import com.gridnine.xtrip.client.fx.model.sandbox.SandboxSpaceVM;
import com.gridnine.xtrip.client.fx.model.sandbox.TableRow1VM;
import com.gridnine.xtrip.client.fx.model.sandbox.TableRow2VM;
import com.gridnine.xtrip.client.fx.model.sandbox.TableRow3VM;
import com.gridnine.xtrip.client.fx.model.sandbox.TableRow4VM;
import com.gridnine.xtrip.client.fx.model.sandbox.ValueControlsPanelVM;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.HistoricalValue;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.dict.CountryReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.restriction.helper.RestrictionsHelper;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;

class SandboxPane
extends BaseContentPane {
    private final ObjectProperty<ViewController<?, ?>> controller = new SimpleObjectProperty();
    protected final BooleanProperty readonly = new SimpleBooleanProperty();
    protected final ObservableMutex mutex;
    private final ScrollPane contentPane;
    private final Label titleLabel = new Label("Overview Pane");
    private final Node overviewPane;

    SandboxPane(ObservableMutex mtx) {
        this.mutex = mtx;
        this.getStyleClass().add((Object)"xtrip-editor-pane");
        this.overviewPane = this.buildOverviewPane();
        this.contentPane = new ScrollPane(this.overviewPane);
        this.contentPane.getStyleClass().add((Object)"edge-to-edge");
        this.contentPane.setFitToWidth(true);
        this.contentPane.setFitToHeight(true);
        GridPane headerPane = new GridPane();
        headerPane.getStyleClass().add((Object)"editor-header-pane");
        headerPane.add((Node)this.titleLabel, 0, 0);
        GridPane.setHgrow((Node)this.titleLabel, (Priority)Priority.ALWAYS);
        CheckBoxWidget checkBox = new CheckBoxWidget(false);
        checkBox.setText("read-only mode");
        this.readonly.bind((ObservableValue)checkBox.selectedProperty());
        headerPane.add((Node)checkBox, 1, 0);
        HyperlinkWidget widget = new HyperlinkWidget();
        widget.setText("Overview Pane");
        widget.setOnAction(evt -> {
            this.controller.set(null);
            this.titleLabel.setText("Overview Pane");
            this.contentPane.setContent(this.overviewPane);
        });
        widget.disableProperty().bind((ObservableValue)Bindings.isNull(this.controller));
        headerPane.add((Node)widget, 2, 0);
        this.readonly.addListener((obj, oldValue, newValue) -> {
            ViewController ctr = (ViewController)this.controller.get();
            if (ctr == null) {
                return;
            }
            ctr.setReadonly(newValue.booleanValue());
        });
        this.composePane((Node)this.contentPane, (Node)headerPane, null, null);
    }

    private Node buildOverviewPane() {
        CardsContainer result = new CardsContainer();
        GridContainer ctr = new GridContainer(4);
        ctr.setAdaptive(true);
        HyperlinkWidget widget = new HyperlinkWidget();
        widget.setText("Sandbox Editor Pane");
        widget.setOnAction(evt -> {
            SandboxSpaceController sandboxSpaceController = new SandboxSpaceController(this.readonly.get());
            sandboxSpaceController.readData(this.createSandboxModel());
            this.openEditor("Sandbox Editor Pane", (ViewController<?, ?>)sandboxSpaceController);
        });
        ctr.getCells().add((Object)new GridCell((Node)widget));
        result.getCards().add((Object)new Card("misc", UiCardsContainer.Style.EXPANDED, "Uncategorized Editors", (Node)ctr));
        final BigTableWidget widget2 = new BigTableWidget(true);
        ArrayList<ActionColumn> columns = new ArrayList<ActionColumn>();
        ActionColumn col = new ActionColumn(RootEntityHandler::format);
        col.setId("name");
        col.setCaption("Editor Name");
        col.setActionHandler(evt -> this.openEditor(RootEntityHandler.format((RootEntityHandler)((RootEntityHandler)evt.getItem())), ((RootEntityHandler)evt.getItem()).createEditorController(this.readonly.get())));
        columns.add(col);
        col = new StringColumn(handler -> handler.getClass().getName(), null);
        col.setId("handlerId");
        col.setCaption("Handler Class");
        columns.add(col);
        col = new StringColumn(handler -> handler.getEntityClass().getName(), null);
        col.setId("entityId");
        col.setCaption("Entity Class");
        columns.add(col);
        widget2.setColumns(columns);
        new BigTableWidgetController<BigTableWidget<RootEntityHandler<?, ?>>, RootEntityHandler<?, ?>>(){

            public BigTableWidget<RootEntityHandler<?, ?>> getView() {
                return widget2;
            }
        }.readData((Collection)ClientRegistry.get().allOf(RootEntityHandler.TYPE).values().stream().sorted((lhs, rhs) -> RootEntityHandler.format((RootEntityHandler)lhs).compareTo(RootEntityHandler.format((RootEntityHandler)rhs))).collect(Collectors.toList()));
        Card card = new Card("rootEntity", UiCardsContainer.Style.COLLAPSED, "Root Entity Editors (" + widget2.getRowsCount() + ")", (Node)widget2);
        card.setAdaptiveHeight(true);
        result.getCards().add((Object)card);
        widget2 = new BigTableWidget(true);
        columns = new ArrayList();
        col = new ActionColumn(DictHandler::format);
        col.setId("name");
        col.setCaption("Editor Name");
        col.setActionHandler(evt -> this.openEditor(DictHandler.format((DictHandler)((DictHandler)evt.getItem())), ((DictHandler)evt.getItem()).createEditorController()));
        columns.add(col);
        col = new StringColumn(handler -> handler.getClass().getName(), null);
        col.setId("handlerId");
        col.setCaption("Handler Class");
        columns.add(col);
        col = new StringColumn(handler -> handler.getDictType().getName(), null);
        col.setId("entityId");
        col.setCaption("Dictionary Class");
        columns.add(col);
        widget2.setColumns(columns);
        new BigTableWidgetController<BigTableWidget<DictHandler<?>>, DictHandler<?>>(){

            public BigTableWidget<DictHandler<?>> getView() {
                return widget2;
            }
        }.readData((Collection)ClientRegistry.get().allOf(DictHandler.TYPE).values().stream().sorted((lhs, rhs) -> DictHandler.format((DictHandler)lhs).compareTo(DictHandler.format((DictHandler)rhs))).collect(Collectors.toList()));
        card = new Card("dicts", UiCardsContainer.Style.COLLAPSED, "Dictionary Editors (" + widget2.getRowsCount() + ")", (Node)widget2);
        card.setAdaptiveHeight(true);
        result.getCards().add((Object)card);
        widget2 = new BigTableWidget(true);
        columns = new ArrayList();
        col = new ActionColumn(ett -> ett.getDisplayName());
        col.setId("name");
        col.setCaption("Entity Name");
        col.setActionHandler(evt -> {
            try {
                this.openEditor(((EntityType)evt.getItem()).getDisplayName(), MetadataBasedEditor.createController((EntityType)((EntityType)evt.getItem()), (type, id) -> true));
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"failed creating metadata based editor for {0}", (Throwable)e, (Object[])new Object[]{((EntityType)evt.getItem()).getId()});
            }
        });
        columns.add(col);
        col = new StringColumn(BaseMetaElement::getId, null);
        col.setId("entityId");
        col.setCaption("Entity Class");
        columns.add(col);
        widget2.setColumns(columns);
        new BigTableWidgetController<BigTableWidget<EntityType>, EntityType>(){

            public BigTableWidget<EntityType> getView() {
                return widget2;
            }
        }.readData((Collection)MetaRegistry.get().getEntities().values().stream().filter(ett -> "true".equals(ett.getParameters().get("useMetadataBasedSystemSettingsClientHandlerFX"))).sorted((lhs, rhs) -> lhs.getDisplayName().compareTo(rhs.getDisplayName())).collect(Collectors.toList()));
        card = new Card("metadataBased", UiCardsContainer.Style.COLLAPSED, "Metadata Based Editors (" + widget2.getRowsCount() + ")", (Node)widget2);
        card.setAdaptiveHeight(true);
        result.getCards().add((Object)card);
        return result;
    }

    private void openEditor(final String name, ViewController<?, ?> ctr) {
        this.controller.set(ctr);
        ctr.setReadonly(this.readonly.get());
        final Node content = ctr.getView();
        if (!content.getProperties().containsKey((Object)"acl-applied")) {
            String nodeClassName = content.getClass().getName();
            Notifications.get().submitTask(() -> AppliedAclData.loadForMetaBasedUI(data -> {
                content.getProperties().put((Object)"acl-applied", (Object)Boolean.TRUE);
                ctr.enforceAcl(data, FxAclUtil.getUiAclResource((String)nodeClassName));
            }, (String[])new String[]{nodeClassName}), this.mutex);
        }
        if (content instanceof TilesSpace) {
            this.contentPane.setContent(content);
        } else {
            this.contentPane.setContent((Node)new TilesSpace(1){
                {
                    super(x0);
                    this.addTiles(new Tile[]{new Tile("main", name, null, content)});
                }
            });
        }
        this.titleLabel.setText(name);
    }

    private SandboxSpaceVM createSandboxModel() {
        SandboxSpaceVM result = new SandboxSpaceVM();
        BaseControlsPanelVM baseControls = result.getBaseControlsFull();
        baseControls.setDictBox1((DictionaryReference)new GeoLocationReference("MOW", "\u041c\u043e\u0441\u043a\u0432\u0430"));
        baseControls.setDictBox2((DictionaryReference)new CountryReference("RU", "\u0420\u043e\u0441\u0441\u0438\u044f"));
        baseControls.setEnumBox(PaymentType.CASH);
        baseControls.setEnumBoxWithIcons(PaymentType.CREDIT_CARD_ONLINE_RAIFFEISEN);
        baseControls.setInfoLabel("Info label content.");
        baseControls.setInfoPanel("Info panel content.");
        baseControls.setTextArea("Text area content.");
        baseControls.setTextBox("text box content");
        baseControls.setRadioBox(Integer.valueOf(25));
        HistoricalValue hv1 = new HistoricalValue();
        hv1.setDate(new Date(1234567890123L));
        hv1.setValue((Object)Boolean.TRUE);
        HistoricalValue hv2 = new HistoricalValue();
        hv2.setDate(new Date());
        hv2.setValue((Object)Boolean.FALSE);
        baseControls.getHistoricalBoolean().add(hv1);
        baseControls.getHistoricalBoolean().add(hv2);
        hv1 = new HistoricalValue();
        hv1.setDate(new Date(1234567890123L));
        hv1.setValue((Object)"qwertyuiop");
        hv2 = new HistoricalValue();
        hv2.setDate(new Date());
        hv2.setValue((Object)"\u0439\u0446\u0443\u043a\u0435\u043d\u0433");
        baseControls.getHistoricalString().add(hv1);
        baseControls.getHistoricalString().add(hv2);
        hv1 = new HistoricalValue();
        hv1.setDate(new Date(1234567890123L));
        hv1.setValue((Object)BigDecimal.valueOf(123.45));
        hv2 = new HistoricalValue();
        hv2.setDate(new Date(1237783453567L));
        hv2.setValue((Object)BigDecimal.valueOf(543.21));
        HistoricalValue hv3 = new HistoricalValue();
        hv3.setDate(new Date(1239265837532L));
        hv3.setValue((Object)BigDecimal.valueOf(15000.0));
        HistoricalValue hv4 = new HistoricalValue();
        hv4.setDate(new Date());
        hv4.setValue((Object)BigDecimal.valueOf(1234.56789));
        baseControls.getHistoricalPrice().add(hv1);
        baseControls.getHistoricalPrice().add(hv2);
        baseControls.getHistoricalPrice().add(hv3);
        baseControls.getHistoricalPrice().add(hv4);
        hv1 = new HistoricalValue();
        hv1.setDate(new Date(1234567890123L));
        hv1.setValue((Object)new Date());
        hv2 = new HistoricalValue();
        hv2.setDate(new Date(1237783453567L));
        hv2.setValue((Object)MiscUtil.addDaysToDate((Date)new Date(), (int)-100));
        baseControls.getHistoricalDate().add(hv1);
        baseControls.getHistoricalDate().add(hv2);
        hv1 = new HistoricalValue();
        hv1.setDate(new Date(1234567890123L));
        hv1.setValue((Object)new Date());
        hv2 = new HistoricalValue();
        hv2.setDate(new Date(1237783453567L));
        hv2.setValue((Object)MiscUtil.addDaysToDate((Date)new Date(), (int)-100));
        baseControls.getHistoricalDateTime().add(hv1);
        baseControls.getHistoricalDateTime().add(hv2);
        String languagesString = "||ru_RU_||\u0410\u0432\u0438\u0430\u043d\u043e\u0432\u0430||en_US_||AviaNOVA";
        PaymentType[] l10nString = new L10nString();
        l10nString.setStringValue(languagesString);
        baseControls.setMultiLingual((L10nString)l10nString);
        baseControls.getValues().addAll(Arrays.asList(PaymentType.CASH, PaymentType.INVOICE, PaymentType.CREDIT_CARD, PaymentType.BANK));
        baseControls.getNestedContainer().setContent("nested panel content data");
        ValueControlsPanelVM valueControls = result.getValueControlsFull();
        valueControls.setBooleanValue(true);
        valueControls.setCurrency("RUB");
        valueControls.setDateTime(LocalDateTime.now());
        valueControls.setDate(LocalDate.now());
        valueControls.setTime(LocalTime.now());
        valueControls.setFloatValue(123.456f);
        valueControls.setDoubleValue(1234.4567);
        valueControls.setIntValue(123456);
        valueControls.setLongValue(123456780L);
        valueControls.setLocale(Locale.ENGLISH);
        valueControls.setMoney(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(123.456), (String)"USD"));
        valueControls.setPrice(BigDecimal.valueOf(123.456));
        valueControls.setTimeZone(TimeZone.getDefault());
        valueControls.setTriple(Boolean.TRUE);
        List list = result.getTablesFull().getTable1();
        TableRow1VM item = new TableRow1VM();
        item.setDictColumn((DictionaryReference)new CountryReference("RU", "\u0420\u043e\u0441\u0441\u0438\u044f"));
        item.setEnumColumn(PaymentType.CASH);
        item.setEnumColumnWithIcon(PaymentType.CREDIT_CARD_AGENCY);
        for (PaymentType pt : PaymentType.values()) {
            if (!pt.name().contains("CREDIT")) continue;
            item.getValuesColumn().add(pt);
        }
        item.setActionColumn("Action text");
        item.setInfoColumn("info text");
        item.setTextColumn("text 1");
        list.add(item);
        item = new TableRow1VM();
        item.setTextColumn("text 2");
        list.add(item);
        list = result.getTablesFull().getTable2();
        item = new TableRow2VM();
        item.setBooleanColumn(true);
        item.setLocaleColumn(Locale.ENGLISH);
        item.setMoneyColumn(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(123.45), (String)"USD"));
        item.setCurrencyColumn("USD");
        item.setDoubleColumn(123.456);
        item.setIntColumn(123456);
        item.setPriceColumn(BigDecimal.valueOf(123.45));
        item.setTripleColumn(Boolean.TRUE);
        list.add(item);
        item = new TableRow2VM();
        item.setBooleanColumn(false);
        item.setLocaleColumn(new Locale("ru"));
        item.setMoneyColumn(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(453.21), (String)"RUB"));
        item.setCurrencyColumn("RUB");
        item.setDoubleColumn(654.321);
        item.setIntColumn(654321);
        item.setPriceColumn(BigDecimal.valueOf(543.21));
        item.setTripleColumn(null);
        list.add(item);
        list = result.getTablesFull().getTable3();
        item = new TableRow3VM();
        item.setDateColumn(LocalDate.now());
        item.setDateTimeColumn(LocalDateTime.now());
        item.setTimeColumn(LocalTime.now());
        item.setTimeZoneColumn(TimeZone.getDefault());
        list.add(item);
        item = new TableRow3VM();
        item.setDateColumn(null);
        item.setDateTimeColumn(null);
        item.setTimeColumn(null);
        list.add(item);
        list = result.getTablesFull().getTable4();
        item = new TableRow4VM();
        item.setColumn1("column 1 row 1 text");
        item.setColumn2("column 2 row 1 text");
        item.setColumn3("column 3 row 1 text");
        list.add(item);
        item = new TableRow4VM();
        item.setColumn1("column 1 row 2 text");
        item.setColumn2("column 2 row 2 text");
        item.setColumn3("column 3 row 2 text");
        list.add(item);
        List groups = ((RestrictionsHelper.RestrictionBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)((RestrictionsHelper.RestrictionGroupBuilder)RestrictionsHelper.RestrictionBuilder.of((String)ProductIndex.class.getName()).simple().property(ProductIndex.Property.equivalentFare.name()).condition(StandardRestrictionResourcePropertyConditions.EQUALS.getId()).value((Object)BigDecimal.valueOf(12000L)).end()).simple().property(ProductIndex.Property.bookingNumber.name()).condition(StandardRestrictionResourcePropertyConditions.EQUALS.getId()).value((Object)"123456").end()).or().simple().property(ProductIndex.Property.status.name()).condition(StandardRestrictionResourcePropertyConditions.EQUALS.getId()).value((Object)ProductStatus.SELL).end()).simple().property(ProductIndex.Property.status.name()).condition(StandardRestrictionResourcePropertyConditions.EQUALS.getId()).value((Object)ProductStatus.REFUND).end()).simple().property(ProductIndex.Property.status.name()).condition(StandardRestrictionResourcePropertyConditions.EQUALS.getId()).value(Collections.singletonList(ProductStatus.EXCHANGE)).end()).end()).simple().property(ProductIndex.Property.issueDate.name()).condition(StandardRestrictionResourcePropertyConditions.TODAY.getId()).value(null).end()).end()).build();
        result.getCustomWidgetsFull().getRestrictionsData().setRestrictionId(ProductIndex.class.getName());
        result.getCustomWidgetsFull().getRestrictionsData().getRestrictions().clear();
        result.getCustomWidgetsFull().getRestrictionsData().getRestrictions().addAll(groups);
        CommissionsEntryVM entry = new CommissionsEntryVM();
        entry.setCommissionsCaption("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u0438, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u043c");
        entry.setFeesCaption("\u0421\u0431\u043e\u0440\u044b, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u043e\u043c");
        CommissionItemVM cmm = new CommissionItemVM();
        cmm.setName("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f \u0422\u041a\u041f");
        RateMoney rm = new RateMoney();
        rm.setMoney(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(12.34), (String)"RUB"));
        cmm.setValue(rm);
        cmm.setSum(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(12.34), (String)"RUB"));
        entry.getCommissions().add(cmm);
        cmm = new CommissionItemVM();
        cmm.setName("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f BSP");
        rm = new RateMoney();
        rm.setRate(Double.valueOf(3.5));
        cmm.setValue(rm);
        cmm.setSum(MoneyHelper.buildMoney((BigDecimal)BigDecimal.valueOf(43.21), (String)"RUB"));
        entry.getCommissions().add(cmm);
        result.getCustomWidgetsFull().getCommissions().getEntries().add(entry);
        entry = new CommissionsEntryVM();
        entry.setCommissionsCaption("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u0438, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c");
        entry.setFeesCaption("\u0421\u0431\u043e\u0440\u044b, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043b\u0438\u0435\u043d\u0442\u043e\u043c");
        result.getCustomWidgetsFull().getCommissions().getEntries().add(entry);
        entry = new CommissionsEntryVM();
        entry.setCommissionsCaption("\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u0438, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u043e\u043c");
        entry.setFeesCaption("\u0421\u0431\u043e\u0440\u044b, \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u043e\u043c");
        result.getCustomWidgetsFull().getCommissions().getEntries().add(entry);
        list = result.getBigTableFull().getContent();
        for (int i = 0; i < 5000; ++i) {
            BigTableRowVM vm = new BigTableRowVM();
            vm.setTextColumn("text row " + (i + 1) + " column value");
            vm.setDateColumn(LocalDate.ofEpochDay(i));
            vm.setDateTimeColumn(LocalDateTime.ofEpochSecond(i * 60, 0, ZoneOffset.UTC));
            vm.setBooleanColumn(i % 2 == 0);
            vm.setPriceColumn(new BigDecimal(i + "." + i));
            vm.setComboBoxColumn(PaymentType.values()[i % PaymentType.values().length]);
            list.add(vm);
        }
        return result;
    }
}

