/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.BusinessTripCurrenciesPanel;
import com.gridnine.xtrip.client.fx.model.dict.BusinessTripCurrenciesPanelController;
import com.gridnine.xtrip.client.fx.model.dict.BusinessTripCurrenciesPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.BusinessTripCurrencies;
import com.gridnine.xtrip.common.model.dict.BusinessTripCurrenciesReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;

public class BusinessTripCurrenciesHandler
extends BaseDictHandler<BusinessTripCurrenciesPanel, BusinessTripCurrencies, BusinessTripCurrenciesPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BusinessTripCurrencies.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BusinessTripCurrencies.Property.currency.name(), Messages.Currency, (Renderer)StandardRenderers.CURRENCY_NAME));
    }

    @Override
    protected void configureController(List<BiConsumer<BusinessTripCurrencies, BusinessTripCurrenciesPanelVM>> toVM, List<BiConsumer<BusinessTripCurrenciesPanelVM, BusinessTripCurrencies>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setCountry(model.getCountry());
            vm.getMain().setCurrency(model.getCurrency());
        });
        fromVM.add((vm, model) -> {
            model.setCountry(vm.getMain().getCountry());
            model.setCurrency(vm.getMain().getCurrency());
        });
    }

    public String format(BusinessTripCurrencies dict) {
        return dict.getCountry() != null ? dict.getCountry().getCaption() : "";
    }

    @Override
    protected BusinessTripCurrenciesPanelVM createVM() {
        return new BusinessTripCurrenciesPanelVM();
    }

    @Override
    protected ViewController<BusinessTripCurrenciesPanel, BusinessTripCurrenciesPanelVM> createController() {
        return new BusinessTripCurrenciesPanelController(false);
    }

    public Class<BusinessTripCurrencies> getDictType() {
        return BusinessTripCurrencies.class;
    }

    public DictionaryReference<BusinessTripCurrencies> createReference(String code) {
        return new BusinessTripCurrenciesReference(code);
    }
}

