/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplateApplicableVM;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplateMainPanel;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplateMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplatePanel;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplatePanelController;
import com.gridnine.xtrip.client.fx.model.dict.FeeRemarkTemplatePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplate;
import com.gridnine.xtrip.common.model.dict.FeeRemarkTemplateReference;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javafx.util.StringConverter;

public class FeeRemarkTemplateHandler
extends BaseDictHandler<FeeRemarkTemplatePanel, FeeRemarkTemplate, FeeRemarkTemplatePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), FeeRemarkTemplate.Property.template.name(), Messages.Remark_Template, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), FeeRemarkTemplate.Property.appliedTo.name(), Messages.Applicable_to, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<FeeRemarkTemplate, FeeRemarkTemplatePanelVM>> toVM, List<BiConsumer<FeeRemarkTemplatePanelVM, FeeRemarkTemplate>> fromVM) {
        toVM.add((model, vm) -> {
            FeeRemarkTemplateMainPanelVM main = vm.getMain();
            main.setTemplate(model.getTemplate());
            FeeRemarkTemplateApplicableVM applicable = new FeeRemarkTemplateApplicableVM();
            applicable.setApplicableTo(model.getAppliedTo());
            vm.getMain().setApplicable(applicable);
        });
        fromVM.add((vm, model) -> {
            FeeRemarkTemplateMainPanelVM main = vm.getMain();
            model.setTemplate(main.getTemplate());
            model.setAppliedTo(main.getApplicable().getApplicableTo());
        });
    }

    public Class<FeeRemarkTemplate> getDictType() {
        return FeeRemarkTemplate.class;
    }

    public DictionaryReference<FeeRemarkTemplate> createReference(String code) {
        return new FeeRemarkTemplateReference(code);
    }

    @Override
    protected FeeRemarkTemplatePanelVM createVM() {
        return new FeeRemarkTemplatePanelVM();
    }

    @Override
    protected ViewController<FeeRemarkTemplatePanel, FeeRemarkTemplatePanelVM> createController() {
        FeeRemarkTemplatePanelController controller = new FeeRemarkTemplatePanelController(false);
        this.addCustomSuppliers(controller);
        this.addCustomConverters(controller);
        return controller;
    }

    private void addCustomSuppliers(FeeRemarkTemplatePanelController controller) {
        ((FeeRemarkTemplateMainPanel)controller.getView().getMainCard().getContent()).getApplicableNode().setItemsSupplier((Supplier)new Supplier<List<FeeRemarkTemplateApplicableVM>>(){

            @Override
            public List<FeeRemarkTemplateApplicableVM> get() {
                ArrayList<FeeRemarkTemplateApplicableVM> list = new ArrayList<FeeRemarkTemplateApplicableVM>();
                for (RuleTarget target : RulesEnvironment.get().getTargets(null)) {
                    FeeRemarkTemplateApplicableVM vm = new FeeRemarkTemplateApplicableVM();
                    vm.setApplicableTo(target.getDisplayName());
                    list.add(vm);
                }
                return list;
            }
        });
    }

    private void addCustomConverters(FeeRemarkTemplatePanelController controller) {
        ((FeeRemarkTemplateMainPanel)controller.getView().getMainCard().getContent()).getApplicableNode().setConverter((StringConverter)new StringConverter<FeeRemarkTemplateApplicableVM>(){

            public String toString(FeeRemarkTemplateApplicableVM object) {
                return object == null ? null : object.getApplicableTo();
            }

            public FeeRemarkTemplateApplicableVM fromString(String string) {
                FeeRemarkTemplateApplicableVM model = new FeeRemarkTemplateApplicableVM();
                model.setApplicableTo(string);
                return model;
            }
        });
    }

    public String format(FeeRemarkTemplate dict) {
        return dict.getTemplate();
    }
}

