/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.MetroStationPanel;
import com.gridnine.xtrip.client.fx.model.dict.MetroStationPanelController;
import com.gridnine.xtrip.client.fx.model.dict.MetroStationPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.delivery.MetroStation;
import com.gridnine.xtrip.common.model.delivery.MetroStationReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;

public class MetroStationHandler
extends BaseDictHandler<MetroStationPanel, MetroStation, MetroStationPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), MetroStation.Property.line.name(), Messages.Subway_Line, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<MetroStation, MetroStationPanelVM>> toVM, List<BiConsumer<MetroStationPanelVM, MetroStation>> fromVM) {
        toVM.add((model, vm) -> {
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            vm.setMetroLine(model.getLine());
        });
        fromVM.add((vm, model) -> {
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            model.setLine(vm.getMetroLine());
        });
    }

    public Class<MetroStation> getDictType() {
        return MetroStation.class;
    }

    public DictionaryReference<MetroStation> createReference(String code) {
        return new MetroStationReference(code);
    }

    @Override
    protected MetroStationPanelVM createVM() {
        return new MetroStationPanelVM();
    }

    @Override
    protected ViewController<MetroStationPanel, MetroStationPanelVM> createController() {
        return new MetroStationPanelController(false);
    }
}

