/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.NomenclaturePanel;
import com.gridnine.xtrip.client.fx.model.dict.NomenclaturePanelController;
import com.gridnine.xtrip.client.fx.model.dict.NomenclaturePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.NomenclatureControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Nomenclature;
import com.gridnine.xtrip.common.model.dict.NomenclatureReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class NomenclatureHandler
extends BaseDictHandler<NomenclaturePanel, Nomenclature, NomenclaturePanelVM> {
    private static final TableColumnSettings COL_FOR_ID = new TableColumnSettings();

    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(COL_FOR_ID);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        TableColumnSettings column = new TableColumnSettings();
        column.setId(Nomenclature.Property.disabled.name());
        column.setDisplayName(Messages.show_dictionaries_title);
        column.setRenderer((Renderer)StandardRenderers.GENERIC);
        column.setType("boolean-actual-dict");
        params.getFilters().add(column);
    }

    @Override
    protected void configureController(List<BiConsumer<Nomenclature, NomenclaturePanelVM>> toVM, List<BiConsumer<NomenclaturePanelVM, Nomenclature>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new NomenclatureControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setId(model.getCode());
            vm.getOtherParameters().setDisabled(model.isDisabled());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getId()));
            model.setDisabled(vm.getOtherParameters().isDisabled());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<Nomenclature> getDictType() {
        return Nomenclature.class;
    }

    public DictionaryReference<Nomenclature> createReference(String code) {
        return new NomenclatureReference(code);
    }

    @Override
    protected NomenclaturePanelVM createVM() {
        return new NomenclaturePanelVM();
    }

    @Override
    protected ViewController<NomenclaturePanel, NomenclaturePanelVM> createController() {
        return new NomenclaturePanelController(false);
    }

    static {
        COL_FOR_ID.setId(BaseDictionary.Property.code.name());
        COL_FOR_ID.setDisplayName(Messages.Code1C);
        COL_FOR_ID.setRenderer((Renderer)StandardRenderers.GENERIC);
    }
}

