/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.PrincipaDictMainPanel;
import com.gridnine.xtrip.client.fx.model.dict.PrincipalDictPanel;
import com.gridnine.xtrip.client.fx.model.dict.PrincipalDictPanelController;
import com.gridnine.xtrip.client.fx.model.dict.PrincipalDictPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.PrincipalReference;
import com.gridnine.xtrip.common.system.model.RegionalType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class PrincipalDictHandler
extends BaseDictHandler<PrincipalDictPanel, Principal, PrincipalDictPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<Principal, PrincipalDictPanelVM>> toVM, List<BiConsumer<PrincipalDictPanelVM, Principal>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            vm.getMain().setRegistrationId(model.getRegistrationId());
            vm.getMain().setPhone(model.getPhone());
            vm.getMain().setBin(model.getBin());
            vm.getMain().setVatSeriesNumber(model.getVatSeriesNumber());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            model.setRegistrationId(vm.getMain().getRegistrationId());
            model.setPhone(vm.getMain().getPhone());
            model.setBin(vm.getMain().getBin());
            model.setVatSeriesNumber(vm.getMain().getVatSeriesNumber());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
        ControllersRegistry.register((ControllerInterceptor)new PrincipalControllerInterceptor());
    }

    public Class<Principal> getDictType() {
        return Principal.class;
    }

    public DictionaryReference<Principal> createReference(String code) {
        return new PrincipalReference(code);
    }

    @Override
    protected PrincipalDictPanelVM createVM() {
        return new PrincipalDictPanelVM();
    }

    @Override
    protected ViewController<PrincipalDictPanel, PrincipalDictPanelVM> createController() {
        return new PrincipalDictPanelController(false);
    }

    static class PrincipalControllerInterceptor
    extends ControllerInterceptor<PrincipalDictPanelVM, PrincipalDictPanelController> {
        PrincipalControllerInterceptor() {
        }

        protected Class<PrincipalDictPanelController> getControllerClass() {
            return PrincipalDictPanelController.class;
        }

        protected void onCreate(PrincipalDictPanelController controller) {
            Set organizationRegionalPropertiesTypes = Collections.singleton(RegionalType.RU);
            if (Prefetched.getData().getRegionalSettings() != null && !Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes().isEmpty()) {
                organizationRegionalPropertiesTypes = Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes();
            }
            ((PrincipaDictMainPanel)controller.getView().getMainCard().getContent()).getRegistrationIdCell().setHidden(!organizationRegionalPropertiesTypes.contains(RegionalType.RU));
            ((PrincipaDictMainPanel)controller.getView().getMainCard().getContent()).getBinCell().setHidden(!organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
            ((PrincipaDictMainPanel)controller.getView().getMainCard().getContent()).getVatSeriesNumberCell().setHidden(!organizationRegionalPropertiesTypes.contains(RegionalType.KZ));
        }
    }
}

