/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.airline;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.AirlinePanel;
import com.gridnine.xtrip.client.fx.model.dict.AirlinePanelController;
import com.gridnine.xtrip.client.fx.model.dict.AirlinePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.airline.StandardAirlineHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.AirlineReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.system.model.RegionalType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;

public class AirlineHandler
extends BaseDictHandler<AirlinePanel, Airline, AirlinePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        Set organizationRegionalPropertiesTypes = Collections.singleton(RegionalType.RU);
        if (Prefetched.getData().getRegionalSettings() != null && !Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes().isEmpty()) {
            organizationRegionalPropertiesTypes = Prefetched.getData().getRegionalSettings().getProfilePropertiesTypes();
        }
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.airlineNumber.name(), Messages.Number, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.openDate.name(), Messages.Open_date, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.closeDate.name(), Messages.Close_date, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.alliance.name(), Messages.Alliance, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.acceptableCards.name(), Messages.Payment_cards, (Renderer)StandardRenderers.GENERIC));
        if (organizationRegionalPropertiesTypes.contains(RegionalType.RU)) {
            params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.registrationId.name(), Messages.INN, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.kpp.name(), Messages.KPP, (Renderer)StandardRenderers.GENERIC));
        }
        if (organizationRegionalPropertiesTypes.contains(RegionalType.KZ)) {
            params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.bin.name(), Messages.BIN, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.vatSeriesNumber.name(), Messages.VAT_series_number, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.vatSeriesDate.name(), Messages.VAT_series_date, (Renderer)StandardRenderers.DATE));
        }
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), Airline.Property.phone.name(), Messages.Phone, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_NOT_UPDATE);
    }

    @Override
    protected void configureController(List<BiConsumer<Airline, AirlinePanelVM>> toVM, List<BiConsumer<AirlinePanelVM, Airline>> fromVM) {
        new StandardAirlineHandlerConfigurator().configureController(toVM, fromVM);
        ClientRegistry.get().allOf(StandardAirlineHandlerConfigurator.TYPE).values().forEach(cfg -> cfg.configureController(toVM, fromVM));
    }

    public Class<Airline> getDictType() {
        return Airline.class;
    }

    public DictionaryReference<Airline> createReference(String code) {
        return new AirlineReference(code);
    }

    @Override
    protected AirlinePanelVM createVM() {
        return new AirlinePanelVM();
    }

    @Override
    protected ViewController<AirlinePanel, AirlinePanelVM> createController() {
        return new AirlinePanelController(false);
    }
}

